/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.command;

import com.github.manasmods.tensura.effect.template.SkillMobEffect;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MiscCommand {
    private static final SimpleCommandExceptionType ERROR_CLEAR_EVERYTHING_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.effect.clear.everything.failed"));

    @SubscribeEvent
    public static void register(RegisterCommandsEvent e) {
        e.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"effect").requires(stack -> stack.m_6761_(2))).then(Commands.m_82127_((String)"clear").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"ability").executes(context -> MiscCommand.clearEffects((CommandSourceStack)context.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandSourceStack)context.getSource()).m_81374_())))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> MiscCommand.clearEffects((CommandSourceStack)context.getSource(), EntityArgument.m_91461_((CommandContext)context, (String)"targets")))))));
        e.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"despawn").requires(stack -> stack.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            List entities = EntityArgument.m_91461_((CommandContext)context, (String)"targets").stream().toList();
            if (entities.size() == 1) {
                Entity entity = (Entity)entities.get(0);
                if (entity instanceof Player) {
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"tensura.command.despawn.fail", (Object[])new Object[]{entity.m_7755_()}));
                } else {
                    entity.m_146870_();
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.despawn", (Object[])new Object[]{entity.m_7755_()}).m_130940_(ChatFormatting.DARK_GREEN), true);
                }
                return 1;
            }
            int i = 0;
            for (Entity entity : entities) {
                if (entity instanceof Player) continue;
                entity.m_146870_();
                ++i;
            }
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"tensura.command.despawn.all", (Object[])new Object[]{i}).m_130940_(ChatFormatting.DARK_GREEN), true);
            return 1;
        })));
    }

    private static int clearEffects(CommandSourceStack pSource, Collection<? extends Entity> pTargets) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : pTargets) {
            LivingEntity living;
            if (!(entity instanceof LivingEntity) || !SkillMobEffect.removeAllEffects(living = (LivingEntity)entity)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_CLEAR_EVERYTHING_FAILED.create();
        }
        if (pTargets.size() == 1) {
            pSource.m_81354_((Component)Component.m_237110_((String)"tensura.command.clear_skill_effect.success.single", (Object[])new Object[]{pTargets.iterator().next().m_5446_()}), true);
        } else {
            pSource.m_81354_((Component)Component.m_237110_((String)"tensura.command.clear_skill_effect.success.multiple", (Object[])new Object[]{pTargets.size()}), true);
        }
        return i;
    }
}

