/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.command;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.OutgoingPlayerChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TelepathyCommand {
    @SubscribeEvent
    public static void register(RegisterCommandsEvent e) {
        LiteralCommandNode command = e.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"telepathy").then(Commands.m_82127_((String)"player").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"message", (ArgumentType)MessageArgument.m_96832_()).executes(context -> {
            MessageArgument.ChatMessage message = MessageArgument.m_232163_((CommandContext)context, (String)"message");
            try {
                return TelepathyCommand.sendMessage((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"target"), message);
            }
            catch (Exception exception) {
                message.m_241074_((CommandSourceStack)context.getSource());
                throw exception;
            }
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"subordinate").then(Commands.m_82127_((String)"stay").executes(context -> TelepathyCommand.stayCommand((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"follow").executes(context -> TelepathyCommand.followCommand((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"wander").executes(context -> TelepathyCommand.wanderCommand((CommandSourceStack)context.getSource())))));
        e.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"t").redirect((CommandNode)command));
    }

    private static int sendMessage(CommandSourceStack pSource, ServerPlayer serverplayer, MessageArgument.ChatMessage pChatMessage) {
        if (TelepathyCommand.noTelepathy((Player)serverplayer)) {
            pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.no_telepathy"));
            return 1;
        }
        ChatType.Bound bound = ChatType.m_241073_((ResourceKey)ChatType.f_240674_, (CommandSourceStack)pSource);
        pChatMessage.m_241987_(pSource, message -> {
            OutgoingPlayerChatMessage chatMessage = OutgoingPlayerChatMessage.m_242676_((PlayerChatMessage)message);
            boolean filtered = message.m_243059_();
            Entity entity = pSource.m_81373_();
            ChatType.Bound targetName = ChatType.m_241073_((ResourceKey)ChatType.f_240668_, (CommandSourceStack)pSource).m_241018_(serverplayer.m_5446_());
            pSource.m_243079_(chatMessage, false, targetName);
            boolean shouldFilter = pSource.m_243061_(serverplayer);
            serverplayer.m_243093_(chatMessage, shouldFilter, bound);
            if (filtered && shouldFilter && serverplayer != entity) {
                pSource.m_243053_(PlayerList.f_243017_);
            }
            chatMessage.m_241051_(pSource.m_81377_().m_6846_());
        });
        return 1;
    }

    public static int stayCommand(CommandSourceStack pSource) {
        ServerPlayer player = pSource.m_230896_();
        if (player != null) {
            if (TelepathyCommand.noTelepathy((Player)player)) {
                pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.no_telepathy"));
                return 1;
            }
            Mob mob = SkillHelper.getTargetingEntity(Mob.class, (LivingEntity)player, 30.0, 0.2, false, false);
            if (mob != null && SkillHelper.isSubordinate((LivingEntity)player, (LivingEntity)mob)) {
                SkillHelper.setStay((LivingEntity)mob);
                player.m_5661_((Component)Component.m_237110_((String)"tensura.message.pet.stay", (Object[])new Object[]{mob.m_5446_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
            } else {
                pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate.not_found"));
            }
        }
        return 1;
    }

    public static int followCommand(CommandSourceStack pSource) {
        ServerPlayer player = pSource.m_230896_();
        if (player != null) {
            if (TelepathyCommand.noTelepathy((Player)player)) {
                pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.no_telepathy"));
                return 1;
            }
            Mob mob = SkillHelper.getTargetingEntity(Mob.class, (LivingEntity)player, 30.0, 0.2, false, false);
            if (mob != null && SkillHelper.isSubordinate((LivingEntity)player, (LivingEntity)mob)) {
                SkillHelper.setFollow((LivingEntity)mob);
                player.m_5661_((Component)Component.m_237110_((String)"tensura.message.pet.follow", (Object[])new Object[]{mob.m_5446_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
            } else {
                pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate.not_found"));
            }
        }
        return 1;
    }

    public static int wanderCommand(CommandSourceStack pSource) {
        ServerPlayer player = pSource.m_230896_();
        if (player != null) {
            if (TelepathyCommand.noTelepathy((Player)player)) {
                pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.no_telepathy"));
                return 1;
            }
            Mob mob = SkillHelper.getTargetingEntity(Mob.class, (LivingEntity)player, 30.0, 0.2, false, false);
            if (mob != null && SkillHelper.isSubordinate((LivingEntity)player, (LivingEntity)mob)) {
                SkillHelper.setWander((LivingEntity)mob);
                player.m_5661_((Component)Component.m_237110_((String)"tensura.message.pet.wander", (Object[])new Object[]{mob.m_5446_()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
            } else {
                pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate.not_found"));
            }
        }
        return 1;
    }

    public static boolean noTelepathy(Player player) {
        return !SkillUtils.hasSkill((Entity)player, (ManasSkill)CommonSkills.TELEPATHY.get());
    }
}

