/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.command;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.entity.template.TensuraHorseEntity;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.OutgoingPlayerChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ThoughtCommunicationCommand {
    @SubscribeEvent
    public static void register(RegisterCommandsEvent e) {
        LiteralCommandNode command = e.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"thoughtCommunication").then(Commands.m_82127_((String)"player").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"message", (ArgumentType)MessageArgument.m_96832_()).executes(context -> {
            MessageArgument.ChatMessage message = MessageArgument.m_232163_((CommandContext)context, (String)"message");
            try {
                return ThoughtCommunicationCommand.sendMessage((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"targets"), message);
            }
            catch (Exception exception) {
                message.m_241074_((CommandSourceStack)context.getSource());
                throw exception;
            }
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"subordinate").then(Commands.m_82127_((String)"stay").executes(context -> ThoughtCommunicationCommand.stayCommand((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"follow").executes(context -> ThoughtCommunicationCommand.followCommand((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"wander").executes(context -> ThoughtCommunicationCommand.wanderCommand((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"attack").executes(context -> ThoughtCommunicationCommand.attackCommand((CommandSourceStack)context.getSource())))));
        e.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"tc").redirect((CommandNode)command));
    }

    private static int sendMessage(CommandSourceStack pSource, Collection<ServerPlayer> pRecipients, MessageArgument.ChatMessage pChatMessage) {
        ServerPlayer player = pSource.m_230896_();
        if (player != null) {
            if (ThoughtCommunicationCommand.noTelepathy((Player)player)) {
                pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.no_telepathy"));
                return 1;
            }
            ChatType.Bound bound = ChatType.m_241073_((ResourceKey)ChatType.f_240674_, (CommandSourceStack)pSource);
            pChatMessage.m_241987_(pSource, message -> {
                OutgoingPlayerChatMessage chatMessage = OutgoingPlayerChatMessage.m_242676_((PlayerChatMessage)message);
                boolean flag = message.m_243059_();
                Entity entity = pSource.m_81373_();
                boolean flag1 = false;
                for (ServerPlayer serverplayer : pRecipients) {
                    ChatType.Bound targetName = ChatType.m_241073_((ResourceKey)ChatType.f_240668_, (CommandSourceStack)pSource).m_241018_(serverplayer.m_5446_());
                    pSource.m_243079_(chatMessage, false, targetName);
                    boolean flag2 = pSource.m_243061_(serverplayer);
                    serverplayer.m_243093_(chatMessage, flag2, bound);
                    flag1 |= flag && flag2 && serverplayer != entity;
                }
                if (flag1) {
                    pSource.m_243053_(PlayerList.f_243017_);
                }
                chatMessage.m_241051_(pSource.m_81377_().m_6846_());
            });
        }
        return pRecipients.size();
    }

    public static int stayCommand(CommandSourceStack pSource) {
        ServerPlayer player = pSource.m_230896_();
        if (player != null) {
            if (ThoughtCommunicationCommand.noTelepathy((Player)player)) {
                pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.no_telepathy"));
                return 1;
            }
            List list = player.m_9236_().m_6443_(Mob.class, player.m_20191_().m_82400_(30.0), arg_0 -> ThoughtCommunicationCommand.lambda$stayCommand$6((Player)player, arg_0));
            if (!list.isEmpty()) {
                for (Mob living : list) {
                    SkillHelper.setStay((LivingEntity)living);
                }
                pSource.m_81354_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate_all.stay"), false);
            } else {
                pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate_all.not_found"));
            }
        }
        return 1;
    }

    public static int followCommand(CommandSourceStack pSource) {
        ServerPlayer player = pSource.m_230896_();
        if (player != null) {
            if (ThoughtCommunicationCommand.noTelepathy((Player)player)) {
                pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.no_telepathy"));
                return 1;
            }
            List list = player.m_9236_().m_6443_(Mob.class, player.m_20191_().m_82400_(30.0), arg_0 -> ThoughtCommunicationCommand.lambda$followCommand$7((Player)player, arg_0));
            if (!list.isEmpty()) {
                for (Mob living : list) {
                    SkillHelper.setFollow((LivingEntity)living);
                }
                pSource.m_81354_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate_all.follow"), false);
            } else {
                pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate_all.not_found"));
            }
        }
        return 1;
    }

    public static int wanderCommand(CommandSourceStack pSource) {
        ServerPlayer player = pSource.m_230896_();
        if (player != null) {
            if (ThoughtCommunicationCommand.noTelepathy((Player)player)) {
                pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.no_telepathy"));
                return 1;
            }
            List list = player.m_9236_().m_6443_(Mob.class, player.m_20191_().m_82400_(30.0), arg_0 -> ThoughtCommunicationCommand.lambda$wanderCommand$8((Player)player, arg_0));
            if (!list.isEmpty()) {
                for (Mob living : list) {
                    SkillHelper.setWander((LivingEntity)living);
                }
                pSource.m_81354_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate_all.wander"), false);
            } else {
                pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate_all.not_found"));
            }
        }
        return 1;
    }

    public static int attackCommand(CommandSourceStack pSource) {
        ServerPlayer player = pSource.m_230896_();
        if (player != null) {
            if (ThoughtCommunicationCommand.noTelepathy((Player)player)) {
                pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.no_telepathy"));
                return 1;
            }
            LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)player, 30.0, true, false);
            if (target != null) {
                List list = player.m_9236_().m_6443_(Mob.class, player.m_20191_().m_82400_(30.0), arg_0 -> ThoughtCommunicationCommand.lambda$attackCommand$9((Player)player, arg_0));
                if (!list.isEmpty()) {
                    for (Mob mob : list) {
                        mob.m_6710_(target);
                        if (mob instanceof TamableAnimal) {
                            TamableAnimal tamableAnimal = (TamableAnimal)mob;
                            tamableAnimal.m_21839_(false);
                            continue;
                        }
                        if (!(mob instanceof TensuraHorseEntity)) continue;
                        TensuraHorseEntity tensuraHorse = (TensuraHorseEntity)mob;
                        tensuraHorse.setSitting(false);
                    }
                    pSource.m_81354_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate_all.success"), false);
                } else {
                    pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate_all.not_found"));
                }
            } else {
                pSource.m_81352_((Component)Component.m_237115_((String)"tensura.telepathy.subordinate_all.no_target"));
            }
        }
        return 1;
    }

    public static boolean noTelepathy(Player player) {
        return !SkillUtils.hasSkill((Entity)player, (ManasSkill)CommonSkills.THOUGHT_COMMUNICATION.get());
    }

    private static /* synthetic */ boolean lambda$attackCommand$9(Player player, Mob entity) {
        return SkillHelper.isSubordinate((LivingEntity)player, (LivingEntity)entity);
    }

    private static /* synthetic */ boolean lambda$wanderCommand$8(Player player, Mob entity) {
        return SkillHelper.isSubordinate((LivingEntity)player, (LivingEntity)entity);
    }

    private static /* synthetic */ boolean lambda$followCommand$7(Player player, Mob entity) {
        return SkillHelper.isSubordinate((LivingEntity)player, (LivingEntity)entity);
    }

    private static /* synthetic */ boolean lambda$stayCommand$6(Player player, Mob entity) {
        return SkillHelper.isSubordinate((LivingEntity)player, (LivingEntity)entity);
    }
}

