/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class AttributeConfig {
    public final ForgeConfigSpec.DoubleValue maxArmor;
    public final ForgeConfigSpec.DoubleValue maxAttack;
    public final ForgeConfigSpec.DoubleValue maxHP;
    public final ForgeConfigSpec.DoubleValue maxToughness;
    public final ForgeConfigSpec.DoubleValue minimumSize;

    public AttributeConfig(ForgeConfigSpec.Builder builder) {
        builder.push("attributeMax");
        this.maxHP = this.maxAttribute(builder, 1024, 30000, "maxHP");
        this.maxAttack = this.maxAttribute(builder, 2048, 10000, "maxAttack");
        this.maxArmor = this.maxAttribute(builder, 30, 1024, "maxArmor");
        this.maxToughness = this.maxAttribute(builder, 20, 1024, "maxToughness");
        builder.pop();
        builder.push("minimumSize");
        this.minimumSize = builder.comment("The minimum size a player can get through races and skills").defineInRange("minimumSize", 0.15, 0.0, 10000.0);
        builder.pop();
    }

    private ForgeConfigSpec.DoubleValue reducedPercentage(ForgeConfigSpec.Builder builder, int defaultValue) {
        return builder.comment("The max percentage of damage getting reduced by armor points\nvanilla is 80\ndefault = " + defaultValue).defineInRange("reducedPercentage", (double)defaultValue, 0.0, 100.0);
    }

    private ForgeConfigSpec.DoubleValue maxAttribute(ForgeConfigSpec.Builder builder, int vanilla, int defaultValue, String string) {
        return builder.comment("The max value for this attribute\nvanilla is " + vanilla + "\ndefault = " + defaultValue).defineInRange(string, (double)defaultValue, 0.0, 1.0E9);
    }
}

