/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class BlocksConfig {
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> inertCoreSkills;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> fusingInertCoreSkills;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> fusingActiveCoreSkills;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> fusingInactiveCoreSkills;
    public final ForgeConfigSpec.DoubleValue turnActiveCoreEP;
    public final ForgeConfigSpec.DoubleValue fusingCoreEP;

    public BlocksConfig(ForgeConfigSpec.Builder builder) {
        builder.push("charybdisCore");
        this.turnActiveCoreEP = builder.comment("The amount of EP needed for Inactive Charybdis Core to turn Active").defineInRange("turnActiveCoreEP", 100000.0, 0.0, 1.0E7);
        this.inertCoreSkills = builder.comment("List of Skills that can be obtained from right-clicking Inert Charybdis Core").defineList("inertCoreSkills", Arrays.asList("tensura:gravity_manipulation", "tensura:magic_jamming"), check -> true);
        builder.pop();
        builder.push("degenerateFusingCore");
        this.fusingInertCoreSkills = builder.comment("List of Skills that can be obtained from fusing with Inert Charybdis Core using Degenerate").defineList("fusingInertCoreSkills", Arrays.asList("tensura:gravity_manipulation", "tensura:magic_jamming", "tensura:magic_sense", "tensura:ultraspeed_regeneration"), check -> true);
        this.fusingActiveCoreSkills = builder.comment("List of Skills that can be obtained from fusing with Active Charybdis Core using Degenerate").defineList("fusingActiveCoreSkills", List.of("tensura:gravity_manipulation", "tensura:magic_sense"), check -> true);
        this.fusingInactiveCoreSkills = builder.comment("List of Skills that can be obtained from fusing with Inactive Charybdis Core using Degenerate").defineList("fusingInactiveCoreSkills", List.of("tensura:gravity_manipulation"), check -> true);
        this.fusingCoreEP = builder.comment("The amount of EP that can be obtained from fusing with Inert Charybdis Core using Degenerate").defineInRange("fusingCoreEP", 200000.0, 0.0, 1.0E7);
        builder.pop();
    }
}

