/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.config;

import java.util.UUID;
import net.minecraftforge.common.ForgeConfigSpec;

public class MagiculeConfig {
    public final ForgeConfigSpec.DoubleValue manaRegen;
    public final ForgeConfigSpec.DoubleValue auraRegen;
    public final ForgeConfigSpec.DoubleValue baseMagicule;
    public final ForgeConfigSpec.DoubleValue baseMagiculeRegeneration;
    public final ForgeConfigSpec.IntValue magiculeSyncInterval;
    public final ForgeConfigSpec.IntValue modifierUpdateInterval;
    public final ForgeConfigSpec.LongValue magiculeSeed;

    public MagiculeConfig(ForgeConfigSpec.Builder builder) {
        this.baseMagicule = builder.comment("Base magicule for a chunk").defineInRange("baseMagicule", 500.0, 0.0, 1.0E8);
        this.baseMagiculeRegeneration = builder.comment("Base magicule regeneration per second for a chunk").defineInRange("baseMagiculeRegeneration", 10.0, 0.0, 1.0E8);
        this.magiculeSyncInterval = builder.comment("How often magicule is synced to clients when marked as dirty in ticks").defineInRange("magiculeSyncInterval", 15, 1, 12000);
        this.modifierUpdateInterval = builder.comment("How often maxMagiculeModifier are updated in ticks").defineInRange("modifierUpdateInterval", 100, 1, 12000);
        this.magiculeSeed = builder.comment(new String[]{"Seed for magicule generation", "Changing this will change the magicule values for all chunks"}).defineInRange("magiculeSeed", UUID.randomUUID().getLeastSignificantBits(), Long.MIN_VALUE, Long.MAX_VALUE);
        builder.push("energyRegen");
        this.manaRegen = builder.comment("The percentage of the current chunk's Magicule gets turned into players' MP within the chunk each 10 ticks (half a second)").defineInRange("manaRegenPercentage", 0.01, 0.0, 1.0E9);
        this.auraRegen = builder.comment("The base amount of Aura that players each 10 ticks (half a second)").defineInRange("auraBaseRegen", 2.0, 0.0, 1.0E9);
        builder.pop();
    }
}

