/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class NamingConfig {
    public final ForgeConfigSpec.DoubleValue lowHPToName;
    public final ForgeConfigSpec.DoubleValue maximumEPToName;
    public final ForgeConfigSpec.DoubleValue maxEPGain;
    public final ForgeConfigSpec.DoubleValue maxCost;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> names;

    public NamingConfig(ForgeConfigSpec.Builder builder) {
        builder.push("namingRequirement");
        this.lowHPToName = builder.comment("The percentage of max HP for the target to submit to the namer").defineInRange("hpToName", 25.0, 0.0, 100.0);
        this.maximumEPToName = builder.comment("The percentage of EP of the namer for the target to submit to the namer").defineInRange("epToName", 1.0, 0.0, 100.0);
        builder.pop();
        builder.push("namingCost");
        this.maxEPGain = builder.comment("The maximum amount of EP that an entity can gain from being named").defineInRange("maxEPFromNaming", 1000000.0, 0.0, 1.0E9);
        this.maxCost = builder.comment("The maximum amount of Magicule that the namer can lose from naming a target").defineInRange("maxMagiculeCost", 3000000.0, 0.0, 1.0E9);
        builder.pop();
        builder.push("names");
        this.names = builder.comment("Random names for the Naming menu").defineList("names", Arrays.asList("Viciel", "MinhEragon", "Borniuus", "Nieadni", "R.E", "Arthur", "ProfessorAkaChris", "Subordinate", "Memoires", "Kenji", "Mac", "AxelDude", "Geld", "Benimaru", "Shion", "Shuna", "Rimuru", "Veldora", "Hakurou", "Milim", "Gabiru", "Souei", "Ranga", "Gobta", "Diablo", "Rigurd", "Beretta", "Clayman", "Leon", "Ifrit", "Mjurran", "Carrion"), check -> true);
        builder.pop();
    }
}

