/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class RacesConfig {
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> startingRaces;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> randomRaces;
    public final ForgeConfigSpec.DoubleValue epToEnlightened;
    public final ForgeConfigSpec.DoubleValue epToSaint;
    public final ForgeConfigSpec.DoubleValue epToDivine;
    public final ForgeConfigSpec.DoubleValue epToHighOrc;
    public final ForgeConfigSpec.DoubleValue epToDisaster;
    public final ForgeConfigSpec.DoubleValue epToOvercomer;
    public final ForgeConfigSpec.DoubleValue epToWightKing;
    public final ForgeConfigSpec.DoubleValue epToSpiritSkeleton;
    public final ForgeConfigSpec.DoubleValue epToTrueDragonewt;
    public final ForgeConfigSpec.IntValue bossForSaint;
    public final ForgeConfigSpec.IntValue bloodForOrcLord;
    public final ForgeConfigSpec.IntValue bloodForVampireAsHuman;
    public final ForgeConfigSpec.IntValue bloodForVampireAsGhoul;
    public final ForgeConfigSpec.IntValue essenceForDragonewt;
    public final ForgeConfigSpec.IntValue essenceForMystic;
    public final ForgeConfigSpec.IntValue essenceForWicked;
    public final ForgeConfigSpec.IntValue oreForMetalSlime;
    public final ForgeConfigSpec.DoubleValue maxHeathPossession;
    public final ForgeConfigSpec.DoubleValue maxAttackPossession;

    public RacesConfig(ForgeConfigSpec.Builder builder) {
        builder.push("startingRaces");
        this.startingRaces = builder.comment(new String[]{"List of races that can be selected through the Race Selection Menu", "default: [\"tensura:human\", \"tensura:elf\", \"tensura:dwarf\", \"tensura:merfolk\", \"tensura:beastfolk\", \"tensura:goblin\", \"tensura:lizardman\", \"tensura:ogre\", \"tensura:orc\", \"tensura:slime\", \"tensura:wight\", \"tensura:ghoul\", \"tensura:lesser_daemon\"]"}).defineList("startingRaces", Arrays.asList("tensura:human", "tensura:elf", "tensura:dwarf", "tensura:merfolk", "tensura:beastfolk", "tensura:goblin", "tensura:lizardman", "tensura:ogre", "tensura:orc", "tensura:slime", "tensura:wight", "tensura:ghoul", "tensura:lesser_daemon"), raceRegistryObject -> true);
        this.randomRaces = builder.comment(new String[]{"List of races that can be obtained through picking the \"Random\" option in the Race Selection Menu", "default: the same as startingRaces"}).defineList("possibleRandomRaces", Arrays.asList("tensura:human", "tensura:ogre", "tensura:orc", "tensura:lizardman", "tensura:beastfolk", "tensura:slime", "tensura:merfolk", "tensura:elf", "tensura:dwarf", "tensura:goblin", "tensura:ghoul", "tensura:wight", "tensura:lesser_daemon"), check -> true);
        builder.pop();
        builder.push("evolutionRequirements");
        this.epToEnlightened = builder.comment("The amount of EP needed to evolve into Enlightened or equivalent races").defineInRange("epToEnlightened", 100000.0, 0.0, 1.0E9);
        this.epToSaint = builder.comment("The amount of EP needed to evolve into Saint or equivalent races").defineInRange("epToSaint", 400000.0, 0.0, 1.0E9);
        this.epToDivine = builder.comment("The amount of EP needed to evolve into Divine or equivalent races").defineInRange("epToDivine", 2000000.0, 0.0, 1.0E9);
        this.epToHighOrc = builder.comment("The amount of EP needed to evolve into High Orc as an Orc").defineInRange("epToHighOrc", 5000.0, 0.0, 1.0E9);
        this.epToDisaster = builder.comment("The amount of EP needed to evolve into Orc Disaster as an Orc Lord").defineInRange("epToDisaster", 200000.0, 0.0, 1.0E9);
        this.epToOvercomer = builder.comment("The amount of EP needed to evolve into Vampire Overcomer as a Vampire").defineInRange("epToOvercomer", 150000.0, 0.0, 1.0E9);
        this.epToWightKing = builder.comment("The amount of EP needed to evolve into Wight King as a Wight").defineInRange("epToWightKing", 200000.0, 0.0, 1.0E9);
        this.epToSpiritSkeleton = builder.comment("The amount of EP needed to evolve into Spirit Skeleton as a Wight King").defineInRange("epToSpiritSkeleton", 800000.0, 0.0, 1.0E9);
        this.epToTrueDragonewt = builder.comment("The amount of EP needed to evolve into True Dragonewt as a Dragonewt").defineInRange("epToTrueDragonewt", 800000.0, 0.0, 1.0E9);
        this.bossForSaint = builder.comment("The number of Boss kills needed to evolve into Saint or equivalent races").defineInRange("bossForSaint", 4, 0, 10000);
        this.essenceForDragonewt = builder.comment("The number of Dragon Essences needed to evolve into Dragonewt as a Lizardman").defineInRange("essenceForDragonewt", 10, 0, 10000);
        this.essenceForMystic = builder.comment("The number of Elemental Essences needed to evolve into Mystic Oni as a Kijin").defineInRange("essenceForMystic", 10, 0, 10000);
        this.essenceForWicked = builder.comment("The number of Demon Essences needed to evolve into Wicked Oni as a Kijin").defineInRange("essenceForWicked", 10, 0, 10000);
        this.oreForMetalSlime = builder.comment("The number of Magic Ores needed to evolve into Metal Slime as a Slime").defineInRange("oreForMetalSlime", 100, 0, 10000);
        this.bloodForOrcLord = builder.comment("The number of Royal Bloods needed to evolve into Orc Lord as an Orc").defineInRange("bloodForOrcLord", 10, 0, 10000);
        this.bloodForVampireAsHuman = builder.comment("The number of Zane Bloods needed to evolve into Vampire as a Human").defineInRange("bloodForVampireAsHuman", 5, 0, 10000);
        this.bloodForVampireAsGhoul = builder.comment("The number of Zane Bloods needed to evolve into Vampire as a Ghoul").defineInRange("bloodForVampireAsGhoul", 1, 0, 10000);
        builder.pop();
        builder.push("possessionStats");
        this.maxHeathPossession = builder.comment("The maximum amount of HP the user can get from possessing an entity").defineInRange("maxHeathPossession", 6000.0, 0.0, 1.0E9);
        this.maxAttackPossession = builder.comment("The maximum amount of Attack Damage the user can get from possessing an entity").defineInRange("maxAttackPossession", 100.0, 0.0, 1.0E9);
        builder.pop();
    }
}

