/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.core;

import com.github.manasmods.tensura.enchantment.IInherentEngrave;
import com.github.manasmods.tensura.enchantment.SlottingEnchantment;
import java.util.Set;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.extensions.IForgeItem;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public class MixinItem
implements IForgeItem {
    @Shadow
    @Final
    protected boolean canRepair;

    public boolean isRepairable(ItemStack stack) {
        return this.canRepair && this.isDamageable(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.m_41720_() == newStack.m_41720_() && oldStack.m_41741_() == 1 && newStack.m_41741_() == 1 && oldStack.m_41783_() != null && newStack.m_41783_() != null && oldStack.m_41783_().m_128459_("DurabilityEP") != newStack.m_41783_().m_128459_("DurabilityEP")) {
            return false;
        }
        return oldStack != newStack;
    }

    @Inject(method={"isFoil(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void isFoil(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        int amount = 0;
        Set enchantments = stack.getAllEnchantments().keySet();
        for (Enchantment enchantment : enchantments) {
            IInherentEngrave noFoil;
            if (!(enchantment instanceof IInherentEngrave) || (noFoil = (IInherentEngrave)enchantment).shouldHasFoil(stack)) continue;
            ++amount;
        }
        if (enchantments.size() <= amount) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getUseAnimation(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/UseAnim;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getUseAnimation(ItemStack pStack, CallbackInfoReturnable<UseAnim> cir) {
        if (!((UseAnim)cir.getReturnValue()).equals((Object)UseAnim.NONE)) {
            return;
        }
        if (SlottingEnchantment.getContentWeight(pStack) > 0) {
            cir.setReturnValue((Object)UseAnim.BOW);
        }
    }

    @Inject(method={"getUseDuration(Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="RETURN")}, cancellable=true)
    private void getUseDuration(ItemStack pStack, CallbackInfoReturnable<Integer> cir) {
        if ((Integer)cir.getReturnValue() >= 16) {
            return;
        }
        if (SlottingEnchantment.getContentWeight(pStack) > 0) {
            cir.setReturnValue((Object)36000);
        }
    }

    @Inject(method={"overrideStackedOnOther(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/inventory/Slot;Lnet/minecraft/world/inventory/ClickAction;Lnet/minecraft/world/entity/player/Player;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void overrideStackedOnOther(ItemStack pStack, Slot pSlot, ClickAction pAction, Player pPlayer, CallbackInfoReturnable<Boolean> cir) {
        if (SlottingEnchantment.getElementalSlots(pStack) > 0 && SlottingEnchantment.putToolUponCore(pStack, pSlot, pAction, pPlayer)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"overrideOtherStackedOnMe(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/inventory/Slot;Lnet/minecraft/world/inventory/ClickAction;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/SlotAccess;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void overrideOtherStackedOnMe(ItemStack pStack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess, CallbackInfoReturnable<Boolean> cir) {
        if (SlottingEnchantment.getElementalSlots(pStack) > 0 && SlottingEnchantment.putCoreOnTool(pStack, pOther, pSlot, pAccess, pAction, pPlayer)) {
            cir.setReturnValue((Object)true);
        }
    }
}

