/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.core;

import com.github.manasmods.tensura.event.ItemDamageEvent;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ItemStack.class})
public abstract class MixinItemStack {
    @Redirect(method={"save"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;putByte(Ljava/lang/String;B)V"))
    private void save(CompoundTag tag, String key, byte p_128346_) {
        int count = ((ItemStack)this).m_41613_();
        tag.m_128344_("Count", (byte)Math.min(count, 127));
        if (count > 127) {
            tag.m_128405_("CountInt", count);
        }
    }

    @Redirect(method={"<init>(Lnet/minecraft/nbt/CompoundTag;)V"}, at=@At(value="FIELD", target="Lnet/minecraft/world/item/ItemStack;count:I", opcode=181))
    private void init(ItemStack instance, int value, CompoundTag tag) {
        ItemStack stack = (ItemStack)this;
        if (tag.m_128441_("CountInt")) {
            stack.m_41764_(tag.m_128451_("CountInt"));
        } else if (tag.m_128435_("Count") == 3) {
            stack.m_41764_(tag.m_128451_("Count"));
        } else {
            stack.m_41764_((int)tag.m_128445_("Count"));
        }
    }

    @ModifyArg(method={"hurtAndBreak"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurt(ILnet/minecraft/util/RandomSource;Lnet/minecraft/server/level/ServerPlayer;)Z"), index=0)
    private int onItemDamage(int pAmount, RandomSource pRandom, @Nullable ServerPlayer pUser) {
        ItemDamageEvent event;
        ItemStack stack = (ItemStack)this;
        if (stack.m_41763_() && pAmount > 0) {
            int i = stack.getEnchantmentLevel((Enchantment)TensuraEnchantments.STURDY.get()) * 5;
            i -= stack.getEnchantmentLevel((Enchantment)TensuraEnchantments.CRUSHING.get()) * 3;
            int j = 0;
            for (int k = 0; k < pAmount; ++k) {
                if (!DigDurabilityEnchantment.m_220282_((ItemStack)stack, (int)Math.abs(i), (RandomSource)pRandom)) continue;
                j += i < 0 ? -1 : 1;
            }
            pAmount -= j;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new ItemDamageEvent(stack, pAmount, pUser)))) {
            return 0;
        }
        return event.getAmount();
    }
}

