/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.core;

import com.github.manasmods.tensura.api.entity.ai.AvoidFearedEntityGoal;
import com.github.manasmods.tensura.api.entity.ai.AvoidMagicEngineGoal;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.entity.magic.barrier.MagicEngineBarrierEntity;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NearestAttackableTargetGoal.class})
public class MixinNearestAttackableTargetGoal {
    @Inject(method={"canUse"}, at={@At(value="RETURN")}, cancellable=true)
    public void canUse(CallbackInfoReturnable<Boolean> cir) {
        NearestAttackableTargetGoal goal = (NearestAttackableTargetGoal)this;
        LivingEntity target = goal.f_26050_;
        if (((Boolean)cir.getReturnValue()).booleanValue() && target != null) {
            if (target instanceof Player) {
                Player player = (Player)target;
                Race race = TensuraPlayerCapability.getRace((LivingEntity)player);
                if (race != null && race.passivelyFriendlyWith((LivingEntity)goal.f_26135_)) {
                    cir.setReturnValue((Object)false);
                    return;
                }
                if (AvoidFearedEntityGoal.shouldAvoid(goal.f_26135_) && target == TensuraEffectsCapability.getEffectSource((LivingEntity)goal.f_26135_, (MobEffect)TensuraMobEffects.FEAR.get())) {
                    cir.setReturnValue((Object)false);
                    return;
                }
            }
            if (TensuraEPCapability.isTargetNeutral((LivingEntity)goal.f_26135_, target)) {
                cir.setReturnValue((Object)false);
                return;
            }
            MagicEngineBarrierEntity barrier = AvoidMagicEngineGoal.getNearestEntity(target.m_9236_(), MagicEngineBarrierEntity.class, new AABB(target.m_20183_()).m_82400_(25.0), target.m_20185_(), target.m_20186_(), target.m_20189_());
            if (barrier == null || barrier.m_20270_((Entity)goal.f_26135_) < 25.0f) {
                return;
            }
            cir.setReturnValue((Object)false);
        }
    }
}

