/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.data.gen;

import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.registry.items.TensuraConsumableItems;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.registry.items.TensuraSmithingSchematicItems;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.data.loot.ChestLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class TensuraChestLootProvider
extends ChestLoot
implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
    private final RandomSource randomSource = RandomSource.m_216327_();

    @Override
    public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
        consumer.accept(StructureLootTables.PALM_GOBLIN_VILLAGE, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 8)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42404_).m_79707_(50))).m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42405_).m_79707_(25))).m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42410_).m_79707_(30))).m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 8)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42398_).m_79707_(35))).m_79161_(LootPool.m_79043_().m_165133_(this.exactly(1)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)TensuraSmithingSchematicItems.SHORT_SWORD.get()).m_79707_(25)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(75))));
        consumer.accept(StructureLootTables.LIZARDMEN_BARREL, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 8)).m_79076_(this.item((ItemLike)Items.f_42530_))).m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 8)).m_79076_(this.item((ItemLike)Items.f_42531_))).m_79161_(LootPool.m_79043_().m_165133_(this.exactly(1)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42468_, this.randomSource.m_216339_(1, 100)).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42469_, this.randomSource.m_216339_(1, 100)).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42470_, this.randomSource.m_216339_(1, 100)).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42471_, this.randomSource.m_216339_(1, 100)).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(60))).m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 3)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)TensuraMobDropItems.MONSTER_LEATHER_D.get()).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(80))).m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 5)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41867_).m_79707_(25)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(75))).m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41902_).m_79707_(30)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(70))));
        consumer.accept(StructureLootTables.LIZARDMEN_CHEST, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 16)).m_79076_(this.item((ItemLike)Items.f_42526_))).m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 16)).m_79076_(this.item((ItemLike)Items.f_42527_))).m_79161_(LootPool.m_79043_().m_165133_(this.exactly(1)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42523_, this.randomSource.m_216339_(1, 100)).m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(50))).m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42094_).m_79707_(25)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(75))).m_79161_(LootPool.m_79043_().m_165133_(this.exactly(1)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42529_).m_79707_(25)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(75))).m_79161_(LootPool.m_79043_().m_165133_(this.exactly(1)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42450_).m_79707_(25)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(75))));
        consumer.accept(StructureLootTables.LIZARDMEN_SMITHING, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 5)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42416_).m_79707_(70)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42417_).m_79707_(30))).m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_151052_).m_79707_(30)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)TensuraMaterialItems.SILVER_INGOT.get()).m_79707_(70))).m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42383_, this.randomSource.m_216339_(1, 100)).m_79707_(25)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)TensuraToolItems.IRON_SPEAR.get(), this.randomSource.m_216339_(1, 100)).m_79707_(25)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(50))).m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_151050_).m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)TensuraToolItems.IRON_SHORT_SWORD.get(), this.randomSource.m_216339_(1, 100)).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(40))).m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)TensuraSmithingSchematicItems.SPEAR.get()).m_79707_(50)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42713_).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(30))));
        consumer.accept(StructureLootTables.SPIDER_NEST, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 5)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42413_).m_79707_(70)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42484_).m_79707_(30))).m_79161_(LootPool.m_79043_().m_165133_(this.between(3, 8)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)TensuraBlocks.SPIDER_EGG.get()).m_79707_(30)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)TensuraBlocks.STICKY_COBWEB.get()).m_79707_(30)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)TensuraBlocks.STICKY_STEEL_COBWEB.get()).m_79707_(30)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(10))).m_79161_(LootPool.m_79043_().m_165133_(this.between(0, 1)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42656_).m_79707_(25)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)TensuraToolItems.SHORT_SPIDER_BOW.get(), this.randomSource.m_216339_(1, 100)).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)TensuraToolItems.SPIDER_BOW.get(), this.randomSource.m_216339_(1, 100)).m_79707_(10)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)TensuraToolItems.LONG_SPIDER_BOW.get(), this.randomSource.m_216339_(1, 100)).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(50))).m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 4)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_151050_).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_151053_).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)TensuraMaterialItems.RAW_SILVER.get()).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(40))).m_79161_(LootPool.m_79043_().m_165133_(this.between(1, 3)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)TensuraSmithingSchematicItems.WEB_GUN.get()).m_79707_(20)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42401_).m_79707_(26)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)TensuraConsumableItems.ENCHANTED_SILVER_APPLE.get()).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_42437_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)this.item((ItemLike)Items.f_41852_).m_79707_(50))));
    }

    private NumberProvider exactly(int number) {
        if (number <= 0) {
            throw new IllegalArgumentException("Number has to be greater than zero.");
        }
        return ConstantValue.m_165692_((float)number);
    }

    private NumberProvider between(int min, int max) {
        if (min > max) {
            throw new IllegalArgumentException("Min cannot be greater than Max.");
        }
        return UniformGenerator.m_165780_((float)min, (float)max);
    }

    private LootPoolSingletonContainer.Builder<?> item(ItemLike item) {
        return LootItem.m_79579_((ItemLike)item);
    }

    private LootPoolSingletonContainer.Builder<?> item(ItemLike item, int durability) {
        if (item.m_5456_().m_7968_().m_41776_() < durability || durability <= 0) {
            return LootItem.m_79579_((ItemLike)item);
        }
        Item item1 = item.m_5456_();
        item1.setDamage(item.m_5456_().m_7968_(), durability);
        return LootItem.m_79579_((ItemLike)item1);
    }

    public static class StructureLootTables {
        private static Set<ResourceLocation> LOOTTABLES = new HashSet<ResourceLocation>();
        public static ResourceLocation PALM_GOBLIN_VILLAGE = StructureLootTables.register("palm_goblin_village");
        public static ResourceLocation LIZARDMEN_BARREL = StructureLootTables.register("lizardmen_barrel");
        public static ResourceLocation LIZARDMEN_CHEST = StructureLootTables.register("lizardmen_chest");
        public static ResourceLocation LIZARDMEN_SMITHING = StructureLootTables.register("lizardmen_smithing");
        public static ResourceLocation SPIDER_NEST = StructureLootTables.register("spider_nest");

        private static ResourceLocation register(String name) {
            ResourceLocation resourceLocation = new ResourceLocation("tensura", String.format("chests/%s", name));
            if (LOOTTABLES.add(resourceLocation)) {
                return resourceLocation;
            }
            throw new IllegalArgumentException(resourceLocation + " already exists.");
        }
    }
}

