/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.data.pack.Slotting;

import com.github.manasmods.tensura.data.pack.Slotting.MagicEffect;
import com.github.manasmods.tensura.data.pack.Slotting.MagicProjectile;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class SlottingElementCombination {
    public static final Codec<SlottingElementCombination> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("combinationID").forGetter(SlottingElementCombination::getCombinationID), (App)Codec.INT.optionalFieldOf("earthCores", (Object)0).forGetter(SlottingElementCombination::getEarthCores), (App)Codec.INT.optionalFieldOf("fireCores", (Object)0).forGetter(SlottingElementCombination::getFireCores), (App)Codec.INT.optionalFieldOf("spaceCores", (Object)0).forGetter(SlottingElementCombination::getSpaceCores), (App)Codec.INT.optionalFieldOf("waterCores", (Object)0).forGetter(SlottingElementCombination::getWaterCores), (App)Codec.INT.optionalFieldOf("windCores", (Object)0).forGetter(SlottingElementCombination::getWindCores), (App)Codec.DOUBLE.optionalFieldOf("earthMultiplier", (Object)0.0).forGetter(SlottingElementCombination::getEarthMultiplier), (App)Codec.DOUBLE.optionalFieldOf("fireMultiplier", (Object)0.0).forGetter(SlottingElementCombination::getFireMultiplier), (App)Codec.DOUBLE.optionalFieldOf("spaceMultiplier", (Object)0.0).forGetter(SlottingElementCombination::getSpaceMultiplier), (App)Codec.DOUBLE.optionalFieldOf("waterMultiplier", (Object)0.0).forGetter(SlottingElementCombination::getWaterMultiplier), (App)Codec.DOUBLE.optionalFieldOf("windMultiplier", (Object)0.0).forGetter(SlottingElementCombination::getWindMultiplier), (App)MagicProjectile.CODEC.optionalFieldOf("magicProjectile", (Object)MagicProjectile.empty).forGetter(SlottingElementCombination::getProjectile), (App)Codec.BOOL.optionalFieldOf("dud", (Object)false).forGetter(SlottingElementCombination::isDud)).apply((Applicative)instance, SlottingElementCombination::new));
    private final int combinationID;
    private final int earthCores;
    private final int fireCores;
    private final int spaceCores;
    private final int waterCores;
    private final int windCores;
    private final double earthMultiplier;
    private final double fireMultiplier;
    private final double spaceMultiplier;
    private final double waterMultiplier;
    private final double windMultiplier;
    private final MagicProjectile projectile;
    private final boolean dud;

    public static SlottingElementCombination of(int combinationID, int earthCore, int fireCore, int spaceCore, int waterCore, int windCore, double earthMultiplier, double fireMultiplier, double spaceMultiplier, double waterMultiplier, double windMultiplier, String entity, float speed, float damage, float knockForce, float explosionRadius, int burnTicks, boolean noGravity, String effect, int level, int ticks, float range) {
        MagicProjectile projectile = new MagicProjectile(new ResourceLocation(entity), speed, damage, knockForce, explosionRadius, burnTicks, noGravity, new MagicEffect(new ResourceLocation(effect), level, ticks, range));
        return new SlottingElementCombination(combinationID, earthCore, fireCore, spaceCore, waterCore, windCore, earthMultiplier, fireMultiplier, spaceMultiplier, waterMultiplier, windMultiplier, projectile, false);
    }

    public static SlottingElementCombination of(int combinationID, int earthCore, int fireCore, int spaceCore, int waterCore, int windCore, double earthMultiplier, double fireMultiplier, double spaceMultiplier, double waterMultiplier, double windMultiplier, String entity, float speed, float damage, float knockForce, float explosionRadius, int burnTicks, boolean noGravity, String effect, int level, int ticks) {
        MagicProjectile projectile = new MagicProjectile(new ResourceLocation(entity), speed, damage, knockForce, explosionRadius, burnTicks, noGravity, new MagicEffect(new ResourceLocation(effect), level, ticks, 0.0f));
        return new SlottingElementCombination(combinationID, earthCore, fireCore, spaceCore, waterCore, windCore, earthMultiplier, fireMultiplier, spaceMultiplier, waterMultiplier, windMultiplier, projectile, false);
    }

    public static SlottingElementCombination of(int combinationID, int earthCore, int fireCore, int spaceCore, int waterCore, int windCore, double earthMultiplier, double fireMultiplier, double spaceMultiplier, double waterMultiplier, double windMultiplier, String entity, float speed, float damage, float knockForce, float explosionRadius, int burnTicks, boolean noGravity, String effect, int level) {
        MagicProjectile projectile = new MagicProjectile(new ResourceLocation(entity), speed, damage, knockForce, explosionRadius, burnTicks, noGravity, new MagicEffect(new ResourceLocation(effect), level, 100, 0.0f));
        return new SlottingElementCombination(combinationID, earthCore, fireCore, spaceCore, waterCore, windCore, earthMultiplier, fireMultiplier, spaceMultiplier, waterMultiplier, windMultiplier, projectile, false);
    }

    public static SlottingElementCombination of(int combinationID, int earthCore, int fireCore, int spaceCore, int waterCore, int windCore, double earthMultiplier, double fireMultiplier, double spaceMultiplier, double waterMultiplier, double windMultiplier, String entity, float speed, float damage, float knockForce, float explosionRadius, int burnTicks, boolean noGravity, String effect) {
        MagicProjectile projectile = new MagicProjectile(new ResourceLocation(entity), speed, damage, knockForce, explosionRadius, burnTicks, noGravity, new MagicEffect(new ResourceLocation(effect), 0, 100, 0.0f));
        return new SlottingElementCombination(combinationID, earthCore, fireCore, spaceCore, waterCore, windCore, earthMultiplier, fireMultiplier, spaceMultiplier, waterMultiplier, windMultiplier, projectile, false);
    }

    public static SlottingElementCombination of(int combinationID, int earthCore, int fireCore, int spaceCore, int waterCore, int windCore, double earthMultiplier, double fireMultiplier, double spaceMultiplier, double waterMultiplier, double windMultiplier, String entity, float speed, float damage, float knockForce, float explosionRadius, int burnTicks, boolean noGravity) {
        MagicProjectile projectile = new MagicProjectile(new ResourceLocation(entity), speed, damage, knockForce, explosionRadius, burnTicks, noGravity, MagicProjectile.noEffect);
        return new SlottingElementCombination(combinationID, earthCore, fireCore, spaceCore, waterCore, windCore, earthMultiplier, fireMultiplier, spaceMultiplier, waterMultiplier, windMultiplier, projectile, false);
    }

    public static SlottingElementCombination of(int combinationID, int earthCore, int fireCore, int spaceCore, int waterCore, int windCore, double earthMultiplier, double fireMultiplier, double spaceMultiplier, double waterMultiplier, double windMultiplier, boolean dud) {
        return new SlottingElementCombination(combinationID, earthCore, fireCore, spaceCore, waterCore, windCore, earthMultiplier, fireMultiplier, spaceMultiplier, waterMultiplier, windMultiplier, MagicProjectile.empty, dud);
    }

    public void buildJson(BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        ResourceLocation combinationResourceLocation = new ResourceLocation("tensura", String.valueOf(this.combinationID));
        consumer.accept(combinationResourceLocation, () -> (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().orElseThrow(() -> new IllegalStateException("Could not serialize " + this)));
    }

    public SlottingElementCombination(int combinationID, int earthCores, int fireCores, int spaceCores, int waterCores, int windCores, double earthMultiplier, double fireMultiplier, double spaceMultiplier, double waterMultiplier, double windMultiplier, MagicProjectile projectile, boolean dud) {
        this.combinationID = combinationID;
        this.earthCores = earthCores;
        this.fireCores = fireCores;
        this.spaceCores = spaceCores;
        this.waterCores = waterCores;
        this.windCores = windCores;
        this.earthMultiplier = earthMultiplier;
        this.fireMultiplier = fireMultiplier;
        this.spaceMultiplier = spaceMultiplier;
        this.waterMultiplier = waterMultiplier;
        this.windMultiplier = windMultiplier;
        this.projectile = projectile;
        this.dud = dud;
    }

    public String toString() {
        return "SlottingElementCombination(combinationID=" + this.getCombinationID() + ", earthCores=" + this.getEarthCores() + ", fireCores=" + this.getFireCores() + ", spaceCores=" + this.getSpaceCores() + ", waterCores=" + this.getWaterCores() + ", windCores=" + this.getWindCores() + ", earthMultiplier=" + this.getEarthMultiplier() + ", fireMultiplier=" + this.getFireMultiplier() + ", spaceMultiplier=" + this.getSpaceMultiplier() + ", waterMultiplier=" + this.getWaterMultiplier() + ", windMultiplier=" + this.getWindMultiplier() + ", projectile=" + this.getProjectile() + ", dud=" + this.isDud() + ")";
    }

    public int getCombinationID() {
        return this.combinationID;
    }

    public int getEarthCores() {
        return this.earthCores;
    }

    public int getFireCores() {
        return this.fireCores;
    }

    public int getSpaceCores() {
        return this.spaceCores;
    }

    public int getWaterCores() {
        return this.waterCores;
    }

    public int getWindCores() {
        return this.windCores;
    }

    public double getEarthMultiplier() {
        return this.earthMultiplier;
    }

    public double getFireMultiplier() {
        return this.fireMultiplier;
    }

    public double getSpaceMultiplier() {
        return this.spaceMultiplier;
    }

    public double getWaterMultiplier() {
        return this.waterMultiplier;
    }

    public double getWindMultiplier() {
        return this.windMultiplier;
    }

    public MagicProjectile getProjectile() {
        return this.projectile;
    }

    public boolean isDud() {
        return this.dud;
    }
}

