/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.effect;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.effect.template.TensuraMobEffect;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.registry.race.TensuraRaces;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CurseEffect
extends TensuraMobEffect {
    protected static final String CURSE_HEALTH_UUID = "2c0ab91a-c4ab-11ed-afa1-0242ac120002";

    public CurseEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
        this.m_19472_(Attributes.f_22276_, CURSE_HEALTH_UUID, -0.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public void m_6385_(LivingEntity entity, AttributeMap pAttributeMap, int pAmplifier) {
        super.m_6385_(entity, pAttributeMap, pAmplifier);
        if (entity.m_21223_() > entity.m_21233_()) {
            entity.m_21153_(entity.m_21233_());
        }
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (amplifier >= 3 && entity.m_6469_(TensuraDamageSources.CURSE, entity.m_21233_())) {
            this.wightTransformation(entity);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return amplifier >= 3;
    }

    public List<ItemStack> getCurativeItems() {
        return Collections.emptyList();
    }

    private boolean canBecomeWight(Race race, Player player) {
        if (race.isMajin()) {
            return false;
        }
        return race.getPreviousEvolutions(player).isEmpty();
    }

    private void wightTransformation(LivingEntity entity) {
        if (entity.m_6084_()) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player pPlayer = (Player)entity;
        if ((double)entity.m_217043_().m_188501_() >= 0.05) {
            return;
        }
        TensuraPlayerCapability.getFrom(pPlayer).ifPresent(cap -> {
            if (cap.getRace() == null || !this.canBecomeWight(cap.getRace(), pPlayer)) {
                return;
            }
            Race race = (Race)TensuraRaces.WIGHT.get();
            cap.setRace((LivingEntity)pPlayer, race, false);
            cap.setTrackedEvolution(pPlayer, null);
            TensuraEPCapability.setMajin((LivingEntity)pPlayer, true);
            if (pPlayer.m_9236_().m_5776_()) {
                return;
            }
            if (race.getIntrinsicSkills(pPlayer).isEmpty()) {
                return;
            }
            for (ManasSkill manasSkill : race.getIntrinsicSkills(pPlayer)) {
                TensuraSkillInstance instance = new TensuraSkillInstance(manasSkill);
                if (!SkillUtils.learnSkill((LivingEntity)pPlayer, instance)) continue;
                cap.addIntrinsicSkill(instance.getSkill());
                pPlayer.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{manasSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                if (!instance.canBeToggled((LivingEntity)pPlayer)) continue;
                instance.setToggled(true);
                instance.onToggleOn((LivingEntity)pPlayer);
            }
        });
        TensuraPlayerCapability.sync(pPlayer);
    }
}

