/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.effect.skill;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.InfiniteRegenerationSkill;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.effect.template.MobEffectHelper;
import com.github.manasmods.tensura.effect.template.SkillMobEffect;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;

public class InstantRegenerationEffect
extends SkillMobEffect {
    public InstantRegenerationEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void m_6742_(LivingEntity entity, int pAmplifier) {
        double maxHealth = (double)entity.m_21233_() - TensuraEffectsCapability.getSeverance(entity);
        if (maxHealth <= 0.0) {
            return;
        }
        boolean failed = false;
        float lackedHealth = (float)maxHealth - entity.m_21223_();
        if (lackedHealth > 0.0f && !MobEffectHelper.shouldCancelHeal(entity)) {
            if (entity instanceof Player) {
                double lackedMagicule;
                Player player = (Player)entity;
                float cost = pAmplifier == 0 && SkillUtils.isSkillToggled((Entity)entity, (ManasSkill)UniqueSkills.SURVIVOR.get()) ? 20.0f : 100.0f;
                Skill toggledSkill = pAmplifier > 0 ? (Skill)((Object)ExtraSkills.INFINITE_REGENERATION.get()) : (Skill)((Object)ExtraSkills.ULTRASPEED_REGENERATION.get());
                Optional instance = SkillAPI.getSkillsFrom((Entity)entity).getSkill((ManasSkill)toggledSkill);
                if (instance.isPresent() && ((ManasSkillInstance)instance.get()).isMastered(entity)) {
                    cost = 60.0f;
                }
                if ((lackedMagicule = SkillHelper.outOfMagiculeStillConsume((LivingEntity)player, (int)(lackedHealth * cost))) > 0.0) {
                    lackedHealth = (float)((double)lackedHealth - lackedMagicule / (double)cost);
                    if (instance.isPresent() && ((ManasSkillInstance)instance.get()).isToggled()) {
                        ((ManasSkillInstance)instance.get()).setToggled(false);
                        SkillAPI.getSkillsFrom((Entity)entity).syncChanges();
                        failed = true;
                        player.m_21195_((MobEffect)this);
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.lack_magicule.toggled_off", (Object[])new Object[]{toggledSkill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                }
            }
            entity.m_5634_(lackedHealth);
        }
        if (!failed) {
            this.healSHP(entity, pAmplifier);
        }
    }

    private void healSHP(LivingEntity entity, int pAmplifier) {
        if (pAmplifier < 1) {
            return;
        }
        double SHP = TensuraEPCapability.getSpiritualHealth(entity);
        double maxSHP = entity.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
        double lackedSHP = maxSHP - SHP;
        if (lackedSHP <= 0.0) {
            return;
        }
        if (lackedSHP > 0.0) {
            if (entity instanceof Player) {
                double lackedMagicule;
                Player player = (Player)entity;
                float cost = 120.0f;
                Optional instance = SkillAPI.getSkillsFrom((Entity)entity).getSkill((ManasSkill)ExtraSkills.INFINITE_REGENERATION.get());
                if (instance.isPresent() && ((ManasSkillInstance)instance.get()).isMastered(entity)) {
                    cost = 80.0f;
                }
                if ((lackedMagicule = SkillHelper.outOfMagiculeStillConsume((LivingEntity)player, (int)(lackedSHP * (double)cost))) > 0.0) {
                    lackedSHP -= lackedMagicule / (double)cost;
                    if (instance.isPresent() && ((ManasSkillInstance)instance.get()).isToggled()) {
                        ((ManasSkillInstance)instance.get()).setToggled(false);
                        SkillAPI.getSkillsFrom((Entity)entity).syncChanges();
                        player.m_21195_((MobEffect)this);
                        player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.lack_magicule.toggled_off", (Object[])new Object[]{((InfiniteRegenerationSkill)((Object)ExtraSkills.INFINITE_REGENERATION.get())).getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                    }
                }
            }
            TensuraEPCapability.setSpiritualHealth(entity, Math.min(SHP + lackedSHP, maxSHP));
        }
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return pDuration % 10 == 0;
    }

    public static boolean canStopDeath(DamageSource source, LivingEntity entity) {
        TensuraDamageSource damageSource;
        if (source.m_19378_()) {
            return false;
        }
        if (source instanceof TensuraDamageSource && (double)(damageSource = (TensuraDamageSource)source).getIgnoreBarrier() >= 1.75) {
            return false;
        }
        return (double)entity.m_21233_() > TensuraEffectsCapability.getSeverance(entity);
    }
}

