/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.effect.template;

import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.effect.template.TensuraMobEffect;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class SkillMobEffect
extends TensuraMobEffect {
    public SkillMobEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    protected void addAttributeModifiersWithMinSize(LivingEntity entity, AttributeMap map, int amplifier) {
        for (Map.Entry entry : this.m_19485_().entrySet()) {
            AttributeInstance instance = map.m_22146_((Attribute)entry.getKey());
            if (instance == null) continue;
            AttributeModifier modifier = (AttributeModifier)entry.getValue();
            instance.m_22130_(modifier);
            double amount = this.m_7048_(amplifier, modifier);
            if (((Attribute)entry.getKey()).equals(TensuraAttributeRegistry.SIZE.get()) && !modifier.m_22217_().equals((Object)AttributeModifier.Operation.ADDITION)) {
                float sizeMultiplier = RaceHelper.getSizeMultiplier(entity);
                amount = Math.max((1.0 + amount) * (double)sizeMultiplier, (Double)TensuraConfig.INSTANCE.attributeConfig.minimumSize.get()) / (double)sizeMultiplier - 1.0;
            }
            instance.m_22125_(new AttributeModifier(modifier.m_22209_(), this.m_19481_() + " " + amplifier, amount, modifier.m_22217_()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(@NotNull Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new IClientMobEffectExtensions(){

            public boolean isVisibleInInventory(MobEffectInstance instance) {
                return false;
            }

            public boolean isVisibleInGui(MobEffectInstance instance) {
                return false;
            }
        });
    }

    public static boolean removeAllEffects(LivingEntity entity) {
        if (entity.f_19853_.f_46443_) {
            return false;
        }
        boolean success = false;
        for (MobEffectInstance effect : List.copyOf(entity.m_21220_())) {
            if (MinecraftForge.EVENT_BUS.post((Event)new MobEffectEvent.Remove(entity, effect)) || !(effect.m_19544_() instanceof SkillMobEffect)) continue;
            entity.m_21195_(effect.m_19544_());
            success = true;
        }
        return success;
    }

    public List<ItemStack> getCurativeItems() {
        return Collections.emptyList();
    }
}

