/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.enchantment;

import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.enchantment.IInherentEngrave;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class DeadEndRainbowEnchantment
extends EngravingEnchantment
implements IInherentEngrave {
    public DeadEndRainbowEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.WEAPON, EquipmentSlot.MAINHAND);
    }

    @Override
    public ChatFormatting getNameFormatting() {
        return ChatFormatting.LIGHT_PURPLE;
    }

    @Override
    public void doAdditionalAttack(ItemStack stack, LivingEntity attacker, Entity entity, int pLevel, float damage) {
        float f;
        if (entity.f_19802_ >= 60) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        double SHP = target.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get());
        float max = Math.max(500.0f, damage);
        float shpDamage = (float)Mth.m_14008_((double)(SHP / 7.0 + SHP * (double)0.1f), (double)10.0, (double)max);
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            f = player.m_36403_(0.5f);
        } else {
            f = 1.0f;
        }
        float f2 = f;
        DamageSourceHelper.directSpiritualHurt(target, (Entity)attacker, shpDamage *= 0.2f + f2 * f2 * 0.8f);
    }

    public static void applyDeadEndRainbow(ItemStack toStack) {
        if (!toStack.m_150930_((Item)TensuraToolItems.DEAD_END_RAINBOW.get())) {
            return;
        }
        if (toStack.getEnchantmentLevel((Enchantment)TensuraEnchantments.DEAD_END_RAINBOW.get()) >= 1) {
            return;
        }
        EngravingEnchantment.engrave(toStack, (Enchantment)TensuraEnchantments.DEAD_END_RAINBOW.get(), 1);
    }
}

