/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.enchantment;

import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.event.EngravingEvent;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;

public class EngravingEnchantment
extends Enchantment {
    private static List<Enchantment> common;
    private static List<Enchantment> uncommon;
    private static List<Enchantment> rare;
    private static List<Enchantment> veryRare;

    protected EngravingEnchantment(Enchantment.Rarity pRarity, EnchantmentCategory pCategory, EquipmentSlot ... pApplicableSlots) {
        super(pRarity, pCategory, pApplicableSlots);
    }

    public int m_6183_(int pEnchantmentLevel) {
        return pEnchantmentLevel * 50;
    }

    @NotNull
    public Component m_44700_(int pLevel) {
        MutableComponent mutablecomponent = Component.m_237115_((String)this.m_44704_());
        mutablecomponent.m_130940_(this.getNameFormatting());
        if (pLevel != 1 || this.m_6586_() != 1) {
            mutablecomponent.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + pLevel)));
        }
        return mutablecomponent;
    }

    public ChatFormatting getNameFormatting() {
        return ChatFormatting.DARK_AQUA;
    }

    public boolean m_6594_() {
        return false;
    }

    public boolean m_6592_() {
        return false;
    }

    public boolean canApplyAtEnchantingTable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isAllowedOnBooks() {
        return false;
    }

    public boolean m_5975_(@NotNull Enchantment enchantment) {
        if (enchantment instanceof EngravingEnchantment) {
            return false;
        }
        return super.m_5975_(enchantment);
    }

    public float getDamageBonus(int pLevel, DamageSource source, LivingEntity attacker, LivingEntity target, EquipmentSlot slot, float damage) {
        return 0.0f;
    }

    public float getDamageProtection(int pLevel, DamageSource source, LivingEntity wearer, EquipmentSlot slot, float damage) {
        return 0.0f;
    }

    public void doAdditionalAttack(ItemStack stack, LivingEntity attacker, Entity target, int pLevel, float damage) {
    }

    public static void doAdditionalAttack(ItemStack stack, LivingEntity attacker, Entity target, float damage) {
        Map map = stack.getAllEnchantments();
        for (Enchantment enchantment : map.keySet()) {
            if (!(enchantment instanceof EngravingEnchantment)) continue;
            EngravingEnchantment engrave = (EngravingEnchantment)enchantment;
            engrave.doAdditionalAttack(stack, attacker, target, (Integer)map.get(enchantment), damage);
        }
    }

    public static void loadConfig() {
        common = ((List)TensuraConfig.INSTANCE.enchantmentsConfig.commonEnchantments.get()).stream().map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(arg_0)).toList();
        uncommon = ((List)TensuraConfig.INSTANCE.enchantmentsConfig.uncommonEnchantments.get()).stream().map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(arg_0)).toList();
        rare = ((List)TensuraConfig.INSTANCE.enchantmentsConfig.rareEnchantments.get()).stream().map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(arg_0)).toList();
        veryRare = ((List)TensuraConfig.INSTANCE.enchantmentsConfig.veryRareEnchantments.get()).stream().map(ResourceLocation::new).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENCHANTMENTS).getValue(arg_0)).toList();
    }

    public static void engrave(ItemStack itemstack, Enchantment enchantment, int level) {
        Map<Enchantment, Integer> map = EnchantmentHelper.m_44831_((ItemStack)itemstack).entrySet().stream().filter(entry -> entry.getKey() != enchantment).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        itemstack.m_41749_("Enchantments");
        itemstack.m_41749_("StoredEnchantments");
        if (level > 0) {
            map.put(enchantment, level);
        }
        EnchantmentHelper.m_44865_(map, (ItemStack)itemstack);
    }

    private static boolean shouldAddEngraving(ItemStack stack, int tier) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return false;
        }
        if (tier == 3 && !tag.m_128441_("GodEngraving")) {
            tag.m_128379_("GodEngraving", true);
            return true;
        }
        if (tier == 2 && !tag.m_128441_("LegendEngraving")) {
            tag.m_128379_("LegendEngraving", true);
            return true;
        }
        if (tier == 1 && !tag.m_128441_("UniqueEngraving")) {
            tag.m_128379_("UniqueEngraving", true);
            return true;
        }
        return false;
    }

    public static void randomEngraving(LivingEntity living, ItemStack stack, double epAfter) {
        int newLevel;
        EngravingEvent event;
        boolean toGod;
        boolean toUnique = epAfter >= (double)((Integer)TensuraConfig.INSTANCE.enchantmentsConfig.unique.get()).intValue() && EngravingEnchantment.shouldAddEngraving(stack, 1);
        boolean toLegend = !toUnique && epAfter >= (double)((Integer)TensuraConfig.INSTANCE.enchantmentsConfig.legendary.get()).intValue() && EngravingEnchantment.shouldAddEngraving(stack, 2);
        boolean bl = toGod = !toUnique && !toLegend && epAfter >= (double)((Integer)TensuraConfig.INSTANCE.enchantmentsConfig.god.get()).intValue() && EngravingEnchantment.shouldAddEngraving(stack, 3);
        if (!(toUnique || toLegend || toGod)) {
            return;
        }
        Enchantment engraving = null;
        int level = 0;
        Enchantment.Rarity rarity = EngravingEnchantment.getRarity(toGod ? 3 : (toLegend ? 2 : 1));
        switch (rarity) {
            case COMMON: {
                engraving = EngravingEnchantment.getRandomEngravingFromList(common, stack);
                break;
            }
            case UNCOMMON: {
                engraving = EngravingEnchantment.getRandomEngravingFromList(uncommon, stack);
                break;
            }
            case RARE: {
                engraving = EngravingEnchantment.getRandomEngravingFromList(rare, stack);
                level = 2;
                break;
            }
            case VERY_RARE: {
                engraving = EngravingEnchantment.getRandomEngravingFromList(veryRare, stack);
                level = 3;
            }
        }
        if (engraving == null) {
            return;
        }
        int oldLevel = stack.getEnchantmentLevel(engraving);
        if (oldLevel == level) {
            ++level;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new EngravingEvent(stack, living, engraving, newLevel = Math.min(oldLevel + level, engraving.m_6586_()))))) {
            return;
        }
        EngravingEnchantment.engrave(stack, event.getEnchantment(), event.getLevel());
    }

    private static Enchantment getRandomEngravingFromList(List<Enchantment> list, ItemStack stack) {
        List<Enchantment> filtered = list.stream().filter(enchantment -> {
            if (enchantment.f_44672_.equals((Object)EnchantmentCategory.WEAPON)) {
                return !EnchantmentCategory.WEARABLE.m_7454_(stack.m_41720_());
            }
            return enchantment.f_44672_.m_7454_(stack.m_41720_());
        }).toList();
        if (filtered.isEmpty()) {
            return null;
        }
        return filtered.get(new Random().nextInt(filtered.size()));
    }

    private static Enchantment.Rarity getRarity(int tier) {
        int chance = new Random().nextInt(100);
        if (tier == 3) {
            if (chance < 60) {
                return Enchantment.Rarity.RARE;
            }
            return Enchantment.Rarity.VERY_RARE;
        }
        if (tier == 2) {
            if (chance < 40) {
                return Enchantment.Rarity.UNCOMMON;
            }
            if (chance < 80) {
                return Enchantment.Rarity.RARE;
            }
            return Enchantment.Rarity.VERY_RARE;
        }
        if (chance < 50) {
            return Enchantment.Rarity.COMMON;
        }
        if (chance < 80) {
            return Enchantment.Rarity.UNCOMMON;
        }
        if (chance < 95) {
            return Enchantment.Rarity.RARE;
        }
        return Enchantment.Rarity.VERY_RARE;
    }
}

