/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.api.entity.ai.FlyingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.ai.TamableFollowParentGoal;
import com.github.manasmods.tensura.api.entity.ai.UndergroundTargetingEntitiesGoal;
import com.github.manasmods.tensura.api.entity.subclass.ITeleportation;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.WingedCatEntity;
import com.github.manasmods.tensura.entity.human.HinataSakaguchiEntity;
import com.github.manasmods.tensura.entity.magic.beam.SpatialRayProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.DimensionCutProjectile;
import com.github.manasmods.tensura.entity.template.GreaterSpiritEntity;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class AkashEntity
extends GreaterSpiritEntity
implements ITeleportation {
    public AkashEntity(EntityType<? extends AkashEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends GreaterSpiritEntity>)pEntityType, pLevel);
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.NOTCHED_20).m_7005_(true);
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22276_, 240.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 3.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.NPCMeleeAttackGoal((PathfinderMob)this, 2.0, true){

            @Override
            public boolean m_8036_() {
                if (!super.m_8036_()) {
                    return false;
                }
                return AkashEntity.this.usingMeleeWeapon();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new AkashAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new GreaterSpiritEntity.FollowHinataGoal(this, 1.0, HinataSakaguchiEntity.class));
        this.f_21345_.m_25352_(5, (Goal)new FlyingFollowOwnerGoal(this, 0.7, 10.0f, 4.0f, true, false));
        this.f_21345_.m_25352_(6, (Goal)new TamableFollowParentGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(7, (Goal)new GreaterSpiritEntity.WalkGoal(this, this));
        this.f_21345_.m_25352_(8, (Goal)new TensuraTamableEntity.FlyingWanderAroundPosGoal(this, this, 1.0, 12));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, AkashEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, new UndergroundTargetingEntitiesGoal<LivingEntity>(this, LivingEntity.class, false, 8.0f, this::shouldAttack));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity2;
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (pSource.m_7639_() instanceof WingedCatEntity) {
            return false;
        }
        if (this.shouldDodge(pSource, pAmount)) {
            return false;
        }
        pAmount = DamageSourceHelper.isNaturalEffects(pSource) ? (pAmount *= 0.2f) : (pAmount *= this.getPhysicalAttackInput(pSource));
        boolean hurt = super.m_6469_(pSource, pAmount);
        if (hurt && (entity2 = pSource.m_7639_()) instanceof LivingEntity) {
            Player player;
            LivingEntity damageSource = (LivingEntity)entity2;
            if (!damageSource.m_6084_()) {
                return true;
            }
            if (damageSource instanceof Player && ((player = (Player)damageSource).m_7500_() || player.m_5833_())) {
                return true;
            }
            List list = this.f_19853_.m_6443_(WingedCatEntity.class, this.m_20191_().m_82400_(32.0), entity -> !entity.m_21824_());
            if (!list.isEmpty()) {
                list.forEach(cat -> cat.m_6710_(damageSource));
            }
        }
        return hurt;
    }

    private boolean shouldDodge(DamageSource source, float damage) {
        if (this.m_9236_().m_5776_()) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (damage >= 10.0f) {
                if (source.m_19378_()) {
                    return false;
                }
                if ((double)entity2.m_217043_().m_188501_() >= 0.1) {
                    return false;
                }
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 2.0f, 1.0f);
                if (!this.m_9236_().m_5776_() && this.m_5448_() != null) {
                    this.teleportTowards((LivingEntity)this, (Entity)this.m_5448_(), 12.0);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof WingedCatEntity) {
            WingedCatEntity cat = (WingedCatEntity)entity;
            return cat.m_21824_() == this.m_21824_();
        }
        if (entity instanceof AkashEntity) {
            AkashEntity akash = (AkashEntity)entity;
            return akash.m_21824_() == this.m_21824_();
        }
        return false;
    }

    @Override
    public boolean shouldCountMotionBlock() {
        return false;
    }

    @Override
    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        if (this.m_6084_() && this.f_19797_ % 10 == 0) {
            TensuraParticleHelper.addParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123789_, 2.0);
        }
        if ((target = this.m_5448_()) == null) {
            return;
        }
        if (!this.m_6084_()) {
            return;
        }
        if (target.m_6084_() && this.m_20280_((Entity)target) > 3.0) {
            this.setFlying(true);
        }
        if (this.getSummonerUUID() == null && this.m_21826_() == null) {
            if (this.f_19797_ % 20 != 0) {
                return;
            }
            if (target.m_20270_((Entity)this) >= 20.0f) {
                this.teleportTowards((LivingEntity)this, (Entity)target, 10.0);
            }
            if (this.f_19797_ % 200 != 0) {
                return;
            }
            if (this.m_217043_().m_188503_(10) == 1) {
                this.teleportTowards((LivingEntity)this, (Entity)target, 10.0);
            }
        }
    }

    @Override
    protected void miscAnimationHandler() {
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (!this.m_9236_().m_5776_()) {
                if (this.getMiscAnimation() == 1 && this.miscAnimationTicks == 10) {
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    AkashEntity.shootSpaceCut((LivingEntity)this);
                    this.m_5496_(SoundEvents.f_12520_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                } else if (this.getMiscAnimation() == 2) {
                    this.m_21573_().m_26573_();
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    if (this.miscAnimationTicks == 10) {
                        this.spatialRay();
                    }
                    if (this.miscAnimationTicks >= 10 && this.miscAnimationTicks <= 35) {
                        this.m_5496_(SoundEvents.f_12049_, 5.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                    }
                } else if (this.getMiscAnimation() == 3) {
                    this.m_21573_().m_26573_();
                    if (this.miscAnimationTicks == 20) {
                        this.combust();
                        this.m_5496_(SoundEvents.f_11913_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                    }
                } else if (this.getMiscAnimation() == 4) {
                    this.m_21573_().m_26573_();
                    switch (this.miscAnimationTicks) {
                        case 10: {
                            this.summonWingedCat(3, 7);
                            break;
                        }
                        case 20: {
                            this.summonWingedCat(5, 10);
                            break;
                        }
                        case 30: {
                            this.summonWingedCat(7, 15);
                        }
                    }
                    this.m_5496_(SoundEvents.f_12418_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                }
            }
            if (this.miscAnimationTicks > this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            case -1 -> 200;
            case 2, 8 -> 40;
            case 3 -> 25;
            case 4 -> 32;
            default -> 15;
        };
    }

    public static void shootSpaceCut(LivingEntity undine) {
        DimensionCutProjectile cut = new DimensionCutProjectile(undine.f_19853_, undine);
        cut.setSkill(SkillUtils.getSkillOrNull((Entity)undine, (ManasSkill)ExtraSkills.SPATIAL_MANIPULATION.get()));
        float angle = (float)Math.PI / 180 * undine.f_20883_;
        double xOffset = Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double zOffset = Mth.m_14089_((float)angle);
        cut.m_7678_(undine.m_20185_() + xOffset, undine.m_20188_() - 0.2, undine.m_20189_() + zOffset, undine.m_146908_(), undine.m_146909_());
        cut.setDamage((float)undine.m_21133_(Attributes.f_22281_));
        cut.setSpiritAttack(true);
        cut.setSpeed(2.0f);
        cut.m_20242_(true);
        cut.shootFromRot(undine.m_20154_());
        undine.f_19853_.m_7967_((Entity)cut);
    }

    private void spatialRay() {
        SpatialRayProjectile ray = new SpatialRayProjectile(this.f_19853_, (LivingEntity)this);
        ray.setFollowingOwner(true);
        ray.setSize(0.5f);
        ray.setLife(20);
        float damage = (float)(this.m_21133_(Attributes.f_22281_) * 2.0);
        ray.setDamage(damage);
        ray.setRange(30.0f);
        ray.m_146884_(this.m_146892_());
        ray.setSkill(SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)ExtraSkills.SPATIAL_MANIPULATION.get()));
        ray.setMpCost(1000.0);
        this.f_19853_.m_7967_((Entity)ray);
    }

    public void combust() {
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123810_, this.m_20185_(), this.m_20188_(), this.m_20189_(), 55, 0.08, 0.08, 0.08, 0.2, true);
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123789_, this.m_20185_(), this.m_20188_(), this.m_20189_(), 55, 0.08, 0.08, 0.08, 0.2, true);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123789_, 3.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123789_, 4.0);
        AABB aabb = this.m_20191_().m_82400_(this.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()) + 10.0);
        List list = this.f_19853_.m_6443_(LivingEntity.class, aabb, this::shouldAttack);
        if (list.isEmpty()) {
            return;
        }
        TensuraDamageSource damageSource = DamageSourceHelper.addSkillAndCost(DamageSource.m_19370_((LivingEntity)this).m_19389_(), 100.0, SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)ExtraSkills.SPATIAL_MANIPULATION.get())).setNotTensuraMagic();
        for (LivingEntity target : list) {
            target.m_6469_((DamageSource)damageSource, (float)this.m_21133_(Attributes.f_22281_) * 3.0f);
            target.m_20334_(0.0, 0.1, 0.0);
            SkillHelper.knockBack((LivingEntity)this, target, 2.0f);
        }
    }

    private void summonWingedCat(int minRadius, int maxRadius) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        WingedCatEntity cat = new WingedCatEntity((EntityType<? extends WingedCatEntity>)((EntityType)TensuraEntityTypes.WINGED_CAT.get()), (Level)serverLevel);
        for (int l = 0; l < 50; ++l) {
            int i1 = i + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            int j1 = j + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            int k1 = k + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            cat.m_6034_(i1, j1, k1);
            if (!serverLevel.m_45784_((Entity)cat) || !serverLevel.m_45786_((Entity)cat)) continue;
            cat.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(cat.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            cat.m_6710_(this.m_5448_());
            serverLevel.m_47205_((Entity)cat);
            cat.setSummonerUUID(this.getSummonerUUID());
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)cat, (ParticleOptions)ParticleTypes.f_123789_, 2.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)cat, (ParticleOptions)ParticleTypes.f_123810_, 2.0);
            break;
        }
    }

    @Override
    public MagicElemental getElemental() {
        return MagicElemental.SPACE;
    }

    @Override
    public Item getElementalCore() {
        return (Item)TensuraMaterialItems.ELEMENT_CORE_SPACE.get();
    }

    protected void m_6153_() {
        if (++this.f_20919_ >= 39) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_5496_(SoundEvents.f_11913_, 10.0f, 1.0f);
            this.spawnDeathParticles();
        }
    }

    @Override
    protected void spawnDeathParticles() {
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123789_);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123810_);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123789_, 2.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123810_, 2.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12499_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12502_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12501_;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_5803_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.akash.relax", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_21825_() && this.getMiscAnimation() == -1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.akash.idle_train", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (event.isMoving() && !this.m_21525_()) {
            if (this.m_21660_() && this.getMiscAnimation() == 0) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.akash.fly_fast", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.akash.fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.akash.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.akash.space_cut", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.akash.spatial_ray", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.akash.burst", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 4) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.akash.summon", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 8) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.akash.death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    static class AkashAttackGoal
    extends Goal {
        private final AkashEntity akash;
        private Vec3 startOrbitFrom;
        private int orbitTime;
        private int maxOrbitTime;
        private int attackCooldown;

        public AkashAttackGoal(AkashEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.akash = entity;
        }

        public boolean m_8036_() {
            if (this.akash.m_21827_()) {
                return false;
            }
            if (this.akash.usingMeleeWeapon()) {
                return false;
            }
            LivingEntity target = this.akash.m_5448_();
            if (target != null && target.m_6084_()) {
                this.startOrbitFrom = target.m_146892_();
                return true;
            }
            return false;
        }

        public void m_8037_() {
            LivingEntity target = this.akash.m_5448_();
            if (target == null || !target.m_6084_()) {
                return;
            }
            this.akash.setFlying(true);
            if (this.orbitTime < this.maxOrbitTime) {
                if (this.akash.getMiscAnimation() == 0) {
                    ++this.orbitTime;
                    --this.attackCooldown;
                }
                float zoomIn = 1.0f - (float)this.orbitTime / (float)this.maxOrbitTime;
                Vec3 orbitPos = this.orbitAroundPos(15.0f).m_82520_(0.0, (double)(4.0f + zoomIn * 3.0f), 0.0);
                this.akash.m_21573_().m_26519_(orbitPos.f_82479_, orbitPos.f_82480_, orbitPos.f_82481_, 1.2);
                if (this.isTimeToAttack()) {
                    this.resetAttackCooldown();
                    this.akash.setMiscAnimation(this.randomAttack(this.akash.m_20270_((Entity)target)));
                    this.akash.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                }
            } else {
                this.orbitTime = 0;
                if (this.canSummonCats()) {
                    this.akash.setMiscAnimation(4);
                }
            }
        }

        public void m_8056_() {
            this.orbitTime = 0;
            this.maxOrbitTime = 80 + this.akash.m_217043_().m_188503_(80);
            this.akash.m_21561_(true);
            this.attackCooldown = 0;
        }

        public Vec3 orbitAroundPos(float circleDistance) {
            float angle = 3.0f * (float)(Math.toRadians(this.orbitTime) * 3.0);
            double extraX = circleDistance * Mth.m_14031_((float)angle);
            double extraZ = circleDistance * Mth.m_14089_((float)angle);
            return this.startOrbitFrom.m_82520_(extraX, 0.0, extraZ);
        }

        private boolean canSummonCats() {
            if (this.akash.m_21824_()) {
                return false;
            }
            List list = this.akash.f_19853_.m_45971_(WingedCatEntity.class, TargetingConditions.m_148353_().m_26883_(20.0).m_148355_().m_26893_(), (LivingEntity)this.akash, this.akash.m_20191_().m_82400_(20.0));
            if (!list.isEmpty()) {
                for (WingedCatEntity entity : list) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.RAMPAGE.get(), 200, 0, false, false, false));
                }
            }
            return this.akash.f_19796_.m_188503_(3) + 1 > list.size();
        }

        private void resetAttackCooldown() {
            this.attackCooldown = this.m_183277_(30);
        }

        private boolean isTimeToAttack() {
            return this.attackCooldown <= 0;
        }

        private int randomAttack(double distance) {
            if (distance < 10.0 && (double)this.akash.f_19796_.m_188501_() <= 0.1) {
                return 3;
            }
            if (distance < 30.0 && (double)this.akash.f_19796_.m_188501_() <= 0.2) {
                return 2;
            }
            return 1;
        }
    }
}

