/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.api.entity.ai.LeapWithStrengthGoal;
import com.github.manasmods.tensura.api.entity.ai.SemiAquaticFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.ai.SemiAquaticRandomSwimmingGoal;
import com.github.manasmods.tensura.api.entity.controller.AquaticMoveController;
import com.github.manasmods.tensura.api.entity.controller.JumpingEntityMoveControl;
import com.github.manasmods.tensura.api.entity.navigator.SemiAquaticNavigator;
import com.github.manasmods.tensura.api.entity.navigator.StraightFlightNavigator;
import com.github.manasmods.tensura.api.entity.subclass.IElementalSpirit;
import com.github.manasmods.tensura.api.entity.subclass.IFollower;
import com.github.manasmods.tensura.api.entity.subclass.IJumpingEntity;
import com.github.manasmods.tensura.api.entity.subclass.ISemiAquatic;
import com.github.manasmods.tensura.api.entity.subclass.ITensuraMount;
import com.github.manasmods.tensura.client.keybind.TensuraKeybinds;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.UndineEntity;
import com.github.manasmods.tensura.entity.magic.projectile.PoisonBallProjectile;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.item.food.HealingPotionItem;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.mojang.math.Vector3f;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class AquaFrogEntity
extends TensuraTamableEntity
implements IAnimatable,
IJumpingEntity,
ISemiAquatic,
IFollower,
ITensuraMount,
IElementalSpirit,
PlayerRideableJumping {
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(AquaFrogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SUMMONING_TICK = SynchedEntityData.m_135353_(AquaFrogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Optional<UUID>> SUMMONER_UUID = SynchedEntityData.m_135353_(AquaFrogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> JUMP = SynchedEntityData.m_135353_(AquaFrogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected boolean playerJumping;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public boolean wasOnGround;
    protected float playerJumpPendingScale;
    public float prevSwimProgress;
    public float swimProgress;
    private int swimTimer = -1000;
    private boolean isLandNavigator;
    public int jumpTicks = 0;
    public int miscAnimationTicks = 0;

    public AquaFrogEntity(EntityType<? extends AquaFrogEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 40;
        this.f_19793_ = 1.0f;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.switchNavigator(true);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22288_, 1.5).m_22268_(Attributes.f_22278_, 0.3).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 5.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new FrogAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LeapJumpGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SemiAquaticFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false, false));
        this.f_21345_.m_25352_(4, (Goal)new SemiAquaticRandomSwimmingGoal((Animal)this, 1.2, 30));
        this.f_21345_.m_25352_(5, (Goal)new IElementalSpirit.FollowGreaterSpiritGoal(this, 1.0, UndineEntity.class));
        this.f_21345_.m_25352_(5, (Goal)new TensuraTamableEntity.WanderAroundPosGoal(this, 60, 1.0, 10, 7));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, UndineEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((AquaFrogEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new JumpingEntityMoveControl((PathfinderMob)this, 2.0f, 2.0f){

                @Override
                public void m_8126_() {
                    if (AquaFrogEntity.this.m_5803_()) {
                        return;
                    }
                    super.m_8126_();
                }
            };
            this.f_21344_ = new StraightFlightNavigator((Mob)this, this.f_19853_);
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new AquaticMoveController((PathfinderMob)this, 1.0f){

                @Override
                public void m_8126_() {
                    if (AquaFrogEntity.this.m_5803_()) {
                        return;
                    }
                    super.m_8126_();
                }
            };
            this.f_21344_ = new SemiAquaticNavigator((Mob)this, this.f_19853_);
            this.isLandNavigator = false;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SUMMONER_UUID, Optional.empty());
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(SUMMONING_TICK, (Object)-1);
        this.f_19804_.m_135372_(JUMP, (Object)Boolean.FALSE);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getSummonerUUID() != null) {
            compound.m_128362_("Summoner", this.getSummonerUUID());
        }
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
        compound.m_128405_("SummoningTick", this.getSummoningTick());
        compound.m_128379_("wasOnGround", this.wasOnGround);
        compound.m_128379_("Jump", this.isJumpingAnimation());
        compound.m_128405_("SwimTimer", this.swimTimer);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("Summoner")) {
            this.setSummonerUUID(compound.m_128342_("Summoner"));
        }
        this.setMiscAnimation(compound.m_128451_("MiscAnimation"));
        this.setSummoningTick(compound.m_128451_("SummoningTick"));
        this.wasOnGround = compound.m_128471_("wasOnGround");
        this.setJumpAnimation(compound.m_128471_("Jump"));
        this.swimTimer = compound.m_128451_("SwimTimer");
    }

    public void setMiscAnimation(int animation) {
        if (this.getMiscAnimation() != 0 && animation != 0) {
            return;
        }
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    @Override
    public int getSummoningTick() {
        return (Integer)this.f_19804_.m_135370_(SUMMONING_TICK);
    }

    @Override
    public void setSummoningTick(int tick) {
        this.f_19804_.m_135381_(SUMMONING_TICK, (Object)tick);
    }

    @Override
    @Nullable
    public UUID getSummonerUUID() {
        return ((Optional)this.f_19804_.m_135370_(SUMMONER_UUID)).orElse(null);
    }

    @Override
    public void setSummonerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(SUMMONER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public LivingEntity m_21826_() {
        if (this.getSummonerUUID() != null) {
            return null;
        }
        return super.m_21826_();
    }

    @Override
    public boolean canSleep() {
        return !this.m_21525_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity;
        boolean hurt;
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_21824_()) {
            UndineEntity undine;
            AquaFrogEntity frog;
            Entity entity2 = pSource.m_7639_();
            if (entity2 instanceof AquaFrogEntity && !(frog = (AquaFrogEntity)entity2).m_21824_()) {
                return false;
            }
            entity2 = pSource.m_7639_();
            if (entity2 instanceof UndineEntity && !(undine = (UndineEntity)entity2).m_21824_()) {
                return false;
            }
        }
        if ((hurt = super.m_6469_(pSource, pAmount *= this.getPhysicalAttackInput(pSource))) && (entity = pSource.m_7640_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (DamageSourceHelper.isPhysicalAttack(pSource) && !living.m_7307_((Entity)this)) {
                SkillHelper.addEffectWithSource(living, (LivingEntity)this, (MobEffect)TensuraMobEffects.FATAL_POISON.get(), 200, 1, true);
            }
        }
        return hurt;
    }

    @Override
    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (this.getSummonerUUID() != null) {
            if (entity instanceof IElementalSpirit) {
                IElementalSpirit spirit = (IElementalSpirit)entity;
                return Objects.equals(spirit.getSummonerUUID(), this.getSummonerUUID());
            }
            return Objects.equals(entity.m_20148_(), this.getSummonerUUID());
        }
        if (entity instanceof AquaFrogEntity) {
            AquaFrogEntity frog = (AquaFrogEntity)entity;
            return frog.m_21824_() == this.m_21824_();
        }
        if (entity instanceof UndineEntity) {
            UndineEntity undine = (UndineEntity)entity;
            return undine.m_21824_() == this.m_21824_();
        }
        return false;
    }

    public boolean m_6779_(LivingEntity pTarget) {
        if (this.m_7307_((Entity)pTarget)) {
            return false;
        }
        return super.m_6779_(pTarget);
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19315_ || source == DamageSource.f_19312_ || source == DamageSource.f_19310_ || source == DamageSource.f_19311_ || super.m_6673_(source);
    }

    @Override
    public boolean shouldEnterWater() {
        return !this.shouldLeaveWater() && this.swimTimer <= -1000;
    }

    @Override
    public boolean shouldLeaveWater() {
        if (this.m_5448_() != null && !this.m_5448_().m_20069_()) {
            return true;
        }
        return this.swimTimer > 600;
    }

    @Override
    public boolean shouldStopMoving() {
        return this.m_21827_();
    }

    @Override
    public int getWaterSearchRange() {
        return 45;
    }

    @Override
    public boolean shouldFollow() {
        return !this.m_21827_() && !this.isWandering() && (this.m_5448_() == null || !this.m_5448_().m_6084_());
    }

    @Override
    public void m_8119_() {
        boolean ground;
        super.m_8119_();
        this.wasOnGround = this.f_19861_;
        this.prevSwimProgress = this.swimProgress;
        boolean bl = ground = !this.m_20072_();
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (ground && this.swimProgress > 0.0f) {
            this.swimProgress -= 1.0f;
        }
        if (!ground && this.swimProgress < 5.0f) {
            this.swimProgress += 1.0f;
        }
        if (!this.f_19853_.m_5776_()) {
            this.summoningTicking(this);
            this.swimTimer = this.m_20069_() ? ++this.swimTimer : --this.swimTimer;
        }
        if (this.setWantedTarget((PathfinderMob)this, 16.0)) {
            this.wasOnGround = true;
        } else if (!this.setWantedOwner(this, 100.0)) {
            this.wasOnGround = true;
        }
        this.animationHandler();
    }

    private void animationHandler() {
        if (this.isJumpingAnimation()) {
            ++this.jumpTicks;
            if (this.jumpTicks >= 20) {
                this.setJumpAnimation(Boolean.FALSE);
                this.jumpTicks = 0;
            }
        }
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (this.getMiscAnimation() == 1 && this.miscAnimationTicks == 10) {
                LivingEntity target = this.m_5448_();
                if (target != null) {
                    this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                }
                this.poisonSpit();
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12098_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else if (this.getMiscAnimation() == 2 && this.miscAnimationTicks == 10) {
                if (this.m_5448_() != null) {
                    this.m_7327_((Entity)this.m_5448_());
                }
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215697_, SoundSource.NEUTRAL, 1.5f, 1.0f);
            }
            if (this.miscAnimationTicks >= 20) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    public void poisonSpit() {
        PoisonBallProjectile ball = new PoisonBallProjectile(this.f_19853_, (LivingEntity)this);
        ball.setSkill(SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)ExtraSkills.WATER_MANIPULATION.get()));
        float radius = 1.0f;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        ball.m_6034_(this.m_20185_() + extraX, this.m_20188_(), this.m_20189_() + extraZ);
        ball.setDamage((float)this.m_21133_(Attributes.f_22281_));
        ball.setMobEffect(new MobEffectInstance((MobEffect)TensuraMobEffects.FATAL_POISON.get(), 200, 1, false, false, false));
        ball.setEffectRange(2.0f);
        ball.setSpiritAttack(true);
        Vector3f vector3f = new Vector3f(this.m_146895_() != null ? this.m_146895_().m_20252_(2.0f) : this.m_20252_(2.0f));
        ball.m_6686_(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_(), 2.0f, 0.0f);
        this.f_19853_.m_7967_((Entity)ball);
    }

    @Override
    public void mountAbility(Player rider) {
        if (this.getMiscAnimation() == 1) {
            return;
        }
        this.setMiscAnimation(1);
    }

    public boolean m_7327_(Entity pEntity) {
        if (super.m_7327_(pEntity) && pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            SkillHelper.addEffectWithSource(living, (LivingEntity)this, (MobEffect)TensuraMobEffects.FATAL_POISON.get(), 200, 2, true);
            return true;
        }
        return false;
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_204117_(TensuraTags.Items.SPIRIT_FOOD);
    }

    public boolean isTamingFood(ItemStack pStack) {
        return pStack.m_150930_((Item)TensuraMaterialItems.ELEMENT_CORE_WATER.get());
    }

    @Override
    public MagicElemental getElemental() {
        return MagicElemental.WATER;
    }

    @Override
    public SpiritualMagic.SpiritLevel getSpiritLevel() {
        return SpiritualMagic.SpiritLevel.MEDIUM;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof HealingPotionItem) {
            return super.m_6071_(player, hand);
        }
        InteractionResult eating = this.handleEating(player, hand, itemstack);
        if (eating.m_19077_()) {
            return eating;
        }
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.isTamingFood(itemstack);
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)player)) {
                if (player.m_36341_()) {
                    this.commanding(player);
                } else if (!this.convertElementalCore((LivingEntity)this, player, hand, (Item)TensuraMaterialItems.ELEMENT_CORE_WATER.get()) && player.m_146895_() == null) {
                    this.m_21839_(false);
                    this.setWandering(false);
                    player.m_7998_((Entity)this, false);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        } else if (this.isTamingFood(itemstack)) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(10) == 7 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                if (this.f_19796_.m_188503_(20) == 0) {
                    this.m_6710_((LivingEntity)player);
                }
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult handleEating(Player player, InteractionHand hand, ItemStack itemstack) {
        if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.m_8035_();
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_8035_() {
        super.m_8035_();
        this.m_5634_(3.0f);
        this.setMiscAnimation(3);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        for (Entity passenger : this.m_20197_()) {
            Player player;
            if (!(passenger instanceof Player) || !(player = (Player)passenger).equals((Object)this.m_21826_())) continue;
            return player;
        }
        return null;
    }

    public void m_7332_(Entity passenger) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        passenger.m_183634_();
        float radius = -0.25f;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double yOffset = this.m_20186_() + this.m_6048_() + passenger.m_6049_();
        if (this.m_20072_()) {
            yOffset -= 0.5;
        }
        passenger.m_6034_(this.m_20185_() + extraX, yOffset, this.m_20189_() + extraZ);
    }

    public boolean m_6146_() {
        return true;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public boolean m_7132_() {
        return this.m_20096_();
    }

    public double getCustomJump() {
        return this.m_21133_(Attributes.f_22288_);
    }

    public void m_7199_(int pJumpPower) {
        if (!this.m_20096_()) {
            return;
        }
        this.m_5496_(SoundEvents.f_215695_, 0.4f, 1.0f);
    }

    public void m_8012_() {
    }

    public void m_7888_(int pJumpPower) {
        if (pJumpPower < 0) {
            pJumpPower = 0;
        }
        this.playerJumpPendingScale = pJumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)pJumpPower / 90.0f;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (!this.m_6084_()) {
            return;
        }
        LivingEntity controller = this.getControllingPassenger();
        if (this.m_20160_() && controller != null) {
            this.m_146922_(controller.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(controller.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20885_ = this.f_20883_ = this.m_146908_();
            float f = controller.f_20900_ * 0.5f;
            float f1 = controller.f_20902_;
            if (f1 <= 0.0f) {
                f1 *= 0.25f;
            }
            if (this.playerJumpPendingScale > 0.0f && !this.isPlayerJumping()) {
                this.setJumpAnimation(Boolean.TRUE);
                double d0 = this.getCustomJump() * (double)this.playerJumpPendingScale * (double)this.m_20098_();
                double d1 = d0 + this.m_182332_();
                Vec3 vec3 = this.m_20184_();
                this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
                this.setPlayerJumping(true);
                this.f_19812_ = true;
                ForgeHooks.onLivingJump((LivingEntity)this);
                if (f1 > 0.0f) {
                    float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                    float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                    this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * this.playerJumpPendingScale), 0.0, (double)(0.4f * f3 * this.playerJumpPendingScale)));
                }
                this.playerJumpPendingScale = 0.0f;
            }
            this.f_20887_ = this.m_6113_() * 0.1f;
            if (this.m_6109_()) {
                float speed = (float)this.m_21133_(Attributes.f_22279_);
                if (controller.m_20142_()) {
                    speed = (float)((double)speed * 1.5);
                }
                if (this.isInFluidType()) {
                    if (this.isInFluidType((fluidType, height) -> height > this.m_20204_()) && controller.f_20899_) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.07, 0.0));
                    } else if (TensuraKeybinds.MOUNT_DESCENDING.m_90857_()) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.07, 0.0));
                    }
                    AttributeInstance instance = this.m_21204_().m_22146_((Attribute)ForgeMod.SWIM_SPEED.get());
                    if (instance != null) {
                        instance.m_22100_(controller.m_20142_() ? 8.0 : 6.0);
                    }
                    super.m_7023_(new Vec3((double)f, pTravelVector.f_82480_, (double)f1));
                } else {
                    if (this.m_20096_()) {
                        speed /= 2.0f;
                    }
                    this.m_7910_(speed);
                    super.m_7023_(new Vec3((double)f, pTravelVector.f_82480_, (double)f1));
                }
            } else if (controller instanceof Player) {
                this.m_20256_(Vec3.f_82478_);
            }
            if (this.f_19861_) {
                this.playerJumpPendingScale = 0.0f;
                this.setPlayerJumping(false);
            }
            this.m_146872_();
        } else {
            AttributeInstance instance = this.m_21204_().m_22146_((Attribute)ForgeMod.SWIM_SPEED.get());
            if (instance != null && instance.m_22115_() != 5.0) {
                instance.m_22100_(5.0);
            }
            this.f_20887_ = 0.02f;
            if (this.m_6142_() && this.m_20069_()) {
                this.m_19920_(this.m_6113_(), pTravelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.9));
                if (this.m_5448_() == null) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
                }
            } else {
                super.m_7023_(pTravelVector);
            }
        }
    }

    @Override
    public int getJumpDelay() {
        return this.f_19796_.m_188503_(40);
    }

    protected void m_6135_() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, (double)this.m_6118_() * 2.0, vec3.f_82481_);
        this.f_19812_ = true;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_215693_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_215691_;
    }

    @Override
    public float getJumpSoundVolume() {
        return 0.4f;
    }

    @Override
    public SoundEvent getJumpSound() {
        return SoundEvents.f_215695_;
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return SpawnRateConfig.rollSpawn((Integer)SpawnRateConfig.INSTANCE.aquaFrogSpawnRate.get(), this.m_217043_(), pSpawnReason) && super.m_5545_(pLevel, pSpawnReason);
    }

    protected void m_6668_(DamageSource pDamageSource) {
        if (this.getSummoningTick() >= 0) {
            this.m_5907_();
        } else {
            super.m_6668_(pDamageSource);
        }
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        if ((double)this.f_19796_.m_188501_() > 0.1) {
            return;
        }
        this.m_19998_((ItemLike)TensuraMobDropItems.ELEMENTAL_ESSENCE.get());
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_5803_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.aqua_frog.sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isJumpingAnimation()) {
            event.getController().clearAnimationCache();
            return PlayState.STOP;
        }
        if (this.m_20072_() && !this.m_21525_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.aqua_frog.swim", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.aqua_frog.sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (event.isMoving() && !this.m_21525_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.aqua_frog.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.aqua_frog.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState playOncePredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.aqua_frog.spit", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.aqua_frog.tongue", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.aqua_frog.eat", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    private <T extends IAnimatable> PlayState jumpPredicate(AnimationEvent<T> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped) && this.isJumpingAnimation()) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.aqua_frog.jump", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "playOnceController", 0.0f, this::playOncePredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "jumpController", 0.0f, this::jumpPredicate));
    }

    public boolean isJumpingAnimation() {
        return (Boolean)this.f_19804_.m_135370_(JUMP);
    }

    @Override
    public void setJumpAnimation(boolean jump) {
        this.f_19804_.m_135381_(JUMP, (Object)jump);
    }

    public boolean isPlayerJumping() {
        return this.playerJumping;
    }

    public void setPlayerJumping(boolean playerJumping) {
        this.playerJumping = playerJumping;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class FrogAttackGoal
    extends MeleeAttackGoal {
        public final AquaFrogEntity frog;

        public FrogAttackGoal(AquaFrogEntity beast) {
            super((PathfinderMob)beast, 1.2, true);
            this.frog = beast;
        }

        public boolean m_8036_() {
            if (this.frog.m_21827_()) {
                return false;
            }
            return super.m_8036_();
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(pEnemy);
            if (this.frog.getMiscAnimation() == 0) {
                double attackRange;
                int randomAttack = this.randomAttack(d0);
                switch (randomAttack) {
                    case 1: {
                        double d = 600.0;
                        break;
                    }
                    case 2: {
                        double d = 25.0;
                        break;
                    }
                    default: {
                        double d = attackRange = d0;
                    }
                }
                if (pDistToEnemySqr <= attackRange && this.m_25564_()) {
                    this.m_25563_();
                    this.frog.setMiscAnimation(randomAttack);
                }
            }
        }

        protected int randomAttack(double distanceSqr) {
            if (this.frog.f_19796_.m_188503_(10) == 5 || distanceSqr >= 25.0) {
                return 1;
            }
            return 2;
        }
    }

    static class LeapJumpGoal
    extends LeapWithStrengthGoal {
        private final AquaFrogEntity frog;

        public LeapJumpGoal(AquaFrogEntity frog) {
            super((Mob)frog, 0.5f, 2.5f, 3.0, 20.0, 20);
            this.frog = frog;
        }

        @Override
        public boolean m_8036_() {
            if (this.frog.m_21827_() || this.frog.m_5803_()) {
                return false;
            }
            return super.m_8036_();
        }

        @Override
        public void m_8056_() {
            this.frog.setJumpAnimation(Boolean.TRUE);
            super.m_8056_();
        }

        @Override
        public boolean m_8045_() {
            if (this.frog.m_21827_() || this.frog.m_5803_()) {
                return false;
            }
            return this.frog.m_20096_();
        }
    }
}

