/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.tensura.api.entity.ai.TamableFollowParentGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraConsumableItems;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class BulldeerEntity
extends TensuraTamableEntity
implements IAnimatable {
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(BulldeerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int itchingCountDown = 0;
    public int miscAnimationTicks = 0;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public BulldeerEntity(EntityType<? extends BulldeerEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(3, (Goal)new EatBlockGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new WanderingFollowOwnerGoal(this, 1.2, 20.0f, 5.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), false));
        this.f_21345_.m_25352_(6, (Goal)new TamableFollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new TensuraTamableEntity.WanderAroundPosGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, (double)0.01f).m_22268_(Attributes.f_22277_, 16.0).m_22265_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        if (this.getMiscAnimation() != 0 && animation != 0) {
            return;
        }
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (this.miscAnimationTicks >= 30 && this.getMiscAnimation() == 1 || this.miscAnimationTicks >= 45 && this.getMiscAnimation() == 2) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this.itchingCountDown++ > 300 && this.m_217043_().m_188503_(10) <= 2) {
            this.itchingCountDown = 0;
            this.setMiscAnimation(2);
        }
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (itemstack.m_150930_(Items.f_42446_)) {
            pPlayer.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
            ItemStack milk = ItemUtils.m_41813_((ItemStack)itemstack, (Player)pPlayer, (ItemStack)((Item)TensuraConsumableItems.BUCKET_OF_BULLDEER_MILK.get()).m_7968_());
            pPlayer.m_21008_(pHand, milk);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        BulldeerEntity entity = (BulldeerEntity)((EntityType)TensuraEntityTypes.BULLDEER.get()).m_20615_((Level)pLevel);
        if (entity == null) {
            return null;
        }
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            entity.m_21816_(uuid);
            entity.m_7105_(true);
        }
        return entity;
    }

    public void m_8035_() {
        super.m_8035_();
        this.setMiscAnimation(1);
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_204117_(TensuraTags.Items.BULLDEER_FOOD);
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return SpawnRateConfig.rollSpawn((Integer)SpawnRateConfig.INSTANCE.bulldeerSpawnRate.get(), this.m_217043_(), pSpawnReason) && super.m_5545_(pLevel, pSpawnReason);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11830_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11832_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11831_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            if (this.m_21188_() != null || this.m_203117_() || this.m_6060_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bulldeer.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bulldeer.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bulldeer.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState playOncePredicate(AnimationEvent<E> event) {
        if (this.getMiscAnimation() == 1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bulldeer.eat", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        } else if (!event.isMoving() && this.getMiscAnimation() == 2) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bulldeer.look_around", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "playOnceController", 0.0f, this::playOncePredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

