/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.skill.extra.HakiSkill;
import com.github.manasmods.tensura.api.entity.ai.TamableFollowParentGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.subclass.IRanking;
import com.github.manasmods.tensura.api.entity.subclass.ITensuraMount;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.keybind.TensuraKeybinds;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.lightning.BlackLightningBolt;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.entity.variant.DirewolfVariant;
import com.github.manasmods.tensura.event.NamingEvent;
import com.github.manasmods.tensura.item.food.HealingPotionItem;
import com.github.manasmods.tensura.network.play2server.RequestNamingGUIPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.util.damage.TensuraEntityDamageSource;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class DirewolfEntity
extends TensuraTamableEntity
implements IAnimatable,
IRanking,
ITensuraMount,
HasCustomInventoryScreen,
PlayerRideableJumping {
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(DirewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EVOLUTION_STATE = SynchedEntityData.m_135353_(DirewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(DirewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LEADER_TICK = SynchedEntityData.m_135353_(DirewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> INTERESTED = SynchedEntityData.m_135353_(DirewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHESTED = SynchedEntityData.m_135353_(DirewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEADER = SynchedEntityData.m_135353_(DirewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ALPHA = SynchedEntityData.m_135353_(DirewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> STAR = SynchedEntityData.m_135353_(DirewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> MAX_SIZE = SynchedEntityData.m_135353_(DirewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(DirewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Optional<UUID>> LEADER_UUID = SynchedEntityData.m_135353_(DirewolfEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int miscAnimationTicks = 0;
    public SimpleContainer inventory;
    public MenuProvider inventoryMenu;
    private boolean hasChestVarChanged = false;
    protected boolean playerJumping;
    protected float playerJumpPendingScale;

    public DirewolfEntity(EntityType<? extends DirewolfEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 10;
        this.f_19793_ = 2.0f;
        this.initInventory();
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22278_, (double)0.2f).m_22268_(Attributes.f_22288_, 1.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new DirewolfAttackGoal());
        this.f_21345_.m_25352_(4, (Goal)new FollowLeaderGoal(this, 1.5));
        this.f_21345_.m_25352_(5, (Goal)new WanderingFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(6, (Goal)new BreedGoal((Animal)this, 1.2, DirewolfEntity.class));
        this.f_21345_.m_25352_(7, (Goal)new TamableFollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new TensuraTamableEntity.WanderAroundPosGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new TiltingHeadGoal(this, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, null));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, e -> e.m_6095_().m_204039_(TensuraTags.EntityTypes.ANIMAL_PREY)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(EVOLUTION_STATE, (Object)0);
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(LEADER_TICK, (Object)0);
        this.f_19804_.m_135372_(INTERESTED, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(CHESTED, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(LEADER, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(ALPHA, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(STAR, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(MAX_SIZE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(LEADER_UUID, Optional.empty());
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getTypeVariant());
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
        compound.m_128405_("EvoState", this.getCurrentEvolutionState());
        compound.m_128405_("LeaderTick", this.getLeaderTick());
        if (this.getLeaderUUID() != null) {
            compound.m_128362_("Leader", this.getLeaderUUID());
        }
        compound.m_128379_("Chested", this.isChested());
        compound.m_128379_("Leader", this.isLeader());
        compound.m_128379_("Alpha", this.isAlpha());
        compound.m_128379_("Star", this.isStar());
        compound.m_128350_("MaxSize", this.getMaxSize());
        compound.m_128350_("Size", this.getSize());
        if (this.inventory != null) {
            ListTag listTag = new ListTag();
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag CompoundNBT = new CompoundTag();
                CompoundNBT.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(CompoundNBT);
                listTag.add((Object)CompoundNBT);
            }
            compound.m_128365_("Items", (Tag)listTag);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)compound.m_128451_("Variant"));
        this.setCurrentEvolutionState(compound.m_128451_("EvoState"));
        this.setLeaderTick(compound.m_128451_("LeaderTick"));
        if (compound.m_128403_("Leader")) {
            this.setLeaderUUID(compound.m_128342_("Leader"));
        }
        this.setChested(compound.m_128471_("Chested"));
        this.setLeader(compound.m_128471_("Leader"));
        this.setAlpha(compound.m_128471_("Alpha"));
        this.setStar(compound.m_128471_("Star"));
        this.setMaxSize(compound.m_128457_("MaxSize"));
        this.setSize(compound.m_128457_("Size"));
        if (this.inventory != null) {
            ListTag listTag = compound.m_128437_("Items", 10);
            this.initInventory();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag CompoundNBT = listTag.m_128728_(i);
                int j = CompoundNBT.m_128445_("Slot") & 0xFF;
                this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)CompoundNBT));
            }
        } else {
            ListTag listTag = compound.m_128437_("Items", 10);
            this.initInventory();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag CompoundNBT = listTag.m_128728_(i);
                int j = CompoundNBT.m_128445_("Slot") & 0xFF;
                this.initInventory();
                this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)CompoundNBT));
            }
        }
    }

    public DirewolfVariant getVariant() {
        return DirewolfVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(DirewolfVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        if (this.getMiscAnimation() != 0 && animation != 0) {
            return;
        }
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
    }

    public int getLeaderTick() {
        return (Integer)this.f_19804_.m_135370_(LEADER_TICK);
    }

    public void setLeaderTick(int tick) {
        this.f_19804_.m_135381_(LEADER_TICK, (Object)tick);
    }

    public boolean isInterested() {
        return (Boolean)this.f_19804_.m_135370_(INTERESTED);
    }

    public void setInterested(boolean pInterested) {
        this.f_19804_.m_135381_(INTERESTED, (Object)pInterested);
    }

    public boolean isChested() {
        return (Boolean)this.f_19804_.m_135370_(CHESTED);
    }

    public void setChested(boolean chested) {
        this.f_19804_.m_135381_(CHESTED, (Object)chested);
        this.hasChestVarChanged = true;
    }

    public boolean isLeader() {
        return (Boolean)this.f_19804_.m_135370_(LEADER);
    }

    public void setLeader(boolean alpha) {
        this.f_19804_.m_135381_(LEADER, (Object)alpha);
    }

    public boolean isAlpha() {
        return (Boolean)this.f_19804_.m_135370_(ALPHA);
    }

    public void setAlpha(boolean alpha) {
        this.f_19804_.m_135381_(ALPHA, (Object)alpha);
    }

    public boolean isStar() {
        return (Boolean)this.f_19804_.m_135370_(STAR);
    }

    public void setStar(boolean star) {
        this.f_19804_.m_135381_(STAR, (Object)star);
    }

    public float getMaxSize() {
        return ((Float)this.f_19804_.m_135370_(MAX_SIZE)).floatValue();
    }

    public void setMaxSize(float size) {
        this.f_19804_.m_135381_(MAX_SIZE, (Object)Float.valueOf(size));
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    public void setSize(float size) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(size));
    }

    @Nullable
    public UUID getLeaderUUID() {
        return ((Optional)this.f_19804_.m_135370_(LEADER_UUID)).orElse(null);
    }

    public void setLeaderUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(LEADER_UUID, Optional.ofNullable(pUuid));
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (SIZE.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    @Override
    public EntityDimensions m_6972_(Pose pPose) {
        EntityDimensions entitydimensions = super.m_6972_(pPose);
        return entitydimensions.m_20388_(this.getSize());
    }

    @Override
    public boolean canSleep() {
        return true;
    }

    public double m_20204_() {
        return super.m_20204_() + (double)(this.m_20206_() / 2.0f);
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19314_ || source == DamageSource.f_19325_ || super.m_6673_(source);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        if (pFallDistance < 8.0f || this.getVariant() == DirewolfVariant.TEMPEST_STAR_WOLF) {
            return false;
        }
        int i = this.m_5639_(pFallDistance - 16.0f, pMultiplier);
        if (i <= 0) {
            return false;
        }
        this.m_6469_(pSource, i);
        this.m_21229_();
        return true;
    }

    @Override
    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof DirewolfEntity) {
            DirewolfEntity wolf = (DirewolfEntity)entity;
            return wolf.m_21824_() == this.m_21824_();
        }
        return false;
    }

    public void m_7334_(Entity pEntity) {
        DirewolfEntity wolf;
        if (pEntity instanceof DirewolfEntity && ((wolf = (DirewolfEntity)pEntity).getLeaderUUID() == this.m_20148_() || wolf.m_20148_() == this.getLeaderUUID())) {
            return;
        }
        super.m_7334_(pEntity);
    }

    @Override
    public boolean canBeNamed() {
        return !this.isAlpha();
    }

    @Override
    public int getMaxEvolutionState() {
        return 3;
    }

    @Override
    public int getCurrentEvolutionState() {
        return (Integer)this.f_19804_.m_135370_(EVOLUTION_STATE);
    }

    @Override
    public void setCurrentEvolutionState(int state) {
        this.f_19804_.m_135381_(EVOLUTION_STATE, (Object)state);
    }

    @Override
    public void onNamed(NamingEvent event) {
        if (!this.isLeader()) {
            return;
        }
        Player owner = event.getNamer();
        if (owner == null) {
            return;
        }
        AtomicInteger namedPack = new AtomicInteger(1);
        List list = this.f_19853_.m_6443_(DirewolfEntity.class, this.m_20191_().m_82377_(32.0, 32.0, 32.0), entity -> entity.m_6084_() && entity != this && entity.getLeaderUUID() == this.m_20148_());
        for (DirewolfEntity wolf : list) {
            if (wolf.m_21824_() && !this.m_21824_()) continue;
            wolf.m_21573_().m_26573_();
            wolf.m_21661_();
            if (!wolf.m_21824_()) {
                wolf.m_21828_(owner);
                wolf.m_21839_(true);
                wolf.m_9236_().m_7605_((Entity)wolf, (byte)7);
            }
            TensuraEPCapability.getFrom((LivingEntity)wolf).ifPresent(namingCap -> {
                if (namingCap.getName() != null) {
                    return;
                }
                UUID uuid = TensuraEPCapability.getPermanentOwner((LivingEntity)wolf);
                if (uuid != null && !uuid.equals(owner.m_20148_())) {
                    return;
                }
                namedPack.getAndIncrement();
                namingCap.setName(String.valueOf(wolf.m_7755_()));
                namingCap.setPermanentOwner(owner.m_20148_());
                owner.f_19853_.m_6263_(null, wolf.m_20185_(), wolf.m_20186_(), wolf.m_20189_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
                wolf.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40, 0, false, false, false));
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)wolf, (ParticleOptions)ParticleTypes.f_123767_, 2.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)wolf, (ParticleOptions)ParticleTypes.f_123747_, 1.0);
                RequestNamingGUIPacket.namingReward((LivingEntity)wolf, Math.min(1000000.0, event.getOriginalCost()), event.getType());
                wolf.m_5634_(wolf.m_21233_());
                TensuraEPCapability.sync((LivingEntity)wolf);
            });
        }
        event.setCalculatedCost(event.getOriginalCost() * (double)namedPack.get());
    }

    @Override
    public void evolve() {
        int current = this.getCurrentEvolutionState();
        this.setSize(this.getSize() + 0.5f);
        this.setMaxSize(this.getMaxSize() + 0.5f);
        if (current < this.getMaxEvolutionState()) {
            this.setCurrentEvolutionState(current + 1);
            this.evolveBuff();
            if (this.getVariant() == DirewolfVariant.DIREWOLF) {
                this.setVariant(this.getEvolutionByBiomes());
            } else if (this.getVariant().getId() >= 14) {
                this.setVariant(DirewolfVariant.TEMPEST_STAR_WOLF);
                if (this.isStar()) {
                    SkillStorage storage = SkillAPI.getSkillsFrom((Entity)this);
                    storage.learnSkill((ManasSkill)ExtraSkills.BLACK_LIGHTNING.get());
                    ManasSkillInstance instance = new ManasSkillInstance((ManasSkill)ExtraSkills.ULTRA_INSTINCT.get());
                    instance.setToggled(true);
                    storage.learnSkill(instance);
                }
            } else if (this.getVariant().getId() % 2 != 0) {
                this.setVariant(DirewolfVariant.byId(this.getVariant().getId() + 1));
            }
            if (this.getVariant().getId() >= 14) {
                SkillAPI.getSkillsFrom((Entity)this).learnSkill((ManasSkill)ExtraSkills.SHADOW_MOTION.get());
            }
        }
    }

    private void evolveBuff() {
        this.gainMaxHealth((LivingEntity)this, 10.0);
        this.gainAttackDamage((LivingEntity)this, 12.0);
        this.gainMovementSpeed((LivingEntity)this, 0.05);
        this.gainSwimSpeed((LivingEntity)this, 1.0);
        this.gainJumpStrength((LivingEntity)this, 0.5);
    }

    private DirewolfVariant getEvolutionByBiomes() {
        if (this.isStar()) {
            return DirewolfVariant.STAR_WOLF;
        }
        Holder biomes = this.f_19853_.m_204166_(this.m_20097_());
        if (biomes.m_203656_(Tags.Biomes.IS_DRY_OVERWORLD) || biomes.m_203656_(Tags.Biomes.IS_DRY_NETHER)) {
            return DirewolfVariant.RED_FANG;
        }
        if (biomes.m_203656_(BiomeTags.f_207603_) || biomes.m_203656_(BiomeTags.f_207604_) || biomes.m_203656_(Tags.Biomes.IS_SWAMP)) {
            return DirewolfVariant.BLUE_FANG;
        }
        if (biomes.m_203656_(BiomeTags.f_207611_) || biomes.m_203656_(BiomeTags.f_207610_)) {
            return DirewolfVariant.GREEN_FANG;
        }
        if (biomes.m_203656_(Tags.Biomes.IS_CAVE) || biomes.m_203656_(Tags.Biomes.IS_SLOPE)) {
            return DirewolfVariant.BROWN_FANG;
        }
        if (biomes.m_203656_(BiomeTags.f_215818_) || biomes.m_203656_(Tags.Biomes.IS_PEAK)) {
            return DirewolfVariant.PURPLE_FANG;
        }
        return DirewolfVariant.BLACK_FANG;
    }

    @Nullable
    private DamageSource getAdditionalDamageSource() {
        return switch (this.getVariant()) {
            case DirewolfVariant.DIREWOLF -> null;
            case DirewolfVariant.RED_FANG -> TensuraDamageSources.elementalAttack("tensura.fire_attack", (Entity)this, true);
            case DirewolfVariant.GREEN_FANG -> TensuraDamageSources.elementalAttack("tensura.wind_attack", (Entity)this, true);
            case DirewolfVariant.BLUE_FANG -> TensuraDamageSources.elementalAttack("tensura.water_attack", (Entity)this, true);
            case DirewolfVariant.BROWN_FANG -> TensuraDamageSources.elementalAttack("tensura.earth_attack", (Entity)this, true);
            case DirewolfVariant.PURPLE_FANG -> TensuraDamageSources.elementalAttack("tensura.space_attack", (Entity)this, true);
            default -> TensuraDamageSources.genericMagic((Entity)this);
        };
    }

    public boolean m_7327_(Entity pEntity) {
        DamageSource source;
        boolean flag;
        int i;
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        float knockBack = (float)this.m_21133_(Attributes.f_22282_);
        if (pEntity instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)pEntity;
            damage += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)entity.m_6336_());
            knockBack += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            pEntity.m_20254_(i * 4);
        }
        if (flag = (source = this.getAdditionalDamageSource()) == null ? pEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this), damage) : DamageSourceHelper.dealSplitDamage(pEntity, DamageSource.m_19370_((LivingEntity)this), 0.5f, source, damage)) {
            if (knockBack > 0.0f && pEntity instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)pEntity;
                entity.m_147240_((double)(knockBack * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_((LivingEntity)this, pEntity);
            this.m_21335_(pEntity);
            if (this.getMiscAnimation() == 0) {
                this.setMiscAnimation(2);
                if (!pEntity.m_6084_()) {
                    this.m_8035_();
                }
            }
        }
        return flag;
    }

    @Nullable
    private ManasSkillInstance getBlackLightning() {
        Optional skill = SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)ExtraSkills.BLACK_LIGHTNING.get());
        if (skill.isEmpty()) {
            return null;
        }
        if (!((ManasSkillInstance)skill.get()).canInteractSkill((LivingEntity)this)) {
            return null;
        }
        return (ManasSkillInstance)skill.get();
    }

    @Nullable
    private ManasSkillInstance getShadowMotion() {
        Optional skill = SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)ExtraSkills.SHADOW_MOTION.get());
        if (skill.isEmpty()) {
            return null;
        }
        if (!((ManasSkillInstance)skill.get()).canInteractSkill((LivingEntity)this)) {
            return null;
        }
        return (ManasSkillInstance)skill.get();
    }

    @Override
    protected void sleepHandler() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.m_5803_() && (this.m_5448_() != null || this.m_27593_() || this.isInFluidType() || this.m_20160_() || this.m_20159_() || ++this.sleepingTime > this.maxSleepTime && this.f_19853_.m_46461_() || this.shouldFollowOwner())) {
            this.setSleeping(false);
        }
        if (this.f_19853_.m_46462_() && this.f_19853_.m_46941_() == 0) {
            if (this.m_5803_()) {
                this.setSleeping(false);
            }
            if (this.f_19853_.m_46468_() >= 17000L && this.f_19853_.m_46468_() <= 19000L && this.f_19796_.m_188503_(200) == 1) {
                this.setMiscAnimation(4);
            }
            return;
        }
        if (!(this.m_5448_() != null || !this.f_19853_.m_46462_() || this.shouldFollowOwner() || this.m_5803_() || this.isInFluidType() || this.m_20160_() || this.m_20159_() || this.f_19796_.m_188503_(100) != 0)) {
            if (this.m_217043_().m_188499_()) {
                this.setSleeping(true);
            } else {
                this.sleepingTime = 0;
                this.maxSleepTime = 100 + this.f_19796_.m_188503_(550);
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.targetingMovementHelper();
        if (this.getSize() <= 0.0f) {
            this.setSize(1.0f);
        }
        if (this.isLeader()) {
            this.setLeaderTick(this.getLeaderTick() - 1);
            if (this.getLeaderTick() <= 0) {
                this.setLeader(false);
            }
        }
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (this.getMiscAnimation() == 3 && this.miscAnimationTicks == 5) {
                this.coercion(this.m_146892_().m_82549_(this.m_20154_().m_82490_(15.0)));
            } else if (this.getMiscAnimation() == 4) {
                if (this.miscAnimationTicks == 30) {
                    target = this.m_5448_();
                    if (target != null) {
                        this.blackLightning(target.m_20182_());
                    }
                } else if (this.miscAnimationTicks == 1) {
                    this.m_5496_(SoundEvents.f_12620_, 3.0f, 1.0f);
                }
            } else if (this.getMiscAnimation() == 5) {
                if (this.miscAnimationTicks % 3 == 0) {
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123765_);
                }
                if (this.miscAnimationTicks >= 5 && this.miscAnimationTicks <= 20) {
                    this.m_21573_().m_26573_();
                } else if (this.miscAnimationTicks == 30 && (target = this.m_5448_()) != null && target.m_20270_((Entity)this) < 5.0f) {
                    this.m_7327_((Entity)target);
                }
            }
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
        if (this.hasChestVarChanged && this.inventory != null && !this.isChested()) {
            for (int i = 3; i < 18; ++i) {
                if (this.inventory.m_8020_(i).m_41619_()) continue;
                if (!this.f_19853_.f_46443_) {
                    this.m_5552_(this.inventory.m_8020_(i), 1.0f);
                }
                this.inventory.m_8016_(i);
            }
            this.hasChestVarChanged = false;
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            default -> 20;
            case 2 -> 5;
            case 3 -> 10;
            case 4 -> 60;
            case 5 -> 40;
        };
    }

    private void coercion(Vec3 targetPos) {
        Level level = this.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        Vec3 source = this.m_146892_().m_82549_(this.m_20154_().m_82490_(2.0));
        Vec3 sourceToTarget = targetPos.m_82546_(source);
        Vec3 normalizes = sourceToTarget.m_82541_();
        level.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215771_, SoundSource.PLAYERS, 5.0f, 1.0f);
        for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)sourceToTarget.m_82553_()); ++particleIndex) {
            Vec3 particlePos = source.m_82549_(normalizes.m_82490_((double)particleIndex));
            ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.SONIC_SOUND.get()), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            AABB aabb = new AABB(new BlockPos(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_)).m_82400_(4.0);
            List list = level.m_6443_(LivingEntity.class, aabb, target -> !target.m_7306_((Entity)this) && !this.m_7307_((Entity)target));
            if (list.isEmpty()) continue;
            double ownerEP = TensuraEPCapability.getEP((LivingEntity)this);
            DirewolfEntity owner = this.getControllingPassenger() != null ? this.getControllingPassenger() : this;
            for (LivingEntity target2 : list) {
                if (this.m_20363_((Entity)target2)) continue;
                DamageSource damagesource = new TensuraEntityDamageSource("sonic_boom", (Entity)this).setMpCost(100.0).m_19380_().m_238403_();
                target2.m_6469_(damagesource, (float)this.m_21133_(Attributes.f_22281_) * 0.25f);
                double targetEP = TensuraEPCapability.getEP(target2);
                double difference = ownerEP / targetEP;
                if (difference <= 2.0) continue;
                int fearLevel = (int)(difference * 0.25 - 0.5);
                fearLevel = Math.min(fearLevel, (Integer)TensuraConfig.INSTANCE.mobEffectConfig.maxFear.get());
                SkillHelper.checkThenAddEffectSource(target2, (Entity)owner, (MobEffect)TensuraMobEffects.FEAR.get(), 200, fearLevel);
                target2.m_147207_(new MobEffectInstance(MobEffects.f_19613_, 200, fearLevel, false, false), (Entity)this);
                HakiSkill.hakiPush(target2, (LivingEntity)this, fearLevel);
            }
        }
    }

    private void blackLightning(Vec3 postion) {
        ManasSkillInstance instance = this.getBlackLightning();
        if (instance == null) {
            return;
        }
        BlackLightningBolt bolt = new BlackLightningBolt(this.f_19853_, (Entity)this);
        bolt.setSkill(instance);
        bolt.setMpCost(500.0);
        bolt.setRadius(3.0f);
        bolt.setTensuraDamage(50.0f);
        bolt.setAdditionalVisual(4);
        bolt.m_146884_(postion);
        this.f_19853_.m_7967_((Entity)bolt);
    }

    private void initInventory() {
        SimpleContainer chest = this.inventory;
        this.inventory = new SimpleContainer(27){

            public boolean m_6542_(Player player) {
                return DirewolfEntity.this.m_6084_() && !DirewolfEntity.this.f_19817_;
            }
        };
        if (chest != null) {
            int i = Math.min(chest.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = chest.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
    }

    public void m_213583_(Player pPlayer) {
        if (!this.isChested()) {
            return;
        }
        if (this.inventory == null) {
            return;
        }
        pPlayer.m_5893_(this.getMenu());
        if (!pPlayer.f_19853_.f_46443_) {
            this.m_146852_(GameEvent.f_157803_, (Entity)pPlayer);
        }
    }

    public void m_6667_(DamageSource cause) {
        Entity itemstack;
        super.m_6667_(cause);
        if (this.f_19853_.m_5776_()) {
            return;
        }
        if (this.m_6084_()) {
            return;
        }
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                this.m_5552_((ItemStack)itemstack, 0.0f);
            }
        }
        if ((this.isAlpha() || this.isLeader()) && (itemstack = cause.m_7639_()) instanceof Player) {
            Player player = (Player)itemstack;
            List list = this.f_19853_.m_6443_(DirewolfEntity.class, this.m_20191_().m_82377_(32.0, 32.0, 32.0), entity -> entity.m_6084_() && entity != this && entity.getLeaderUUID() == this.m_20148_());
            for (DirewolfEntity wolf : list) {
                if (wolf.m_21824_() && !this.m_21824_()) continue;
                TensuraEPCapability.getFrom((LivingEntity)wolf).ifPresent(cap -> {
                    wolf.f_19802_ = 10;
                    if (wolf.m_5448_() == player) {
                        wolf.m_21661_();
                    }
                    cap.addNeutralTarget(player.m_20148_());
                    TensuraEPCapability.sync((LivingEntity)wolf);
                });
                if (!this.isAlpha() || !wolf.m_21023_((MobEffect)TensuraMobEffects.FEAR.get()) || wolf.m_21824_()) continue;
                wolf.m_21195_((MobEffect)TensuraMobEffects.FEAR.get());
                wolf.m_21828_(player);
                wolf.m_21573_().m_26573_();
                wolf.m_21661_();
                wolf.m_21839_(false);
                wolf.m_9236_().m_7605_((Entity)wolf, (byte)7);
                TensuraEPCapability.getFrom((LivingEntity)wolf).ifPresent(namingCap -> {
                    namingCap.setPermanentOwner(player.m_20148_());
                    TensuraEPCapability.sync((LivingEntity)wolf);
                });
            }
        }
    }

    public MenuProvider getMenu() {
        if (this.inventoryMenu == null) {
            this.inventoryMenu = new MenuProvider(){

                public AbstractContainerMenu m_7208_(int menu, Inventory inventory, Player player) {
                    return new ChestMenu(MenuType.f_39959_, menu, inventory, (Container)DirewolfEntity.this.inventory, 3);
                }

                public Component m_5446_() {
                    return Component.m_237115_((String)"container.chest");
                }
            };
        }
        return this.inventoryMenu;
    }

    public boolean m_6898_(ItemStack pStack) {
        FoodProperties food = pStack.getFoodProperties((LivingEntity)this);
        return food != null && food.m_38746_();
    }

    @Nullable
    private DirewolfVariant getVariantFromCore(ItemStack core) {
        if (this.getVariant() != DirewolfVariant.BLACK_FANG) {
            return null;
        }
        if (core.m_150930_((Item)TensuraMaterialItems.ELEMENT_CORE_EARTH.get())) {
            return DirewolfVariant.BROWN_FANG;
        }
        if (core.m_150930_((Item)TensuraMaterialItems.ELEMENT_CORE_FIRE.get())) {
            return DirewolfVariant.RED_FANG;
        }
        if (core.m_150930_((Item)TensuraMaterialItems.ELEMENT_CORE_WIND.get())) {
            return DirewolfVariant.GREEN_FANG;
        }
        if (core.m_150930_((Item)TensuraMaterialItems.ELEMENT_CORE_WATER.get())) {
            return DirewolfVariant.BLUE_FANG;
        }
        if (core.m_150930_((Item)TensuraMaterialItems.ELEMENT_CORE_SPACE.get())) {
            return DirewolfVariant.PURPLE_FANG;
        }
        return null;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof HealingPotionItem) {
            return super.m_6071_(player, hand);
        }
        InteractionResult eating = this.handleEating(player, hand, itemstack);
        if (eating.m_19077_()) {
            return eating;
        }
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.getVariantFromCore(itemstack) != null;
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)player)) {
                DirewolfVariant coreVariant = this.getVariantFromCore(itemstack);
                if (coreVariant != null) {
                    this.setVariant(coreVariant);
                    this.m_5496_(SoundEvents.f_11887_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_175830_);
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
                if (!this.m_6162_()) {
                    if (!this.isChested() && itemstack.m_204117_(Tags.Items.CHESTS_WOODEN) && !this.m_6162_()) {
                        this.setChested(true);
                        this.m_5496_(SoundEvents.f_11811_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                        if (!player.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                    }
                    if (this.isChested() && itemstack.m_150930_(Items.f_42574_)) {
                        this.m_5496_(SoundEvents.f_12344_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                        this.m_19998_((ItemLike)Blocks.f_50087_);
                        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                            this.m_19983_(this.inventory.m_8020_(i));
                        }
                        this.inventory.m_6211_();
                        this.setChested(false);
                        return InteractionResult.SUCCESS;
                    }
                }
                if (player.m_36341_() || this.m_6162_()) {
                    this.commanding(player);
                } else if (this.getControllingPassenger() == null) {
                    this.m_21839_(false);
                    this.setWandering(false);
                    if (this.m_20197_().size() > (int)((double)this.getSize() + 0.25) - 1) {
                        for (Entity passenger : this.m_20197_()) {
                            if (passenger == this.getControllingPassenger()) continue;
                            passenger.m_19877_();
                            break;
                        }
                    }
                    if (player.m_7998_((Entity)this, false) && this.isStar() && this.getVariant().equals((Object)DirewolfVariant.TEMPEST_STAR_WOLF) && player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        TensuraAdvancementsHelper.grant(serverPlayer, TensuraAdvancementsHelper.Advancements.GOOD_BOY);
                    }
                } else if (this.isChested()) {
                    this.m_213583_(player);
                }
            } else if (this.m_7310_((Entity)player)) {
                player.m_7998_((Entity)this, false);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public InteractionResult handleEating(Player player, InteractionHand hand, ItemStack itemstack) {
        if (this.m_21824_() && itemstack.m_150930_(Items.f_42500_)) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.m_8035_();
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.m_6898_(itemstack)) {
            if (this.m_21223_() < this.m_21233_()) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                this.m_8035_();
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            int i = this.m_146764_();
            if (!this.f_19853_.m_5776_() && i == 0 && this.m_5957_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_27595_(player);
                this.setMiscAnimation(1);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_146740_(DirewolfEntity.m_216967_((int)(-this.m_146764_())), true);
                this.m_9236_().m_6269_(player, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.setMiscAnimation(1);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_8035_() {
        super.m_8035_();
        this.setMiscAnimation(1);
        this.m_5634_(3.0f);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        if (!(pOtherParent instanceof DirewolfEntity)) {
            return null;
        }
        DirewolfEntity direwolf = (DirewolfEntity)pOtherParent;
        DirewolfEntity baby = (DirewolfEntity)((EntityType)TensuraEntityTypes.DIREWOLF.get()).m_20615_((Level)pLevel);
        if (baby == null) {
            return null;
        }
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            baby.m_21816_(uuid);
            baby.m_7105_(true);
        }
        if (this.getCurrentEvolutionState() >= 1 && direwolf.getCurrentEvolutionState() >= 1) {
            int tempestParent;
            baby.evolve();
            baby.setCurrentEvolutionState(1);
            int n = tempestParent = this.getTypeVariant() >= 13 ? 1 : 0;
            if (direwolf.getTypeVariant() >= 13) {
                ++tempestParent;
            }
            if ((double)pLevel.m_213780_().m_188501_() <= (Double)SpawnRateConfig.INSTANCE.tempestWolfPack.get() * (double)tempestParent / 100.0) {
                baby.setVariant(DirewolfVariant.TEMPEST_WOLF);
                if (this.isStar() && SpawnRateConfig.rollChance((Integer)SpawnRateConfig.INSTANCE.starBirthmark.get(), pLevel.m_213780_())) {
                    baby.setStar(true);
                } else if (direwolf.isStar() && SpawnRateConfig.rollChance((Integer)SpawnRateConfig.INSTANCE.starBirthmark.get(), pLevel.m_213780_())) {
                    baby.setStar(true);
                }
            } else {
                int motherVariant;
                int fatherVariant = this.getTypeVariant();
                if (fatherVariant == (motherVariant = direwolf.getTypeVariant())) {
                    baby.setVariant(baby.getVariant());
                } else if (fatherVariant >= 13) {
                    baby.setVariant(direwolf.getVariant());
                } else if (motherVariant >= 13) {
                    baby.setVariant(this.getVariant());
                } else if ((double)(pLevel.m_213780_().m_188501_() * 100.0f) <= (Double)SpawnRateConfig.INSTANCE.elementalFangPack.get()) {
                    baby.setVariant(this.getEvolutionByBiomes());
                } else {
                    baby.setVariant(DirewolfVariant.BLACK_FANG);
                }
            }
            if (baby.getTypeVariant() >= 14) {
                baby.setVariant(DirewolfVariant.TEMPEST_WOLF);
            }
        }
        return baby;
    }

    public boolean m_7132_() {
        return this.m_20160_() && !this.m_20068_();
    }

    public double getCustomJump() {
        return this.m_21133_(Attributes.f_22288_);
    }

    public boolean m_6146_() {
        return true;
    }

    @Override
    public boolean hasScrollAbility() {
        if (this.getCurrentEvolutionState() <= 0) {
            return false;
        }
        return this.getControllingPassenger() != null;
    }

    public boolean m_7310_(Entity other) {
        if (this.getControllingPassenger() == null && this.m_21826_() != other) {
            return false;
        }
        if ((double)this.getSize() < 1.75) {
            return super.m_7310_(other);
        }
        return this.m_20197_().size() < (int)((double)this.getSize() + 0.25);
    }

    protected void m_20351_(Entity pPassenger) {
        super.m_20351_(pPassenger);
        if (this.m_20068_() && this.getControllingPassenger() == null) {
            this.m_20242_(false);
        }
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        for (Entity passenger : this.m_20197_()) {
            Player player;
            if (!(passenger instanceof Player) || !(player = (Player)passenger).equals((Object)this.m_21826_())) continue;
            return player;
        }
        return null;
    }

    public void m_7332_(Entity passenger) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        passenger.m_183634_();
        int index = this.m_20197_().indexOf(passenger);
        float radius = -0.35f - (float)index;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double yOffset = this.m_20186_() + this.m_6048_() + passenger.m_6049_();
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        passenger.m_6034_(this.m_20185_() + extraX, yOffset, this.m_20189_() + extraZ);
    }

    public double m_6048_() {
        return super.m_6048_() + 0.25 * (double)(this.getSize() - 1.0f);
    }

    public void m_7888_(int pJumpPower) {
        if (pJumpPower >= 90) {
            this.playerJumpPendingScale = 1.0f;
        } else {
            if (pJumpPower < 0) {
                pJumpPower = 0;
            }
            this.playerJumpPendingScale = 0.4f + 0.4f * (float)pJumpPower / 90.0f;
        }
    }

    public void m_7199_(int pJumpPower) {
        if (this.m_20096_()) {
            this.playJumpSound();
        } else if (this.getVariant() == DirewolfVariant.TEMPEST_STAR_WOLF && !this.m_21023_((MobEffect)TensuraMobEffects.MAGIC_INTERFERENCE.get())) {
            this.m_20242_(true);
        }
    }

    public void m_8012_() {
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6084_()) {
            LivingEntity controller = this.getControllingPassenger();
            if (this.m_20160_() && controller != null) {
                boolean canJump;
                this.m_146922_(controller.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(controller.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = controller.f_20900_ * 0.5f;
                float f1 = controller.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                double threshold = Math.min(this.m_20204_(), 0.9);
                boolean bl = canJump = this.m_20096_() || this.isInFluidType((fluidType, height) -> height <= threshold) && this.getVariant() == DirewolfVariant.TEMPEST_STAR_WOLF;
                if (this.playerJumpPendingScale > 0.0f && !this.isPlayerJumping() && canJump) {
                    double d0 = this.getCustomJump() * (double)this.playerJumpPendingScale * (double)this.m_20098_();
                    double d1 = d0 + this.m_182332_();
                    Vec3 vec3 = this.m_20184_();
                    this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
                    this.setPlayerJumping(true);
                    this.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * this.playerJumpPendingScale), 0.0, (double)(0.4f * f3 * this.playerJumpPendingScale)));
                    }
                    this.playerJumpPendingScale = 0.0f;
                }
                float flyingMultiplier = this.m_20068_() ? 0.5f : 0.1f;
                this.f_20887_ = this.m_6113_() * flyingMultiplier;
                if (this.m_6109_()) {
                    float speed = (float)this.m_21133_(Attributes.f_22279_);
                    if (controller.m_20142_()) {
                        speed = (float)((double)speed * 2.5);
                    }
                    this.m_7910_(speed);
                    if (this.m_20068_()) {
                        if (controller.f_20899_) {
                            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.1, 0.0));
                        } else if (TensuraKeybinds.MOUNT_DESCENDING.m_90857_()) {
                            this.descending((Entity)this, controller);
                        }
                    } else if (this.isInFluidType((fluidType, height) -> height > threshold) && f1 > 0.0f) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.03, 0.0));
                    }
                    super.m_7023_(new Vec3((double)f, pTravelVector.f_82480_, (double)f1));
                } else if (controller instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.f_19861_) {
                    this.playerJumpPendingScale = 0.0f;
                    this.setPlayerJumping(false);
                    this.m_20242_(false);
                }
                this.m_146872_();
            } else {
                this.f_20887_ = 0.02f;
                super.m_7023_(pTravelVector);
            }
        }
    }

    @Override
    public void mountAbility(Player rider) {
        if (this.getMiscAnimation() != 0 && this.getMiscAnimation() != 1 && this.getMiscAnimation() != 2) {
            return;
        }
        this.m_8127_();
        if (this.getSize() >= this.getMaxSize() && this.getBlackLightning() != null) {
            LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)rider, 50.0, true, false);
            Vec3 pos = target != null ? target.m_20182_() : SkillHelper.getPlayerPOVHitResultFromPos(this.f_19853_, (LivingEntity)rider, ClipContext.Fluid.NONE, 50.0, rider.m_20182_().m_82520_(0.0, (double)rider.m_20206_(), 0.0)).m_82450_();
            this.blackLightning(pos);
            this.setMiscAnimation(4);
        } else {
            this.setMiscAnimation(3);
        }
    }

    @Override
    public void mountScrollAbility(Player rider, double scrollChange) {
        float newSize = Mth.m_14036_((float)(this.getSize() + (float)scrollChange * 0.1f), (float)0.75f, (float)this.getMaxSize());
        this.setSize(newSize);
        if (this.m_20197_().size() > (int)((double)newSize + 0.25)) {
            for (Entity passenger : this.m_20197_()) {
                if (passenger == this.getControllingPassenger()) continue;
                passenger.m_19877_();
                break;
            }
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.isChested()) {
            if (!this.f_19853_.m_5776_()) {
                this.m_19998_((ItemLike)Blocks.f_50087_);
                for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                    this.m_19983_(this.inventory.m_8020_(i));
                }
            }
            this.inventory.m_6211_();
            this.setChested(false);
        }
    }

    public int m_5792_() {
        return 12;
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return SpawnRateConfig.rollSpawn((Integer)SpawnRateConfig.INSTANCE.direwolfSpawnRate.get(), this.m_217043_(), pSpawnReason) && super.m_5545_(pLevel, pSpawnReason);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        DirewolfVariant variant;
        DirewolfPackData data;
        DirewolfPackData packData = pSpawnData instanceof DirewolfPackData ? (data = (DirewolfPackData)pSpawnData) : new DirewolfPackData();
        this.setSize(1.0f);
        this.setMaxSize(1.2f);
        if (packData.getVariant() == null) {
            if ((double)(pLevel.m_213780_().m_188501_() * 100.0f) <= (Double)SpawnRateConfig.INSTANCE.evolvedPack.get()) {
                if ((double)(pLevel.m_213780_().m_188501_() * 100.0f) <= (Double)SpawnRateConfig.INSTANCE.tempestWolfPack.get()) {
                    packData.setVariant(DirewolfVariant.TEMPEST_WOLF);
                } else if ((double)(pLevel.m_213780_().m_188501_() * 100.0f) <= (Double)SpawnRateConfig.INSTANCE.elementalFangPack.get()) {
                    packData.setVariant(this.getEvolutionByBiomes());
                } else {
                    packData.setVariant(DirewolfVariant.BLACK_FANG);
                }
            } else {
                packData.setVariant(DirewolfVariant.DIREWOLF);
            }
        }
        if ((variant = packData.getVariant()).getId() > 0) {
            this.setSize(this.getSize() + 0.25f);
            this.setMaxSize(1.25f);
            this.setCurrentEvolutionState(this.getCurrentEvolutionState() + 1);
            this.evolveBuff();
            if (variant == DirewolfVariant.TEMPEST_WOLF && packData.getStar() == null && SpawnRateConfig.rollChance((Integer)SpawnRateConfig.INSTANCE.starBirthmark.get(), pLevel.m_213780_())) {
                this.setStar(true);
                packData.setStar(this);
            }
        }
        this.setVariant(packData.getVariant());
        if (packData.getAlpha() == null && SpawnRateConfig.rollChance((Integer)SpawnRateConfig.INSTANCE.alphaWolf.get(), pLevel.m_213780_())) {
            packData.setAlpha(this);
            this.setAlpha(true);
            this.setSize(this.getVariant() != DirewolfVariant.DIREWOLF ? 1.75f : 1.5f);
            this.setMaxSize(this.getMaxSize() + 0.5f);
            this.gainAttackDamage((LivingEntity)this, 20.0);
            this.gainMovementSpeed((LivingEntity)this, 0.1f);
            this.gainSwimSpeed((LivingEntity)this, 1.0);
            this.gainMaxHealth((LivingEntity)this, 30.0);
        }
        if (this.getShadowMotion() != null && (pReason == MobSpawnType.MOB_SUMMONED || pReason == MobSpawnType.SPAWN_EGG)) {
            this.setMiscAnimation(5);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, (SpawnGroupData)packData, pDataTag);
    }

    protected SoundEvent m_7515_() {
        if (this.m_21660_() || this.isAlpha()) {
            return SoundEvents.f_12619_;
        }
        return SoundEvents.f_12617_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    protected void playJumpSound() {
        this.m_5496_((SoundEvent)TensuraSoundEvents.SMALL_JUMP_IMPACT.get(), 0.4f, 1.0f);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_5803_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.direwolf.sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.direwolf.sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            if (this.isInFluidType()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.direwolf.swim", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (this.m_21660_() || this.getControllingPassenger() != null && this.getControllingPassenger().m_20142_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.direwolf.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.direwolf.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.direwolf.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.direwolf.eat", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.direwolf.bite", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.direwolf.bark", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 4) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.direwolf.howl", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 5) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.direwolf.shadow_motion", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState tiltPredicate(AnimationEvent<E> event) {
        if (this.getMiscAnimation() != 0) {
            return PlayState.STOP;
        }
        if (this.isInterested()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.direwolf.head_tilt", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "tiltController", 0.0f, this::tiltPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean isPlayerJumping() {
        return this.playerJumping;
    }

    public void setPlayerJumping(boolean playerJumping) {
        this.playerJumping = playerJumping;
    }

    class DirewolfAttackGoal
    extends MeleeAttackGoal {
        private final DirewolfEntity wolf;

        public DirewolfAttackGoal() {
            super((PathfinderMob)DirewolfEntity.this, 2.5, true);
            this.wolf = DirewolfEntity.this;
        }

        public boolean m_8036_() {
            if (this.wolf.m_21827_()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.wolf.m_21827_()) {
                return false;
            }
            return super.m_8045_();
        }

        public void m_8037_() {
            if (this.wolf.getMiscAnimation() == 0) {
                super.m_8037_();
            }
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double distance = this.m_6639_(pEnemy);
            if (this.wolf.getMiscAnimation() == 0) {
                double attackRange;
                int randomAttack = this.randomAttack(pDistToEnemySqr, pEnemy);
                switch (randomAttack) {
                    case 4: 
                    case 5: {
                        this.wolf.m_21573_().m_26573_();
                        double d = 3600.0;
                        break;
                    }
                    case 3: {
                        this.wolf.m_21573_().m_26573_();
                        double d = 225.0;
                        break;
                    }
                    default: {
                        double d = attackRange = distance;
                    }
                }
                if (pDistToEnemySqr <= attackRange && this.m_25564_()) {
                    this.m_25563_();
                    this.wolf.setMiscAnimation(randomAttack);
                    if (randomAttack == 2) {
                        this.wolf.m_7327_((Entity)pEnemy);
                    } else if (randomAttack == 5) {
                        this.wolf.m_8127_();
                        this.wolf.m_20219_(pEnemy.m_20182_());
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this.wolf, (ParticleOptions)ParticleTypes.f_123765_);
                        this.wolf.f_19864_ = true;
                    }
                }
            }
        }

        protected int randomAttack(double distance, LivingEntity entity) {
            if (this.wolf.m_6162_()) {
                return 2;
            }
            if (this.wolf.f_19796_.m_188503_(10) == 1) {
                if (entity.m_20096_() && this.wolf.m_20096_() && distance >= 200.0 && this.wolf.f_19796_.m_188503_(10) == 1 && this.wolf.getShadowMotion() != null) {
                    return 5;
                }
                if ((distance >= 200.0 || this.wolf.f_19796_.m_188503_(15) == 1) && this.wolf.getBlackLightning() != null) {
                    return 4;
                }
                if (distance >= 36.0 || this.wolf.f_19796_.m_188503_(20) == 1) {
                    return 3;
                }
            }
            return 2;
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() * 3.0f + pAttackTarget.m_20205_();
        }
    }

    static class FollowLeaderGoal
    extends Goal {
        private final DirewolfEntity wolf;
        @Nullable
        private DirewolfEntity leader;
        private final double speedModifier;
        private int timeToRePath;
        private int nextStartTick;

        public FollowLeaderGoal(DirewolfEntity wolf, double pSpeedModifier) {
            this.wolf = wolf;
            this.speedModifier = pSpeedModifier;
            this.nextStartTick = this.nextStartTick(wolf);
        }

        protected int nextStartTick(DirewolfEntity pTaskOwner) {
            return FollowLeaderGoal.m_186073_((int)(100 + pTaskOwner.m_217043_().m_188503_(100) % 20));
        }

        public boolean m_8036_() {
            ServerLevel serverLevel;
            Level level;
            if (this.wolf.m_21824_()) {
                return false;
            }
            if (this.wolf.isAlpha() || this.wolf.isLeader()) {
                return false;
            }
            if (this.nextStartTick > 0) {
                --this.nextStartTick;
                return false;
            }
            UUID uuid = this.wolf.getLeaderUUID();
            if (uuid != null && (level = this.wolf.f_19853_) instanceof ServerLevel && (level = (serverLevel = (ServerLevel)level).m_8791_(uuid)) instanceof DirewolfEntity) {
                DirewolfEntity direwolf;
                this.leader = direwolf = (DirewolfEntity)level;
                return true;
            }
            List<DirewolfEntity> list = this.wolf.f_19853_.m_45976_(DirewolfEntity.class, this.wolf.m_20191_().m_82377_(32.0, 32.0, 32.0)).stream().filter(entity -> entity != this.wolf).toList();
            if (this.searchForLeader(list, DirewolfEntity::isAlpha)) {
                return true;
            }
            if (this.searchForLeader(list, DirewolfEntity::isLeader)) {
                return true;
            }
            if (this.searchForLeader(list, DirewolfEntity::isStar)) {
                return true;
            }
            return this.searchForLeader(list, entity -> true);
        }

        private boolean searchForLeader(List<DirewolfEntity> list, Predicate<DirewolfEntity> predicate) {
            List<DirewolfEntity> filtered = list.stream().filter(predicate).sorted(Comparator.comparingInt(DirewolfEntity::getCurrentEvolutionState)).sorted(Comparator.comparingDouble(DirewolfEntity::getMaxSize)).toList();
            if (filtered.isEmpty()) {
                return false;
            }
            DirewolfEntity leader = filtered.get(0);
            this.wolf.setLeaderUUID(leader.m_20148_());
            this.wolf.setLeader(false);
            this.leader = leader;
            this.leader.setLeader(true);
            this.leader.setLeaderUUID(null);
            return true;
        }

        public boolean m_8045_() {
            if (this.wolf.m_21824_()) {
                return false;
            }
            if (this.leader == null) {
                return false;
            }
            return this.leader.m_6084_();
        }

        public void m_8056_() {
            this.timeToRePath = 0;
            if (this.wolf.m_5803_()) {
                this.wolf.setSleeping(false);
            }
        }

        public void m_8041_() {
            this.leader = null;
            this.wolf.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (this.leader == null) {
                return;
            }
            this.leader.setLeaderTick(200);
            this.wolf.setLeaderUUID(this.leader.m_20148_());
            if (this.wolf.m_21523_() || this.wolf.m_20159_()) {
                return;
            }
            if (this.wolf.m_5448_() != null) {
                return;
            }
            if (--this.timeToRePath > 0) {
                return;
            }
            double d0 = this.wolf.m_20280_((Entity)this.leader);
            if (d0 >= 36.0 && d0 <= 400.0) {
                if (this.leader.m_5448_() != null && this.wolf.m_5448_() != null && this.leader.m_5448_() != this.wolf && this.leader.m_5448_().m_20270_((Entity)this.wolf) <= 20.0f) {
                    this.wolf.m_6710_(this.leader.m_5448_());
                }
                this.timeToRePath = this.m_183277_(10);
                this.wolf.m_21573_().m_5624_((Entity)this.leader, this.speedModifier);
            }
        }
    }

    static class TiltingHeadGoal
    extends Goal {
        private final DirewolfEntity wolf;
        @Nullable
        private Player player;
        private final Level level;
        private final float lookDistance;
        private int lookTime;
        private final TargetingConditions begTargeting;

        public TiltingHeadGoal(DirewolfEntity entity, float pLookDistance) {
            this.wolf = entity;
            this.level = entity.f_19853_;
            this.lookDistance = pLookDistance;
            this.begTargeting = TargetingConditions.m_148353_().m_26883_((double)pLookDistance);
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            this.player = this.level.m_45946_(this.begTargeting, (LivingEntity)this.wolf);
            if (this.player == null) {
                return false;
            }
            return this.playerHoldingInteresting(this.player);
        }

        public boolean m_8045_() {
            if (this.player == null) {
                return false;
            }
            if (!this.player.m_6084_()) {
                return false;
            }
            if (this.wolf.m_20280_((Entity)this.player) > (double)(this.lookDistance * this.lookDistance)) {
                return false;
            }
            return this.lookTime > 0 && this.playerHoldingInteresting(this.player);
        }

        public void m_8056_() {
            this.wolf.setInterested(true);
            this.lookTime = this.m_183277_(40 + this.wolf.m_217043_().m_188503_(40));
        }

        public void m_8041_() {
            this.wolf.setInterested(false);
            this.player = null;
        }

        public void m_8037_() {
            if (this.player == null) {
                return;
            }
            this.wolf.m_21563_().m_24950_(this.player.m_20185_(), this.player.m_20188_(), this.player.m_20189_(), 10.0f, (float)this.wolf.m_8132_());
            --this.lookTime;
        }

        private boolean playerHoldingInteresting(Player pPlayer) {
            if (this.wolf.m_20363_((Entity)pPlayer)) {
                return false;
            }
            for (InteractionHand interactionhand : InteractionHand.values()) {
                ItemStack itemstack = pPlayer.m_21120_(interactionhand);
                if (!this.wolf.m_21824_()) continue;
                if (itemstack.m_150930_(Items.f_42500_)) {
                    return true;
                }
                if (!this.wolf.m_6898_(itemstack) || !(this.wolf.m_21223_() < this.wolf.m_21233_())) continue;
                return true;
            }
            return false;
        }
    }

    public static class DirewolfPackData
    extends AgeableMob.AgeableMobGroupData {
        @Nullable
        private DirewolfEntity alpha;
        @Nullable
        private DirewolfEntity star;
        @Nullable
        private DirewolfVariant variant;

        public DirewolfPackData() {
            super(false);
        }

        public void setAlpha(@Nullable DirewolfEntity alpha) {
            this.alpha = alpha;
        }

        public void setStar(@Nullable DirewolfEntity star) {
            this.star = star;
        }

        public void setVariant(@Nullable DirewolfVariant variant) {
            this.variant = variant;
        }

        @Nullable
        public DirewolfEntity getAlpha() {
            return this.alpha;
        }

        @Nullable
        public DirewolfEntity getStar() {
            return this.star;
        }

        @Nullable
        public DirewolfVariant getVariant() {
            return this.variant;
        }
    }
}

