/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.api.entity.ai.TamableFollowParentGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.subclass.ITensuraMount;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.projectile.KunaiProjectile;
import com.github.manasmods.tensura.entity.projectile.SpearProjectile;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.item.food.HealingPotionItem;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class GiantBearEntity
extends TensuraTamableEntity
implements IAnimatable,
ITensuraMount,
PlayerRideableJumping {
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(GiantBearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private boolean prevSprint;
    public int miscAnimationTicks = 0;
    protected float playerJumpPendingScale;
    protected boolean playerJumping;

    public GiantBearEntity(EntityType<? extends GiantBearEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 40;
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 18.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22278_, (double)0.4f).m_22268_(Attributes.f_22288_, 1.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 2.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new GiantBearAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new WanderingFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 1.2, GiantBearEntity.class));
        this.f_21345_.m_25352_(6, (Goal)new TamableFollowParentGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(7, (Goal)new TensuraTamableEntity.WanderAroundPosGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new GiantBearAttackPlayersGoal());
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((GiantBearEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, e -> this.m_21223_() < this.m_21233_() / 2.0f));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, e -> e.m_6095_().m_204039_(TensuraTags.EntityTypes.ANIMAL_PREY) && this.m_21223_() < this.m_21233_() / 2.0f));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        if (this.getMiscAnimation() != 0 && animation != 0) {
            return;
        }
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (f_21798_.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return SpawnRateConfig.rollSpawn((Integer)SpawnRateConfig.INSTANCE.giantBearSpawnRate.get(), this.m_217043_(), pSpawnReason) && super.m_5545_(pLevel, pSpawnReason);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        GiantBearEntity bear = (GiantBearEntity)((EntityType)TensuraEntityTypes.GIANT_BEAR.get()).m_20615_((Level)pLevel);
        if (bear == null) {
            return null;
        }
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            bear.m_21816_(uuid);
            bear.m_7105_(true);
        }
        return bear;
    }

    public boolean m_6898_(ItemStack pStack) {
        if (pStack.m_204117_(TensuraTags.Items.BEAR_TAMING_FOOD)) {
            return false;
        }
        FoodProperties food = pStack.getFoodProperties((LivingEntity)this);
        return food != null && food.m_38746_();
    }

    public boolean isPassengerSprint() {
        return this.getControllingPassenger() != null && this.getControllingPassenger().m_20142_();
    }

    @Override
    public EntityDimensions m_6972_(Pose pPose) {
        EntityDimensions entitydimensions = super.m_6972_(pPose);
        if (this.isPassengerSprint()) {
            return EntityDimensions.m_20398_((float)entitydimensions.f_20377_, (float)(entitydimensions.f_20378_ * 4.0f / 5.0f));
        }
        if (this.m_21825_()) {
            return EntityDimensions.m_20398_((float)entitydimensions.f_20377_, (float)(entitydimensions.f_20378_ * 2.0f / 3.0f));
        }
        return entitydimensions;
    }

    public boolean m_6673_(DamageSource source) {
        if (source.m_7640_() instanceof Arrow || source.m_7640_() instanceof SpearProjectile || source.m_7640_() instanceof ThrownTrident || source.m_7640_() instanceof KunaiProjectile) {
            this.setMiscAnimation(6);
            return true;
        }
        return source == DamageSource.f_19314_ || source == DamageSource.f_19325_ || super.m_6673_(source);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        if (pFallDistance < 6.0f) {
            return false;
        }
        int i = this.m_5639_(pFallDistance - 7.0f, pMultiplier);
        if (i <= 0) {
            return false;
        }
        this.m_6469_(pSource, i);
        this.m_21229_();
        return true;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.prevSprint != this.isPassengerSprint()) {
            this.prevSprint = this.isPassengerSprint();
            this.m_6210_();
        }
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (this.miscAnimationTicks >= 11) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    @Override
    public void mountAbility(Player rider) {
        if (this.getMiscAnimation() == 3) {
            return;
        }
        if (this.getMiscAnimation() == 4) {
            return;
        }
        if (this.getMiscAnimation() == 5) {
            return;
        }
        if (this.m_6162_()) {
            return;
        }
        LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)rider, 6.0, false);
        if (target == null) {
            return;
        }
        this.setMiscAnimation(5);
        this.m_7327_((Entity)target);
    }

    public void areaAttack(int animType) {
        float multiply = animType == 4 ? 1.0f : 1.5f;
        AABB aabb = this.m_20191_().m_82400_(4.0);
        List livingEntityList = this.f_19853_.m_6443_(LivingEntity.class, aabb, entity -> !entity.m_7307_((Entity)this) && !entity.equals((Object)this.m_21826_()) && !entity.equals((Object)this) && (!(entity instanceof GiantBearEntity) || entity == this.m_5448_()));
        if (livingEntityList.isEmpty()) {
            return;
        }
        for (LivingEntity target : livingEntityList) {
            target.m_6469_(DamageSource.m_19370_((LivingEntity)target), (float)(this.m_21133_(Attributes.f_22281_) * (double)multiply));
            target.m_20184_().m_82520_(0.0, 0.5 * (double)multiply, 0.0);
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof HealingPotionItem) {
            return super.m_6071_(player, hand);
        }
        InteractionResult eating = this.handleEating(player, hand, itemstack);
        if (eating.m_19077_()) {
            return eating;
        }
        if (!player.m_36341_() && !this.m_6162_() && this.m_21830_((LivingEntity)player)) {
            this.setMiscAnimation(2);
            if (this.m_21827_()) {
                this.m_21839_(false);
            }
            if (this.isWandering()) {
                this.setWandering(false);
            }
            if (!this.f_19853_.m_5776_()) {
                player.m_7998_((Entity)this, true);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        }
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || itemstack.m_204117_(TensuraTags.Items.BEAR_TAMING_FOOD);
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (!super.m_6071_(player, hand).m_19077_() && this.m_21830_((LivingEntity)player)) {
                this.commanding(player);
                return InteractionResult.SUCCESS;
            }
        } else if (itemstack.m_204117_(TensuraTags.Items.BEAR_TAMING_FOOD)) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(10) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                if (this.f_19796_.m_188503_(20) == 0) {
                    this.m_6710_((LivingEntity)player);
                }
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult handleEating(Player player, InteractionHand hand, ItemStack itemstack) {
        if (this.m_6898_(itemstack)) {
            if (this.m_21223_() < this.m_21233_()) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(3.0f);
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.setMiscAnimation(1);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_146740_(GiantBearEntity.m_216967_((int)(-this.m_146764_())), true);
                this.m_9236_().m_6269_(player, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.setMiscAnimation(1);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (!this.f_19853_.f_46443_ && this.m_146764_() == 0 && this.m_5957_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_27595_(player);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_7132_() {
        return this.m_20160_();
    }

    public double getCustomJump() {
        return this.m_21133_(Attributes.f_22288_);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public void m_7888_(int pJumpPower) {
        if (pJumpPower >= 90) {
            this.playerJumpPendingScale = 1.0f;
        } else {
            if (pJumpPower < 0) {
                pJumpPower = 0;
            }
            this.playerJumpPendingScale = 0.4f + 0.4f * (float)pJumpPower / 90.0f;
        }
    }

    public void m_7199_(int pJumpPower) {
        if (!this.m_20096_()) {
            return;
        }
        this.playJumpSound();
    }

    public void m_8012_() {
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6084_()) {
            LivingEntity livingentity = this.getControllingPassenger();
            if (this.m_20160_() && livingentity != null) {
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = livingentity.f_20900_ * 0.5f;
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.playerJumpPendingScale > 0.0f && !this.isPlayerJumping() && this.f_19861_) {
                    double d0 = this.getCustomJump() * (double)this.playerJumpPendingScale * (double)this.m_20098_();
                    double d1 = d0 + this.m_182332_();
                    Vec3 vec3 = this.m_20184_();
                    this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
                    this.setPlayerJumping(true);
                    this.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * this.playerJumpPendingScale), 0.0, (double)(0.4f * f3 * this.playerJumpPendingScale)));
                    }
                    this.playerJumpPendingScale = 0.0f;
                }
                this.f_20887_ = this.m_6113_() * 0.1f;
                if (this.m_6109_()) {
                    float speed = (float)this.m_21133_(Attributes.f_22279_);
                    if (livingentity.m_20142_()) {
                        speed = (float)((double)speed * 1.5);
                    }
                    this.m_7910_(speed);
                    if (this.isInFluidType((fluidType, height) -> height > this.m_20204_()) && f1 > 0.0f) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.03, 0.0));
                        super.m_7023_(new Vec3((double)f, (double)livingentity.f_20901_, (double)f1));
                    } else {
                        super.m_7023_(new Vec3((double)f, pTravelVector.f_82480_, (double)f1));
                    }
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.f_19861_) {
                    this.playerJumpPendingScale = 0.0f;
                    this.setPlayerJumping(false);
                }
                this.m_21043_((LivingEntity)this, false);
                this.m_146872_();
            } else {
                this.f_20887_ = 0.02f;
                super.m_7023_(pTravelVector);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return this.m_6162_() ? SoundEvents.f_12281_ : SoundEvents.f_12280_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        if (this.getMiscAnimation() == 0) {
            this.setMiscAnimation(6);
        }
        return SoundEvents.f_12283_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12282_;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected void playJumpSound() {
        this.m_5496_((SoundEvent)TensuraSoundEvents.SMALL_JUMP_IMPACT.get(), 0.4f, 1.0f);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_bear.sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (event.isMoving()) {
            if (this.m_20096_() && this.m_21660_() || this.getControllingPassenger() != null && this.getControllingPassenger().m_20142_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_bear.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_bear.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.m_21223_() <= this.m_21233_() / 4.0f) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_bear.idle_hurt", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_bear.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                if (this.m_21825_()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_bear.block", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    return PlayState.CONTINUE;
                }
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_bear.eat", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (!this.m_21825_()) {
                if (this.getMiscAnimation() == 2) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_bear.pick_up_item", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                } else if (this.getMiscAnimation() == 3) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_bear.slam_both_hand", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                } else if (this.getMiscAnimation() == 4) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_bear.slam_one_hand", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                } else if (this.getMiscAnimation() == 5) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation(new Random().nextFloat() <= 0.5f ? "animation.giant_bear.right_punch" : "animation.giant_bear.left_punch", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                } else if (this.getMiscAnimation() == 6) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.giant_bear.block", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void setPlayerJumping(boolean playerJumping) {
        this.playerJumping = playerJumping;
    }

    public boolean isPlayerJumping() {
        return this.playerJumping;
    }

    static class GiantBearAttackGoal
    extends MeleeAttackGoal {
        public final GiantBearEntity giantBear;

        public GiantBearAttackGoal(GiantBearEntity bear) {
            super((PathfinderMob)bear, 3.0, true);
            this.giantBear = bear;
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(pEnemy);
            if ((double)this.giantBear.f_19796_.m_188501_() >= 0.2) {
                if (pDistToEnemySqr <= d0 && this.m_25564_()) {
                    this.m_25563_();
                    this.f_25540_.m_7327_((Entity)pEnemy);
                    this.giantBear.setMiscAnimation(5);
                }
            } else {
                int slamAnim;
                int n = slamAnim = new Random().nextFloat() <= 0.5f ? 4 : 3;
                if (pDistToEnemySqr <= d0 + 4.0 && this.m_25564_()) {
                    this.m_25563_();
                    this.f_25540_.f_19853_.m_5594_(null, this.f_25540_.m_20183_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    this.giantBear.areaAttack(slamAnim);
                } else if (pDistToEnemySqr <= d0 * 2.0) {
                    if (this.m_25564_()) {
                        this.m_25563_();
                    }
                    if (this.m_25565_() <= 150) {
                        this.giantBear.setMiscAnimation(slamAnim);
                    }
                } else {
                    this.m_25563_();
                }
            }
        }
    }

    class GiantBearAttackPlayersGoal
    extends NearestAttackableTargetGoal<Player> {
        public GiantBearAttackPlayersGoal() {
            super((Mob)GiantBearEntity.this, Player.class, 20, true, true, null);
        }

        public boolean m_8036_() {
            if (GiantBearEntity.this.m_21824_()) {
                return false;
            }
            if (GiantBearEntity.this.m_6162_()) {
                return false;
            }
            if (super.m_8036_()) {
                for (GiantBearEntity bear : GiantBearEntity.this.f_19853_.m_45976_(GiantBearEntity.class, GiantBearEntity.this.m_20191_().m_82377_(8.0, 4.0, 8.0))) {
                    if (!bear.m_6162_() || bear.m_21824_()) continue;
                    return true;
                }
            }
            return false;
        }

        protected double m_7623_() {
            return super.m_7623_() * 0.5;
        }
    }
}

