/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.tensura.api.entity.ai.CrossbowAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.TamableFollowParentGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.subclass.IRanking;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.entity.human.PlayerLikeEntity;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.entity.variant.GoblinVariant;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;

public class GoblinEntity
extends PlayerLikeEntity
implements IRanking {
    private static final EntityDataAccessor<Integer> EVOLUTION_STATE = SynchedEntityData.m_135353_(GoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(GoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SKIN = SynchedEntityData.m_135353_(GoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FACE = SynchedEntityData.m_135353_(GoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HAIR = SynchedEntityData.m_135353_(GoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CLOTHING = SynchedEntityData.m_135353_(GoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> BANDAGES = SynchedEntityData.m_135353_(GoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> HEAD = SynchedEntityData.m_135353_(GoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> HEAD_COLOR = SynchedEntityData.m_135353_(GoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TOP = SynchedEntityData.m_135353_(GoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TOP_COLOR = SynchedEntityData.m_135353_(GoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BOTTOM = SynchedEntityData.m_135353_(GoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BOTTOM_COLOR = SynchedEntityData.m_135353_(GoblinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public GoblinEntity(EntityType<? extends GoblinEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends PlayerLikeEntity>)pEntityType, pLevel);
        this.f_21364_ = 5;
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 1.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, new CrossbowAttackGoal<GoblinEntity>(this, 1.2, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.SpearTypeAttackGoal(this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.NPCMeleeAttackGoal(this, (PathfinderMob)this, 2.0, true));
        this.f_21345_.m_25352_(4, (Goal)new WanderingFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 1.2, GoblinEntity.class));
        this.f_21345_.m_25352_(6, (Goal)new TamableFollowParentGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(7, (Goal)new TensuraTamableEntity.WanderAroundPosGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, GoblinEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((GoblinEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(EVOLUTION_STATE, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(SKIN, (Object)0);
        this.f_19804_.m_135372_(FACE, (Object)0);
        this.f_19804_.m_135372_(HAIR, (Object)0);
        this.f_19804_.m_135372_(CLOTHING, (Object)0);
        this.f_19804_.m_135372_(BANDAGES, (Object)false);
        this.f_19804_.m_135372_(HEAD, (Object)0);
        this.f_19804_.m_135372_(HEAD_COLOR, (Object)0);
        this.f_19804_.m_135372_(TOP, (Object)0);
        this.f_19804_.m_135372_(TOP_COLOR, (Object)0);
        this.f_19804_.m_135372_(BOTTOM, (Object)0);
        this.f_19804_.m_135372_(BOTTOM_COLOR, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("EvoState", this.getCurrentEvolutionState());
        compound.m_128405_("Gender", ((Integer)this.f_19804_.m_135370_(GENDER)).intValue());
        compound.m_128405_("Skin", ((Integer)this.f_19804_.m_135370_(SKIN)).intValue());
        compound.m_128405_("Face", ((Integer)this.f_19804_.m_135370_(FACE)).intValue());
        compound.m_128405_("Hair", ((Integer)this.f_19804_.m_135370_(HAIR)).intValue());
        compound.m_128405_("Clothing", ((Integer)this.f_19804_.m_135370_(CLOTHING)).intValue());
        compound.m_128379_("Bandages", ((Boolean)this.f_19804_.m_135370_(BANDAGES)).booleanValue());
        compound.m_128405_("Head", ((Integer)this.f_19804_.m_135370_(HEAD)).intValue());
        compound.m_128405_("HeadColor", ((Integer)this.f_19804_.m_135370_(HEAD_COLOR)).intValue());
        compound.m_128405_("Top", ((Integer)this.f_19804_.m_135370_(TOP)).intValue());
        compound.m_128405_("TopColor", ((Integer)this.f_19804_.m_135370_(TOP_COLOR)).intValue());
        compound.m_128405_("Bottom", ((Integer)this.f_19804_.m_135370_(BOTTOM)).intValue());
        compound.m_128405_("BottomColor", ((Integer)this.f_19804_.m_135370_(BOTTOM_COLOR)).intValue());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCurrentEvolutionState(compound.m_128451_("EvoState"));
        this.f_19804_.m_135381_(GENDER, (Object)compound.m_128451_("Gender"));
        this.f_19804_.m_135381_(SKIN, (Object)compound.m_128451_("Skin"));
        this.f_19804_.m_135381_(FACE, (Object)compound.m_128451_("Face"));
        this.f_19804_.m_135381_(HAIR, (Object)compound.m_128451_("Hair"));
        this.f_19804_.m_135381_(CLOTHING, (Object)compound.m_128451_("Clothing"));
        this.f_19804_.m_135381_(BANDAGES, (Object)compound.m_128471_("Bandages"));
        this.f_19804_.m_135381_(HEAD, (Object)compound.m_128451_("Head"));
        this.f_19804_.m_135381_(HEAD_COLOR, (Object)compound.m_128451_("HeadColor"));
        this.f_19804_.m_135381_(TOP, (Object)compound.m_128451_("TopColor"));
        this.f_19804_.m_135381_(TOP_COLOR, (Object)compound.m_128451_("Top"));
        this.f_19804_.m_135381_(BOTTOM, (Object)compound.m_128451_("Bottom"));
        this.f_19804_.m_135381_(BOTTOM_COLOR, (Object)compound.m_128451_("BottomColor"));
    }

    public GoblinVariant.Gender getGender() {
        return GoblinVariant.Gender.byId((Integer)this.f_19804_.m_135370_(GENDER));
    }

    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    public GoblinVariant.Skin getSkin() {
        return GoblinVariant.Skin.byId((Integer)this.f_19804_.m_135370_(SKIN));
    }

    public void setSkin(int skin) {
        this.f_19804_.m_135381_(SKIN, (Object)skin);
    }

    public GoblinVariant.Face getFace() {
        return GoblinVariant.Face.byId((Integer)this.f_19804_.m_135370_(FACE));
    }

    public void setFace(int face) {
        this.f_19804_.m_135381_(FACE, (Object)face);
    }

    public GoblinVariant.Hair getHair() {
        return GoblinVariant.Hair.byId((Integer)this.f_19804_.m_135370_(HAIR));
    }

    public void setHair(int hair) {
        this.f_19804_.m_135381_(HAIR, (Object)hair);
    }

    public GoblinVariant.Clothing getClothing() {
        return GoblinVariant.Clothing.byId((Integer)this.f_19804_.m_135370_(CLOTHING));
    }

    public void setClothing(int clothing) {
        this.f_19804_.m_135381_(CLOTHING, (Object)clothing);
    }

    public GoblinVariant.Head getHead() {
        return GoblinVariant.Head.byId((Integer)this.f_19804_.m_135370_(HEAD));
    }

    public void setHead(int head) {
        this.f_19804_.m_135381_(HEAD, (Object)head);
    }

    public int getHeadColor() {
        return (Integer)this.f_19804_.m_135370_(HEAD_COLOR);
    }

    public void setHeadColor(int i) {
        this.f_19804_.m_135381_(HEAD_COLOR, (Object)i);
    }

    public GoblinVariant.Top getTop() {
        return GoblinVariant.Top.byId((Integer)this.f_19804_.m_135370_(TOP));
    }

    public void setTop(int top) {
        this.f_19804_.m_135381_(TOP, (Object)top);
    }

    public int getTopColor() {
        return (Integer)this.f_19804_.m_135370_(TOP_COLOR);
    }

    public void setTopColor(int i) {
        this.f_19804_.m_135381_(TOP_COLOR, (Object)i);
    }

    public GoblinVariant.Bottom getBottom() {
        return GoblinVariant.Bottom.byId((Integer)this.f_19804_.m_135370_(BOTTOM));
    }

    public void setBottom(int bottom) {
        this.f_19804_.m_135381_(BOTTOM, (Object)bottom);
    }

    public int getBottomColor() {
        return (Integer)this.f_19804_.m_135370_(BOTTOM_COLOR);
    }

    public void setBottomColor(int i) {
        this.f_19804_.m_135381_(BOTTOM_COLOR, (Object)i);
    }

    public boolean hasBandages() {
        return (Boolean)this.f_19804_.m_135370_(BANDAGES);
    }

    public void setBandages(boolean bandages) {
        this.f_19804_.m_135381_(BANDAGES, (Object)bandages);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (EVOLUTION_STATE.equals(pKey)) {
            this.m_20090_();
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    @Override
    public boolean m_7848_(Animal pOtherAnimal) {
        if (pOtherAnimal == this) {
            return false;
        }
        if (pOtherAnimal.getClass() != this.getClass()) {
            return false;
        }
        return this.m_27593_() && pOtherAnimal.m_27593_() && ((GoblinEntity)pOtherAnimal).getGender() != this.getGender();
    }

    @Override
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        GoblinEntity baby = (GoblinEntity)((EntityType)TensuraEntityTypes.GOBLIN.get()).m_20615_((Level)pLevel);
        if (baby == null) {
            return null;
        }
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            baby.m_21816_(uuid);
            baby.m_7105_(true);
        }
        baby.randomTexture();
        if (this.isHobgoblin() && ((GoblinEntity)pOtherParent).isHobgoblin()) {
            baby.evolve();
        }
        return baby;
    }

    public float m_6134_() {
        float multiplier = this.isHobgoblin() ? 1.3333334f : 1.0f;
        return multiplier * (this.m_6162_() ? 0.5f : 1.0f);
    }

    @Override
    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public boolean isHobgoblin() {
        return this.getCurrentEvolutionState() >= 1;
    }

    @Override
    public int getCurrentEvolutionState() {
        return (Integer)this.f_19804_.m_135370_(EVOLUTION_STATE);
    }

    @Override
    public void setCurrentEvolutionState(int state) {
        this.f_19804_.m_135381_(EVOLUTION_STATE, (Object)state);
    }

    @Override
    public void evolve() {
        int current = this.getCurrentEvolutionState();
        if (current < this.getMaxEvolutionState()) {
            this.setCurrentEvolutionState(current + 1);
            this.gainMovementSpeed((LivingEntity)this, 0.05);
            this.gainSwimSpeed((LivingEntity)this, 1.0);
            this.gainMaxHealth((LivingEntity)this, 10.0);
        }
    }

    @Override
    public InteractionResult handleEating(Player player, InteractionHand hand, ItemStack stack) {
        if (this.m_6898_(stack)) {
            if (this.m_21223_() < this.m_21233_()) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                this.m_8035_();
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.m_142075_(player, hand, stack);
                this.m_146740_(GoblinEntity.m_216967_((int)(-this.m_146764_())), true);
                this.m_9236_().m_6269_(player, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (!this.m_6162_() && this.m_5957_()) {
                this.m_142075_(player, hand, stack);
                this.m_27595_(player);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_8035_() {
        super.m_8035_();
        this.m_5634_(3.0f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (!pReason.equals((Object)MobSpawnType.BUCKET)) {
            this.m_213945_(this.f_19796_, pDifficulty);
            this.randomTexture();
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    private void randomTexture() {
        this.setGender(this.f_19796_.m_188499_() ? 0 : 1);
        this.setSkin(GoblinVariant.Skin.getRandom(this));
        this.setFace(GoblinVariant.Face.getRandom(this.getGender(), this));
        this.setHair(GoblinVariant.Hair.getRandom(this));
        this.setClothing(GoblinVariant.Clothing.getRandom(this));
        this.setBandages(this.f_19796_.m_188499_());
        List colors = (List)TensuraConfig.INSTANCE.entitiesConfig.goblinClothingColors.get();
        this.setHead(this.f_19796_.m_188499_() ? -1 : GoblinVariant.Head.getRandom(this));
        this.setHeadColor((Integer)colors.get(this.f_19796_.m_188503_(colors.size())));
        this.setTop(GoblinVariant.Top.getRandom(this));
        this.setTopColor((Integer)colors.get(this.f_19796_.m_188503_(colors.size())));
        this.setBottom(GoblinVariant.Bottom.getRandom(this));
        this.setBottomColor((Integer)colors.get(this.f_19796_.m_188503_(colors.size())));
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return SpawnRateConfig.rollSpawn((Integer)SpawnRateConfig.INSTANCE.goblinSpawnRate.get(), this.m_217043_(), pSpawnReason) && super.m_5545_(pLevel, pSpawnReason);
    }

    @Override
    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        super.m_213945_(pRandom, pDifficulty);
        if (pRandom.m_188501_() >= 0.5f) {
            return;
        }
        int i = pRandom.m_188503_(3);
        ItemStack stack = new ItemStack((ItemLike)TensuraToolItems.GOBLIN_CLUB.get());
        if (i == 0) {
            stack = new ItemStack((ItemLike)TensuraToolItems.STONE_SHORT_SWORD.get());
        }
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
        this.inventory.m_6836_(4, stack);
        this.inventory.m_6596_();
    }

    @Override
    @Nullable
    public Item getEquipmentForArmorSlot(EquipmentSlot pSlot, int pChance) {
        return switch (pSlot) {
            case EquipmentSlot.HEAD -> {
                if (pChance == 2) {
                    yield Items.f_42407_;
                }
                yield null;
            }
            case EquipmentSlot.CHEST -> {
                if (pChance == 2) {
                    yield Items.f_42408_;
                }
                if (pChance == 4) {
                    yield Items.f_42465_;
                }
                yield null;
            }
            case EquipmentSlot.LEGS -> {
                if (pChance == 2) {
                    yield Items.f_42462_;
                }
                if (pChance == 4) {
                    yield Items.f_42466_;
                }
                yield null;
            }
            case EquipmentSlot.FEET -> {
                if (pChance == 2) {
                    yield Items.f_42463_;
                }
                if (pChance == 4) {
                    yield Items.f_42467_;
                }
                yield null;
            }
            default -> null;
        };
    }
}

