/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.tensura.api.entity.ai.CaterpillarTryToCocoonGoal;
import com.github.manasmods.tensura.api.entity.subclass.SpittingRangedMonster;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.HellMothEntity;
import com.github.manasmods.tensura.entity.projectile.MonsterSpitProjectile;
import com.github.manasmods.tensura.entity.template.ClimbingEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.entity.variant.MothVariant;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import java.awt.Color;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class HellCaterpillarEntity
extends ClimbingEntity
implements IAnimatable,
SpittingRangedMonster {
    private static final EntityDataAccessor<Integer> COCOON_TYPE = SynchedEntityData.m_135353_(HellCaterpillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COCOON_TICKS = SynchedEntityData.m_135353_(HellCaterpillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> GRASS_EATEN = SynchedEntityData.m_135353_(HellCaterpillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DONE_COCOON = SynchedEntityData.m_135353_(HellCaterpillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> START_COCOON = SynchedEntityData.m_135353_(HellCaterpillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SILK_SHOOTING = SynchedEntityData.m_135353_(HellCaterpillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Direction> FACE_ATTACHED = SynchedEntityData.m_135353_(HellCaterpillarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    protected boolean didSpit;
    private int startCocoon;
    public float attachChangeProgress = 0.0f;
    public float prevAttachChangeProgress = 0.0f;
    public Direction prevAttachDir = Direction.DOWN;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public static final AnimationBuilder IDLE = new AnimationBuilder().addAnimation("animation.hell_caterpillar.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder WALKING = new AnimationBuilder().addAnimation("animation.hell_caterpillar.walking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder COCOONED = new AnimationBuilder().addAnimation("animation.hell_caterpillar.cocooned", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder PRE_COCOON = new AnimationBuilder().addAnimation("animation.hell_caterpillar.cocoon_pose", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder COCOONING = new AnimationBuilder().addAnimation("animation.hell_caterpillar.cocooning", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder SILK_SHOT = new AnimationBuilder().addAnimation("animation.hell_caterpillar.silk_shot", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);

    public HellCaterpillarEntity(EntityType<? extends HellCaterpillarEntity> type, Level level) {
        super((EntityType<? extends ClimbingEntity>)type, level);
        this.f_21364_ = 10;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22278_, 0.2).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CocoonStickOnLeavesGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new CaterpillarTryToCocoonGoal(this, 1.0, 16));
        this.f_21345_.m_25352_(3, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 40, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(4, (Goal)new SpitThenGoGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new CaterpillarEatGrassGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new CaterpillarFollowFoodGoal(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new CaterpillarWanderGoal(this, 40, 1.0, 10, 7));
        this.f_21345_.m_25352_(8, (Goal)new CaterpillarLookAroundGoal(this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FACE_ATTACHED, (Object)Direction.DOWN);
        this.f_19804_.m_135372_(START_COCOON, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(DONE_COCOON, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(COCOON_TYPE, (Object)0);
        this.f_19804_.m_135372_(GRASS_EATEN, (Object)0);
        this.f_19804_.m_135372_(COCOON_TICKS, (Object)0);
        this.f_19804_.m_135372_(SILK_SHOOTING, (Object)Boolean.FALSE);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("StartCocoon", this.hasStartedCocoon());
        compound.m_128379_("Cocooned", this.isCocooned());
        compound.m_128405_("CocoonType", this.getCocoonType());
        compound.m_128405_("GrassEaten", this.getGrassEaten());
        compound.m_128405_("CocoonTicks", this.getCocoonTicks());
        compound.m_128379_("SilkShooting", this.isShootingSilk());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setStartCocoon(compound.m_128471_("StartCocoon"));
        this.setCocooned(compound.m_128471_("Cocooned"));
        this.setCocoonType(compound.m_128451_("CocoonType"));
        this.setGrassEaten(compound.m_128451_("GrassEaten"));
        this.setCocoonTick(compound.m_128451_("CocoonTicks"));
        this.setShootingSilk(compound.m_128471_("SilkShooting"));
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> accessor) {
        super.m_7350_(accessor);
        if (FACE_ATTACHED.equals(accessor)) {
            this.prevAttachChangeProgress = 0.0f;
            this.attachChangeProgress = 0.0f;
        } else if (DONE_COCOON.equals(accessor)) {
            this.m_6210_();
        }
    }

    public int getCocoonTicks() {
        return (Integer)this.f_19804_.m_135370_(COCOON_TICKS);
    }

    public void setCocoonTick(int cocoonTick) {
        this.f_19804_.m_135381_(COCOON_TICKS, (Object)cocoonTick);
    }

    public int getGrassEaten() {
        return (Integer)this.f_19804_.m_135370_(GRASS_EATEN);
    }

    public void setGrassEaten(int grassEaten) {
        this.f_19804_.m_135381_(GRASS_EATEN, (Object)grassEaten);
    }

    public int getCocoonType() {
        return (Integer)this.f_19804_.m_135370_(COCOON_TYPE);
    }

    public void setCocoonType(int cocoonType) {
        this.f_19804_.m_135381_(COCOON_TYPE, (Object)cocoonType);
    }

    public boolean hasStartedCocoon() {
        return (Boolean)this.f_19804_.m_135370_(START_COCOON);
    }

    public void setStartCocoon(boolean started) {
        this.f_19804_.m_135381_(START_COCOON, (Object)started);
    }

    public boolean isCocooned() {
        return (Boolean)this.f_19804_.m_135370_(DONE_COCOON);
    }

    public void setCocooned(boolean cocooned) {
        this.f_19804_.m_135381_(DONE_COCOON, (Object)cocooned);
    }

    public boolean isShootingSilk() {
        return (Boolean)this.f_19804_.m_135370_(SILK_SHOOTING);
    }

    public void setShootingSilk(boolean shootingSilk) {
        this.f_19804_.m_135381_(SILK_SHOOTING, (Object)shootingSilk);
    }

    public void makeCocoon() {
        this.setCocooned(Boolean.TRUE);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22100_(10.0);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22100_(1.0);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.0);
        if (new Random().nextInt(20) == 10) {
            this.setCocoonType(1);
        }
    }

    protected ResourceLocation m_7582_() {
        if (this.isCocooned()) {
            if (this.getCocoonType() == 1) {
                return new ResourceLocation(Registry.f_122826_.m_7981_((Object)this.m_6095_()).m_135827_(), "entities/gehenna_cocoon");
            }
            return new ResourceLocation(Registry.f_122826_.m_7981_((Object)this.m_6095_()).m_135827_(), "entities/hell_cocoon");
        }
        return super.m_7582_();
    }

    @Override
    public EntityDimensions m_6972_(Pose pPose) {
        EntityDimensions entitydimensions = super.m_6972_(pPose);
        return this.isCocooned() ? EntityDimensions.m_20398_((float)entitydimensions.f_20377_, (float)2.0f) : entitydimensions;
    }

    public boolean m_5957_() {
        return false;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        HellCaterpillarEntity hellCaterpillar = (HellCaterpillarEntity)((EntityType)TensuraEntityTypes.HELL_CATERPILLAR.get()).m_20615_((Level)pLevel);
        if (hellCaterpillar == null) {
            return null;
        }
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            hellCaterpillar.m_21816_(uuid);
            hellCaterpillar.m_7105_(true);
        }
        return hellCaterpillar;
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.m_6898_(itemstack)) {
            if (!pPlayer.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (this.m_21223_() < this.m_21233_()) {
                this.m_5634_(1.0f);
            } else {
                this.m_8035_();
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.SMALL_CHEW.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_8035_() {
        super.m_8035_();
        this.setGrassEaten(this.getGrassEaten() + 1);
        this.m_5634_(5.0f);
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_204117_(TensuraTags.Items.CATERPILLAR_FOOD);
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    @Override
    protected float getClimbSpeedMultiplier() {
        return 0.5f;
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19310_ || super.m_6673_(source);
    }

    public Direction getAttachmentFacing() {
        return (Direction)this.f_19804_.m_135370_(FACE_ATTACHED);
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        return false;
    }

    public void m_7601_(BlockState pState, Vec3 pMotionMultiplier) {
        if (pState.m_204336_(TensuraTags.Blocks.WEB_BLOCKS)) {
            return;
        }
        super.m_7601_(pState, pMotionMultiplier);
    }

    protected float m_6041_() {
        BlockState blockstate = this.f_19853_.m_8055_(this.m_20183_());
        return blockstate.m_204336_(TensuraTags.Blocks.WEB_BLOCKS) ? 1.0f : super.m_6041_();
    }

    protected float m_20098_() {
        BlockState blockstate = this.f_19853_.m_8055_(this.m_20183_());
        return blockstate.m_204336_(TensuraTags.Blocks.WEB_BLOCKS) ? 1.0f : super.m_20098_();
    }

    public static boolean checkCaterpillarSpawnRules(EntityType<HellCaterpillarEntity> pCaterpillar, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_184232_) && HellCaterpillarEntity.m_217057_(pCaterpillar, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return SpawnRateConfig.rollSpawn((Integer)SpawnRateConfig.INSTANCE.hellCaterpillarSpawnRate.get(), this.m_217043_(), pSpawnReason) && super.m_5545_(pLevel, pSpawnReason);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity2;
        boolean hurt = super.m_6469_(source, amount);
        if (hurt && (entity2 = source.m_7639_()) instanceof LivingEntity) {
            Player player;
            LivingEntity damageSource = (LivingEntity)entity2;
            if (!damageSource.m_6084_()) {
                return true;
            }
            if (damageSource instanceof Player && ((player = (Player)damageSource).m_7500_() || player.m_5833_())) {
                return true;
            }
            List list = this.f_19853_.m_6443_(HellMothEntity.class, this.m_20191_().m_82400_((double)((Integer)SpawnRateConfig.INSTANCE.hellMothAwarenessRange.get()).intValue()), entity -> !entity.m_21824_());
            if (!list.isEmpty()) {
                list.forEach(hellMoth -> hellMoth.m_6710_(damageSource));
            }
        }
        return hurt;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TensuraSoundEvents.CATERPILLAR_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TensuraSoundEvents.MOTH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TensuraSoundEvents.MOTH_DEATH.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isCocooned() && this.m_6084_()) {
            this.setCocoonTick(this.getCocoonTicks() + 1);
            if (this.getCocoonTicks() >= 2400) {
                Level level = this.m_9236_();
                CompoundTag tag = this.serializeNBT();
                this.m_146870_();
                HellMothEntity moth = new HellMothEntity((EntityType<? extends HellMothEntity>)((EntityType)TensuraEntityTypes.HELL_MOTH.get()), level);
                moth.m_20258_(tag);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    moth.m_6518_((ServerLevelAccessor)serverLevel, level.m_6436_(moth.m_20183_()), MobSpawnType.CONVERSION, null, null);
                }
                if (this.getCocoonType() == 1) {
                    moth.setVariant(MothVariant.GEHENNA);
                }
                RaceHelper.applyBaseAttribute(HellMothEntity.setAttributes(), (LivingEntity)moth);
                moth.m_21153_(moth.m_21233_());
                RaceHelper.updateSpiritualHP((LivingEntity)moth);
                RaceHelper.updateEntityEPCount((LivingEntity)moth);
                moth.m_146762_(-24000);
                int randomSize = new Random().nextInt(10);
                moth.setBabySize(randomSize >= 8 ? 2 : 1);
                moth.setFlying(true);
                level.m_46796_(2009, moth.m_20183_(), new Color(255, 255, 255).getRGB());
                level.m_5594_(null, moth.m_20183_(), SoundEvents.f_12639_, SoundSource.PLAYERS, 1.0f, 1.0f);
                level.m_7967_((Entity)moth);
                return;
            }
        }
        if (this.hasStartedCocoon()) {
            ++this.startCocoon;
            if (this.startCocoon >= 30) {
                this.setStartCocoon(Boolean.FALSE);
                this.startCocoon = 0;
            }
        }
        if (this.isShootingSilk()) {
            ++this.startCocoon;
            if (this.startCocoon >= 5) {
                this.setShootingSilk(Boolean.FALSE);
                this.startCocoon = 0;
            }
        }
        this.f_20883_ = Mth.m_14148_((float)this.f_20884_, (float)this.f_20883_, (float)this.m_8085_());
        this.prevAttachChangeProgress = this.attachChangeProgress;
        if (this.prevAttachDir != this.getAttachmentFacing()) {
            if (this.attachChangeProgress < 5.0f) {
                this.attachChangeProgress += 1.0f;
            } else if (this.attachChangeProgress >= 5.0f) {
                this.prevAttachDir = this.getAttachmentFacing();
            }
        } else {
            this.attachChangeProgress = 5.0f;
        }
        Vec3 vector3d = this.m_20184_();
        if (!this.f_19853_.f_46443_) {
            this.setBesideClimbableBlock(HellCaterpillarEntity.collidingWall((Entity)this) || this.f_19863_ && !this.m_20096_());
            if (this.m_20096_() || this.m_20072_() || this.m_20077_()) {
                this.f_19804_.m_135381_(FACE_ATTACHED, (Object)Direction.DOWN);
            } else if (this.f_19863_) {
                this.f_19804_.m_135381_(FACE_ATTACHED, (Object)Direction.UP);
            } else {
                Direction closestDirection = Direction.DOWN;
                double closestDistance = 100.0;
                for (Direction dir : DIRECTIONS) {
                    BlockPos antPos = new BlockPos(Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20186_()), Mth.m_14107_((double)this.m_20189_()));
                    BlockPos offsetPos = antPos.m_121945_(dir);
                    Vec3 offset = Vec3.m_82512_((Vec3i)offsetPos);
                    if (!(closestDistance > this.m_20182_().m_82554_(offset)) || !this.f_19853_.m_46578_(offsetPos, (Entity)this, dir.m_122424_())) continue;
                    closestDistance = this.m_20182_().m_82554_(offset);
                    closestDirection = dir;
                }
                this.f_19804_.m_135381_(FACE_ATTACHED, (Object)closestDirection);
            }
        }
        if (this.getAttachmentFacing() == Direction.UP) {
            this.m_20242_(true);
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.1, 0.0));
        } else {
            this.m_20242_(false);
            if (this.getAttachmentFacing() != Direction.DOWN && vector3d.f_82480_ < 0.0) {
                if (!this.f_19862_) {
                    Vec3 vec = Vec3.m_82528_((Vec3i)this.getAttachmentFacing().m_122436_());
                    this.m_20256_(this.m_20184_().m_82549_(vec.m_82541_().m_82542_((double)0.1f, (double)0.1f, (double)0.1f)));
                }
                if (!this.f_19861_) {
                    this.m_20256_(this.m_20184_().m_82542_(1.0, 0.5, 1.0));
                    if (this.m_6147_()) {
                        this.m_20256_(vector3d.m_82542_(1.0, 0.5, 1.0));
                    }
                }
            }
        }
    }

    @Override
    public void spitParticle(MonsterSpitProjectile projectile) {
        this.particleSpawning(projectile, (ParticleOptions)ParticleTypes.f_123764_, 5);
    }

    @Override
    public void m_6504_(@NotNull LivingEntity target, float pDistanceFactor) {
        this.setShootingSilk(Boolean.TRUE);
        MonsterSpitProjectile spit = new MonsterSpitProjectile(this.f_19853_, (LivingEntity)this);
        spit.m_7678_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), this.m_146908_(), this.m_146909_());
        double d0 = target.m_20186_();
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = d0 - spit.m_20186_();
        double d3 = target.m_20189_() - this.m_20189_();
        double f = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        spit.m_6686_(d1, d2 + f, d3, 1.2f, 0.0f);
        this.f_19853_.m_7967_((Entity)spit);
    }

    @Override
    public void spitHit(LivingEntity pTarget) {
        if (pTarget instanceof HellMothEntity) {
            return;
        }
        if (pTarget instanceof HellCaterpillarEntity) {
            return;
        }
        this.setDidSpit(true);
        if (pTarget.m_6469_(DamageSource.m_19370_((LivingEntity)this), 5.0f)) {
            if (pTarget.m_20206_() <= 3.0f || pTarget.m_20205_() <= 3.0f) {
                pTarget.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.WEBBED.get(), 300, 0, false, false, true), (Entity)this);
                pTarget.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.SILENCE.get(), 300, 0, false, false, true), (Entity)this);
            } else {
                pTarget.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 300, 0, false, false, true), (Entity)this);
            }
        }
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.hasStartedCocoon()) {
            event.getController().setAnimation(PRE_COCOON);
        } else if (this.isCocooned()) {
            event.getController().setAnimation(COCOONED);
        } else if (event.isMoving() || !this.getAttachmentFacing().equals((Object)Direction.DOWN) && !this.getAttachmentFacing().equals((Object)Direction.UP)) {
            event.getController().setAnimation(WALKING);
        } else {
            event.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    private <T extends IAnimatable> PlayState cocoonPredicate(AnimationEvent<T> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped) && this.hasStartedCocoon()) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(COCOONING);
        }
        return PlayState.CONTINUE;
    }

    private <T extends IAnimatable> PlayState silkShootingPredicate(AnimationEvent<T> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped) && this.isShootingSilk()) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(SILK_SHOT);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "cocoonController", 0.0f, this::cocoonPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "silkShootingController", 0.0f, this::silkShootingPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void setDidSpit(boolean didSpit) {
        this.didSpit = didSpit;
    }

    static class CocoonStickOnLeavesGoal
    extends Goal {
        private final HellCaterpillarEntity caterpillar;

        public CocoonStickOnLeavesGoal(HellCaterpillarEntity caterpillarEntity) {
            this.caterpillar = caterpillarEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.caterpillar.isCocooned() && this.getLeavesBlock(this.caterpillar.m_20183_(), (BlockGetter)this.caterpillar.f_19853_);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            this.caterpillar.f_19804_.m_135381_(FACE_ATTACHED, (Object)Direction.UP);
            this.caterpillar.m_20256_(this.caterpillar.m_20184_().m_82520_(0.0, (double)0.1f, 0.0));
        }

        private boolean getLeavesBlock(BlockPos pPos, BlockGetter pLevel) {
            BlockPos[] pos = new BlockPos[]{pPos.m_7494_(), pPos.m_7494_().m_7494_(), pPos.m_7494_().m_7494_().m_7494_()};
            boolean flag = false;
            for (BlockPos blockpos : pos) {
                if (!pLevel.m_8055_(blockpos).m_204336_(BlockTags.f_13035_) && !pLevel.m_8055_(blockpos).m_204336_(BlockTags.f_13106_)) continue;
                flag = true;
            }
            return flag;
        }
    }

    static class SpitThenGoGoal
    extends HurtByTargetGoal {
        protected final HellCaterpillarEntity hellCaterpillar;

        public SpitThenGoGoal(HellCaterpillarEntity caterpillar) {
            super((PathfinderMob)caterpillar, new Class[0]);
            this.hellCaterpillar = caterpillar;
        }

        public boolean m_8036_() {
            if (this.hellCaterpillar.hasStartedCocoon()) {
                return false;
            }
            if (this.hellCaterpillar.isCocooned()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.hellCaterpillar.didSpit) {
                this.hellCaterpillar.setDidSpit(false);
                return false;
            }
            return super.m_8045_();
        }
    }

    static class CaterpillarEatGrassGoal
    extends EatBlockGoal {
        protected final HellCaterpillarEntity hellCaterpillar;

        public CaterpillarEatGrassGoal(HellCaterpillarEntity caterpillar) {
            super((Mob)caterpillar);
            this.hellCaterpillar = caterpillar;
        }

        public boolean m_8036_() {
            if (this.hellCaterpillar.m_217043_().m_188503_(200) != 0) {
                return false;
            }
            BlockPos blockpos = this.hellCaterpillar.m_20183_();
            if (BlockStatePredicate.m_61287_((Block)Blocks.f_50034_).test(this.hellCaterpillar.f_19853_.m_8055_(blockpos))) {
                return true;
            }
            return this.hellCaterpillar.f_19853_.m_8055_(blockpos.m_7495_()).m_60713_(Blocks.f_50440_);
        }
    }

    static class CaterpillarFollowFoodGoal
    extends TemptGoal {
        HellCaterpillarEntity caterpillar;

        public CaterpillarFollowFoodGoal(HellCaterpillarEntity pMob, double pSpeedModifier) {
            super((PathfinderMob)pMob, pSpeedModifier, Ingredient.m_204132_(TensuraTags.Items.CATERPILLAR_FOOD), false);
            this.caterpillar = pMob;
        }

        public boolean m_8036_() {
            if (this.caterpillar.m_5448_() != null) {
                return false;
            }
            if (this.caterpillar.m_21827_()) {
                return false;
            }
            if (this.caterpillar.isCocooned()) {
                return false;
            }
            if (this.caterpillar.hasStartedCocoon()) {
                return false;
            }
            if (this.caterpillar.m_21826_() != null && this.f_25925_ != null && !this.caterpillar.m_21826_().equals((Object)this.f_25925_)) {
                return false;
            }
            return super.m_8036_();
        }
    }

    static class CaterpillarWanderGoal
    extends TensuraTamableEntity.WanderAroundPosGoal {
        protected HellCaterpillarEntity hellCaterpillar;

        public CaterpillarWanderGoal(HellCaterpillarEntity mob, int interval, double speed, int xzRange, int yRange) {
            super(mob, interval, speed, xzRange, yRange);
            this.hellCaterpillar = mob;
        }

        @Override
        public boolean m_8036_() {
            if (this.hellCaterpillar.isCocooned() || this.hellCaterpillar.hasStartedCocoon()) {
                return false;
            }
            if (this.hellCaterpillar.getGrassEaten() >= 50) {
                return false;
            }
            return super.m_8036_();
        }
    }

    static class CaterpillarLookAroundGoal
    extends RandomLookAroundGoal {
        private final HellCaterpillarEntity caterpillar;

        public CaterpillarLookAroundGoal(HellCaterpillarEntity pMob) {
            super((Mob)pMob);
            this.caterpillar = pMob;
        }

        public boolean m_8036_() {
            if (this.caterpillar.isCocooned() || this.caterpillar.hasStartedCocoon()) {
                return false;
            }
            if (this.caterpillar.getGrassEaten() >= 50) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.caterpillar.isCocooned() || this.caterpillar.hasStartedCocoon()) {
                return false;
            }
            return super.m_8045_();
        }
    }
}

