/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.api.entity.ai.FlyingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.ai.TamableFollowParentGoal;
import com.github.manasmods.tensura.api.entity.ai.UndergroundTargetingEntitiesGoal;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.IfritCloneEntity;
import com.github.manasmods.tensura.entity.SalamanderEntity;
import com.github.manasmods.tensura.entity.human.HinataSakaguchiEntity;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierEntity;
import com.github.manasmods.tensura.entity.magic.barrier.FlareCircleEntity;
import com.github.manasmods.tensura.entity.magic.field.Hellfire;
import com.github.manasmods.tensura.entity.magic.projectile.FireBoltProjectile;
import com.github.manasmods.tensura.entity.magic.skill.FlameOrbProjectile;
import com.github.manasmods.tensura.entity.template.GreaterSpiritEntity;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.PacketDistributor;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class IfritEntity
extends GreaterSpiritEntity {
    protected static final EntityDataAccessor<BlockPos> FLARE_POS = SynchedEntityData.m_135353_(IfritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public IfritEntity(EntityType<? extends IfritEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends GreaterSpiritEntity>)pEntityType, pLevel);
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_20).m_7005_(true);
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22281_, 40.0).m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 3.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.NPCMeleeAttackGoal((PathfinderMob)this, 2.0, true){

            @Override
            public boolean m_8036_() {
                if (!super.m_8036_()) {
                    return false;
                }
                return IfritEntity.this.usingMeleeWeapon();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new IfritAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new GreaterSpiritEntity.FollowHinataGoal(this, 1.0, HinataSakaguchiEntity.class));
        this.f_21345_.m_25352_(5, (Goal)new FlyingFollowOwnerGoal(this, 0.7, 10.0f, 4.0f, true, false));
        this.f_21345_.m_25352_(6, (Goal)new TamableFollowParentGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(7, (Goal)new GreaterSpiritEntity.WalkGoal(this, this));
        this.f_21345_.m_25352_(8, (Goal)new TensuraTamableEntity.FlyingWanderAroundPosGoal(this, this, 1.0, 12));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, IfritEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, new UndergroundTargetingEntitiesGoal<LivingEntity>(this, LivingEntity.class, false, 8.0f, this::shouldAttack));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLARE_POS, (Object)BlockPos.f_121853_);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128347_("FlareX", (double)this.getFlarePos().m_123341_());
        compound.m_128347_("FlareY", (double)this.getFlarePos().m_123342_());
        compound.m_128347_("FlareZ", (double)this.getFlarePos().m_123343_());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFlarePos(compound.m_128459_("FlareX"), compound.m_128459_("FlareY"), compound.m_128459_("FlareZ"));
    }

    public BlockPos getFlarePos() {
        return (BlockPos)this.f_19804_.m_135370_(FLARE_POS);
    }

    public void setFlarePos(double x, double y, double z) {
        this.f_19804_.m_135381_(FLARE_POS, (Object)new BlockPos(x, y, z));
    }

    public boolean m_6060_() {
        return TensuraEffectsCapability.hasSyncedEffect((LivingEntity)this, (MobEffect)TensuraMobEffects.BLACK_BURN.get());
    }

    public static boolean shouldEvaporateProjectile(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.m_6095_().m_204039_(TensuraTags.EntityTypes.CAN_EVAPORATE);
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity2;
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (pSource.m_7639_() instanceof SalamanderEntity || pSource.m_7639_() instanceof IfritCloneEntity) {
            return false;
        }
        pAmount = DamageSourceHelper.isHeat(pSource) ? (pAmount *= 0.05f) : (DamageSourceHelper.isNaturalEffects(pSource) ? (pAmount *= 0.2f) : (pAmount *= this.getPhysicalAttackInput(pSource)));
        if (IfritEntity.shouldEvaporateProjectile(pSource.m_7640_())) {
            this.m_5496_(SoundEvents.f_12031_, 10.0f, 0.8f);
            pSource.m_7640_().m_142687_(Entity.RemovalReason.KILLED);
            return false;
        }
        boolean hurt = super.m_6469_(pSource, pAmount);
        if (hurt && (entity2 = pSource.m_7639_()) instanceof LivingEntity) {
            Player player;
            LivingEntity damageSource = (LivingEntity)entity2;
            if (!damageSource.m_6084_()) {
                return true;
            }
            if (damageSource instanceof Player && ((player = (Player)damageSource).m_7500_() || player.m_5833_())) {
                return true;
            }
            List list = this.f_19853_.m_6443_(SalamanderEntity.class, this.m_20191_().m_82400_(32.0), entity -> !entity.m_21824_());
            if (!list.isEmpty()) {
                list.forEach(salamander -> salamander.m_6710_(damageSource));
            }
        }
        return hurt;
    }

    @Override
    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof SalamanderEntity) {
            SalamanderEntity salamander = (SalamanderEntity)entity;
            return salamander.m_21824_() == this.m_21824_();
        }
        if (entity instanceof IfritEntity) {
            IfritEntity ifrit = (IfritEntity)entity;
            return ifrit.m_21824_() == this.m_21824_();
        }
        return false;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.m_20072_() && this.f_19797_ % 10 == 0 && this.removeFluid((LivingEntity)this, FluidTags.f_13131_, 3.0f, true, 0)) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12031_, SoundSource.NEUTRAL, 10.0f, 1.0f);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.m_5776_() && this.m_6084_()) {
            if (this.f_19797_ % 10 == 0) {
                TensuraParticleHelper.addParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.RED_FIRE.get(), 2.0);
            }
            Vec3 vec3 = this.m_20252_(1.0f).m_82541_();
            float radius = -0.15f;
            double yPos = this.m_20188_() + (double)0.2f;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            double extraX = Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = Mth.m_14089_((float)angle);
            if (this.m_5803_()) {
                yPos -= (double)0.2f;
                radius = -0.5f;
            } else if (this.getMiscAnimation() == -1) {
                yPos -= (double)1.6f;
                radius = 0.6f;
            } else if (this.getMiscAnimation() == 7) {
                radius = -0.3f;
                yPos -= (double)0.1f;
            } else if (this.m_20184_().m_82556_() > 0.03 && this.getMiscAnimation() < 5 && this.getMiscAnimation() != 3) {
                if (!this.m_20096_()) {
                    yPos -= (double)0.2f;
                    radius = 0.3f;
                } else if (this.m_21660_()) {
                    radius = 0.0f;
                }
            }
            for (int i = 0; i < 15; ++i) {
                double ox = Math.random() * 0.3 - 0.15;
                double oy = Math.random() * 0.3 - 0.15;
                double oz = Math.random() * 0.3 - 0.15;
                Vec3 randomVec = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).m_82541_();
                Vec3 result = vec3.m_82490_(-1.0).m_82549_(randomVec).m_82541_().m_82490_(0.1);
                this.m_9236_().m_7106_((ParticleOptions)TensuraParticles.HEAT_EFFECT.get(), this.m_20185_() - vec3.f_82479_ * 0.1 + ox + extraX * (double)radius, yPos + oy, this.m_20189_() - vec3.f_82481_ * 0.1 + oz + extraZ * (double)radius, result.f_82479_, result.f_82480_, result.f_82481_);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() - vec3.f_82479_ * 0.1 + ox + extraX * (double)radius, yPos + oy, this.m_20189_() - vec3.f_82481_ * 0.1 + oz + extraZ * (double)radius, result.f_82479_, result.f_82480_, result.f_82481_);
            }
        }
    }

    @Override
    protected void miscAnimationHandler() {
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (!this.m_9236_().m_5776_()) {
                if ((this.getMiscAnimation() == 1 || this.getMiscAnimation() == 2) && this.miscAnimationTicks == 10) {
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    IfritEntity.shootFireBolt((LivingEntity)this);
                    this.m_5496_(SoundEvents.f_11705_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                } else if (this.getMiscAnimation() == 3) {
                    this.m_21573_().m_26573_();
                    if (this.miscAnimationTicks >= 10 && this.miscAnimationTicks <= 25) {
                        this.flameOrb();
                    } else {
                        this.setMagicID(0);
                    }
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    this.m_5496_(SoundEvents.f_11705_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                } else if (this.getMiscAnimation() == 4 && this.miscAnimationTicks == 25) {
                    IfritEntity.hellFire((Mob)this);
                    this.m_5496_(SoundEvents.f_11862_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                } else if (this.getMiscAnimation() == 5) {
                    this.m_21573_().m_26573_();
                    if (this.miscAnimationTicks == 1) {
                        Vec3 pos;
                        LivingEntity target = this.m_5448_();
                        if (target != null) {
                            pos = target.m_20182_();
                        } else {
                            BlockHitResult result = SkillHelper.getPlayerPOVHitResult(this.f_19853_, (Entity)this, ClipContext.Fluid.NONE, 20.0);
                            pos = result.m_82450_();
                        }
                        this.setFlarePos(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
                        this.setMagicID(0);
                    } else {
                        this.flareCircle(this.miscAnimationTicks);
                    }
                } else if (this.getMiscAnimation() == 6) {
                    this.m_21573_().m_26573_();
                    if (this.miscAnimationTicks == 15) {
                        IfritEntity.combust((LivingEntity)this, this::shouldAttack);
                        this.m_5496_(SoundEvents.f_11913_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                    }
                } else if (this.getMiscAnimation() == 7) {
                    this.m_21573_().m_26573_();
                    switch (this.miscAnimationTicks) {
                        case 10: {
                            this.summonSalamanders(3, 7);
                            break;
                        }
                        case 20: {
                            this.summonSalamanders(5, 10);
                            break;
                        }
                        case 30: {
                            this.summonSalamanders(7, 15);
                        }
                    }
                    this.m_5496_(SoundEvents.f_11705_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                } else if (this.getMiscAnimation() == 8) {
                    this.m_21573_().m_26573_();
                    switch (this.miscAnimationTicks) {
                        case 10: {
                            this.summonClones(3, 7);
                            break;
                        }
                        case 20: {
                            this.summonClones(5, 10);
                            break;
                        }
                        case 30: {
                            this.summonClones(7, 15);
                        }
                    }
                    this.m_5496_(SoundEvents.f_11705_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                }
            }
            if (this.miscAnimationTicks > this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            case -1 -> 200;
            case 3, 7, 8 -> 40;
            case 4, 6 -> 30;
            case 5 -> 65;
            default -> 15;
        };
    }

    public static void shootFireBolt(LivingEntity ifrit) {
        FireBoltProjectile bolt = new FireBoltProjectile(ifrit.f_19853_, ifrit);
        bolt.setSkill(SkillUtils.getSkillOrNull((Entity)ifrit, (ManasSkill)SpiritualMagics.FIRE_BOLT.get()));
        float angle = (float)Math.PI / 180 * ifrit.f_20883_;
        double xOffset = Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double zOffset = Mth.m_14089_((float)angle);
        bolt.m_7678_(ifrit.m_20185_() + xOffset, ifrit.m_20188_() - 0.2, ifrit.m_20189_() + zOffset, ifrit.m_146908_(), ifrit.m_146909_());
        bolt.setSize(1.5f);
        bolt.setDamage((float)ifrit.m_21133_(Attributes.f_22281_));
        bolt.setExplosionRadius(1.0f);
        bolt.setBurnTicks(100);
        bolt.setSpiritAttack(true);
        bolt.setSpeed(1.5f);
        bolt.m_20242_(true);
        bolt.shootFromRot(ifrit.m_20154_());
        ifrit.f_19853_.m_7967_((Entity)bolt);
    }

    private void flameOrb() {
        int orbID = this.getMagicID();
        if (orbID == 0) {
            FlameOrbProjectile orb = new FlameOrbProjectile(this.f_19853_, (LivingEntity)this);
            orb.setDamage((float)(this.m_21133_(Attributes.f_22281_) * 3.0));
            orb.setBurnTicks(100);
            orb.setSpiritAttack(true);
            orb.setMpCost(500.0);
            orb.setSkill(SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)ExtraSkills.FLAME_MANIPULATION.get()).orElse(null));
            orb.setExplosionRadius(4.0f);
            orb.m_146884_(this.m_146892_().m_82520_(0.0, 4.0, 0.0));
            orb.setOwnerOffset(new Vec3(0.0, 4.0, 0.0));
            orb.setLookDistance(30.0f);
            orb.setDelayTick(15);
            orb.m_20242_(true);
            this.m_9236_().m_7967_((Entity)orb);
            this.setMagicID(orb.m_19879_());
        } else {
            Entity entity = this.m_9236_().m_6815_(orbID);
            if (!(entity instanceof FlameOrbProjectile)) {
                this.setMagicID(0);
                this.flameOrb();
            } else {
                FlameOrbProjectile orb = (FlameOrbProjectile)entity;
                if (orb.getDelayTick() > 0) {
                    orb.setSize(orb.getSize() + 0.1f);
                }
            }
        }
        this.m_5496_(SoundEvents.f_11705_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
    }

    public static void hellFire(Mob ifrit) {
        Vec3 pos;
        LivingEntity target = ifrit.m_5448_();
        if (target != null) {
            pos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
        } else {
            BlockHitResult result = SkillHelper.getPlayerPOVHitResult(ifrit.m_9236_(), (Entity)ifrit, ClipContext.Fluid.NONE, 15.0);
            pos = result.m_82450_().m_82520_(0.0, 0.5, 0.0);
        }
        Hellfire sphere = new Hellfire(ifrit.m_9236_(), (Entity)ifrit);
        sphere.setDamage((float)(ifrit.m_21133_(Attributes.f_22281_) * 8.0));
        sphere.setMpCost(10000.0);
        sphere.setSkill(SkillAPI.getSkillsFrom((Entity)ifrit).getSkill((ManasSkill)SpiritualMagics.HELLFIRE.get()).orElse(null));
        sphere.setLife(60);
        sphere.setRadius(2.5f);
        sphere.m_6034_(pos.f_82479_, pos.f_82480_ - (double)sphere.getRadius(), pos.f_82481_);
        ifrit.m_9236_().m_7967_((Entity)sphere);
        ifrit.m_5496_(SoundEvents.f_11913_, 10.0f, 0.95f + ifrit.m_217043_().m_188501_() * 0.1f);
        ((ServerLevel)ifrit.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.RED_FIRE.get()), ifrit.m_20185_(), ifrit.m_20186_() + (double)ifrit.m_20206_() / 2.0, ifrit.m_20189_(), 10, 0.08, 0.08, 0.08, 0.15);
        TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sphere), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:fire_sphere_5x5"), sphere.m_19879_(), 0.0, sphere.getRadius(), 0.0, false));
    }

    private void flareCircle(int heldTicks) {
        BlockPos pos = this.getFlarePos();
        if (heldTicks >= 20) {
            int flareID = this.getMagicID();
            if (flareID == 0) {
                FlareCircleEntity barrier = new FlareCircleEntity((EntityType<? extends FlareCircleEntity>)((EntityType)TensuraEntityTypes.FLARE_CIRCLE.get()), this.f_19853_);
                barrier.m_5602_((Entity)this);
                barrier.setDamage((float)(this.m_21133_(Attributes.f_22281_) * 2.0));
                barrier.setRadius(5.0f);
                barrier.setHeight(7.0f);
                barrier.setLife(30);
                barrier.setHealth(200.0f);
                barrier.m_146884_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
                barrier.setMpCost(2000.0);
                barrier.setSkill(SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)SpiritualMagics.FLARE_CIRCLE.get()).orElse(null));
                this.m_9236_().m_7967_((Entity)barrier);
                this.setMagicID(barrier.m_19879_());
            } else {
                Entity entity = this.m_9236_().m_6815_(flareID);
                if (!(entity instanceof BarrierEntity)) {
                    this.setMagicID(0);
                } else {
                    BarrierEntity barrier = (BarrierEntity)entity;
                    barrier.increaseLife(2);
                }
            }
            this.m_5496_(SoundEvents.f_11705_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
        } else {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:flare_circle_circle"), pos, 0.0, 0.0, 0.0, 0, true));
        }
    }

    public static void combust(LivingEntity ifrit, Predicate<LivingEntity> predicate) {
        TensuraParticleHelper.spawnServerParticles(ifrit.f_19853_, (ParticleOptions)TensuraParticles.RED_FIRE.get(), ifrit.m_20185_(), ifrit.m_20188_(), ifrit.m_20189_(), 55, 0.08, 0.08, 0.08, 0.2, true);
        TensuraParticleHelper.spawnServerParticles(ifrit.f_19853_, (ParticleOptions)TensuraParticles.HEAT_EFFECT.get(), ifrit.m_20185_(), ifrit.m_20188_(), ifrit.m_20189_(), 55, 0.08, 0.08, 0.08, 0.2, true);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)ifrit, (ParticleOptions)ParticleTypes.f_123756_, 2.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)ifrit, (ParticleOptions)ParticleTypes.f_123756_, 3.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)ifrit, (ParticleOptions)ParticleTypes.f_123756_, 4.0);
        AABB aabb = ifrit.m_20191_().m_82400_(ifrit.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()) + 10.0);
        List list = ifrit.f_19853_.m_6443_(LivingEntity.class, aabb, predicate);
        if (list.isEmpty()) {
            return;
        }
        for (LivingEntity target : list) {
            target.m_6469_(TensuraDamageSources.heatWave((Entity)ifrit), (float)ifrit.m_21133_(Attributes.f_22281_) * 3.0f);
            target.m_7311_(Math.max(200, target.m_20094_()));
            target.m_20334_(0.0, 0.1, 0.0);
            SkillHelper.knockBack(ifrit, target, 2.0f);
        }
    }

    private void summonSalamanders(int minRadius, int maxRadius) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        SalamanderEntity salamander = new SalamanderEntity((EntityType<? extends SalamanderEntity>)((EntityType)TensuraEntityTypes.SALAMANDER.get()), (Level)level2);
        for (int l = 0; l < 50; ++l) {
            int i1 = i + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            int j1 = j + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            int k1 = k + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            BlockPos blockpos = new BlockPos(i1, j1, k1);
            EntityType entitytype = (EntityType)TensuraEntityTypes.SALAMANDER.get();
            SpawnPlacements.Type type = SpawnPlacements.m_21752_((EntityType)entitytype);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)type, (LevelReader)level2, (BlockPos)blockpos, (EntityType)entitytype)) continue;
            salamander.m_6034_(i1, j1, k1);
            if (!level2.m_45784_((Entity)salamander) || !level2.m_45786_((Entity)salamander) || level2.m_46855_(salamander.m_20191_())) continue;
            salamander.m_6518_((ServerLevelAccessor)level2, level2.m_6436_(salamander.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            salamander.m_6710_(this.m_5448_());
            level2.m_47205_((Entity)salamander);
            salamander.setSummonerUUID(this.getSummonerUUID());
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)salamander, (ParticleOptions)TensuraParticles.RED_FIRE.get(), 2.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)salamander, (ParticleOptions)ParticleTypes.f_123756_, 2.0);
            break;
        }
    }

    private void summonClones(int minRadius, int maxRadius) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        double EP = TensuraEPCapability.getEP((LivingEntity)this);
        IfritCloneEntity clone = new IfritCloneEntity((EntityType<? extends IfritCloneEntity>)((EntityType)TensuraEntityTypes.IFRIT_CLONE.get()), (Level)level2);
        for (int l = 0; l < 50; ++l) {
            int i1 = i + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            int j1 = j + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            int k1 = k + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            BlockPos blockpos = new BlockPos(i1, j1, k1);
            EntityType entitytype = (EntityType)TensuraEntityTypes.IFRIT_CLONE.get();
            SpawnPlacements.Type type = SpawnPlacements.m_21752_((EntityType)entitytype);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)type, (LevelReader)level2, (BlockPos)blockpos, (EntityType)entitytype)) continue;
            clone.m_6034_(i1, j1, k1);
            if (!level2.m_45784_((Entity)clone) || !level2.m_45786_((Entity)clone) || level2.m_46855_(clone.m_20191_())) continue;
            clone.m_6518_((ServerLevelAccessor)level2, level2.m_6436_(clone.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            clone.m_6710_(this.m_5448_());
            clone.copySkills((LivingEntity)this);
            TensuraEPCapability.setLivingEP((LivingEntity)clone, EP * 0.1);
            level2.m_47205_((Entity)clone);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)clone, (ParticleOptions)TensuraParticles.RED_FIRE.get(), 2.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)clone, (ParticleOptions)ParticleTypes.f_123756_, 2.0);
            break;
        }
    }

    @Override
    public MagicElemental getElemental() {
        return MagicElemental.FLAME;
    }

    @Override
    public Item getElementalCore() {
        return (Item)TensuraMaterialItems.ELEMENT_CORE_FIRE.get();
    }

    protected void m_6153_() {
        if (++this.f_20919_ >= 35) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_5496_(SoundEvents.f_11913_, 10.0f, 1.0f);
            this.spawnDeathParticles();
        }
    }

    @Override
    protected void spawnDeathParticles() {
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.RED_FIRE.get());
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123796_);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.HEAT_EFFECT.get(), 2.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123796_, 2.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11701_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11704_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11703_;
    }

    public boolean shouldStand() {
        if (this.m_21525_()) {
            return true;
        }
        if (this.getMiscAnimation() == 3) {
            return true;
        }
        if (this.getMiscAnimation() >= 5) {
            return true;
        }
        return this.m_20096_();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_5803_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_21825_() && this.getMiscAnimation() == -1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.idle_train", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (event.isMoving() && this.getMiscAnimation() < 5 && this.getMiscAnimation() != 3 && !this.m_21525_()) {
            if (this.m_20096_()) {
                if (this.m_21660_()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.shouldStand()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.idle_fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.fire_ball_right", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.fire_ball_left", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.fire_ball_massive", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 4) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.fire_wall", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 5) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.flare_circle", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 6) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.burst", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 7 || this.getMiscAnimation() == 8) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.summon", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 9) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    static class IfritAttackGoal
    extends Goal {
        private final IfritEntity ifrit;
        private Vec3 startOrbitFrom;
        private int orbitTime;
        private int maxOrbitTime;
        private int attackCooldown;

        public IfritAttackGoal(IfritEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.ifrit = entity;
        }

        public boolean m_8036_() {
            if (this.ifrit.m_21827_()) {
                return false;
            }
            if (this.ifrit.usingMeleeWeapon()) {
                return false;
            }
            LivingEntity target = this.ifrit.m_5448_();
            if (target != null && target.m_6084_()) {
                this.startOrbitFrom = target.m_146892_();
                return true;
            }
            return false;
        }

        public void m_8037_() {
            LivingEntity target = this.ifrit.m_5448_();
            if (target == null || !target.m_6084_()) {
                return;
            }
            this.ifrit.setFlying(true);
            if (this.orbitTime < this.maxOrbitTime) {
                if (this.ifrit.getMiscAnimation() == 0) {
                    ++this.orbitTime;
                    --this.attackCooldown;
                }
                float zoomIn = 1.0f - (float)this.orbitTime / (float)this.maxOrbitTime;
                Vec3 orbitPos = this.orbitAroundPos(15.0f).m_82520_(0.0, (double)(4.0f + zoomIn * 3.0f), 0.0);
                this.ifrit.m_21573_().m_26519_(orbitPos.f_82479_, orbitPos.f_82480_, orbitPos.f_82481_, 1.2);
                if (this.isTimeToAttack()) {
                    this.resetAttackCooldown();
                    this.ifrit.setMiscAnimation(this.randomAttack(this.ifrit.m_20270_((Entity)target)));
                    this.ifrit.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                }
            } else {
                this.orbitTime = 0;
                if (this.canSummonSalamanders()) {
                    this.ifrit.setMiscAnimation(7);
                } else if (this.canSummonClone() && this.ifrit.m_217043_().m_188503_(4) == 1) {
                    this.ifrit.setMiscAnimation(8);
                }
            }
        }

        public void m_8056_() {
            this.orbitTime = 0;
            this.maxOrbitTime = 80 + this.ifrit.m_217043_().m_188503_(80);
            this.ifrit.m_21561_(true);
            this.attackCooldown = 0;
        }

        public Vec3 orbitAroundPos(float circleDistance) {
            float angle = 3.0f * (float)(Math.toRadians(this.orbitTime) * 3.0);
            double extraX = circleDistance * Mth.m_14031_((float)angle);
            double extraZ = circleDistance * Mth.m_14089_((float)angle);
            return this.startOrbitFrom.m_82520_(extraX, 0.0, extraZ);
        }

        private boolean canSummonSalamanders() {
            if (this.ifrit.m_21824_()) {
                return false;
            }
            List list = this.ifrit.f_19853_.m_45971_(SalamanderEntity.class, TargetingConditions.m_148353_().m_26883_(20.0).m_148355_().m_26893_(), (LivingEntity)this.ifrit, this.ifrit.m_20191_().m_82400_(20.0));
            if (!list.isEmpty()) {
                for (SalamanderEntity entity : list) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.RAMPAGE.get(), 200, 0, false, false, false));
                }
            }
            return this.ifrit.f_19796_.m_188503_(3) + 1 > list.size();
        }

        private boolean canSummonClone() {
            if (this.ifrit.m_21824_() || this.ifrit.getSummonerUUID() != null) {
                return false;
            }
            List list = this.ifrit.f_19853_.m_45971_(IfritCloneEntity.class, TargetingConditions.m_148353_().m_26883_(20.0).m_148355_().m_26893_(), (LivingEntity)this.ifrit, this.ifrit.m_20191_().m_82400_(20.0));
            return this.ifrit.f_19796_.m_188503_(3) + 1 > list.size();
        }

        private void resetAttackCooldown() {
            this.attackCooldown = this.m_183277_(30);
        }

        private boolean isTimeToAttack() {
            return this.attackCooldown <= 0;
        }

        private int randomAttack(double distance) {
            if (distance < 10.0 && (double)this.ifrit.f_19796_.m_188501_() <= 0.2) {
                return 6;
            }
            if (distance < 15.0) {
                if ((double)this.ifrit.f_19796_.m_188501_() <= 0.05) {
                    return 4;
                }
                if ((double)this.ifrit.f_19796_.m_188501_() <= 0.1) {
                    return 5;
                }
            }
            if ((double)this.ifrit.f_19796_.m_188501_() <= 0.4) {
                return 3;
            }
            return this.ifrit.m_217043_().m_188499_() ? 1 : 2;
        }
    }
}

