/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.api.entity.ai.LeapWithStrengthGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.subclass.IGiantMob;
import com.github.manasmods.tensura.api.entity.subclass.ITensuraMount;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.template.ClimbingEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.item.food.HealingPotionItem;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class KnightSpiderEntity
extends ClimbingEntity
implements IAnimatable,
IGiantMob,
ITensuraMount,
PlayerRideableJumping {
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(KnightSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SLAMMING_ATTACK = SynchedEntityData.m_135353_(KnightSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SLAMMING_FALL = SynchedEntityData.m_135353_(KnightSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(KnightSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int miscAnimationTicks = 0;
    protected int slammingCoolDown = 0;
    protected int ticksJump = 0;
    protected float playerJumpPendingScale;
    protected boolean playerJumping;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public KnightSpiderEntity(EntityType<? extends KnightSpiderEntity> type, Level level) {
        super((EntityType<? extends ClimbingEntity>)type, level);
        this.f_19793_ = 4.0f;
        this.f_21364_ = 40;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22276_, 90.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 22.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22278_, (double)0.9f).m_22268_(Attributes.f_22288_, 2.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 2.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new WanderingFollowOwnerGoal(this, 1.2, 20.0f, 5.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new KnightSpiderLeapGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new TensuraTamableEntity.WanderAroundPosGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new KnightSpiderAttackGoal(this, 1.2, true));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, null));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Villager.class, false, null));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, entity -> !(entity instanceof KnightSpiderEntity)));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, IronGolem.class, false, null));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(SLAMMING_ATTACK, (Object)false);
        this.f_19804_.m_135372_(SLAMMING_FALL, (Object)false);
        this.f_19804_.m_135372_(SADDLED, (Object)Boolean.FALSE);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
        compound.m_128379_("Slamming", this.isSlamming());
        compound.m_128379_("SlammingFall", this.isSlammingFall());
        compound.m_128379_("Saddled", this.isSaddled());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
        this.setSlamming(compound.m_128471_("Slamming"));
        this.setSlammingFall(compound.m_128471_("SlammingFall"));
        this.setSaddled(compound.m_128471_("Saddled"));
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
    }

    public boolean isSlamming() {
        return (Boolean)this.f_19804_.m_135370_(SLAMMING_ATTACK);
    }

    public void setSlamming(boolean slamming) {
        this.f_19804_.m_135381_(SLAMMING_ATTACK, (Object)slamming);
    }

    public boolean isSlammingFall() {
        return (Boolean)this.f_19804_.m_135370_(SLAMMING_FALL);
    }

    public void setSlammingFall(boolean falling) {
        this.f_19804_.m_135381_(SLAMMING_FALL, (Object)falling);
    }

    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(SADDLED, (Object)saddled);
    }

    public boolean m_5957_() {
        return false;
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        return false;
    }

    public KnightSpiderEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        KnightSpiderEntity spider = (KnightSpiderEntity)((EntityType)TensuraEntityTypes.KNIGHT_SPIDER.get()).m_20615_((Level)pLevel);
        if (spider == null) {
            return null;
        }
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            spider.m_21816_(uuid);
            spider.m_7105_(true);
        }
        return spider;
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = super.m_7327_(pEntity);
        if (flag && this.getMiscAnimation() == 0) {
            this.setMiscAnimation(1);
        }
        return flag;
    }

    public void m_7601_(BlockState pState, Vec3 pMotionMultiplier) {
        if (pState.m_204336_(TensuraTags.Blocks.WEB_BLOCKS)) {
            return;
        }
        super.m_7601_(pState, pMotionMultiplier);
    }

    protected float m_6041_() {
        BlockState blockstate = this.f_19853_.m_8055_(this.m_20183_());
        return blockstate.m_204336_(TensuraTags.Blocks.WEB_BLOCKS) ? 1.0f : super.m_6041_();
    }

    protected float m_20098_() {
        BlockState blockstate = this.f_19853_.m_8055_(this.m_20183_());
        return blockstate.m_204336_(TensuraTags.Blocks.WEB_BLOCKS) ? 1.0f : super.m_20098_();
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof HealingPotionItem) {
            return super.m_6071_(player, hand);
        }
        InteractionResult eating = this.handleEating(player, hand, itemstack);
        if (eating.m_19077_()) {
            return eating;
        }
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            Item item = itemstack.m_41720_();
            if (item.equals(TensuraMaterialItems.MONSTER_SADDLE.get()) && !this.isSaddled()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.setSaddled(true);
                this.m_5496_(SoundEvents.f_11811_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (this.isSaddled() && item.equals(Items.f_42574_)) {
                this.m_5496_(SoundEvents.f_12344_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.m_19998_((ItemLike)TensuraMaterialItems.MONSTER_SADDLE.get());
                this.setSaddled(false);
                return InteractionResult.SUCCESS;
            }
            if (player.m_36341_() || !this.isSaddled()) {
                this.commanding(player);
            } else if (player.m_146895_() == null) {
                this.m_21839_(false);
                this.setWandering(false);
                player.m_7998_((Entity)this, true);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public InteractionResult handleEating(Player player, InteractionHand hand, ItemStack itemstack) {
        if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.m_8035_();
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_8035_() {
        super.m_8035_();
        this.setMiscAnimation(1);
        this.m_5634_(5.0f);
    }

    public boolean m_6898_(ItemStack pStack) {
        if (pStack.m_41720_() instanceof HealingPotionItem) {
            return false;
        }
        return pStack.m_41614_();
    }

    public boolean m_7132_() {
        return this.m_20160_();
    }

    public double getCustomJump() {
        return this.m_21133_(Attributes.f_22288_);
    }

    public boolean m_6146_() {
        return true;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        for (Entity passenger : this.m_20197_()) {
            Player player;
            if (!(passenger instanceof Player) || !(player = (Player)passenger).equals((Object)this.m_21826_())) continue;
            return player;
        }
        return null;
    }

    public void m_7332_(Entity passenger) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        passenger.m_183634_();
        float radius = 2.7f;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double yOffset = this.m_20186_() - 0.25 + this.m_6048_() + passenger.m_6049_();
        passenger.m_6034_(this.m_20185_() + extraX, yOffset, this.m_20189_() + extraZ);
    }

    public void m_7888_(int pJumpPower) {
        if (pJumpPower >= 90) {
            this.playerJumpPendingScale = 1.0f;
        } else {
            if (pJumpPower < 0) {
                pJumpPower = 0;
            }
            this.playerJumpPendingScale = 0.4f + 0.4f * (float)pJumpPower / 90.0f;
        }
    }

    public void m_7199_(int pJumpPower) {
        if (!this.m_20096_()) {
            return;
        }
        this.playJumpSound();
        this.setMiscAnimation(2);
    }

    public void m_8012_() {
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6084_()) {
            LivingEntity livingentity = this.getControllingPassenger();
            if (this.m_20160_() && livingentity != null) {
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = livingentity.f_20900_ * 0.5f;
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.playerJumpPendingScale > 0.0f && !this.isPlayerJumping() && this.f_19861_) {
                    double d0 = this.getCustomJump() * (double)this.playerJumpPendingScale * (double)this.m_20098_();
                    double d1 = d0 + this.m_182332_();
                    Vec3 vec3 = this.m_20184_();
                    this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
                    this.setPlayerJumping(true);
                    this.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * this.playerJumpPendingScale), 0.0, (double)(0.4f * f3 * this.playerJumpPendingScale)));
                    }
                    this.playerJumpPendingScale = 0.0f;
                }
                this.f_20887_ = this.m_6113_() * 0.1f;
                if (this.m_6109_()) {
                    float speed = (float)this.m_21133_(Attributes.f_22279_);
                    if (livingentity.m_20142_()) {
                        speed = (float)((double)speed * 1.25);
                    }
                    this.m_7910_(speed);
                    if (this.isInFluidType((fluidType, height) -> height > this.m_20204_()) && f1 > 0.0f) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.03, 0.0));
                        super.m_7023_(new Vec3((double)f, (double)livingentity.f_20901_, (double)f1));
                    } else {
                        super.m_7023_(new Vec3((double)f, pTravelVector.f_82480_, (double)f1));
                    }
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.f_19861_) {
                    this.playerJumpPendingScale = 0.0f;
                    this.setPlayerJumping(false);
                }
                this.m_146872_();
            } else {
                this.f_20887_ = 0.02f;
                super.m_7023_(pTravelVector);
            }
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.isSaddled() && !this.m_9236_().m_5776_()) {
            this.m_19998_((ItemLike)TensuraMaterialItems.MONSTER_SADDLE.get());
        }
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19310_ || source == DamageSource.f_19314_ || source == DamageSource.f_19325_ || source == DamageSource.f_19309_ || super.m_6673_(source);
    }

    public int m_5792_() {
        return 1;
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return SpawnRateConfig.rollSpawn((Integer)SpawnRateConfig.INSTANCE.knightSpiderSpawnRate.get(), this.m_217043_(), pSpawnReason) && super.m_5545_(pLevel, pSpawnReason);
    }

    @Override
    protected float getClimbSpeedMultiplier() {
        return 2.0f;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        int i;
        if (this.isSlammingFall() && pFallDistance >= 5.0f) {
            this.setMiscAnimation(4);
            this.setSlamming(Boolean.FALSE);
            this.setSlammingFall(Boolean.FALSE);
            AABB aabb = AABB.m_165882_((Vec3)this.m_20182_(), (double)16.0, (double)16.0, (double)16.0);
            List list = this.m_9236_().m_6443_(LivingEntity.class, aabb, entity -> !entity.m_7307_((Entity)this) && entity != this.m_21826_() && !(entity instanceof KnightSpiderEntity));
            for (LivingEntity target : list) {
                target.m_6469_(DamageSource.m_19370_((LivingEntity)this), 30.0f);
                SkillHelper.knockBack((LivingEntity)this, target, 1.0f);
            }
            if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_)) {
                SkillHelper.launchBlock((Entity)this, this.m_20182_(), 7, 1, 0.5f, 0.3f, blockState -> {
                    if (this.m_217043_().m_188503_(3) != 1) {
                        return false;
                    }
                    return blockState.m_204336_(TensuraTags.Blocks.EARTH_DOMINATING);
                }, blockPos -> true);
            }
            this.f_19853_.m_7703_((Entity)this, DamageSource.m_19370_((LivingEntity)this), null, (double)this.m_20097_().m_123341_(), (double)this.m_20097_().m_123342_(), (double)this.m_20097_().m_123343_(), 5.0f, false, Explosion.BlockInteraction.NONE);
            return false;
        }
        if (pFallDistance < 16.0f) {
            return false;
        }
        if (pFallDistance > 16.0f) {
            this.m_5496_(SoundEvents.f_12319_, 0.4f, 1.0f);
        }
        if ((i = this.m_5639_(pFallDistance - 10.0f, pMultiplier)) <= 0) {
            return false;
        }
        this.m_6469_(pSource, i);
        if (this.m_20160_()) {
            for (Entity entity2 : this.m_146897_()) {
                entity2.m_6469_(pSource, (float)i);
            }
        }
        this.m_21229_();
        return true;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12432_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12434_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected void playJumpSound() {
        this.m_5496_((SoundEvent)TensuraSoundEvents.SMALL_JUMP_IMPACT.get(), 0.4f, 1.0f);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.targetingMovementHelper();
        if (this.m_5448_() != null) {
            if (!this.isSlamming()) {
                if (++this.slammingCoolDown == 100) {
                    this.slammingCoolDown = 0;
                    this.setSlamming(Boolean.TRUE);
                }
            } else if (this.m_20077_() || this.m_20072_()) {
                this.setSlammingFall(Boolean.FALSE);
                this.setSlamming(Boolean.FALSE);
            }
        }
        if (!this.f_19853_.m_5776_()) {
            LivingEntity controller = this.getControllingPassenger();
            if (!this.m_21824_() || controller != null && this.m_21830_(controller)) {
                this.breakBlocks((LivingEntity)this, 1.0f, false);
            }
        }
        if (this.getMiscAnimation() != 0) {
            int animationTick;
            ++this.miscAnimationTicks;
            int n = this.getMiscAnimation() == 3 ? 15 : (animationTick = this.getMiscAnimation() == 2 ? 20 : 10);
            if (this.miscAnimationTicks > animationTick) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    @Override
    public void mountAbility(Player rider) {
        if (this.getMiscAnimation() == 2) {
            return;
        }
        if (this.getMiscAnimation() == 3) {
            return;
        }
        if (this.getMiscAnimation() == 4) {
            return;
        }
        if (this.m_6162_()) {
            return;
        }
        if (!this.m_20096_() && !this.isInFluidType()) {
            this.setSlammingFall(Boolean.TRUE);
        } else {
            LivingEntity target = SkillHelper.getTargetingEntity((LivingEntity)rider, 8.0, false);
            if (target != null) {
                this.m_7327_((Entity)target);
            }
        }
    }

    private boolean isFalling() {
        if (this.m_20096_()) {
            return false;
        }
        if (this.isInFluidType()) {
            return false;
        }
        return this.f_19789_ > 3.0f;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getMiscAnimation() == 2 || this.getMiscAnimation() == 3 || this.getMiscAnimation() == 4) {
            return PlayState.CONTINUE;
        }
        if (this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.knight_spider.dead", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.isFalling()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.knight_spider.falling", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.knight_spider.stay", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.knight_spider.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.knight_spider.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.knight_spider.bite", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.knight_spider.leap", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.knight_spider.jump", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 4) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.knight_spider.land", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void setPlayerJumping(boolean playerJumping) {
        this.playerJumping = playerJumping;
    }

    public boolean isPlayerJumping() {
        return this.playerJumping;
    }

    static class KnightSpiderLeapGoal
    extends LeapWithStrengthGoal {
        private final KnightSpiderEntity spider;

        public KnightSpiderLeapGoal(KnightSpiderEntity spider) {
            super((Mob)spider, 0.7f, 3.0f, 10.0, 20.0, 20);
            this.spider = spider;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.spider.setMiscAnimation(2);
        }

        @Override
        public boolean m_8045_() {
            if (this.spider.getMiscAnimation() != 0) {
                return false;
            }
            return !this.spider.m_20096_();
        }
    }

    static class KnightSpiderAttackGoal
    extends MeleeAttackGoal {
        private final KnightSpiderEntity spider;

        public KnightSpiderAttackGoal(KnightSpiderEntity spider, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)spider, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.spider = spider;
        }

        public boolean m_8036_() {
            if (this.spider.m_21827_()) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.spider.m_21827_()) {
                return false;
            }
            return super.m_8045_();
        }

        public void m_8037_() {
            LivingEntity target = this.spider.m_5448_();
            if (target == null) {
                return;
            }
            if (this.spider.isSlamming() && !this.spider.isSlammingFall() && ++this.spider.ticksJump >= 40 && this.spider.m_20270_((Entity)target) <= 10.0f) {
                if (this.spider.m_20096_()) {
                    this.spider.setMiscAnimation(3);
                    this.spider.m_20256_(new Vec3(this.spider.m_20184_().f_82479_, this.spider.m_20184_().f_82480_ + (double)1.2f, this.spider.m_20184_().f_82481_));
                } else if (!this.spider.m_20077_() && !this.spider.m_20072_()) {
                    this.spider.ticksJump = 0;
                    this.spider.setSlammingFall(Boolean.TRUE);
                }
            }
            super.m_8037_();
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() * 3.0f + pAttackTarget.m_20205_();
        }
    }
}

