/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.api.entity.ai.FlyingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.ai.TamableFollowParentGoal;
import com.github.manasmods.tensura.api.entity.navigator.NoSpinFlightPathNavigator;
import com.github.manasmods.tensura.api.entity.subclass.IElementalSpirit;
import com.github.manasmods.tensura.api.entity.subclass.IFollower;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.IfritCloneEntity;
import com.github.manasmods.tensura.entity.IfritEntity;
import com.github.manasmods.tensura.entity.magic.projectile.FireBoltProjectile;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.item.food.HealingPotionItem;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.IntrinsicSkills;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SalamanderEntity
extends HumanoidNPCEntity
implements IAnimatable,
IElementalSpirit,
FlyingAnimal,
IFollower {
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(SalamanderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SUMMONING_TICK = SynchedEntityData.m_135353_(SalamanderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Optional<UUID>> SUMMONER_UUID = SynchedEntityData.m_135353_(SalamanderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(SalamanderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> CAN_SELF_DESTRUCT = SynchedEntityData.m_135353_(SalamanderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public float prevFlyProgress;
    public float flyProgress;
    protected boolean wasFlying;
    public int timeFlying = 0;
    public int miscAnimationTicks = 0;

    public SalamanderEntity(EntityType<? extends SalamanderEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends HumanoidNPCEntity>)pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
        this.f_21364_ = 40;
        this.f_19793_ = 1.0f;
    }

    protected void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this){

                public void m_8126_() {
                    if (!SalamanderEntity.this.isSelfDestruct()) {
                        super.m_8126_();
                    }
                }
            };
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.f_19853_);
            this.wasFlying = false;
        } else {
            this.f_21342_ = new SalamanderMoveControl(){

                @Override
                public void m_8126_() {
                    if (!SalamanderEntity.this.isSelfDestruct()) {
                        super.m_8126_();
                    }
                }
            };
            this.f_21344_ = new NoSpinFlightPathNavigator((Mob)this, this.f_19853_);
            this.wasFlying = true;
        }
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, (double)0.2f).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 1.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.NPCMeleeAttackGoal((PathfinderMob)this, 2.0, true){

            @Override
            public boolean m_8036_() {
                if (!super.m_8036_()) {
                    return false;
                }
                return SalamanderEntity.this.usingMeleeWeapon();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new SalamanderAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new IElementalSpirit.FollowGreaterSpiritGoal(this, 1.0, IfritEntity.class));
        this.f_21345_.m_25352_(5, (Goal)new FlyingFollowOwnerGoal(this, 0.7, 10.0f, 4.0f, true, false));
        this.f_21345_.m_25352_(6, (Goal)new TamableFollowParentGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(7, (Goal)new WalkGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new FollowBoatGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(8, (Goal)new TensuraTamableEntity.FlyingWanderAroundPosGoal(this, this));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, IfritEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((SalamanderEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(SUMMONING_TICK, (Object)-1);
        this.f_19804_.m_135372_(SUMMONER_UUID, Optional.empty());
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(CAN_SELF_DESTRUCT, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getSummonerUUID() != null) {
            compound.m_128362_("Summoner", this.getSummonerUUID());
        }
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
        compound.m_128405_("SummoningTick", this.getSummoningTick());
        compound.m_128379_("Flying", this.m_29443_());
        compound.m_128379_("CanSelfDestruct", this.canSelfDestruct());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("Summoner")) {
            this.setSummonerUUID(compound.m_128342_("Summoner"));
        }
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
        this.setSummoningTick(compound.m_128451_("SummoningTick"));
        this.setFlying(compound.m_128471_("Flying"));
        this.setCanSelfDestruct(compound.m_128471_("CanSelfDestruct"));
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    @Override
    public void setMiscAnimation(int tick) {
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)tick);
    }

    @Override
    public int getSummoningTick() {
        return (Integer)this.f_19804_.m_135370_(SUMMONING_TICK);
    }

    @Override
    public void setSummoningTick(int tick) {
        this.f_19804_.m_135381_(SUMMONING_TICK, (Object)tick);
    }

    @Override
    @Nullable
    public UUID getSummonerUUID() {
        return ((Optional)this.f_19804_.m_135370_(SUMMONER_UUID)).orElse(null);
    }

    @Override
    public void setSummonerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(SUMMONER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public LivingEntity m_21826_() {
        if (this.getSummonerUUID() != null) {
            return null;
        }
        return super.m_21826_();
    }

    public boolean m_29443_() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public boolean canSelfDestruct() {
        return (Boolean)this.f_19804_.m_135370_(CAN_SELF_DESTRUCT);
    }

    public void setCanSelfDestruct(boolean selfDestruct) {
        this.f_19804_.m_135381_(CAN_SELF_DESTRUCT, (Object)selfDestruct);
    }

    protected boolean isSelfDestruct() {
        return this.getMiscAnimation() == 3 || this.getMiscAnimation() == 5;
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_21824_()) {
            HumanoidNPCEntity ifrit;
            SalamanderEntity salamander;
            Entity entity = pSource.m_7639_();
            if (entity instanceof SalamanderEntity && !(salamander = (SalamanderEntity)entity).m_21824_()) {
                return false;
            }
            entity = pSource.m_7639_();
            if (entity instanceof IfritCloneEntity && !(ifrit = (IfritCloneEntity)entity).m_21824_()) {
                return false;
            }
            entity = pSource.m_7639_();
            if (entity instanceof IfritEntity && !(ifrit = (IfritEntity)entity).m_21824_()) {
                return false;
            }
        }
        return super.m_6469_(pSource, pAmount *= this.getPhysicalAttackInput(pSource));
    }

    @Override
    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (this.getSummonerUUID() != null) {
            if (entity instanceof IElementalSpirit) {
                IElementalSpirit spirit = (IElementalSpirit)entity;
                return Objects.equals(spirit.getSummonerUUID(), this.getSummonerUUID());
            }
            return Objects.equals(entity.m_20148_(), this.getSummonerUUID());
        }
        if (entity instanceof SalamanderEntity) {
            SalamanderEntity salamander = (SalamanderEntity)entity;
            return salamander.m_21824_() == this.m_21824_();
        }
        if (entity instanceof IfritEntity) {
            IfritEntity ifrit = (IfritEntity)entity;
            return ifrit.m_21824_() == this.m_21824_();
        }
        return false;
    }

    public boolean m_6779_(LivingEntity pTarget) {
        if (this.m_7307_((Entity)pTarget)) {
            return false;
        }
        return super.m_6779_(pTarget);
    }

    public boolean m_6060_() {
        return TensuraEffectsCapability.hasSyncedEffect((LivingEntity)this, (MobEffect)TensuraMobEffects.BLACK_BURN.get());
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    @Override
    public boolean shouldFollow() {
        return !this.m_21827_() && !this.isWandering() && (this.m_5448_() == null || !this.m_5448_().m_6084_());
    }

    @Override
    public boolean m_7243_(ItemStack pStack) {
        if (!this.m_21824_()) {
            return false;
        }
        return super.m_7243_(pStack);
    }

    @Override
    public boolean canEquipSlots(EquipmentSlot slot) {
        if (!super.canEquipSlots(slot)) {
            return false;
        }
        return !slot.m_20743_().equals((Object)EquipmentSlot.Type.ARMOR);
    }

    private boolean usingMeleeWeapon() {
        Item item = this.m_21205_().m_41720_();
        if (item instanceof AxeItem) {
            return true;
        }
        return item instanceof SwordItem;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.handleFlying();
        this.miscAnimationHandler();
        if (!this.f_19853_.m_5776_()) {
            this.summoningTicking(this);
        } else if (!this.m_20069_()) {
            Vec3 vec3 = this.m_20252_(0.0f);
            float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180))) * 0.3f;
            float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180))) * 0.3f;
            double yPos = this.m_20188_() + (double)0.2f;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            float radius = 0.3f;
            double extraX = Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = Mth.m_14089_((float)angle);
            if (this.m_21825_()) {
                radius = 0.0f;
                f *= 0.8f;
                f1 *= 0.8f;
                yPos -= 0.5;
            } else if (this.m_20096_()) {
                radius = 0.2f;
            } else if (this.m_20184_().m_82556_() > 0.03) {
                f *= 0.6f;
                f1 *= 0.6f;
                yPos -= (double)0.1f;
            }
            this.f_19853_.m_7106_((ParticleOptions)TensuraParticles.RED_FIRE.get(), this.m_20185_() - vec3.f_82479_ * 0.1 + (double)f + extraX * (double)radius, yPos, this.m_20189_() - vec3.f_82481_ * 0.1 + (double)f1 + extraZ * (double)radius, 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)TensuraParticles.RED_FIRE.get(), this.m_20185_() - vec3.f_82479_ * 0.1 - (double)f + extraX * (double)radius, yPos, this.m_20189_() - vec3.f_82481_ * 0.1 - (double)f1 + extraZ * (double)radius, 0.0, 0.0, 0.0);
        }
    }

    protected void handleFlying() {
        this.prevFlyProgress = this.flyProgress;
        if (this.m_29443_()) {
            if (this.flyProgress < 5.0f) {
                this.flyProgress += 1.0f;
            }
        } else if (this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (!this.f_19853_.m_5776_()) {
            boolean isFlying = this.m_29443_();
            if (isFlying != this.wasFlying) {
                this.switchNavigator(!isFlying);
            }
            if (isFlying) {
                ++this.timeFlying;
                this.m_20242_(true);
                if (this.m_21827_() || this.m_20159_() || this.m_27593_() || this.m_5803_()) {
                    this.setFlying(false);
                }
            } else {
                this.timeFlying = 0;
                this.m_20242_(false);
            }
        }
    }

    protected void miscAnimationHandler() {
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            boolean exploding = this.getMiscAnimation() == 3 && this.miscAnimationTicks == 20 || this.getMiscAnimation() == 5 && this.miscAnimationTicks == 30;
            LivingEntity target = this.m_5448_();
            if (exploding && target != null && target.m_20270_((Entity)this) <= 5.0f) {
                this.explode();
            }
            if (this.miscAnimationTicks > this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            case 1 -> 17;
            case 2 -> 12;
            case 4 -> 40;
            case 5 -> 30;
            default -> 20;
        };
    }

    @Override
    public void m_6504_(@NotNull LivingEntity target, float v) {
        FireBoltProjectile spit = new FireBoltProjectile(this.f_19853_, (LivingEntity)this);
        spit.setSkill(SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)ExtraSkills.FLAME_MANIPULATION.get()));
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double xOffset = Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double zOffset = Mth.m_14089_((float)angle);
        spit.m_7678_(this.m_20185_() + xOffset, this.m_20188_() - 0.2, this.m_20189_() + zOffset, this.m_146908_(), this.m_146909_());
        double d0 = target.m_20186_() + (double)(target.m_20206_() / 2.0f);
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = d0 - spit.m_20186_();
        double d3 = target.m_20189_() - this.m_20189_();
        double f = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        spit.setDamage((float)(this.m_21133_(Attributes.f_22281_) + 1.0));
        spit.setBurnTicks(100);
        spit.setSpiritAttack(true);
        spit.m_6686_(d1, d2 + f, d3, v, 0.0f);
        this.f_19853_.m_7967_((Entity)spit);
    }

    private void explode() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        Explosion.BlockInteraction interaction = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
        this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6.0f, interaction);
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance effectInstance : collection) {
                if (effectInstance.m_19544_().getCurativeItems().isEmpty()) continue;
                areaeffectcloud.m_19716_(new MobEffectInstance(effectInstance));
            }
            this.f_19853_.m_7967_((Entity)areaeffectcloud);
        }
        DamageSource source = DamageSource.m_19373_((LivingEntity)null).m_19381_().m_19380_().m_238403_().m_19382_();
        this.m_6469_(source, this.m_21233_());
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.m_20069_() && this.m_20184_().f_82480_ > 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.5, 1.0));
        }
        super.m_7023_(vec3d);
    }

    @Override
    public void followEntity(TamableAnimal animal, LivingEntity owner, double followSpeed) {
        if (this.m_20270_((Entity)owner) > 5.0f) {
            this.setFlying(true);
            this.m_21566_().m_6849_(owner.m_20185_(), owner.m_20186_() + (double)owner.m_20206_(), owner.m_20189_(), followSpeed);
        } else {
            if (this.f_19861_) {
                this.setFlying(false);
            }
            if (this.m_29443_()) {
                BlockPos vec = this.getGround((LivingEntity)this, this.m_20183_());
                this.m_21566_().m_6849_((double)vec.m_123341_(), (double)vec.m_123342_(), (double)vec.m_123343_(), followSpeed);
            } else {
                this.m_21573_().m_5624_((Entity)owner, followSpeed);
            }
        }
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_204117_(TensuraTags.Items.SPIRIT_FOOD);
    }

    public boolean isTamingFood(ItemStack pStack) {
        return pStack.m_150930_((Item)TensuraMaterialItems.ELEMENT_CORE_FIRE.get());
    }

    public void m_21828_(Player pPlayer) {
        super.m_21828_(pPlayer);
        if (this.canSelfDestruct()) {
            this.setCanSelfDestruct(false);
        }
    }

    @Override
    public MagicElemental getElemental() {
        return MagicElemental.FLAME;
    }

    @Override
    public SpiritualMagic.SpiritLevel getSpiritLevel() {
        return SpiritualMagic.SpiritLevel.MEDIUM;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof HealingPotionItem) {
            return super.m_6071_(player, hand);
        }
        InteractionResult eating = this.handleEating(player, hand, itemstack);
        if (eating.m_19077_()) {
            return eating;
        }
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.isTamingFood(itemstack);
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.convertElementalCore((LivingEntity)this, player, hand, (Item)TensuraMaterialItems.ELEMENT_CORE_FIRE.get())) {
                return InteractionResult.SUCCESS;
            }
            if (!super.m_6071_(player, hand).m_19077_() && this.m_21830_((LivingEntity)player)) {
                this.commanding(player);
                return InteractionResult.SUCCESS;
            }
        } else if (this.isTamingFood(itemstack)) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(10) == 7 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                if (this.f_19796_.m_188503_(20) == 0) {
                    this.m_6710_((LivingEntity)player);
                }
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult handleEating(Player player, InteractionHand hand, ItemStack itemstack) {
        if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.m_8035_();
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_8035_() {
        super.m_8035_();
        this.m_5634_(3.0f);
        if (this.m_20096_() && !this.m_21566_().m_24995_()) {
            this.setMiscAnimation(4);
        } else {
            this.setMiscAnimation(1);
        }
    }

    @Override
    public void commanding(Player player) {
        MutableComponent message;
        boolean isSelfDestruct = this.canSelfDestruct();
        if (isSelfDestruct) {
            message = Component.m_237110_((String)"tensura.message.pet.follow", (Object[])new Object[]{this.m_5446_()});
            this.m_21839_(false);
            this.setWandering(false);
            this.setCanSelfDestruct(false);
        } else if (!this.isWandering() && !this.m_21827_()) {
            message = Component.m_237110_((String)"tensura.message.pet.wander", (Object[])new Object[]{this.m_5446_()});
            this.m_21839_(false);
            this.m_6710_(null);
            this.setCanSelfDestruct(false);
            this.setWandering(true);
            this.setWanderPos(player.m_20097_().m_7494_());
        } else if (this.isWandering()) {
            message = Component.m_237110_((String)"tensura.message.pet.stay", (Object[])new Object[]{this.m_5446_()});
            this.m_21573_().m_26573_();
            this.m_21839_(true);
            this.setWandering(false);
            this.m_6710_(null);
            this.setCanSelfDestruct(false);
        } else {
            message = Component.m_237110_((String)"tensura.message.pet.self_destruct", (Object[])new Object[]{this.m_5446_()});
            this.m_21839_(false);
            this.setWandering(false);
            this.m_6710_(null);
            this.setCanSelfDestruct(true);
        }
        player.m_5661_((Component)message.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA)), true);
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return SpawnRateConfig.rollSpawn((Integer)SpawnRateConfig.INSTANCE.salamanderSpawnRate.get(), this.m_217043_(), pSpawnReason) && super.m_5545_(pLevel, pSpawnReason);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (!this.m_20096_()) {
            this.setFlying(true);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void m_6668_(DamageSource pDamageSource) {
        if (this.getSummoningTick() >= 0) {
            this.m_5907_();
        } else {
            super.m_6668_(pDamageSource);
        }
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        if ((double)this.f_19796_.m_188501_() > 0.1) {
            return;
        }
        this.m_19998_((ItemLike)TensuraMobDropItems.ELEMENTAL_ESSENCE.get());
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11701_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11704_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11703_;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getMiscAnimation() == 4 || this.getMiscAnimation() == 5) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.salamander.still", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.salamander.stay", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving() && !this.m_21525_()) {
            if (this.m_20096_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.salamander.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.salamander.fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.m_20096_() || this.m_21525_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.salamander.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.salamander.idle_fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.salamander.eat", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.salamander.fire_ball", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.salamander.self_destruct", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 4) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.salamander.eat_still", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 5) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.salamander.self_destruct_still", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class SalamanderAttackGoal
    extends Goal {
        private final SalamanderEntity salamander;
        private int fireTrailTime = 40;
        private Vec3 startOrbitFrom;
        private int orbitTime;
        private int fireTrailCoolDown;
        private int fireballCoolDown = 40;

        public SalamanderAttackGoal(SalamanderEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.salamander = entity;
        }

        public boolean m_8036_() {
            if (this.salamander.m_21827_()) {
                return false;
            }
            if (this.salamander.usingMeleeWeapon()) {
                return false;
            }
            LivingEntity target = this.salamander.m_5448_();
            if (target != null && target.m_6084_()) {
                this.startOrbitFrom = target.m_146892_();
                return true;
            }
            return false;
        }

        private boolean shouldSelfDestruct() {
            if (!this.salamander.m_21824_()) {
                if (this.salamander.m_21223_() >= this.salamander.m_21233_() * 0.1f) {
                    return false;
                }
                if (this.salamander.m_21023_((MobEffect)TensuraMobEffects.RAMPAGE.get())) {
                    return true;
                }
            }
            return this.salamander.canSelfDestruct();
        }

        public void m_8037_() {
            LivingEntity target = this.salamander.m_5448_();
            if (target == null || !target.m_6084_()) {
                return;
            }
            double distance = this.salamander.m_20270_((Entity)target);
            if (this.shouldSelfDestruct()) {
                this.salamander.m_21573_().m_5624_((Entity)target, 1.5);
                this.salamander.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                if (distance <= 5.0) {
                    if (this.salamander.m_20096_()) {
                        this.salamander.setMiscAnimation(5);
                    } else {
                        this.salamander.setMiscAnimation(3);
                    }
                    this.salamander.f_21344_.m_26573_();
                } else {
                    this.salamander.setFlying(true);
                }
                return;
            }
            this.salamander.setFlying(true);
            if (this.orbitTime < this.fireTrailCoolDown) {
                ++this.orbitTime;
                --this.fireballCoolDown;
                float zoomIn = 1.0f - (float)this.orbitTime / (float)this.fireTrailCoolDown;
                Vec3 orbitPos = this.orbitAroundPos(5.5f).m_82520_(0.0, (double)(4.0f + zoomIn * 3.0f), 0.0);
                this.salamander.m_21573_().m_26519_(orbitPos.f_82479_, orbitPos.f_82480_, orbitPos.f_82481_, 1.2);
                if (this.salamander.m_29443_() && this.fireballCoolDown <= 15 && distance < 12.0) {
                    if (this.fireballCoolDown <= 10) {
                        this.salamander.setMiscAnimation(2);
                    }
                    this.salamander.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                } else {
                    this.salamander.m_7618_(EntityAnchorArgument.Anchor.EYES, orbitPos);
                }
            } else {
                this.orbitTime = 0;
                this.fireTrailTime = 60;
            }
            if (this.salamander.getMiscAnimation() == 2 && this.fireballCoolDown <= 0) {
                this.salamander.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                this.fireballCoolDown = 40;
                this.salamander.m_6504_(target, 1.0f);
                this.salamander.setMiscAnimation(0);
                this.salamander.f_19853_.m_6263_(null, this.salamander.m_20185_(), this.salamander.m_20186_(), this.salamander.m_20189_(), SoundEvents.f_11705_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else if (this.fireTrailTime-- > 0) {
                this.fireTrail();
                AABB aabb = new AABB(this.salamander.m_20183_().m_6625_(2), this.salamander.m_20183_().m_6625_(8));
                List list = this.salamander.f_19853_.m_6443_(LivingEntity.class, aabb.m_82400_(2.0), entity -> !entity.m_7307_((Entity)this.salamander) && !this.salamander.m_21830_((LivingEntity)entity));
                if (list.isEmpty()) {
                    return;
                }
                for (LivingEntity entity2 : list) {
                    TensuraDamageSource damageSource;
                    if (!entity2.m_6469_((DamageSource)(damageSource = DamageSourceHelper.turnTensura(TensuraDamageSources.burn((Entity)this.salamander)).setSkill(SkillUtils.getSkillOrNull((Entity)this.salamander, (ManasSkill)IntrinsicSkills.FLAME_BREATH.get()))), 4.0f)) continue;
                    entity2.m_20254_(3);
                }
            }
        }

        public void m_8056_() {
            this.orbitTime = 0;
            this.fireTrailCoolDown = 60 + this.salamander.m_217043_().m_188503_(80);
        }

        public Vec3 orbitAroundPos(float circleDistance) {
            float angle = 3.0f * (float)(Math.toRadians(this.orbitTime) * 3.0);
            double extraX = circleDistance * Mth.m_14031_((float)angle);
            double extraZ = circleDistance * Mth.m_14089_((float)angle);
            return this.startOrbitFrom.m_82520_(extraX, 0.0, extraZ);
        }

        private void fireTrail() {
            Level level = this.salamander.f_19853_;
            float radius = this.salamander.m_20205_();
            double x = this.salamander.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * (double)radius;
            double y = this.salamander.m_20186_() - 1.0 + (level.f_46441_.m_188500_() - 0.5) * (double)radius * 0.75;
            double z = this.salamander.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * (double)radius;
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 5; ++j) {
                    double newX = x + this.salamander.m_217043_().m_188583_() / 2.0;
                    double newY = y + this.salamander.m_217043_().m_188583_() / 2.0;
                    double newZ = z + this.salamander.m_217043_().m_188583_() / 2.0;
                    TensuraParticleHelper.spawnServerParticles(level, (ParticleOptions)TensuraParticles.RED_FIRE.get(), newX, newY - (double)i, newZ, 0, 0.0, -0.1, 0.0, 0.0, false);
                }
            }
        }
    }

    public class WalkGoal
    extends Goal {
        protected final SalamanderEntity entity;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;

        public WalkGoal(SalamanderEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.entity = entity;
        }

        public boolean m_8036_() {
            if (this.entity.m_20160_() || this.entity.m_5448_() != null && this.entity.m_5448_().m_6084_() || this.entity.m_20159_() || this.entity.m_21827_()) {
                return false;
            }
            if (this.entity.m_217043_().m_188503_(30) != 0 && !this.entity.m_29443_()) {
                return false;
            }
            this.flightTarget = this.entity.m_20096_() ? SalamanderEntity.this.f_19796_.m_188499_() : SalamanderEntity.this.f_19796_.m_188503_(5) > 0 && this.entity.timeFlying < 200;
            Vec3 position = this.getPosition();
            if (position == null) {
                return false;
            }
            this.x = position.f_82479_;
            this.y = position.f_82480_;
            this.z = position.f_82481_;
            return true;
        }

        public void m_8037_() {
            if (this.flightTarget) {
                this.entity.m_21566_().m_6849_(this.x, this.y, this.z, 1.0);
            } else {
                this.entity.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
                if (SalamanderEntity.this.m_29443_() && this.entity.f_19861_) {
                    this.entity.setFlying(false);
                }
            }
            if (SalamanderEntity.this.m_29443_() && this.entity.f_19861_ && this.entity.timeFlying > 10) {
                this.entity.setFlying(false);
            }
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = this.entity.m_20182_();
            if (SalamanderEntity.this.isOverWater((LivingEntity)this.entity)) {
                this.flightTarget = true;
            }
            Vec3 pos = Vec3.m_82512_((Vec3i)this.entity.getWanderPos());
            double distance = (Double)TensuraConfig.INSTANCE.entitiesConfig.tamedWanderRadius.get();
            if (this.entity.isWandering() && this.entity.m_20238_(pos) >= distance * distance) {
                return pos;
            }
            if (this.flightTarget) {
                if (this.entity.timeFlying < 50) {
                    return SalamanderEntity.this.getBlockInViewAway((LivingEntity)this.entity, vector3d, 0.0f);
                }
                return SalamanderEntity.this.getBlockGrounding((LivingEntity)this.entity, vector3d);
            }
            return LandRandomPos.m_148488_((PathfinderMob)this.entity, (int)10, (int)7);
        }

        public boolean m_8045_() {
            if (this.entity.m_21827_()) {
                return false;
            }
            if (this.flightTarget) {
                return this.entity.m_29443_() && this.entity.m_20275_(this.x, this.y, this.z) > 2.0;
            }
            return !this.entity.m_21573_().m_26571_() && !this.entity.m_20160_();
        }

        public void m_8056_() {
            if (this.flightTarget) {
                this.entity.setFlying(true);
                this.entity.m_21566_().m_6849_(this.x, this.y, this.z, 1.0);
            } else {
                this.entity.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
            }
        }

        public void m_8041_() {
            this.entity.m_21573_().m_26573_();
            super.m_8041_();
        }
    }

    class SalamanderMoveControl
    extends MoveControl {
        private final Mob parentEntity;

        public SalamanderMoveControl() {
            super((Mob)SalamanderEntity.this);
            this.parentEntity = SalamanderEntity.this;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d0 = vector3d.m_82553_();
                double width = this.parentEntity.m_20191_().m_82309_();
                Vec3 vector3d1 = vector3d.m_82490_(this.f_24978_ * 0.05 / d0);
                this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d1).m_82490_(0.95).m_82520_(0.0, -0.01, 0.0));
                if (d0 < width) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else if (d0 >= width) {
                    float yaw = -((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f;
                    this.parentEntity.m_146922_(Mth.m_14148_((float)this.parentEntity.m_146908_(), (float)yaw, (float)8.0f));
                }
            }
        }
    }
}

