/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.tensura.api.entity.ai.RandomFluidSwimmingGoal;
import com.github.manasmods.tensura.api.entity.ai.SemiAquaticFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.ai.UndergroundTargetingEntitiesGoal;
import com.github.manasmods.tensura.api.entity.subclass.ITensuraMount;
import com.github.manasmods.tensura.client.keybind.TensuraKeybinds;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.entity.GiantCodEntity;
import com.github.manasmods.tensura.entity.GiantSalmonEntity;
import com.github.manasmods.tensura.entity.template.SwimmingTamableEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.item.food.HealingPotionItem;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidType;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class SissieEntity
extends SwimmingTamableEntity
implements IAnimatable,
ITensuraMount,
HasCustomInventoryScreen,
PlayerRideableJumping {
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(SissieEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(SissieEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHESTED = SynchedEntityData.m_135353_(SissieEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int miscAnimationTicks = 0;
    public SimpleContainer inventory;
    public MenuProvider inventoryMenu;
    private boolean hasChestVarChanged = false;
    protected float playerJumpPendingScale;
    protected boolean playerJumping;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public SissieEntity(EntityType<? extends SissieEntity> type, Level level) {
        super((EntityType<? extends SwimmingTamableEntity>)type, level);
        this.initInventory();
        this.f_21364_ = 40;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 24.0).m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22278_, (double)0.4f).m_22268_(Attributes.f_22288_, 2.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new RandomFluidSwimmingGoal((PathfinderMob)this, 1.0, 8, fluidState -> fluidState.m_205070_(FluidTags.f_13131_)));
        this.f_21345_.m_25352_(4, (Goal)new SemiAquaticFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false, true));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new SissieJumpAttackGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new SissieAttackGoal(this, 2.0, true));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, new UndergroundTargetingEntitiesGoal<LivingEntity>(this, LivingEntity.class, false, 64.0f, this::shouldAttack));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    private boolean shouldAttack(LivingEntity entity) {
        if (entity.m_20096_()) {
            if (entity.m_20186_() - this.m_20186_() > 3.0) {
                return false;
            }
            if (this.m_20270_((Entity)entity) > 6.0f) {
                return false;
            }
        }
        if (entity instanceof Player) {
            return true;
        }
        if (entity instanceof Villager) {
            return true;
        }
        if (entity instanceof GiantCodEntity || entity instanceof GiantSalmonEntity) {
            return true;
        }
        if (entity instanceof Animal) {
            return !(entity instanceof SissieEntity);
        }
        return entity instanceof Guardian;
    }

    @Override
    protected boolean isJumper() {
        return true;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(SADDLED, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(CHESTED, (Object)Boolean.FALSE);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
        compound.m_128379_("Saddled", this.isSaddled());
        compound.m_128379_("Chested", this.isChested());
        if (this.inventory != null) {
            ListTag listTag = new ListTag();
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag CompoundNBT = new CompoundTag();
                CompoundNBT.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(CompoundNBT);
                listTag.add((Object)CompoundNBT);
            }
            compound.m_128365_("Items", (Tag)listTag);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
        this.setSaddled(compound.m_128471_("Saddled"));
        this.setChested(compound.m_128471_("Chested"));
        if (this.inventory != null) {
            ListTag listTag = compound.m_128437_("Items", 10);
            this.initInventory();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag CompoundNBT = listTag.m_128728_(i);
                int j = CompoundNBT.m_128445_("Slot") & 0xFF;
                this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)CompoundNBT));
            }
        } else {
            ListTag listTag = compound.m_128437_("Items", 10);
            this.initInventory();
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag CompoundNBT = listTag.m_128728_(i);
                int j = CompoundNBT.m_128445_("Slot") & 0xFF;
                this.initInventory();
                this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)CompoundNBT));
            }
        }
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        if (this.getMiscAnimation() != 0 && animation != 0) {
            return;
        }
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
    }

    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(SADDLED, (Object)saddled);
    }

    public boolean isChested() {
        return (Boolean)this.f_19804_.m_135370_(CHESTED);
    }

    public void setChested(boolean chested) {
        this.f_19804_.m_135381_(CHESTED, (Object)chested);
        this.hasChestVarChanged = true;
    }

    public boolean m_6898_(ItemStack pStack) {
        FoodProperties food = pStack.getFoodProperties((LivingEntity)this);
        return food != null && food.m_38746_();
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    @Override
    public boolean isPushedByFluid(FluidType type) {
        return type != ForgeMod.WATER_TYPE.get();
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19314_ || source == DamageSource.f_19325_ || source == DamageSource.f_19310_ || super.m_6673_(source);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        SissieEntity fish = (SissieEntity)((EntityType)TensuraEntityTypes.SISSIE.get()).m_20615_((Level)pLevel);
        if (fish == null) {
            return null;
        }
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            fish.m_21816_(uuid);
            fish.m_7105_(true);
        }
        return fish;
    }

    @Override
    public boolean shouldFollow() {
        if (this.getMiscAnimation() == 2) {
            return false;
        }
        return super.shouldFollow();
    }

    @Override
    public boolean shouldUseJumpAttack(LivingEntity target) {
        if (!this.isJumper()) {
            return false;
        }
        if (this.getMiscAnimation() >= 3) {
            return false;
        }
        if (this.jumpCooldown != 0) {
            return false;
        }
        if (target.m_20069_() || target.m_20202_() instanceof Boat) {
            return false;
        }
        Vec3 eye = target.m_146892_();
        Vec3 below = eye.m_82520_(0.0, -10.0, 0.0);
        return this.f_19853_.m_45547_(new ClipContext(eye, below, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_().equals((Object)HitResult.Type.MISS);
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = super.m_7327_(pEntity);
        if (flag && this.getMiscAnimation() == 0) {
            this.setMiscAnimation(1);
            this.m_5496_(SoundEvents.f_11865_, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getMiscAnimation() != 0) {
            boolean shouldStop;
            ++this.miscAnimationTicks;
            LivingEntity target = this.m_5448_();
            if (this.getMiscAnimation() >= 3 && (target != null || this.getMiscAnimation() == 5)) {
                float f = (float)this.m_21133_(Attributes.f_22281_);
                if (this.getMiscAnimation() == 3) {
                    f *= 1.5f;
                }
                if (target != null) {
                    this.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), this.m_21566_().m_24999_());
                    this.m_21563_().m_148051_((Entity)target);
                }
                double radius = this.getMiscAnimation() == 4 ? 1.0 : 0.0;
                AABB aabb = this.m_20191_().m_82383_(this.m_20252_(1.0f).m_82490_(this.m_6162_() ? 2.0 : 4.0)).m_82400_(radius);
                List list = this.m_9236_().m_6443_(LivingEntity.class, aabb, living -> !living.m_7306_((Entity)this) && living.m_20202_() != this && living.m_6084_());
                if (this.getMiscAnimation() == 3 || this.getMiscAnimation() == 5) {
                    for (LivingEntity living2 : list) {
                        living2.m_6469_(DamageSource.m_19370_((LivingEntity)this), f);
                        if (living2 != target) continue;
                        this.setMiscAnimation(0);
                    }
                } else if (this.getMiscAnimation() == 4) {
                    for (LivingEntity living2 : list) {
                        living2.m_6469_(DamageSource.m_19370_((LivingEntity)this), f);
                        if (living2 != target) continue;
                        this.setMiscAnimation(0);
                    }
                }
            }
            boolean bl = shouldStop = (this.getMiscAnimation() == 3 || this.getMiscAnimation() == 4) && target == null;
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation()) || shouldStop) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
        if (this.hasChestVarChanged && this.inventory != null && !this.isChested()) {
            for (int i = 3; i < 18; ++i) {
                if (this.inventory.m_8020_(i).m_41619_()) continue;
                if (!this.f_19853_.f_46443_) {
                    this.m_5552_(this.inventory.m_8020_(i), 1.0f);
                }
                this.inventory.m_8016_(i);
            }
            this.hasChestVarChanged = false;
        }
    }

    @Override
    protected void swimmingParticle() {
    }

    private int getAnimationTick(int miscAnimation) {
        if (miscAnimation == 5) {
            return 20;
        }
        if (miscAnimation > 2) {
            return 600;
        }
        if (miscAnimation == 2) {
            return 38;
        }
        return 9;
    }

    @Override
    public void mountAbility(Player rider) {
        if (this.getMiscAnimation() == 2) {
            return;
        }
        this.setMiscAnimation(5);
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof HealingPotionItem) {
            return super.m_6071_(player, hand);
        }
        InteractionResult eating = this.handleEating(player, hand, itemstack);
        if (eating.m_19077_()) {
            return eating;
        }
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (!this.m_6162_() && this.m_21830_((LivingEntity)player)) {
                Item item = itemstack.m_41720_();
                if (item.equals(TensuraMaterialItems.MONSTER_SADDLE.get()) && !this.isSaddled()) {
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.setSaddled(true);
                    this.m_5496_(SoundEvents.f_11811_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
                if (!this.isChested() && itemstack.m_204117_(Tags.Items.CHESTS_WOODEN) && (itemstack.m_41613_() >= 2 || player.m_150110_().f_35937_)) {
                    this.setChested(true);
                    this.m_5496_(SoundEvents.f_11811_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    if (!player.m_150110_().f_35937_) {
                        itemstack.m_41774_(2);
                    }
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
                if (this.isChested() && item.equals(Items.f_42574_)) {
                    this.m_5496_(SoundEvents.f_12344_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    this.m_19998_((ItemLike)Blocks.f_50087_);
                    this.m_19998_((ItemLike)Blocks.f_50087_);
                    for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                        this.m_19983_(this.inventory.m_8020_(i));
                    }
                    this.inventory.m_6211_();
                    this.setChested(false);
                    return InteractionResult.SUCCESS;
                }
                if (this.isSaddled() && item.equals(Items.f_42574_)) {
                    this.m_5496_(SoundEvents.f_12344_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    this.m_19998_((ItemLike)TensuraMaterialItems.MONSTER_SADDLE.get());
                    this.setSaddled(false);
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
            }
            if (this.m_21830_((LivingEntity)player) && (player.m_36341_() || !this.isSaddled() && !this.isChested())) {
                this.commanding(player);
            } else if (this.isSaddled() && (this.getControllingPassenger() != null || this.m_21830_((LivingEntity)player))) {
                if (this.m_21830_((LivingEntity)player)) {
                    this.m_21839_(false);
                    this.setWandering(false);
                }
                player.m_7998_((Entity)this, false);
            } else if (this.isChested()) {
                this.m_213583_(player);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public InteractionResult handleEating(Player pPlayer, InteractionHand hand, ItemStack itemstack) {
        if (this.m_6898_(itemstack)) {
            if (this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                this.m_8035_();
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            int i = this.m_146764_();
            if (!this.f_19853_.m_5776_() && i == 0 && this.m_5957_()) {
                this.m_142075_(pPlayer, hand, itemstack);
                this.m_27595_(pPlayer);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (this.m_6162_()) {
                this.m_142075_(pPlayer, hand, itemstack);
                this.m_8035_();
                this.m_146740_(SissieEntity.m_216967_((int)(-i)), true);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_8035_() {
        super.m_8035_();
        this.setMiscAnimation(1);
        this.m_5634_(5.0f);
    }

    private void initInventory() {
        SimpleContainer chest = this.inventory;
        this.inventory = new SimpleContainer(54){

            public boolean m_6542_(Player player) {
                return SissieEntity.this.m_6084_() && !SissieEntity.this.f_19817_;
            }
        };
        if (chest != null) {
            int i = Math.min(chest.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = chest.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
    }

    public void m_213583_(Player pPlayer) {
        if (!this.isChested()) {
            return;
        }
        if (this.inventory == null) {
            return;
        }
        pPlayer.m_5893_(this.getMenu());
        if (!pPlayer.f_19853_.f_46443_) {
            this.m_146852_(GameEvent.f_157803_, (Entity)pPlayer);
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (this.f_19853_.m_5776_()) {
            return;
        }
        if (this.inventory == null) {
            return;
        }
        if (this.m_6084_()) {
            return;
        }
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            this.m_5552_(itemstack, 0.0f);
        }
    }

    public MenuProvider getMenu() {
        if (this.inventoryMenu == null) {
            this.inventoryMenu = new MenuProvider(){

                public AbstractContainerMenu m_7208_(int menu, Inventory inventory, Player player) {
                    return new ChestMenu(MenuType.f_39962_, menu, inventory, (Container)SissieEntity.this.inventory, 6);
                }

                public Component m_5446_() {
                    return Component.m_237115_((String)"container.chest");
                }
            };
        }
        return this.inventoryMenu;
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.isSaddled() && !this.m_9236_().m_5776_()) {
            this.m_19998_((ItemLike)TensuraMaterialItems.MONSTER_SADDLE.get());
        }
        if (this.isChested()) {
            if (!this.f_19853_.f_46443_) {
                this.m_19998_((ItemLike)Blocks.f_50087_);
                this.m_19998_((ItemLike)Blocks.f_50087_);
                for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                    this.m_19983_(this.inventory.m_8020_(i));
                }
            }
            this.inventory.m_6211_();
            this.setChested(false);
        }
    }

    public boolean m_7132_() {
        return this.m_20160_();
    }

    public double getCustomJump() {
        return this.m_21133_(Attributes.f_22288_);
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        for (Entity passenger : this.m_20197_()) {
            Player player;
            if (!(passenger instanceof Player) || !(player = (Player)passenger).equals((Object)this.m_21826_())) continue;
            return player;
        }
        return null;
    }

    public double m_6048_() {
        return (double)this.m_6972_((Pose)Pose.STANDING).f_20378_ - 0.5;
    }

    public void m_7332_(Entity passenger) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        passenger.m_183634_();
        float radius = -1.0f;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double yOffset = this.m_20186_() + this.m_6048_() + passenger.m_6049_();
        switch (this.m_20197_().indexOf(passenger)) {
            default: {
                passenger.m_6034_(this.m_20185_() + extraX, yOffset, this.m_20189_() + extraZ);
                break;
            }
            case 1: {
                float yaw = this.m_146908_() * ((float)Math.PI / 180);
                float f3 = Mth.m_14031_((float)((float)((double)yaw + Math.toRadians(145.0))));
                float f = -Mth.m_14089_((float)((float)((double)yaw + Math.toRadians(145.0))));
                passenger.m_6034_(this.m_20185_() + extraX * 1.25 + (double)f3 * 1.5, yOffset, this.m_20189_() + extraZ * 1.25 + (double)f * 1.5);
                break;
            }
            case 2: {
                float yaw = this.m_146908_() * ((float)Math.PI / 180);
                float f3 = Mth.m_14031_((float)((float)((double)yaw + Math.toRadians(-145.0))));
                float f = -Mth.m_14089_((float)((float)((double)yaw + Math.toRadians(-145.0))));
                passenger.m_6034_(this.m_20185_() + extraX * 1.25 + (double)f3 * 1.5, yOffset, this.m_20189_() + extraZ * 1.25 + (double)f * 1.5);
            }
        }
    }

    public boolean m_7310_(Entity other) {
        return this.m_20197_().size() < 3;
    }

    public void m_7888_(int pJumpPower) {
        if (pJumpPower >= 90) {
            this.playerJumpPendingScale = 1.0f;
        } else {
            if (pJumpPower < 0) {
                pJumpPower = 0;
            }
            this.playerJumpPendingScale = 0.4f + 0.4f * (float)pJumpPower / 90.0f;
        }
    }

    public void m_7199_(int pJumpPower) {
        if (pJumpPower < 50) {
            return;
        }
        if (this.canJumpOutOfWater()) {
            this.setMiscAnimation(2);
        }
    }

    public void m_8012_() {
    }

    @Override
    public void m_7023_(Vec3 travelVector) {
        if (this.m_6084_()) {
            LivingEntity controller = this.getControllingPassenger();
            if (this.m_20160_() && controller != null) {
                this.m_146922_(controller.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(0.0f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = controller.f_20900_ * 0.5f;
                float f1 = controller.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.playerJumpPendingScale > 0.0f && this.canJumpOutOfWater() && !this.isPlayerJumping() && this.isInFluidType()) {
                    double d0 = this.getCustomJump() * (double)this.playerJumpPendingScale * (double)this.m_20098_();
                    double d1 = d0 + this.m_182332_();
                    Vec3 vec3 = this.m_20184_();
                    this.m_20334_(vec3.f_82479_, d1, vec3.f_82481_);
                    this.setPlayerJumping(true);
                    this.f_19812_ = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        float f3 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                        this.m_20256_(this.m_20184_().m_82520_((double)(-0.4f * f2 * this.playerJumpPendingScale), 0.0, (double)(0.4f * f3 * this.playerJumpPendingScale)));
                    }
                    this.playerJumpPendingScale = 0.0f;
                }
                this.f_20887_ = this.m_6113_() * 0.2f;
                if (this.m_6109_()) {
                    this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                    if (this.isInFluidType((fluidType, height) -> height > this.m_20204_()) && controller.f_20899_) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.07, 0.0));
                    } else if (this.isInFluidType() && TensuraKeybinds.MOUNT_DESCENDING.m_90857_()) {
                        this.descending((Entity)this, controller);
                    }
                    AttributeInstance instance = this.m_21204_().m_22146_((Attribute)ForgeMod.SWIM_SPEED.get());
                    if (instance != null) {
                        instance.m_22100_(controller.m_20142_() ? 10.0 : 8.0);
                    }
                    super.m_7023_(new Vec3((double)f, travelVector.f_82480_, (double)f1));
                } else if (controller instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.isInFluidType()) {
                    this.playerJumpPendingScale = 0.0f;
                    this.setPlayerJumping(false);
                }
                this.m_146872_();
            } else {
                AttributeInstance instance = this.m_21204_().m_22146_((Attribute)ForgeMod.SWIM_SPEED.get());
                if (instance != null && instance.m_22115_() != 1.0) {
                    instance.m_22100_(1.0);
                }
                this.f_20887_ = 0.04f;
                super.m_7023_(travelVector);
            }
        }
    }

    public int m_5792_() {
        return 1;
    }

    public static boolean checkSissieSpawnRules(EntityType<SissieEntity> type, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource source) {
        if (pos.m_123342_() > 30 && pos.m_123342_() < level.m_5736_()) {
            return level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
        }
        return false;
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return SpawnRateConfig.rollSpawn((Integer)SpawnRateConfig.INSTANCE.sissieSpawnRate.get(), this.m_217043_(), pSpawnReason) && super.m_5545_(pLevel, pSpawnReason);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (!this.isInFluidType()) {
            if (this.f_19853_.m_8055_(this.m_20183_().m_7495_()).m_60767_().m_76334_() || this.f_19853_.m_8055_(this.m_20183_().m_6625_(2)).m_60767_().m_76334_() && this.f_19853_.m_6425_(this.m_20183_().m_7495_()).m_76178_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sissie.flop", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (this.getMiscAnimation() != 2 && this.f_19853_.m_6425_(this.m_20183_().m_7495_()).m_76178_() && this.f_19853_.m_6425_(this.m_20183_().m_6625_(2)).m_76178_() && this.f_19853_.m_6425_(this.m_20183_().m_6625_(3)).m_76178_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sissie.fall", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.getMiscAnimation() == 3 || this.getMiscAnimation() == 5) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sissie.chase_bite", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.getMiscAnimation() == 4) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sissie.chase_thrash", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (event.isMoving()) {
            if (this.m_21660_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sissie.swim_fast", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sissie.swim", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sissie.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sissie.bite", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sissie.jump_attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean isPlayerJumping() {
        return this.playerJumping;
    }

    public void setPlayerJumping(boolean playerJumping) {
        this.playerJumping = playerJumping;
    }

    static class SissieJumpAttackGoal
    extends SwimmingTamableEntity.JumpAttackGoal {
        private final SissieEntity entity;

        public SissieJumpAttackGoal(SissieEntity entity) {
            super(entity);
            this.entity = entity;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            LivingEntity target = this.entity.m_5448_();
            if (target == null || this.entity.m_20275_(target.m_20185_(), this.entity.m_20186_(), target.m_20189_()) >= 150.0) {
                return;
            }
            this.entity.setMiscAnimation(2);
        }
    }

    static class SissieAttackGoal
    extends SwimmingTamableEntity.JumperMeleeAttackGoal {
        private SissieEntity entity;

        public SissieAttackGoal(SissieEntity entity, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super(entity, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.entity = entity;
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            if (!this.m_25564_()) {
                return;
            }
            int randomAttack = this.randomAttack(pDistToEnemySqr);
            if (randomAttack >= 3) {
                this.m_25563_();
                if (this.entity.getMiscAnimation() == 0) {
                    this.entity.setMiscAnimation(randomAttack);
                }
            } else if (pDistToEnemySqr <= this.m_6639_(pEnemy)) {
                this.m_25563_();
                if (this.entity.getMiscAnimation() == 0) {
                    this.entity.setMiscAnimation(randomAttack);
                }
                this.entity.m_7327_((Entity)pEnemy);
            }
        }

        protected int randomAttack(double distance) {
            if (distance >= 144.0 || this.entity.f_19796_.m_188503_(9) == 3) {
                if (this.entity.f_19796_.m_188503_(6) == 3) {
                    return 3;
                }
                if (this.entity.f_19796_.m_188503_(20) == 3) {
                    return 4;
                }
            }
            return 1;
        }

        protected double m_6639_(LivingEntity pAttackTarget) {
            return super.m_6639_(pAttackTarget) + 9.0;
        }
    }
}

