/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.earth.EarthSpikesMagic;
import com.github.manasmods.tensura.api.entity.ai.FlyingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.ai.TamableFollowParentGoal;
import com.github.manasmods.tensura.api.entity.ai.UndergroundTargetingEntitiesGoal;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.BeastGnomeEntity;
import com.github.manasmods.tensura.entity.human.HinataSakaguchiEntity;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.entity.magic.field.GravityField;
import com.github.manasmods.tensura.entity.magic.projectile.GravitySphereProjectile;
import com.github.manasmods.tensura.entity.template.GreaterSpiritEntity;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class WarGnomeEntity
extends GreaterSpiritEntity {
    public WarGnomeEntity(EntityType<? extends WarGnomeEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends GreaterSpiritEntity>)pEntityType, pLevel);
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.NOTCHED_20).m_7005_(true);
    }

    @Override
    protected void switchNavigator(boolean onLand) {
        this.f_21342_ = new TensuraTamableEntity.SleepMoveControl(){

            @Override
            public void m_8126_() {
                if (WarGnomeEntity.this.getMiscAnimation() == 3) {
                    return;
                }
                if (WarGnomeEntity.this.getMiscAnimation() == 4) {
                    return;
                }
                super.m_8126_();
            }
        };
        this.f_21344_ = new GroundPathNavigation((Mob)this, this.f_19853_);
        this.wasFlying = false;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22281_, 40.0).m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 3.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(4, (Goal)new WarGnomeAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new GreaterSpiritEntity.FollowHinataGoal(this, 1.0, HinataSakaguchiEntity.class));
        this.f_21345_.m_25352_(5, (Goal)new FlyingFollowOwnerGoal(this, 0.7, 10.0f, 4.0f, true, false));
        this.f_21345_.m_25352_(6, (Goal)new TamableFollowParentGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(7, (Goal)new GreaterSpiritEntity.WalkGoal(this, this));
        this.f_21345_.m_25352_(8, (Goal)new TensuraTamableEntity.FlyingWanderAroundPosGoal(this, this, 1.0, 12));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, WarGnomeEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, new UndergroundTargetingEntitiesGoal<LivingEntity>(this, LivingEntity.class, false, 8.0f, this::shouldAttack));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    public boolean usingMeleeWeapon() {
        return false;
    }

    @Override
    public EntityDimensions m_6972_(Pose pPose) {
        EntityDimensions entitydimensions = super.m_6972_(pPose);
        if (this.m_5803_()) {
            return entitydimensions.m_20390_(1.0f, 0.3f);
        }
        return entitydimensions;
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity target2;
        boolean hurt;
        Object damageSource;
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (pSource.m_7639_() instanceof BeastGnomeEntity) {
            return false;
        }
        pAmount = DamageSourceHelper.isNaturalEffects(pSource) ? (pAmount *= 0.2f) : (pAmount *= this.getPhysicalAttackInput(pSource));
        if (!this.m_21827_() && (this.getMiscAnimation() == 0 || this.getMiscAnimation() <= -2) && (double)this.f_19796_.m_188501_() <= 0.3) {
            int randomBlock = this.m_217043_().m_188503_(4);
            if (!(!DamageSourceHelper.isPhysicalAttack(pSource) || pSource.m_19378_() || pSource instanceof TensuraDamageSource && ((TensuraDamageSource)((Object)(damageSource = (TensuraDamageSource)pSource))).getIgnoreBarrier() >= 2.0f)) {
                Entity entity2 = pSource.m_7640_();
                if (entity2 instanceof LivingEntity) {
                    LivingEntity target2 = (LivingEntity)entity2;
                    if (randomBlock == 3) {
                        this.setMiscAnimation(-4);
                        SkillHelper.knockBack((LivingEntity)this, target2, 3.0f);
                    } else if (randomBlock == 2) {
                        this.setMiscAnimation(-3);
                        vec3 = new Vec3(target2.m_20185_() - this.m_20185_(), target2.m_20186_() - this.m_20186_() + 1.0, target2.m_20189_() - this.m_20189_()).m_82490_(1.0 / (double)target2.m_20270_((Entity)this));
                        target2.m_20256_(vec3.m_82541_().m_82490_(1.0));
                        target2.f_19812_ = true;
                        target2.f_19864_ = true;
                    } else {
                        this.setMiscAnimation(-2);
                    }
                } else {
                    Projectile target3;
                    vec3 = pSource.m_7640_();
                    if (vec3 instanceof Projectile && !((target3 = (Projectile)vec3) instanceof TensuraProjectile)) {
                        if (randomBlock == 3 || randomBlock == 2) {
                            this.setMiscAnimation(randomBlock == 3 ? -4 : -3);
                            vec3 = new Vec3(target3.m_20185_() - this.m_20185_(), target3.m_20186_() - this.m_20186_() + (randomBlock == 2 ? 2.0 : 0.5), target3.m_20189_() - this.m_20189_()).m_82490_(1.0 / (double)target3.m_20270_((Entity)this));
                            target3.m_20256_(vec3.m_82541_().m_82490_(2.0));
                            target3.f_19812_ = true;
                            target3.f_19864_ = true;
                        } else {
                            this.setMiscAnimation(-2);
                        }
                    } else if (randomBlock == 3) {
                        this.setMiscAnimation(-4);
                    } else if (randomBlock == 2) {
                        this.setMiscAnimation(-3);
                    } else {
                        this.setMiscAnimation(-2);
                    }
                }
                this.m_5496_(SoundEvents.f_12346_, 1.0f, 1.0f);
                return false;
            }
        }
        if ((hurt = super.m_6469_(pSource, pAmount)) && (target2 = pSource.m_7639_()) instanceof LivingEntity) {
            Player player;
            damageSource = (LivingEntity)target2;
            if (!damageSource.m_6084_()) {
                return true;
            }
            if (damageSource instanceof Player && ((player = (Player)damageSource).m_7500_() || player.m_5833_())) {
                return true;
            }
            List list = this.f_19853_.m_6443_(BeastGnomeEntity.class, this.m_20191_().m_82400_(32.0), entity -> !entity.m_21824_());
            if (!list.isEmpty()) {
                list.forEach(arg_0 -> WarGnomeEntity.lambda$hurt$2((LivingEntity)damageSource, arg_0));
            }
        }
        return hurt;
    }

    @Override
    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof BeastGnomeEntity) {
            BeastGnomeEntity gnome = (BeastGnomeEntity)entity;
            return gnome.m_21824_() == this.m_21824_();
        }
        if (entity instanceof WarGnomeEntity) {
            WarGnomeEntity gnome = (WarGnomeEntity)entity;
            return gnome.m_21824_() == this.m_21824_();
        }
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_()) {
            this.m_7311_(Math.min(60, this.m_20094_()));
        }
    }

    @Override
    protected void breakBlocks() {
        if (!this.m_21824_()) {
            this.breakBlocks((LivingEntity)this, 2.0f, false, 1, null, false);
        }
    }

    @Override
    protected void handleFlying() {
    }

    @Override
    protected void miscAnimationHandler() {
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (!this.m_9236_().m_5776_()) {
                if (this.getMiscAnimation() == 1 && this.miscAnimationTicks == 7) {
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                        this.m_7327_((Entity)target);
                    }
                    this.m_5496_(SoundEvents.f_12317_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                } else if (this.getMiscAnimation() == 2 && this.miscAnimationTicks == 7) {
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                        this.m_7327_((Entity)target);
                        Vec3 vec3 = new Vec3(target.m_20185_() - this.m_20185_(), target.m_20186_() - this.m_20186_() + 1.0, target.m_20189_() - this.m_20189_()).m_82490_(1.0 / (double)target.m_20270_((Entity)this));
                        target.m_20256_(vec3.m_82541_().m_82490_(2.0));
                        target.f_19812_ = true;
                        target.f_19864_ = true;
                    }
                    this.m_5496_(SoundEvents.f_11667_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                } else if (this.getMiscAnimation() == 3 && this.miscAnimationTicks == 12) {
                    this.stomp();
                    TensuraParticleHelper.spawnGroundSlamParticle((LivingEntity)this, 5, 2.5f);
                    TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_220844_.m_49966_()), this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), 55, 0.08, 0.08, 0.08, 0.15, true);
                    TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152537_.m_49966_()), this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), 55, 0.08, 0.08, 0.08, 0.15, true);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215778_, SoundSource.NEUTRAL, 5.0f, 1.0f);
                } else if (this.getMiscAnimation() == 4) {
                    this.m_21573_().m_26573_();
                    if (this.miscAnimationTicks >= 20 && this.miscAnimationTicks <= 45) {
                        this.gravitySphere();
                    } else {
                        this.setMagicID(0);
                    }
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    this.m_5496_(SoundEvents.f_11862_, 8.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                } else if (this.getMiscAnimation() == 5 && this.miscAnimationTicks == 15) {
                    this.m_21573_().m_26573_();
                    GravityField sphere = new GravityField(this.m_9236_(), (LivingEntity)this);
                    sphere.setLife(1200);
                    sphere.setRadius(10.0f);
                    sphere.m_146884_(this.m_20182_().m_82520_(0.0, -10.0, 0.0));
                    this.m_9236_().m_7967_((Entity)sphere);
                    this.m_5496_(SoundEvents.f_11868_, 8.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                } else if (this.getMiscAnimation() == 7) {
                    this.m_21573_().m_26573_();
                    switch (this.miscAnimationTicks) {
                        case 7: {
                            this.summonBeastGnome(3, 7);
                            break;
                        }
                        case 14: {
                            this.summonBeastGnome(5, 10);
                            break;
                        }
                        case 21: {
                            this.summonBeastGnome(7, 15);
                        }
                    }
                    this.m_5496_(SoundEvents.f_144135_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                }
            }
            if (this.miscAnimationTicks > this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            case -3 -> 10;
            case -2 -> 5;
            case -1 -> 200;
            case 1 -> 14;
            case 3 -> 20;
            case 4 -> 63;
            case 5, 7 -> 26;
            default -> 15;
        };
    }

    private void gravitySphere() {
        int ballId = this.getMagicID();
        if (ballId == 0) {
            GravitySphereProjectile sphere = new GravitySphereProjectile(this.f_19853_, (LivingEntity)this);
            sphere.setDamage((float)(this.m_21133_(Attributes.f_22281_) * 3.0));
            sphere.setSpiritAttack(true);
            sphere.setSize(0.5f);
            sphere.setMpCost(500.0);
            sphere.setSkill(SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)ExtraSkills.EARTH_MANIPULATION.get()).orElse(null));
            sphere.m_146884_(this.m_146892_().m_82520_(0.0, 4.0, 0.0));
            sphere.setOwnerOffset(new Vec3(0.0, 3.0, 0.0));
            sphere.setLookDistance(30.0f);
            sphere.setDelayTick(25);
            sphere.m_20242_(true);
            sphere.setMobEffect(new MobEffectInstance((MobEffect)TensuraMobEffects.BURDEN.get(), 100, 0, false, false, false));
            sphere.setEffectRange(3.0f);
            this.m_9236_().m_7967_((Entity)sphere);
            this.setMagicID(sphere.m_19879_());
        } else {
            Entity entity = this.m_9236_().m_6815_(ballId);
            if (!(entity instanceof GravitySphereProjectile)) {
                this.setMagicID(0);
                this.gravitySphere();
            } else {
                GravitySphereProjectile ball = (GravitySphereProjectile)entity;
                if (ball.getDelayTick() > 0) {
                    ball.setSize(ball.getSize() + 0.1f);
                }
            }
        }
        this.m_5496_(SoundEvents.f_12521_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
    }

    public void stomp() {
        double damageMultiplier = 1.5;
        float damage = (float)(this.m_21133_(Attributes.f_22281_) * damageMultiplier);
        ManasSkillInstance instance = SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)SpiritualMagics.EARTH_SPIKES.get());
        for (int i = 0; i < 10; ++i) {
            float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i;
            double extraX = 4.0f * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = 4.0f * Mth.m_14089_((float)angle);
            Vec3 groundPos = new Vec3((double)Mth.m_14107_((double)(this.m_20185_() + extraX)), this.m_20186_(), (double)Mth.m_14107_((double)(this.m_20189_() + extraZ)));
            EarthSpikesMagic.spawnSpikes(groundPos, (LivingEntity)this, instance, damage, 200.0);
        }
        AABB aabb = this.m_20191_().m_82400_(this.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()) + 10.0);
        List list = this.f_19853_.m_6443_(LivingEntity.class, aabb, this::shouldAttack);
        if (list.isEmpty()) {
            return;
        }
        TensuraDamageSource damageSource = DamageSourceHelper.addSkillAndCost(DamageSource.m_19370_((LivingEntity)this).m_19389_(), 100.0, SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)ExtraSkills.EARTH_MANIPULATION.get())).setNotTensuraMagic();
        for (LivingEntity target : list) {
            if (target.m_20270_((Entity)this) > 5.0f) {
                target.m_6469_((DamageSource)damageSource, damage / 1.5f);
            } else {
                target.m_6469_((DamageSource)damageSource, damage);
            }
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 1, false, false, false));
            target.m_20334_(0.0, 0.1, 0.0);
            SkillHelper.knockBack((LivingEntity)this, target, 2.0f);
        }
    }

    private void summonBeastGnome(int minRadius, int maxRadius) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        BeastGnomeEntity gnome = new BeastGnomeEntity((EntityType<? extends BeastGnomeEntity>)((EntityType)TensuraEntityTypes.BEAST_GNOME.get()), (Level)serverLevel);
        for (int l = 0; l < 50; ++l) {
            int i1 = i + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            int j1 = j + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            int k1 = k + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            gnome.m_6034_(i1, j1, k1);
            if (!serverLevel.m_45784_((Entity)gnome) || !serverLevel.m_45786_((Entity)gnome)) continue;
            gnome.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(gnome.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            gnome.m_6710_(this.m_5448_());
            serverLevel.m_47205_((Entity)gnome);
            gnome.setSummonerUUID(this.getSummonerUUID());
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)gnome, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_220844_.m_49966_()), 2.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)gnome, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152537_.m_49966_()), 2.0);
            break;
        }
    }

    @Override
    public MagicElemental getElemental() {
        return MagicElemental.EARTH;
    }

    @Override
    public Item getElementalCore() {
        return (Item)TensuraMaterialItems.ELEMENT_CORE_EARTH.get();
    }

    protected void m_6153_() {
        if (++this.f_20919_ >= 29) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_5496_(SoundEvents.f_11913_, 10.0f, 1.0f);
            this.spawnDeathParticles();
        }
    }

    @Override
    protected void spawnDeathParticles() {
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_220844_.m_49966_()));
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152537_.m_49966_()));
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_220844_.m_49966_()), 2.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152537_.m_49966_()), 2.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12476_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12008_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_5803_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.relax", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_21825_()) {
            if (this.getMiscAnimation() == -1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.idle_train", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.stay", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (event.isMoving() && this.getMiscAnimation() != 3 && this.getMiscAnimation() != 4 && !this.m_21525_()) {
            if (!this.m_20096_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == -4) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.block_fling_away", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == -3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.block_fling_up", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == -2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.block", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 1) {
                if (this.f_19796_.m_188499_()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.swing", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.swing2", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                }
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.shield_bash", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.stomp", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 4) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.sphere", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 5) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.summon", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 7) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.summon", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 8) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.war_gnome.death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    private static /* synthetic */ void lambda$hurt$2(LivingEntity damageSource, BeastGnomeEntity gnome) {
        gnome.m_6710_(damageSource);
    }

    static class WarGnomeAttackGoal
    extends MeleeAttackGoal {
        public final WarGnomeEntity gnome;

        public WarGnomeAttackGoal(WarGnomeEntity beast) {
            super((PathfinderMob)beast, 2.0, true);
            this.gnome = beast;
        }

        public boolean m_8036_() {
            if (this.gnome.m_21827_()) {
                return false;
            }
            return super.m_8036_();
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(pEnemy);
            if (this.gnome.getMiscAnimation() <= 1) {
                double attackRange;
                int randomAttack = this.randomAttack(d0);
                switch (randomAttack) {
                    case 4: 
                    case 7: {
                        double d = 1000.0;
                        break;
                    }
                    case 3: {
                        double d = 100.0;
                        break;
                    }
                    default: {
                        double d = attackRange = d0;
                    }
                }
                if (pDistToEnemySqr <= attackRange && this.m_25564_()) {
                    this.m_25563_();
                    this.gnome.setMiscAnimation(randomAttack);
                }
            }
        }

        private boolean canSummonGnomes() {
            if (this.gnome.m_21824_()) {
                return false;
            }
            List list = this.gnome.f_19853_.m_45971_(BeastGnomeEntity.class, TargetingConditions.m_148353_().m_26883_(30.0).m_148355_().m_26893_(), (LivingEntity)this.gnome, this.gnome.m_20191_().m_82400_(30.0));
            if (!list.isEmpty()) {
                for (BeastGnomeEntity entity : list) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.RAMPAGE.get(), 200, 0, false, false, false));
                }
            }
            return list.size() < 2;
        }

        protected int randomAttack(double distance) {
            if (distance < 12.0 || (double)this.gnome.m_217043_().m_188501_() <= 0.2) {
                if ((double)this.gnome.m_217043_().m_188501_() <= 0.2) {
                    return 3;
                }
                if ((double)this.gnome.m_217043_().m_188501_() <= 0.1) {
                    return 5;
                }
            }
            if (distance > 20.0 && (double)this.gnome.m_217043_().m_188501_() <= 0.3 || (double)this.gnome.m_217043_().m_188501_() <= 0.1) {
                return 4;
            }
            if ((double)this.gnome.m_217043_().m_188501_() <= 0.2) {
                return 2;
            }
            if ((double)this.gnome.m_217043_().m_188501_() <= 0.01 && this.canSummonGnomes()) {
                return 7;
            }
            return 1;
        }
    }
}

