/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client;

import com.github.manasmods.tensura.entity.HellCaterpillarEntity;
import com.github.manasmods.tensura.entity.client.HellCaterpillarModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;

public class HellCaterpillarRenderer
extends GeoEntityRenderer<HellCaterpillarEntity> {
    public HellCaterpillarRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (AnimatedGeoModel)new HellCaterpillarModel());
        this.f_114477_ = 0.3f;
    }

    public ResourceLocation getTextureLocation(HellCaterpillarEntity instance) {
        if (instance.getCocoonType() == 1) {
            return new ResourceLocation("tensura", "textures/entity/hell_moth_line/gehenna_caterpillar.png");
        }
        return new ResourceLocation("tensura", "textures/entity/hell_moth_line/hell_caterpillar.png");
    }

    public RenderType getRenderType(HellCaterpillarEntity hellCaterpillar, float partialTicks, PoseStack stack, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        if (hellCaterpillar.m_6162_()) {
            stack.m_85841_(0.3f, 0.3f, 0.3f);
        } else {
            stack.m_85841_(0.6f, 0.6f, 0.6f);
        }
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(hellCaterpillar));
    }

    private Direction rotate(Direction attachmentFacing) {
        return attachmentFacing.m_122434_() == Direction.Axis.Y ? Direction.UP : attachmentFacing;
    }

    private void rotateForAngle(PoseStack matrixStackIn, Direction rotate, float f) {
        if (rotate.m_122434_() != Direction.Axis.Y) {
            matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(90.0f * f));
        }
        switch (rotate) {
            case DOWN: 
            case NORTH: {
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f * f));
                break;
            }
            case UP: 
            case SOUTH: {
                break;
            }
            case WEST: {
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(90.0f * f));
                break;
            }
            case EAST: {
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f * f));
            }
        }
    }

    protected void applyRotations(HellCaterpillarEntity entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        if (entityLiving.m_20159_()) {
            super.applyRotations((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
            return;
        }
        float trans = entityLiving.m_6162_() ? 0.2f : 0.4f;
        Pose pose = entityLiving.m_20089_();
        if (pose != Pose.SLEEPING && !entityLiving.hasStartedCocoon() && !entityLiving.isCocooned()) {
            float progress = (entityLiving.prevAttachChangeProgress + (entityLiving.attachChangeProgress - entityLiving.prevAttachChangeProgress) * partialTicks) * 0.2f;
            float yawMul = 0.0f;
            if (entityLiving.prevAttachDir == entityLiving.getAttachmentFacing() && entityLiving.getAttachmentFacing().m_122434_() == Direction.Axis.Y) {
                yawMul = 1.0f;
            }
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - yawMul * rotationYaw));
            matrixStackIn.m_85837_(0.0, (double)trans, 0.0);
            float prevProgress = 1.0f - progress;
            this.rotateForAngle(matrixStackIn, this.rotate(entityLiving.prevAttachDir), prevProgress);
            this.rotateForAngle(matrixStackIn, this.rotate(entityLiving.getAttachmentFacing()), progress);
            if (entityLiving.getAttachmentFacing() != Direction.DOWN) {
                matrixStackIn.m_85837_(0.0, (double)trans, 0.0);
                if (entityLiving.m_20184_().f_82480_ <= (double)-0.001f) {
                    matrixStackIn.m_85845_(Vector3f.f_122224_.m_122240_(180.0f * progress));
                }
                matrixStackIn.m_85837_(0.0, (double)(-trans), 0.0);
            }
            matrixStackIn.m_85837_(0.0, (double)(-trans), 0.0);
        }
        if (entityLiving.f_20919_ > 0) {
            float f = ((float)entityLiving.f_20919_ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(f * 90.0f));
        } else if (entityLiving.m_8077_() && pose != Pose.SLEEPING) {
            String s = ChatFormatting.m_126649_((String)entityLiving.m_7755_().getString());
            if ("Dinnerbone".equals(s)) {
                matrixStackIn.m_85837_(0.0, (double)(entityLiving.m_20206_() + 0.1f), 0.0);
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            }
        } else if (pose != Pose.SLEEPING && (entityLiving.hasStartedCocoon() || entityLiving.isCocooned())) {
            matrixStackIn.m_85837_(0.0, (double)(entityLiving.m_20206_() + 0.1f), 0.0);
            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        }
    }
}

