/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client;

import com.github.manasmods.tensura.entity.KnightSpiderEntity;
import com.github.manasmods.tensura.entity.client.KnightSpiderRenderer;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class KnightSpiderModel
extends AnimatedGeoModel<KnightSpiderEntity> {
    public ResourceLocation getModelResource(KnightSpiderEntity object) {
        return new ResourceLocation("tensura", "geo/knight_spider.geo.json");
    }

    public ResourceLocation getTextureResource(KnightSpiderEntity instance) {
        return KnightSpiderRenderer.getSpiderTexture(instance);
    }

    public ResourceLocation getAnimationResource(KnightSpiderEntity moth) {
        return new ResourceLocation("tensura", "animations/knight_spider.animation.json");
    }

    public void setCustomAnimations(KnightSpiderEntity spider, int instanceId, AnimationEvent customPredicate) {
        super.setCustomAnimations((IAnimatable)spider, instanceId, customPredicate);
        IBone saddle = this.getAnimationProcessor().getBone("Saddle");
        if (spider.isSaddled() == saddle.isHidden()) {
            saddle.setHidden(!spider.isSaddled());
        }
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        IBone head = this.getAnimationProcessor().getBone("Head");
        if (head != null) {
            head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }
}

