/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client;

import com.github.manasmods.tensura.entity.LizardmanEntity;
import com.github.manasmods.tensura.entity.client.LizardmanModel;
import com.github.manasmods.tensura.entity.variant.LizardmanVariant;
import com.github.manasmods.tensura.item.custom.TempestScaleShieldItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.ExtendedGeoEntityRenderer;

public class LizardmanRenderer
extends ExtendedGeoEntityRenderer<LizardmanEntity> {
    protected ItemStack mainHandItem;
    protected ItemStack offHandItem;
    protected ItemStack helmetItem;
    protected ItemStack chestplateItem;
    protected ItemStack leggingsItem;
    protected ItemStack bootsItem;

    public LizardmanRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (AnimatedGeoModel)new LizardmanModel());
        this.f_114477_ = 0.2f;
    }

    public ResourceLocation getTextureLocation(LizardmanEntity instance) {
        return LizardmanVariant.LOCATION_BY_VARIANT.get((Object)instance.getVariant());
    }

    public void renderEarly(LizardmanEntity lizardman, PoseStack poseStack, float partialTick, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float partialTicks) {
        super.renderEarly((LivingEntity)lizardman, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlay, red, green, blue, partialTicks);
        this.mainHandItem = lizardman.m_6844_(EquipmentSlot.MAINHAND);
        this.offHandItem = lizardman.m_6844_(EquipmentSlot.OFFHAND);
        this.helmetItem = lizardman.m_6844_(EquipmentSlot.HEAD);
        this.chestplateItem = lizardman.m_6844_(EquipmentSlot.CHEST);
        this.leggingsItem = lizardman.m_6844_(EquipmentSlot.LEGS);
        this.bootsItem = lizardman.m_6844_(EquipmentSlot.FEET);
        if (lizardman.m_6162_()) {
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        }
    }

    protected ItemStack getHeldItemForBone(String boneName, LizardmanEntity currentEntity) {
        return switch (boneName) {
            case "leftItem" -> {
                if (currentEntity.m_21526_()) {
                    yield this.mainHandItem;
                }
                yield this.offHandItem;
            }
            case "rightItem" -> {
                if (currentEntity.m_21526_()) {
                    yield this.offHandItem;
                }
                yield this.mainHandItem;
            }
            default -> null;
        };
    }

    protected ItemTransforms.TransformType getCameraTransformForItemAtBone(ItemStack boneItem, String boneName) {
        return switch (boneName) {
            case "leftItem", "rightItem" -> ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            default -> ItemTransforms.TransformType.NONE;
        };
    }

    protected void preRenderItem(PoseStack stack, ItemStack item, String boneName, LizardmanEntity currentEntity, IBone bone) {
        if (item == this.mainHandItem) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            if (item.m_41720_() instanceof ShieldItem || item.m_41720_() instanceof TempestScaleShieldItem) {
                stack.m_85837_(0.0, 0.0, -0.25);
            }
        } else if (item == this.offHandItem) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            if (item.m_41720_() instanceof ShieldItem || item.m_41720_() instanceof TempestScaleShieldItem) {
                stack.m_85837_(0.0, 0.0, 0.25);
                stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            }
        }
    }

    protected void postRenderItem(PoseStack matrixStack, ItemStack item, String boneName, LizardmanEntity currentEntity, IBone bone) {
    }

    protected ItemStack getArmorForBone(String boneName, LizardmanEntity currentEntity) {
        return switch (boneName) {
            case "leftBootArmor", "rightBootArmor" -> this.bootsItem;
            case "leftLegArmor", "rightLegArmor" -> this.leggingsItem;
            case "bodyArmor", "rightArmArmor", "leftArmArmor" -> this.chestplateItem;
            case "headArmor" -> this.helmetItem;
            default -> null;
        };
    }

    protected EquipmentSlot getEquipmentSlotForArmorBone(String boneName, LizardmanEntity currentEntity) {
        return switch (boneName) {
            case "leftBootArmor", "rightBootArmor" -> EquipmentSlot.FEET;
            case "leftLegArmor", "rightLegArmor" -> EquipmentSlot.LEGS;
            case "rightArmArmor" -> {
                if (!currentEntity.m_21526_()) {
                    yield EquipmentSlot.MAINHAND;
                }
                yield EquipmentSlot.OFFHAND;
            }
            case "leftArmArmor" -> {
                if (currentEntity.m_21526_()) {
                    yield EquipmentSlot.MAINHAND;
                }
                yield EquipmentSlot.OFFHAND;
            }
            case "bodyArmor" -> EquipmentSlot.CHEST;
            case "headArmor" -> EquipmentSlot.HEAD;
            default -> null;
        };
    }

    protected ModelPart getArmorPartForBone(String name, HumanoidModel<?> armorModel) {
        return switch (name) {
            case "leftBootArmor", "leftLegArmor" -> armorModel.f_102814_;
            case "rightBootArmor", "rightLegArmor" -> armorModel.f_102813_;
            case "rightArmArmor" -> armorModel.f_102811_;
            case "leftArmArmor" -> armorModel.f_102812_;
            case "bodyArmor" -> armorModel.f_102810_;
            case "headArmor" -> armorModel.f_102808_;
            default -> null;
        };
    }

    protected BlockState getHeldBlockForBone(String boneName, LizardmanEntity currentEntity) {
        return null;
    }

    protected void preRenderBlock(PoseStack stack, BlockState block, String boneName, LizardmanEntity currentEntity) {
    }

    protected void postRenderBlock(PoseStack stack, BlockState block, String boneName, LizardmanEntity currentEntity) {
    }

    protected ResourceLocation getTextureForBone(String boneName, LizardmanEntity animatable) {
        return null;
    }

    protected boolean isArmorBone(GeoBone bone) {
        return bone.getName().endsWith("Armor");
    }
}

