/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client;

import com.github.manasmods.tensura.entity.SylphideEntity;
import com.github.manasmods.tensura.entity.client.SylphideModel;
import com.github.manasmods.tensura.item.custom.TempestScaleShieldItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.ExtendedGeoEntityRenderer;

public class SylphideRenderer
extends ExtendedGeoEntityRenderer<SylphideEntity> {
    protected ItemStack mainHandItem;
    protected ItemStack offHandItem;

    public SylphideRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (AnimatedGeoModel)new SylphideModel());
        this.f_114477_ = 0.5f;
    }

    protected float getDeathMaxRotation(SylphideEntity animatable) {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(SylphideEntity instance) {
        return SylphideRenderer.getSylphideTexture(instance);
    }

    public static ResourceLocation getSylphideTexture(SylphideEntity instance) {
        if (instance.m_7770_() != null && instance.m_7770_().getString().equalsIgnoreCase("misa")) {
            return new ResourceLocation("tensura", "textures/entity/sylphide/sylphide_goth.png");
        }
        return new ResourceLocation("tensura", "textures/entity/sylphide/sylphide.png");
    }

    public void renderEarly(SylphideEntity sylphide, PoseStack poseStack, float partialTick, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float partialTicks) {
        super.renderEarly((LivingEntity)sylphide, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlay, red, green, blue, partialTicks);
        this.mainHandItem = sylphide.m_6844_(EquipmentSlot.MAINHAND);
        this.offHandItem = sylphide.m_6844_(EquipmentSlot.OFFHAND);
    }

    protected ItemStack getHeldItemForBone(String boneName, SylphideEntity currentEntity) {
        return switch (boneName) {
            case "LeftItem" -> {
                if (currentEntity.m_21526_()) {
                    yield this.mainHandItem;
                }
                yield this.offHandItem;
            }
            case "RightItem" -> {
                if (currentEntity.m_21526_()) {
                    yield this.offHandItem;
                }
                yield this.mainHandItem;
            }
            default -> null;
        };
    }

    protected ItemTransforms.TransformType getCameraTransformForItemAtBone(ItemStack boneItem, String boneName) {
        return switch (boneName) {
            case "LeftItem", "RightItem" -> ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            default -> ItemTransforms.TransformType.NONE;
        };
    }

    protected void preRenderItem(PoseStack stack, ItemStack item, String boneName, SylphideEntity currentEntity, IBone bone) {
        if (item == this.mainHandItem) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            if (item.m_41720_() instanceof ShieldItem || item.m_41720_() instanceof TempestScaleShieldItem) {
                stack.m_85837_(0.0, 0.0, -0.25);
            }
        } else if (item == this.offHandItem) {
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            if (item.m_41720_() instanceof ShieldItem || item.m_41720_() instanceof TempestScaleShieldItem) {
                stack.m_85837_(0.0, 0.0, 0.25);
                stack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            }
        }
    }

    protected void postRenderItem(PoseStack matrixStack, ItemStack item, String boneName, SylphideEntity currentEntity, IBone bone) {
    }

    protected ItemStack getArmorForBone(String boneName, SylphideEntity currentEntity) {
        return null;
    }

    protected EquipmentSlot getEquipmentSlotForArmorBone(String boneName, SylphideEntity currentEntity) {
        return null;
    }

    protected ModelPart getArmorPartForBone(String name, HumanoidModel<?> armorModel) {
        return null;
    }

    protected BlockState getHeldBlockForBone(String boneName, SylphideEntity currentEntity) {
        return null;
    }

    protected void preRenderBlock(PoseStack stack, BlockState block, String boneName, SylphideEntity currentEntity) {
    }

    protected void postRenderBlock(PoseStack stack, BlockState block, String boneName, SylphideEntity currentEntity) {
    }

    protected ResourceLocation getTextureForBone(String boneName, SylphideEntity animatable) {
        return null;
    }

    protected boolean isArmorBone(GeoBone bone) {
        return bone.getName().endsWith("Armor");
    }
}

