/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client.beam;

import com.github.manasmods.tensura.entity.magic.beam.BeamProjectile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BeamProjectileRenderer
extends EntityRenderer<BeamProjectile> {
    public BeamProjectileRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    @NotNull
    public ResourceLocation getTextureLocation(BeamProjectile instance) {
        ResourceLocation[] resourceLocations = instance.getTextureLocation();
        if (resourceLocations == null) {
            return BeaconRenderer.f_112102_;
        }
        return Arrays.stream(resourceLocations).toList().get(instance.f_19797_ % resourceLocations.length);
    }

    public void render(BeamProjectile beam, float pEntityYaw, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        double collidePosX = Mth.m_14139_((double)pPartialTick, (double)beam.prevCollidePosX, (double)beam.collidePosX);
        double collidePosY = Mth.m_14139_((double)pPartialTick, (double)beam.prevCollidePosY, (double)beam.collidePosY);
        double collidePosZ = Mth.m_14139_((double)pPartialTick, (double)beam.prevCollidePosZ, (double)beam.collidePosZ);
        Vec3 collisionPos = new Vec3(collidePosX, collidePosY, collidePosZ);
        double posX = Mth.m_14139_((double)pPartialTick, (double)beam.f_19854_, (double)beam.m_20185_());
        double posY = Mth.m_14139_((double)pPartialTick, (double)beam.f_19855_, (double)beam.m_20186_());
        double posZ = Mth.m_14139_((double)pPartialTick, (double)beam.f_19856_, (double)beam.m_20189_());
        Vec3 startPos = new Vec3(posX, posY, posZ);
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.0, (double)(beam.m_20206_() / 2.0f), 0.0);
        beam.startParticles(startPos);
        Vec3 offSetToTarget = collisionPos.m_82546_(startPos);
        for (int i = 1; i < Mth.m_14107_((double)offSetToTarget.m_82553_()) - 1; ++i) {
            beam.rayParticles(startPos.m_82549_(offSetToTarget.m_82541_().m_82490_((double)i)), i);
        }
        this.renderRays(beam, startPos, collisionPos, pPartialTick, pPoseStack, pBuffer, pPackedLight);
        beam.hitParticles(collidePosX, collidePosY, collidePosZ);
        pPoseStack.m_85849_();
    }

    public void renderRays(BeamProjectile beam, Vec3 startPos, Vec3 collidePos, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        for (Map.Entry<Color, Float> entry : beam.beamColorAndSize.entrySet()) {
            this.renderRay(beam, startPos, collidePos, pPartialTick, pPoseStack, pBuffer, pPackedLight, entry.getValue().floatValue() * beam.getVisualSize(), entry.getKey().getRed(), entry.getKey().getGreen(), entry.getKey().getBlue(), entry.getKey().getAlpha());
        }
    }

    public void renderRay(BeamProjectile beam, Vec3 start, Vec3 end, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float size, int red, int green, int blue, int alpha) {
        float gloveHalfWidth = beam.m_20205_() / 2.0f;
        float xDist = (float)(end.m_7096_() - start.m_7096_());
        float yDist = (float)(end.m_7098_() - start.m_7098_() - (double)gloveHalfWidth);
        float zDist = (float)(end.m_7094_() - start.m_7094_());
        float f = Mth.m_14116_((float)(xDist * xDist + zDist * zDist));
        float f1 = Mth.m_14116_((float)(xDist * xDist + yDist * yDist + zDist * zDist));
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gloveHalfWidth, 0.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122270_((float)(-Math.atan2(zDist, xDist)) - 1.5707964f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122270_((float)(-Math.atan2(f, yDist)) - 1.5707964f));
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)this.getTextureLocation(beam)));
        float f2 = 0.0f - ((float)beam.f_19797_ + partialTick) * 0.01f;
        float f3 = f1 / 32.0f - ((float)beam.f_19797_ + partialTick) * 0.01f;
        int k = beam.f_19797_ % 16;
        if (k > 8) {
            k = 8 + (k - 8) * -1;
        }
        int i = 8 + k;
        float f4 = 0.0f;
        float f5 = 0.25f * size;
        float f6 = 0.0f;
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_85861_();
        Matrix3f matrix3f = pose.m_85864_();
        for (int j = 0; j <= i; ++j) {
            float f7 = Mth.m_14031_((float)((float)j * ((float)Math.PI * 2) / (float)i)) * size;
            float f8 = Mth.m_14089_((float)((float)j * ((float)Math.PI * 2) / (float)i)) * size;
            float f9 = (float)j / (float)i * size;
            vertexConsumer.m_85982_(matrix4f, f4, f5, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(f6, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_85982_(matrix4f, f4, f5, f1).m_6122_(red, green, blue, alpha).m_7421_(f6, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_85982_(matrix4f, f7, f8, f1).m_6122_(red, green, blue, alpha).m_7421_(f9, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_85982_(matrix4f, f7, f8, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(f9, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        poseStack.m_85849_();
    }
}

