/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client.layer;

import com.github.manasmods.tensura.entity.GoblinEntity;
import com.github.manasmods.tensura.entity.client.player.PlayerLikeModel;
import com.github.manasmods.tensura.entity.variant.GoblinVariant;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;

public class GoblinLayer {
    public static final LayerDefinition FACE_LAYER = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.01f), (float)0.0f), (int)64, (int)64);
    public static final LayerDefinition HAIR_HEAD_LAYER = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.02f), (float)0.0f), (int)64, (int)64);
    public static final LayerDefinition HAIR_BODY_LAYER = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.45f), (float)0.0f), (int)64, (int)64);
    public static final LayerDefinition CLOTHING_LAYER = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.27f), (float)0.0f), (int)64, (int)64);
    public static final LayerDefinition BANDAGES_LAYER = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.3f), (float)0.0f), (int)64, (int)64);
    public static final LayerDefinition HEAD_LAYER = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.5f), (float)0.0f), (int)64, (int)64);
    public static final LayerDefinition TOP_LAYER = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f), (int)64, (int)64);
    public static final LayerDefinition BOTTOM_LAYER = LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.35f), (float)0.0f), (int)64, (int)64);

    private static void renderWithColor(HumanoidModel model, PoseStack pMatrixStack, VertexConsumer vertexconsumer, int pPackedLight, int i) {
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        model.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, f, f1, f2, 1.0f);
    }

    private static RenderType getRenderType(ResourceLocation texture) {
        return RenderType.m_110473_((ResourceLocation)texture);
    }

    public static class Bottom<T extends GoblinEntity>
    extends RenderLayer<T, HumanoidModel<T>> {
        public static ModelLayerLocation BOTTOM = new ModelLayerLocation(new ResourceLocation("tensura", "goblin_bottom"), "main");
        private final HumanoidModel<T> model = new HumanoidModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(BOTTOM)){

            protected Iterable<ModelPart> m_5607_() {
                return ImmutableList.of();
            }
        };

        public Bottom(RenderLayerParent pRenderer) {
            super(pRenderer);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T entity, float pLimbSwing, float pLimbSwingAmount, float partialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (!((GoblinEntity)entity).isHobgoblin()) {
                return;
            }
            if (!entity.m_6844_(EquipmentSlot.LEGS).m_41619_()) {
                return;
            }
            HumanoidModel<T> model = this.model();
            model.m_6839_(entity, pLimbSwing, pLimbSwingAmount, partialTicks);
            ((HumanoidModel)this.m_117386_()).m_102872_(model);
            VertexConsumer vertexconsumer = pBuffer.m_6299_(GoblinLayer.getRenderType(this.getBottomTexture(entity)));
            model.m_6973_(entity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            PlayerLikeModel.sittingPose(entity, model);
            GoblinLayer.renderWithColor(model, pMatrixStack, vertexconsumer, pPackedLight, ((GoblinEntity)entity).getBottomColor());
        }

        protected HumanoidModel<T> model() {
            return this.model;
        }

        private ResourceLocation getBottomTexture(T entity) {
            return GoblinVariant.Bottom.getTextureLocation(entity);
        }
    }

    public static class Top<T extends GoblinEntity>
    extends RenderLayer<T, HumanoidModel<T>> {
        public static ModelLayerLocation TOP = new ModelLayerLocation(new ResourceLocation("tensura", "goblin_top"), "main");
        private final HumanoidModel<T> model = new HumanoidModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(TOP)){

            protected Iterable<ModelPart> m_5607_() {
                return ImmutableList.of();
            }
        };

        public Top(RenderLayerParent pRenderer) {
            super(pRenderer);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T entity, float pLimbSwing, float pLimbSwingAmount, float partialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (!((GoblinEntity)entity).isHobgoblin()) {
                return;
            }
            HumanoidModel<T> model = this.model();
            model.m_6839_(entity, pLimbSwing, pLimbSwingAmount, partialTicks);
            ((HumanoidModel)this.m_117386_()).m_102872_(model);
            VertexConsumer vertexconsumer = pBuffer.m_6299_(GoblinLayer.getRenderType(this.getTopTexture(entity)));
            model.m_6973_(entity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            PlayerLikeModel.sittingPose(entity, model);
            GoblinLayer.renderWithColor(model, pMatrixStack, vertexconsumer, pPackedLight, ((GoblinEntity)entity).getTopColor());
        }

        protected HumanoidModel<T> model() {
            return this.model;
        }

        private ResourceLocation getTopTexture(T entity) {
            return GoblinVariant.Top.getTextureLocation(entity);
        }
    }

    public static class Head<T extends GoblinEntity>
    extends RenderLayer<T, HumanoidModel<T>> {
        public static ModelLayerLocation HEAD = new ModelLayerLocation(new ResourceLocation("tensura", "goblin_head"), "main");
        private final HumanoidModel<T> model = new HumanoidModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(HEAD)){

            protected Iterable<ModelPart> m_5608_() {
                return ImmutableList.of();
            }
        };

        public Head(RenderLayerParent pRenderer) {
            super(pRenderer);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T entity, float pLimbSwing, float pLimbSwingAmount, float partialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (!((GoblinEntity)entity).isHobgoblin()) {
                return;
            }
            if ((Integer)entity.m_20088_().m_135370_(GoblinEntity.HEAD) == -1) {
                return;
            }
            if (!entity.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                return;
            }
            HumanoidModel<T> model = this.model();
            model.m_6839_(entity, pLimbSwing, pLimbSwingAmount, partialTicks);
            ((HumanoidModel)this.m_117386_()).m_102872_(model);
            VertexConsumer vertexconsumer = pBuffer.m_6299_(GoblinLayer.getRenderType(this.getHeadTexture(entity)));
            model.m_6973_(entity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            GoblinLayer.renderWithColor(model, pMatrixStack, vertexconsumer, pPackedLight, ((GoblinEntity)entity).getHeadColor());
        }

        protected HumanoidModel<T> model() {
            return this.model;
        }

        private ResourceLocation getHeadTexture(T entity) {
            return GoblinVariant.Head.getTextureLocation(entity);
        }
    }

    public static class Bandages<T extends GoblinEntity>
    extends RenderLayer<T, HumanoidModel<T>> {
        public static ModelLayerLocation BANDAGES = new ModelLayerLocation(new ResourceLocation("tensura", "goblin_bandages"), "main");
        private final HumanoidModel<T> model = new HumanoidModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(BANDAGES)){

            protected Iterable<ModelPart> m_5607_() {
                return ImmutableList.of();
            }
        };

        public Bandages(RenderLayerParent pRenderer) {
            super(pRenderer);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T entity, float pLimbSwing, float pLimbSwingAmount, float partialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (!((GoblinEntity)entity).hasBandages()) {
                return;
            }
            HumanoidModel<T> model = this.model();
            model.m_6839_(entity, pLimbSwing, pLimbSwingAmount, partialTicks);
            ((HumanoidModel)this.m_117386_()).m_102872_(model);
            VertexConsumer vertexconsumer = pBuffer.m_6299_(GoblinLayer.getRenderType(this.getBandagesTexture()));
            model.m_6973_(entity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            PlayerLikeModel.sittingPose(entity, model);
            model.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 0.8f, 0.8f, 0.8f, 1.0f);
        }

        protected HumanoidModel<T> model() {
            return this.model;
        }

        private ResourceLocation getBandagesTexture() {
            return new ResourceLocation("tensura", "textures/entity/goblin/unisex/bandages.png");
        }
    }

    public static class Clothing<T extends GoblinEntity>
    extends RenderLayer<T, HumanoidModel<T>> {
        public static ModelLayerLocation CLOTHING = new ModelLayerLocation(new ResourceLocation("tensura", "goblin_clothing"), "main");
        private final HumanoidModel<T> model = new HumanoidModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(CLOTHING)){

            protected Iterable<ModelPart> m_5607_() {
                return ImmutableList.of();
            }
        };

        public Clothing(RenderLayerParent pRenderer) {
            super(pRenderer);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T entity, float pLimbSwing, float pLimbSwingAmount, float partialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            HumanoidModel<T> model = this.model();
            model.m_6839_(entity, pLimbSwing, pLimbSwingAmount, partialTicks);
            ((HumanoidModel)this.m_117386_()).m_102872_(model);
            VertexConsumer vertexconsumer = pBuffer.m_6299_(GoblinLayer.getRenderType(this.getClothingTexture(entity)));
            model.m_6973_(entity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            PlayerLikeModel.sittingPose(entity, model);
            model.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 0.8f, 0.8f, 0.8f, 1.0f);
        }

        protected HumanoidModel<T> model() {
            return this.model;
        }

        private ResourceLocation getClothingTexture(T entity) {
            return GoblinVariant.Clothing.getTextureLocation(entity);
        }
    }

    public static class HairBody<T extends GoblinEntity>
    extends RenderLayer<T, HumanoidModel<T>> {
        public static ModelLayerLocation HAIR_BODY = new ModelLayerLocation(new ResourceLocation("tensura", "goblin_hair_body"), "main");
        private final HumanoidModel<T> model = new HumanoidModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(HAIR_BODY)){

            protected Iterable<ModelPart> m_5607_() {
                return ImmutableList.of();
            }
        };

        public HairBody(RenderLayerParent pRenderer) {
            super(pRenderer);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T entity, float pLimbSwing, float pLimbSwingAmount, float partialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            HumanoidModel<T> model = this.model();
            model.m_6839_(entity, pLimbSwing, pLimbSwingAmount, partialTicks);
            ((HumanoidModel)this.m_117386_()).m_102872_(model);
            VertexConsumer vertexconsumer = pBuffer.m_6299_(GoblinLayer.getRenderType(this.getHairTexture(entity)));
            model.m_6973_(entity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            model.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 0.8f, 0.8f, 0.8f, 1.0f);
        }

        protected HumanoidModel<T> model() {
            return this.model;
        }

        private ResourceLocation getHairTexture(T entity) {
            return GoblinVariant.Hair.getTextureLocation(entity);
        }
    }

    public static class Hair<T extends GoblinEntity>
    extends RenderLayer<T, HumanoidModel<T>> {
        public static ModelLayerLocation HAIR = new ModelLayerLocation(new ResourceLocation("tensura", "goblin_hair"), "main");
        private final HumanoidModel<T> model = new HumanoidModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(HAIR)){

            protected Iterable<ModelPart> m_5608_() {
                return ImmutableList.of();
            }
        };

        public Hair(RenderLayerParent pRenderer) {
            super(pRenderer);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T entity, float pLimbSwing, float pLimbSwingAmount, float partialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (!entity.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                return;
            }
            HumanoidModel<T> model = this.model();
            model.m_6839_(entity, pLimbSwing, pLimbSwingAmount, partialTicks);
            ((HumanoidModel)this.m_117386_()).m_102872_(model);
            VertexConsumer vertexconsumer = pBuffer.m_6299_(GoblinLayer.getRenderType(this.getHairTexture(entity)));
            model.m_6973_(entity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            model.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 0.8f, 0.8f, 0.8f, 1.0f);
        }

        protected HumanoidModel<T> model() {
            return this.model;
        }

        private ResourceLocation getHairTexture(T entity) {
            return GoblinVariant.Hair.getTextureLocation(entity);
        }
    }

    public static class Face<T extends GoblinEntity>
    extends RenderLayer<T, HumanoidModel<T>> {
        public static ModelLayerLocation FACE = new ModelLayerLocation(new ResourceLocation("tensura", "goblin_face"), "main");
        private final HumanoidModel<T> model = new HumanoidModel<T>(Minecraft.m_91087_().m_167973_().m_171103_(FACE)){

            protected Iterable<ModelPart> m_5608_() {
                return ImmutableList.of();
            }
        };

        public Face(RenderLayerParent pRenderer) {
            super(pRenderer);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, T entity, float pLimbSwing, float pLimbSwingAmount, float partialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            HumanoidModel<T> model = this.model();
            model.m_6839_(entity, pLimbSwing, pLimbSwingAmount, partialTicks);
            ((HumanoidModel)this.m_117386_()).m_102872_(model);
            VertexConsumer vertexconsumer = pBuffer.m_6299_(GoblinLayer.getRenderType(((GoblinEntity)entity).getFace().getTextureLocation()));
            model.m_6973_(entity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            model.m_7695_(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 0.8f, 0.8f, 0.8f, 1.0f);
        }

        protected HumanoidModel<T> model() {
            return this.model;
        }
    }
}

