/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client.misc;

import com.github.manasmods.tensura.entity.magic.misc.ChaosEaterProjectile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class ChaosEaterRenderer
extends EntityRenderer<ChaosEaterProjectile> {
    public static final ModelLayerLocation CHAOS_EATER = new ModelLayerLocation(new ResourceLocation("tensura", "chaos_eater"), "main");
    private final ModelPart eater;

    public ChaosEaterRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart modelpart = context.m_174023_(CHAOS_EATER);
        this.eater = modelpart.m_171324_("Ball");
    }

    public ResourceLocation getTextureLocation(ChaosEaterProjectile instance) {
        ResourceLocation[] resourceLocations = instance.getTextureLocation();
        if (resourceLocations == null) {
            return new ResourceLocation("tensura", "textures/blank_texture.png");
        }
        return Arrays.stream(resourceLocations).toList().get(instance.f_19797_ % resourceLocations.length);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("Ball", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-3.0f, -3.0f, -5.3333f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.3333f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)44);
    }

    public void render(ChaosEaterProjectile entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && entity.m_20177_((Player)minecraft.f_91074_)) {
            return;
        }
        poseStack.m_85836_();
        float scale = entity.getVisualSize();
        poseStack.m_85841_(scale, scale, scale);
        Vec3 motion = entity.m_20184_();
        float xRot = -((float)(Mth.m_14136_((double)motion.m_165924_(), (double)motion.f_82480_) * 57.2957763671875) - 90.0f);
        float yRot = -((float)(Mth.m_14136_((double)motion.f_82481_, (double)motion.f_82479_) * 57.2957763671875) + 90.0f);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(yRot));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(xRot));
        float f = (float)entity.f_19797_ + partialTicks;
        poseStack.m_85836_();
        float swirlX = Mth.m_14089_((float)(0.05f * f * 2.0f)) * 90.0f;
        float swirlY = Mth.m_14031_((float)(0.05f * f * 2.0f)) * 90.0f;
        float swirlZ = Mth.m_14089_((float)(0.05f * f * 2.0f + 5464.0f)) * 90.0f;
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(swirlX * 0.45f));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(swirlY * 0.45f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(swirlZ * 0.45f));
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        this.eater.m_104301_(poseStack, consumer, 0xF000F0, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(swirlZ));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(swirlX));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(swirlY));
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
        if (entity.m_37282_() != null) {
            ChaosEaterRenderer.renderRay(entity, entity.m_37282_(), partialTicks, poseStack, bufferSource, 0xF000F0, 0.3f, 38, 23, 19, 255);
            ChaosEaterRenderer.renderRay(entity, entity.m_37282_(), partialTicks, poseStack, bufferSource, 0xF000F0, 0.4f, 78, 2, 9, 30);
        }
    }

    public static void renderRay(ChaosEaterProjectile eater, Entity owner, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float size, int red, int green, int blue, int alpha) {
        float gloveHalfWidth = eater.m_20205_() / 2.0f;
        Vec3 offset = owner.m_146892_().m_82549_(eater.getStartOffset());
        double x = offset.m_7096_();
        double y = offset.m_7098_();
        double z = offset.m_7094_();
        float xDist = (float)(x - Mth.m_14139_((double)partialTick, (double)eater.f_19854_, (double)eater.m_20185_()));
        float yDist = (float)(y - Mth.m_14139_((double)partialTick, (double)eater.f_19855_, (double)eater.m_20186_()) - (double)gloveHalfWidth);
        float zDist = (float)(z - Mth.m_14139_((double)partialTick, (double)eater.f_19856_, (double)eater.m_20189_()));
        float f = Mth.m_14116_((float)(xDist * xDist + zDist * zDist));
        float f1 = Mth.m_14116_((float)(xDist * xDist + yDist * yDist + zDist * zDist));
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gloveHalfWidth, 0.0);
        poseStack.m_85845_(Vector3f.f_122225_.m_122270_((float)(-Math.atan2(zDist, xDist)) - 1.5707964f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122270_((float)(-Math.atan2(f, yDist)) - 1.5707964f));
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)BeaconRenderer.f_112102_));
        float f2 = 0.0f - ((float)eater.f_19797_ + partialTick) * 0.01f;
        float f3 = f1 / 32.0f - ((float)eater.f_19797_ + partialTick) * 0.01f;
        int i = 8;
        float f4 = 0.0f;
        float f5 = 0.25f;
        float f6 = 0.0f;
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_85861_();
        Matrix3f matrix3f = pose.m_85864_();
        for (int j = 1; j <= i; ++j) {
            float f7 = Mth.m_14031_((float)((float)j * ((float)Math.PI * 2) / (float)i)) * size;
            float f8 = Mth.m_14089_((float)((float)j * ((float)Math.PI * 2) / (float)i)) * size;
            float f9 = (float)j / (float)i;
            vertexConsumer.m_85982_(matrix4f, f4, f5, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(f6, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_85982_(matrix4f, f4, f5, f1).m_6122_(red, green, blue, alpha).m_7421_(f6, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_85982_(matrix4f, f7, f8, f1).m_6122_(red, green, blue, alpha).m_7421_(f9, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_85982_(matrix4f, f7, f8, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(f9, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        poseStack.m_85849_();
    }
}

