/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client.projectile;

import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class BladeProjectileRenderer
extends EntityRenderer<TensuraProjectile> {
    public static final ModelLayerLocation BLADE = new ModelLayerLocation(new ResourceLocation("tensura", "blade"), "main");
    private final ModelPart spike;

    public BladeProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart modelpart = context.m_174023_(BLADE);
        this.spike = modelpart.m_171324_("blade");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition blade = partdefinition.m_171599_("blade", CubeListBuilder.m_171558_().m_171514_(0, -16).m_171488_(0.0f, -1.0f, -8.0f, 0.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        blade.m_171599_("plane_1", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(0.0f, -8.0f, -8.0f, 0.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        blade.m_171599_("plane_2", CubeListBuilder.m_171558_().m_171514_(32, -16).m_171488_(0.0f, -8.0f, -8.0f, 0.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        blade.m_171599_("plane_3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(0.0f, 0.0f, -8.0f, 0.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void render(TensuraProjectile entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && entity.m_20177_((Player)minecraft.f_91074_)) {
            return;
        }
        poseStack.m_85836_();
        Vec3 motion = entity.m_20184_();
        float xRot = -((float)(Mth.m_14136_((double)motion.m_165924_(), (double)motion.f_82480_) * 57.2957763671875) - 90.0f);
        float yRot = -((float)(Mth.m_14136_((double)motion.f_82481_, (double)motion.f_82479_) * 57.2957763671875) + 90.0f);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(yRot));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(xRot));
        poseStack.m_85841_(entity.getVisualSize(), entity.getVisualSize(), entity.getVisualSize());
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        this.spike.m_104301_(poseStack, consumer, 0xF000F0, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(TensuraProjectile instance) {
        ResourceLocation[] resourceLocations = instance.getTextureLocation();
        if (resourceLocations == null) {
            return new ResourceLocation("tensura", "textures/blank_texture.png");
        }
        return Arrays.stream(resourceLocations).toList().get(instance.f_19797_ % resourceLocations.length);
    }
}

