/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.human;

import com.github.manasmods.tensura.api.entity.ai.CrossbowAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.human.FolgenEntity;
import com.github.manasmods.tensura.entity.human.PlayerLikeEntity;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.item.custom.KunaiItem;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.dwarf.DwarfRace;
import com.github.manasmods.tensura.race.elf.ElfRace;
import com.github.manasmods.tensura.race.human.HumanRace;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;

public class FalmuthKnightEntity
extends PlayerLikeEntity {
    public FalmuthKnightEntity(EntityType<? extends FalmuthKnightEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends PlayerLikeEntity>)pEntityType, pLevel);
        this.f_21364_ = 20;
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 2.0).m_22268_(Attributes.f_22287_, (double)0.1f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, new CrossbowAttackGoal<FalmuthKnightEntity>(this, 1.2, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.SpearTypeAttackGoal(this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.NPCMeleeAttackGoal(this, (PathfinderMob)this, 2.0, true));
        this.f_21345_.m_25352_(4, (Goal)new FollowFolgenGoal(this, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new WanderingFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, FalmuthKnightEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, this::shouldAttackPlayers));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, LivingEntity.class, false, entity -> entity.m_6095_().m_204039_(TensuraTags.EntityTypes.OTHERWORLDER_PREY)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    boolean shouldAttackPlayers(LivingEntity target) {
        Race race = TensuraPlayerCapability.getRace(target);
        if (race == null || race.isSpiritual()) {
            return false;
        }
        if (TensuraEPCapability.getEP(target) < 5000.0) {
            return false;
        }
        if (TensuraEPCapability.isMajin(target)) {
            return true;
        }
        if (race instanceof ElfRace) {
            return false;
        }
        if (race instanceof DwarfRace) {
            return false;
        }
        return !(race instanceof HumanRace);
    }

    public void m_7334_(Entity pEntity) {
        if (pEntity instanceof FolgenEntity) {
            return;
        }
        super.m_7334_(pEntity);
    }

    @Override
    public InteractionResult handleEating(Player player, InteractionHand hand, ItemStack stack) {
        if (this.m_6898_(stack) && this.m_21223_() < this.m_21233_()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.m_8035_();
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_8035_() {
        super.m_8035_();
        this.m_5634_(3.0f);
    }

    @Override
    protected boolean isSpearType(ItemStack weapon) {
        return weapon.m_41720_() instanceof KunaiItem || weapon.m_41720_() instanceof TridentItem;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (!pReason.equals((Object)MobSpawnType.BUCKET)) {
            this.m_213945_(this.f_19796_, pDifficulty);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        ItemStack weapon = new ItemStack(pRandom.m_188499_() ? (ItemLike)TensuraToolItems.IRON_SPEAR.get() : (ItemLike)TensuraToolItems.IRON_LONG_SWORD.get());
        if (pRandom.m_188503_(10) == 1) {
            weapon.m_41663_(Enchantments.f_44977_, 2);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, weapon);
        this.inventory.m_6836_(4, weapon);
        this.inventory.m_6596_();
        if (pRandom.m_188501_() >= 0.8f) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)Items.f_42740_);
        this.m_8061_(EquipmentSlot.OFFHAND, stack);
        this.inventory.m_6836_(5, stack);
        this.inventory.m_6596_();
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity;
        if (!super.m_6469_(pSource, pAmount)) {
            return false;
        }
        LivingEntity target = this.m_5448_();
        if (target == null && (entity = pSource.m_7639_()) instanceof LivingEntity) {
            LivingEntity attacker;
            target = attacker = (LivingEntity)entity;
        }
        this.summonKnights(target);
        return true;
    }

    protected void summonKnights(LivingEntity target) {
        Level level = this.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        if ((double)this.f_19796_.m_188501_() < this.m_21133_(Attributes.f_22287_) && this.f_19853_.m_46469_().m_46207_(GameRules.f_46134_)) {
            FalmuthKnightEntity knight = new FalmuthKnightEntity((EntityType<? extends FalmuthKnightEntity>)((EntityType)TensuraEntityTypes.FALMUTH_KNIGHT.get()), this.m_9236_());
            for (int l = 0; l < 50; ++l) {
                int i1 = i + Mth.m_216271_((RandomSource)this.f_19796_, (int)7, (int)40) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
                int j1 = j + Mth.m_216271_((RandomSource)this.f_19796_, (int)7, (int)40) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
                int k1 = k + Mth.m_216271_((RandomSource)this.f_19796_, (int)7, (int)40) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
                BlockPos blockpos = new BlockPos(i1, j1, k1);
                EntityType type = knight.m_6095_();
                SpawnPlacements.Type placement = SpawnPlacements.m_21752_((EntityType)type);
                if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)placement, (LevelReader)this.f_19853_, (BlockPos)blockpos, (EntityType)type) || !SpawnPlacements.m_217074_((EntityType)type, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.REINFORCEMENT, (BlockPos)blockpos, (RandomSource)this.f_19853_.f_46441_)) continue;
                knight.m_6034_(i1, j1, k1);
                if (this.f_19853_.m_45914_((double)i1, (double)j1, (double)k1, 7.0) || !this.f_19853_.m_45784_((Entity)knight) || !this.f_19853_.m_45786_((Entity)knight) || this.f_19853_.m_46855_(knight.m_20191_())) continue;
                if (target != null) {
                    knight.m_6710_(target);
                }
                knight.m_6518_((ServerLevelAccessor)serverLevel, this.f_19853_.m_6436_(knight.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                serverLevel.m_47205_((Entity)knight);
                this.m_21051_(Attributes.f_22287_).m_22125_(new AttributeModifier("Knight reinforcement caller charge", (double)-0.05f, AttributeModifier.Operation.ADDITION));
                knight.m_21051_(Attributes.f_22287_).m_22125_(new AttributeModifier("Knight reinforcement callee charge", (double)-0.05f, AttributeModifier.Operation.ADDITION));
                break;
            }
        }
    }

    static class FollowFolgenGoal
    extends Goal {
        private final FalmuthKnightEntity knight;
        @Nullable
        private FolgenEntity folgen;
        private final double speedModifier;
        private int timeToRecalcPath;

        public FollowFolgenGoal(FalmuthKnightEntity knight, double pSpeedModifier) {
            this.knight = knight;
            this.speedModifier = pSpeedModifier;
        }

        public boolean m_8036_() {
            if (this.knight.m_21824_()) {
                return false;
            }
            if (this.knight.m_21523_() || this.knight.m_20159_()) {
                return false;
            }
            List list = this.knight.f_19853_.m_45976_(FolgenEntity.class, this.knight.m_20191_().m_82377_(30.0, 8.0, 30.0));
            FolgenEntity entity = null;
            double d0 = Double.MAX_VALUE;
            for (FolgenEntity parent : list) {
                double distance = this.knight.m_20280_((Entity)parent);
                if (!(distance <= d0)) continue;
                d0 = distance;
                entity = parent;
            }
            if (entity == null) {
                return false;
            }
            if (this.knight.m_5448_() != null) {
                return false;
            }
            if (d0 > 256.0) {
                this.folgen = entity;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.knight.m_21824_()) {
                return false;
            }
            if (this.knight.m_21523_() || this.knight.m_20159_()) {
                return false;
            }
            if (this.knight.m_5448_() != null) {
                return false;
            }
            if (this.folgen == null) {
                return false;
            }
            if (!this.folgen.m_6084_()) {
                return false;
            }
            double d0 = this.knight.m_20280_((Entity)this.folgen);
            return d0 >= 49.0 && d0 <= 256.0;
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            if (this.knight.m_5803_()) {
                this.knight.setSleeping(false);
            }
        }

        public void m_8041_() {
            this.folgen = null;
            this.knight.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (--this.timeToRecalcPath > 0) {
                return;
            }
            if (this.folgen == null) {
                return;
            }
            this.timeToRecalcPath = this.m_183277_(10);
            this.knight.m_21573_().m_5624_((Entity)this.folgen, this.speedModifier);
            if (this.folgen.m_5448_() != null && this.knight.m_5448_() == null && this.folgen.m_5448_() != this.knight && this.folgen.m_5448_().m_20270_((Entity)this.knight) <= 30.0f) {
                this.knight.m_6710_(this.folgen.m_5448_());
            }
        }
    }
}

