/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.human;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.api.entity.ai.CrossbowAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.human.FalmuthKnightEntity;
import com.github.manasmods.tensura.entity.human.IOtherworlder;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;

public class FolgenEntity
extends FalmuthKnightEntity
implements IOtherworlder {
    public FolgenEntity(EntityType<? extends FolgenEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends FalmuthKnightEntity>)pEntityType, pLevel);
        this.f_21364_ = 100;
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 30.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.75).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 2.0).m_22268_(Attributes.f_22287_, (double)0.2f).m_22265_();
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, new CrossbowAttackGoal<FolgenEntity>(this, 1.2, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.SpearTypeAttackGoal(this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.NPCMeleeAttackGoal(this, (PathfinderMob)this, 2.0, true));
        this.f_21345_.m_25352_(4, (Goal)new WanderingFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, FalmuthKnightEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, this::shouldAttackPlayer));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, LivingEntity.class, false, entity -> entity.m_6095_().m_204039_(TensuraTags.EntityTypes.OTHERWORLDER_PREY)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return new ResourceLocation("tensura", "textures/entity/otherworlder/folgen.png");
    }

    @Override
    public List<ManasSkill> getUniqueSkills() {
        return List.of((ManasSkill)UniqueSkills.SPEARHEAD.get());
    }

    @Override
    protected boolean removeWhenNoAction() {
        return false;
    }

    @Override
    protected float m_21519_(EquipmentSlot pSlot) {
        if (this.m_21824_()) {
            return 0.0f;
        }
        if (pSlot.equals((Object)EquipmentSlot.MAINHAND)) {
            return 0.1f;
        }
        if (pSlot.equals((Object)EquipmentSlot.OFFHAND)) {
            return 0.3f;
        }
        return super.m_21519_(pSlot);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason != MobSpawnType.BUCKET) {
            this.summonKnightsRandomPos();
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected void summonKnightsRandomPos() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        block0: for (int knights = 0; knights < 9; ++knights) {
            FalmuthKnightEntity knight = new FalmuthKnightEntity((EntityType<? extends FalmuthKnightEntity>)((EntityType)TensuraEntityTypes.FALMUTH_KNIGHT.get()), (Level)serverLevel);
            for (int l = 0; l < 50; ++l) {
                int i1 = i + Mth.m_216271_((RandomSource)this.f_19796_, (int)0, (int)7) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
                int j1 = j + Mth.m_216271_((RandomSource)this.f_19796_, (int)0, (int)7) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
                int k1 = k + Mth.m_216271_((RandomSource)this.f_19796_, (int)0, (int)7) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
                BlockPos blockpos = new BlockPos(i1, j1, k1);
                EntityType entitytype = (EntityType)TensuraEntityTypes.FALMUTH_KNIGHT.get();
                SpawnPlacements.Type type = SpawnPlacements.m_21752_((EntityType)entitytype);
                if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)type, (LevelReader)serverLevel, (BlockPos)blockpos, (EntityType)entitytype) || !SpawnPlacements.m_217074_((EntityType)entitytype, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.REINFORCEMENT, (BlockPos)blockpos, (RandomSource)serverLevel.f_46441_)) continue;
                knight.m_6034_(i1, j1, k1);
                if (!serverLevel.m_45784_((Entity)knight) || !serverLevel.m_45786_((Entity)knight)) continue;
                knight.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(knight.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                knight.m_6710_(this.m_5448_());
                serverLevel.m_47205_((Entity)knight);
                continue block0;
            }
        }
    }

    @Override
    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        ItemStack weapon = new ItemStack(pRandom.m_188503_(3) == 1 ? (ItemLike)TensuraToolItems.HIGH_MAGISTEEL_LONG_SWORD.get() : (ItemLike)TensuraToolItems.LOW_MAGISTEEL_LONG_SWORD.get());
        if (pRandom.m_188503_(10) == 1) {
            weapon.m_41663_(Enchantments.f_44977_, 5);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, weapon);
        this.inventory.m_6836_(4, weapon);
        this.inventory.m_6596_();
        if (pRandom.m_188501_() >= 0.8f) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)Items.f_42740_);
        this.m_8061_(EquipmentSlot.OFFHAND, stack);
        this.inventory.m_6836_(5, stack);
        this.inventory.m_6596_();
    }

    @Override
    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (this.f_19853_.m_5776_()) {
            return;
        }
        if (this.m_6084_()) {
            return;
        }
        this.dropSkills(source.m_7639_());
    }
}

