/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.human;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.dwarf.DwarfRace;
import com.github.manasmods.tensura.race.elf.ElfRace;
import com.github.manasmods.tensura.race.human.HumanRace;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.ProjectileImpactEvent;

public interface IOtherworlder {
    public ResourceLocation getTextureLocation();

    public List<ManasSkill> getUniqueSkills();

    default public boolean shouldAttackPlayer(LivingEntity target) {
        Race race = TensuraPlayerCapability.getRace(target);
        if (race == null || race.isSpiritual()) {
            return false;
        }
        if (TensuraEPCapability.getEP(target) < 5000.0) {
            return false;
        }
        if (TensuraEPCapability.isMajin(target)) {
            return true;
        }
        if (race instanceof ElfRace) {
            return false;
        }
        if (race instanceof DwarfRace) {
            return false;
        }
        return !(race instanceof HumanRace);
    }

    default public void onProjectileImpact(ProjectileImpactEvent event) {
    }

    default public void dropSkills(@Nullable Entity attacker) {
        if (!(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        for (ManasSkill skill : this.getUniqueSkills()) {
            double chance = (Double)TensuraConfig.INSTANCE.skillsConfig.otherworlderDrops.get();
            if (chance <= (double)(player.m_217043_().m_188501_() * 100.0f) || !SkillUtils.learnSkill((LivingEntity)player, skill)) continue;
            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

