/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.human;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.intrinsic.CharmSkill;
import com.github.manasmods.tensura.api.entity.ai.CrossbowAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.human.OtherworlderEntity;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.FireBoltProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.IceLanceProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.StoneShotProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.WaterBallProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.WindBladeProjectile;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;

public class KiraraMizutaniEntity
extends OtherworlderEntity {
    public KiraraMizutaniEntity(EntityType<? extends KiraraMizutaniEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends OtherworlderEntity>)pEntityType, pLevel);
        this.f_21364_ = 100;
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 2.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, new CrossbowAttackGoal<KiraraMizutaniEntity>(this, 1.2, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.SpearTypeAttackGoal(this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new BewilderAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new WanderingFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, KiraraMizutaniEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, this::shouldAttackPlayer));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, LivingEntity.class, false, entity -> entity.m_6095_().m_204039_(TensuraTags.EntityTypes.OTHERWORLDER_PREY)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return new ResourceLocation("tensura", "textures/entity/otherworlder/kirara_mizutani.png");
    }

    @Override
    public List<ManasSkill> getUniqueSkills() {
        return List.of((ManasSkill)UniqueSkills.BEWILDER.get());
    }

    private void shootMagicProjectile() {
        if (this.m_5448_() != null) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.m_5448_().m_146892_());
        }
        int randomProjectile = this.m_217043_().m_188503_(5);
        TensuraProjectile projectile = switch (randomProjectile) {
            default -> new FireBoltProjectile(this.m_9236_(), (LivingEntity)this);
            case 1 -> new StoneShotProjectile(this.m_9236_(), (LivingEntity)this);
            case 2 -> new IceLanceProjectile(this.m_9236_(), (LivingEntity)this);
            case 3 -> new WaterBallProjectile(this.m_9236_(), (LivingEntity)this);
            case 4 -> new WindBladeProjectile(this.m_9236_(), (LivingEntity)this);
        };
        projectile.setSpeed(1.5f);
        projectile.setDamage(20.0f);
        if (randomProjectile >= 2) {
            projectile.setBurnTicks(-1);
        } else if (randomProjectile == 0) {
            projectile.setBurnTicks(10);
        } else {
            projectile.setKnockForce(1.0f);
        }
        projectile.m_20242_(true);
        projectile.setPosAndShoot((LivingEntity)this);
        this.m_9236_().m_7967_((Entity)projectile);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void mindControlSurrounding() {
        LivingEntity livingTarget = this.m_5448_();
        if (livingTarget == null) {
            return;
        }
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11733_, SoundSource.PLAYERS, 1.0f, 1.0f);
        List list = this.f_19853_.m_6443_(Mob.class, this.m_20191_().m_82400_(20.0), mob -> !mob.m_7306_((Entity)this) && mob.m_6084_());
        if (list.isEmpty()) {
            return;
        }
        for (Mob target : list) {
            if (!CharmSkill.canMindControl((LivingEntity)target, this.f_19853_, true) || target.m_21023_((MobEffect)TensuraMobEffects.RAMPAGE.get()) || RaceHelper.isSpiritualLifeForm((LivingEntity)target) || SkillUtils.isSkillToggled((Entity)target, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get())) continue;
            target.m_21561_(true);
            target.m_6710_(livingTarget);
            if (target instanceof NeutralMob) {
                NeutralMob neutralMob = (NeutralMob)target;
                neutralMob.m_6710_(livingTarget);
            }
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123798_);
        }
    }

    private void instantKill() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11733_, SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!CharmSkill.canMindControl(target, this.f_19853_, true)) {
            return;
        }
        if (target.m_21023_((MobEffect)TensuraMobEffects.RAMPAGE.get())) {
            return;
        }
        if (RaceHelper.isSpiritualLifeForm(target)) {
            return;
        }
        if (SkillUtils.isSkillToggled((Entity)target, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_NULLIFICATION.get())) {
            return;
        }
        if (TensuraEPCapability.getEP((LivingEntity)this) < TensuraEPCapability.getEP(target)) {
            return;
        }
        float damage = target.m_21223_();
        if (SkillUtils.isSkillToggled((Entity)target, (ManasSkill)ResistanceSkills.SPIRITUAL_ATTACK_RESISTANCE.get())) {
            damage /= 2.0f;
        }
        if (target.m_6469_(TensuraDamageSources.selfKill((Entity)this), damage)) {
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123808_);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123792_);
        }
    }

    @Nullable
    private ManasSkillInstance getBewilder() {
        Optional skill = SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)UniqueSkills.BEWILDER.get());
        if (skill.isEmpty()) {
            return null;
        }
        if (!((ManasSkillInstance)skill.get()).canInteractSkill((LivingEntity)this)) {
            return null;
        }
        return (ManasSkillInstance)skill.get();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (!pReason.equals((Object)MobSpawnType.BUCKET)) {
            this.m_213945_(this.f_19796_, pDifficulty);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        super.m_213945_(pRandom, pDifficulty);
        ItemStack stack = new ItemStack((ItemLike)Items.f_42398_);
        stack.m_41714_((Component)Component.m_237113_((String)"Staff").m_130940_(ChatFormatting.GOLD));
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
        this.inventory.m_6836_(4, stack);
        this.inventory.m_6596_();
    }

    @Override
    @Nullable
    public Item getEquipmentForArmorSlot(EquipmentSlot pSlot, int pChance) {
        return null;
    }

    public class BewilderAttackGoal
    extends HumanoidNPCEntity.NPCMeleeAttackGoal {
        public final KiraraMizutaniEntity entity;

        public BewilderAttackGoal(KiraraMizutaniEntity entity) {
            super(KiraraMizutaniEntity.this, (PathfinderMob)entity, 1.5, true);
            this.entity = entity;
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(pEnemy);
            int randomAttack = this.randomAttack(pDistToEnemySqr);
            if (randomAttack == 0) {
                return;
            }
            double d = randomAttack == 4 ? d0 : d0 + 900.0;
            if (pDistToEnemySqr <= d && this.m_25564_()) {
                this.m_25563_();
                switch (randomAttack) {
                    default: {
                        this.entity.shootMagicProjectile();
                        break;
                    }
                    case 2: {
                        this.entity.mindControlSurrounding();
                        break;
                    }
                    case 3: {
                        this.entity.instantKill();
                        break;
                    }
                    case 4: {
                        this.entity.m_7327_((Entity)pEnemy);
                    }
                }
                this.entity.m_21011_(InteractionHand.MAIN_HAND, true);
            }
        }

        protected int randomAttack(double distSqr) {
            boolean hasBewilder;
            boolean bl = hasBewilder = this.entity.getBewilder() != null;
            if (this.entity.f_19796_.m_188503_(7) == 1 && distSqr <= 400.0 && hasBewilder) {
                return 3;
            }
            if (this.entity.f_19796_.m_188503_(4) == 1 && hasBewilder) {
                return 2;
            }
            return this.entity.m_21205_().m_150930_(Items.f_42398_) ? 1 : 4;
        }
    }
}

