/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.human;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.api.entity.ai.CrossbowAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.data.pack.OtherworlderSpawning;
import com.github.manasmods.tensura.data.pack.TensuraData;
import com.github.manasmods.tensura.entity.human.HinataSakaguchiEntity;
import com.github.manasmods.tensura.entity.human.OtherworlderEntity;
import com.github.manasmods.tensura.entity.human.ShizuEntity;
import com.github.manasmods.tensura.entity.projectile.SevererBladeProjectile;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class KyoyaTachibanaEntity
extends OtherworlderEntity {
    public KyoyaTachibanaEntity(EntityType<? extends KyoyaTachibanaEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends OtherworlderEntity>)pEntityType, pLevel);
        this.f_21364_ = 100;
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 2.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, new CrossbowAttackGoal<KyoyaTachibanaEntity>(this, 1.2, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.SpearTypeAttackGoal(this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new SevererAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new WanderingFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, KyoyaTachibanaEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, this::shouldAttackPlayer));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, LivingEntity.class, false, entity -> entity.m_6095_().m_204039_(TensuraTags.EntityTypes.OTHERWORLDER_PREY)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return new ResourceLocation("tensura", "textures/entity/otherworlder/kyoya_tachibana.png");
    }

    @Override
    public List<ManasSkill> getUniqueSkills() {
        return List.of((ManasSkill)UniqueSkills.SEVERER.get());
    }

    private void bladeShoot() {
        if (!this.m_21205_().m_150930_((Item)TensuraToolItems.SPATIAL_BLADE.get())) {
            return;
        }
        if (this.m_5448_() != null) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.m_5448_().m_146892_());
        }
        SevererBladeProjectile blade = new SevererBladeProjectile(this.f_19853_, (LivingEntity)this, true, this.m_21205_());
        if (EnchantmentHelper.m_44914_((LivingEntity)this) > 0) {
            blade.m_20254_(600);
        }
        Vector3f vector3f = new Vector3f(this.m_20252_(1.0f));
        blade.m_6686_(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_(), 3.0f, 0.0f);
        this.f_19853_.m_7967_((Entity)blade);
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, SoundSource.NEUTRAL, 0.5f, 0.4f + (this.f_19796_.m_188501_() * 0.4f + 0.8f));
    }

    private void bladeStorm(int arrowAmount) {
        if (this.m_5448_() != null) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.m_5448_().m_146892_());
        }
        int arrowRot = 360 / arrowAmount;
        for (int i = 0; i < arrowAmount; ++i) {
            Vec3 arrowOffset = new Vec3(0.0, 1.0, 0.0).m_82535_(((float)(arrowRot * i) - (float)arrowRot / 2.0f) * ((float)Math.PI / 180));
            Vec3 arrowPos = this.m_146892_().m_82549_(this.m_20154_().m_82541_().m_82490_(1.0)).m_82549_(arrowOffset.m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180)));
            SevererBladeProjectile blade = new SevererBladeProjectile(this.m_9236_(), (LivingEntity)this, this.getSpatialBlade());
            blade.m_20242_(true);
            blade.m_146884_(arrowPos);
            blade.setOwnerOffset(arrowOffset);
            blade.setLookDistance(30.0f);
            blade.setDelayTick(20);
            this.m_9236_().m_7967_((Entity)blade);
            this.f_19853_.m_6263_(null, arrowPos.m_7096_(), arrowPos.m_7098_(), arrowPos.m_7094_(), SoundEvents.f_11687_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private void bladeJail(int amount) {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            Vec3 bladePos = target.m_146892_().m_82549_(new Vec3(0.0, Math.random() - 0.5, 0.6).m_82541_().m_82490_((double)(target.m_20205_() + 5.0f)).m_82524_((float)(360 * i) * ((float)Math.PI / 180) / (float)amount));
            SevererBladeProjectile blade = new SevererBladeProjectile(this.m_9236_(), (LivingEntity)this, this.getSpatialBlade());
            blade.m_20242_(true);
            blade.m_146884_(bladePos);
            blade.setDelayVec(target.m_20182_().m_82546_(bladePos).m_82541_());
            blade.setDelayTick(20);
            this.m_9236_().m_7967_((Entity)blade);
            this.f_19853_.m_6263_(null, bladePos.m_7096_(), bladePos.m_7098_(), bladePos.m_7094_(), SoundEvents.f_11887_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private ItemStack getSpatialBlade() {
        if (this.m_21205_().m_150930_((Item)TensuraToolItems.SPATIAL_BLADE.get())) {
            return this.m_21205_();
        }
        ItemStack stack = new ItemStack((ItemLike)TensuraToolItems.SPATIAL_BLADE.get());
        stack.m_41784_().m_128379_("dummy", true);
        stack.m_41663_((Enchantment)TensuraEnchantments.SEVERANCE.get(), 5);
        this.m_8061_(EquipmentSlot.MAINHAND, stack.m_41777_());
        this.inventory.m_6836_(4, stack.m_41777_());
        this.inventory.m_6596_();
        return stack;
    }

    @Nullable
    private ManasSkillInstance getSeverer() {
        Optional skill = SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)UniqueSkills.SEVERER.get());
        if (skill.isEmpty()) {
            return null;
        }
        if (!((ManasSkillInstance)skill.get()).canInteractSkill((LivingEntity)this)) {
            return null;
        }
        return (ManasSkillInstance)skill.get();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.NATURAL || pReason == MobSpawnType.CHUNK_GENERATION) {
            if (SpawnRateConfig.rollChance((Integer)SpawnRateConfig.INSTANCE.shizuChance.get(), this.f_19796_)) {
                ShizuEntity shizu = new ShizuEntity((EntityType<? extends ShizuEntity>)((EntityType)TensuraEntityTypes.SHIZU.get()), this.m_9236_());
                shizu.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                shizu.m_6518_(pLevel, this.f_19853_.m_6436_(this.m_20183_()), MobSpawnType.NATURAL, null, null);
                this.m_9236_().m_7967_((Entity)shizu);
                this.m_142467_(Entity.RemovalReason.DISCARDED);
                return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
            }
            if (SpawnRateConfig.rollChance((Integer)SpawnRateConfig.INSTANCE.hinataChance.get(), this.f_19796_)) {
                HinataSakaguchiEntity hinata = new HinataSakaguchiEntity((EntityType<? extends HinataSakaguchiEntity>)((EntityType)TensuraEntityTypes.HINATA_SAKAGUCHI.get()), this.m_9236_());
                hinata.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                hinata.m_6518_(pLevel, this.f_19853_.m_6436_(this.m_20183_()), MobSpawnType.NATURAL, null, null);
                this.m_9236_().m_7967_((Entity)hinata);
                this.m_142467_(Entity.RemovalReason.DISCARDED);
                return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
            }
            float chance = this.m_217043_().m_188501_();
            for (OtherworlderSpawning spawning : TensuraData.getOtherworlderSpawning()) {
                Entity entity;
                Optional entityType;
                if (chance >= spawning.getChance()) {
                    chance -= spawning.getChance();
                    continue;
                }
                if (spawning.getId().equals((Object)EntityType.m_20613_((EntityType)this.m_6095_())) || (entityType = EntityType.m_20632_((String)spawning.getId().toString())).isEmpty() || !((entity = ((EntityType)entityType.get()).m_20615_(this.m_9236_())) instanceof Mob)) break;
                Mob mob = (Mob)entity;
                entity.m_146884_(this.m_20182_());
                mob.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
                this.m_9236_().m_7967_(entity);
                this.m_142467_(Entity.RemovalReason.DISCARDED);
                return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
            }
        }
        if (!pReason.equals((Object)MobSpawnType.BUCKET)) {
            this.m_213945_(this.f_19796_, pDifficulty);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return SpawnRateConfig.rollSpawn((Integer)SpawnRateConfig.INSTANCE.otherworlderSpawnRate.get(), this.m_217043_(), pSpawnReason) && super.m_5545_(pLevel, pSpawnReason);
    }

    @Override
    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        super.m_213945_(pRandom, pDifficulty);
        this.getSpatialBlade();
        if (pRandom.m_188501_() >= 0.2f) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)Items.f_42740_);
        this.m_8061_(EquipmentSlot.OFFHAND, stack);
        this.inventory.m_6836_(5, stack);
        this.inventory.m_6596_();
    }

    @Override
    @Nullable
    public Item getEquipmentForArmorSlot(EquipmentSlot pSlot, int pChance) {
        return switch (pSlot) {
            case EquipmentSlot.HEAD -> {
                if (pChance == 1) {
                    yield Items.f_42407_;
                }
                yield null;
            }
            case EquipmentSlot.CHEST -> {
                if (pChance == 1) {
                    yield Items.f_42408_;
                }
                if (pChance == 3) {
                    yield Items.f_42465_;
                }
                yield null;
            }
            case EquipmentSlot.LEGS -> {
                if (pChance == 1) {
                    yield Items.f_42462_;
                }
                if (pChance == 3) {
                    yield Items.f_42466_;
                }
                yield null;
            }
            case EquipmentSlot.FEET -> {
                if (pChance == 1) {
                    yield Items.f_42463_;
                }
                if (pChance == 3) {
                    yield Items.f_42467_;
                }
                yield null;
            }
            default -> null;
        };
    }

    public class SevererAttackGoal
    extends HumanoidNPCEntity.NPCMeleeAttackGoal {
        public final KyoyaTachibanaEntity entity;

        public SevererAttackGoal(KyoyaTachibanaEntity entity) {
            super(KyoyaTachibanaEntity.this, (PathfinderMob)entity, 2.0, true);
            this.entity = entity;
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(pEnemy);
            int randomAttack = this.randomAttack(pEnemy, pDistToEnemySqr);
            if (randomAttack == 0) {
                return;
            }
            double d = randomAttack == 1 ? d0 : d0 + 900.0;
            if (pDistToEnemySqr <= d && this.m_25564_()) {
                this.m_25563_();
                switch (randomAttack) {
                    default: {
                        this.entity.m_7327_((Entity)pEnemy);
                        break;
                    }
                    case 2: {
                        this.entity.bladeShoot();
                        break;
                    }
                    case 3: {
                        this.entity.m_21573_().m_26573_();
                        this.entity.bladeStorm(10);
                        break;
                    }
                    case 4: {
                        this.entity.bladeJail(10);
                    }
                }
                this.entity.m_21011_(InteractionHand.MAIN_HAND, true);
            }
        }

        protected int randomAttack(LivingEntity target, double distSqr) {
            if (this.entity.getSeverer() == null) {
                return 1;
            }
            if (distSqr > this.m_6639_(target) || this.entity.f_19796_.m_188503_(10) == 1) {
                if ((double)this.entity.f_19796_.m_188501_() <= 0.1) {
                    return 4;
                }
                if ((double)this.entity.f_19796_.m_188501_() <= 0.3) {
                    return 3;
                }
                return 2;
            }
            return 1;
        }
    }
}

