/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.barrier;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierEntity;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierPart;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MegiddoBubbleEntity
extends BarrierEntity {
    private static final EntityDataAccessor<Integer> CHARGE = SynchedEntityData.m_135353_(MegiddoBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CHAIN_CHARGE = SynchedEntityData.m_135353_(MegiddoBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> START_POS_X = SynchedEntityData.m_135353_(MegiddoBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> START_POS_Y = SynchedEntityData.m_135353_(MegiddoBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> START_POS_Z = SynchedEntityData.m_135353_(MegiddoBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> TARGET_POS_X = SynchedEntityData.m_135353_(MegiddoBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> TARGET_POS_Y = SynchedEntityData.m_135353_(MegiddoBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> TARGET_POS_Z = SynchedEntityData.m_135353_(MegiddoBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int beamTick = 0;
    private int chargeChain = 0;

    public MegiddoBubbleEntity(Level level, LivingEntity entity) {
        this((EntityType<? extends MegiddoBubbleEntity>)((EntityType)TensuraEntityTypes.MEGIDDO_BUBBLE.get()), level);
        this.m_5602_((Entity)entity);
    }

    public MegiddoBubbleEntity(EntityType<? extends MegiddoBubbleEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGE, (Object)10);
        this.f_19804_.m_135372_(CHAIN_CHARGE, (Object)0);
        this.f_19804_.m_135372_(START_POS_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(START_POS_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(START_POS_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGET_POS_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGET_POS_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGET_POS_Z, (Object)Float.valueOf(0.0f));
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Charge", this.getCharge());
        pCompound.m_128405_("ChainCharge", this.getChainCharge());
        pCompound.m_128350_("xStart", (float)this.getStartBeamOffset().m_7096_());
        pCompound.m_128350_("yStart", (float)this.getStartBeamOffset().m_7098_());
        pCompound.m_128350_("zStart", (float)this.getStartBeamOffset().m_7094_());
        pCompound.m_128350_("xTarget", (float)this.getTargetPos().m_7096_());
        pCompound.m_128350_("yTarget", (float)this.getTargetPos().m_7098_());
        pCompound.m_128350_("zTarget", (float)this.getTargetPos().m_7094_());
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setCharge(pCompound.m_128451_("Charge"));
        this.setChainCharge(pCompound.m_128451_("ChainCharge"));
        this.setStartBeamOffset(pCompound.m_128457_("xStart"), pCompound.m_128457_("yStart"), pCompound.m_128457_("zStart"));
        this.setTargetPos(pCompound.m_128457_("xTarget"), pCompound.m_128457_("yTarget"), pCompound.m_128457_("zTarget"));
    }

    public int getCharge() {
        return (Integer)this.m_20088_().m_135370_(CHARGE);
    }

    public void setCharge(int charge) {
        this.m_20088_().m_135381_(CHARGE, (Object)charge);
    }

    public int getChainCharge() {
        return (Integer)this.m_20088_().m_135370_(CHAIN_CHARGE);
    }

    public void setChainCharge(int charge) {
        this.m_20088_().m_135381_(CHAIN_CHARGE, (Object)charge);
        this.chargeChain = charge;
    }

    public void setStartBeamOffset(float x, float y, float z) {
        this.m_20088_().m_135381_(START_POS_X, (Object)Float.valueOf(x));
        this.m_20088_().m_135381_(START_POS_Y, (Object)Float.valueOf(y));
        this.m_20088_().m_135381_(START_POS_Z, (Object)Float.valueOf(z));
    }

    public Vec3 getStartBeamOffset() {
        return new Vec3((double)((Float)this.m_20088_().m_135370_(START_POS_X)).floatValue(), (double)((Float)this.m_20088_().m_135370_(START_POS_Y)).floatValue(), (double)((Float)this.m_20088_().m_135370_(START_POS_Z)).floatValue());
    }

    public void setTargetPos(float x, float y, float z) {
        this.m_20088_().m_135381_(TARGET_POS_X, (Object)Float.valueOf(x));
        this.m_20088_().m_135381_(TARGET_POS_Y, (Object)Float.valueOf(y));
        this.m_20088_().m_135381_(TARGET_POS_Z, (Object)Float.valueOf(z));
    }

    public Vec3 getTargetPos() {
        return new Vec3((double)((Float)this.m_20088_().m_135370_(TARGET_POS_X)).floatValue(), (double)((Float)this.m_20088_().m_135370_(TARGET_POS_Y)).floatValue(), (double)((Float)this.m_20088_().m_135370_(TARGET_POS_Z)).floatValue());
    }

    @Override
    public boolean canWalkThrough() {
        return true;
    }

    @Override
    public boolean blockBuilding() {
        return false;
    }

    @Override
    public boolean isMultipartEntity() {
        return false;
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    @Override
    public boolean m_6783_(double pDistance) {
        return super.m_6783_(pDistance) || pDistance < 16384.0;
    }

    @Override
    public void m_8119_() {
        List<LivingEntity> list;
        super.m_8119_();
        Entity owner = this.m_37282_();
        if (owner != null && this.getChainCharge() <= 0) {
            this.m_6034_(owner.m_20185_(), owner.m_20186_() + 20.0, owner.m_20189_());
            List bubbles = this.m_9236_().m_6443_(MegiddoBubbleEntity.class, this.m_20191_(), entityData -> entityData.m_37282_() == owner && entityData != this);
            if (!bubbles.isEmpty() || !owner.m_6084_()) {
                this.m_146870_();
            }
        }
        if (!this.getTargetPos().equals((Object)Vec3.f_82478_)) {
            ++this.beamTick;
            if (this.beamTick == 1) {
                Vec3 source = this.getStartBeamOffset();
                Vec3 targetPos = this.getTargetPos();
                Vec3 offSetToTarget = targetPos.m_82546_(source);
                Vec3 normalizes = offSetToTarget.m_82541_();
                for (int i = 0; i < Mth.m_14107_((double)offSetToTarget.m_82553_()) + 1; ++i) {
                    Vec3 particlePos = source.m_82549_(normalizes.m_82490_((double)i));
                    AABB aabb = new AABB(particlePos.f_82479_ + 0.5, particlePos.f_82480_ + 0.5, particlePos.f_82481_ + 0.5, particlePos.f_82479_ - 0.5, particlePos.f_82480_ - 0.5, particlePos.f_82481_ - 0.5);
                    List list2 = this.f_19853_.m_6443_(LivingEntity.class, aabb, entityData -> entityData != this.m_37282_() && entityData.m_6084_());
                    for (LivingEntity living : list2) {
                        DamageSource damagesource;
                        if (!living.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost(damagesource = TensuraDamageSources.megiddo((Entity)(this.m_37282_() != null ? this.m_37282_() : this)), 3000.0, new ManasSkillInstance((ManasSkill)SpiritualMagics.MEGIDDO.get())), 150.0f)) continue;
                        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)living, (ParticleOptions)ParticleTypes.f_123796_);
                    }
                }
                this.f_19853_.m_6263_(null, targetPos.m_7096_(), targetPos.m_7098_(), targetPos.m_7094_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 0.5f, 1.0f);
            } else if (this.beamTick >= 10) {
                if (this.getChainCharge() > 0) {
                    list = this.getTargetList(this.getTargetPos(), 20.0f);
                    if (!list.isEmpty()) {
                        if (this.chargeChain <= 0) {
                            this.chargeChain = this.getChainCharge();
                            this.startNewBeam(list.get(this.f_19796_.m_188503_(list.size())));
                        } else {
                            LivingEntity target = list.get(this.f_19796_.m_188503_(list.size()));
                            this.setStartBeamOffset((float)this.getTargetPos().m_7096_(), (float)this.getTargetPos().m_7098_(), (float)this.getTargetPos().m_7094_());
                            this.setTargetPos((float)target.m_20185_(), (float)(target.m_20186_() + (double)(target.m_20206_() / 2.0f)), (float)target.m_20189_());
                        }
                        --this.chargeChain;
                    } else {
                        this.setTargetPos(0.0f, 0.0f, 0.0f);
                    }
                } else {
                    this.setTargetPos(0.0f, 0.0f, 0.0f);
                }
                this.beamTick = 0;
            }
        } else if (this.getChainCharge() > 0 && this.f_19797_ % 200 == 0 && !(list = this.getTargetList(this.m_20182_().m_82520_(0.0, -40.0, 0.0), 40.0f)).isEmpty()) {
            this.startNewBeam(list.get(this.f_19796_.m_188503_(list.size())));
        }
        if (this.getCharge() <= 0 || this.f_19853_.m_6042_().f_63857_()) {
            for (BarrierPart part : this.parts) {
                part.addServerParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123796_, 0.5);
                part.addServerParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123796_, 0.5);
                part.addServerParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123796_, 0.5);
            }
            this.m_146870_();
        }
    }

    public void startNewBeam(LivingEntity target) {
        if (!this.hasSunlight()) {
            return;
        }
        this.setCharge(this.getCharge() - 1);
        this.setTargetPos((float)target.m_20185_(), (float)(target.m_20186_() + (double)(target.m_20206_() / 2.0f)), (float)target.m_20189_());
        float radius = this.getRadius() - 1.0f;
        float randomX = (float)(this.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)radius);
        float randomZ = (float)(this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)radius);
        this.setStartBeamOffset(randomX, (float)(this.m_20186_() + (double)(this.getRadius() * 2.0f)), randomZ);
    }

    private boolean hasSunlight() {
        Level level = this.m_9236_();
        if (level.m_46471_() || level.m_46470_()) {
            return false;
        }
        if (!level.m_45527_(this.m_20183_())) {
            return false;
        }
        return level.m_46461_();
    }

    public List<LivingEntity> getTargetList(Vec3 pos, float radius) {
        AABB box = new AABB(new BlockPos(pos)).m_82400_((double)radius);
        return this.m_9236_().m_6443_(LivingEntity.class, box, this::shouldTarget);
    }

    protected boolean shouldTarget(LivingEntity entity) {
        Player player;
        if (!entity.f_19853_.m_46749_(entity.m_20183_())) {
            return false;
        }
        if (this.m_37282_() != null && entity.m_7307_(this.m_37282_())) {
            return false;
        }
        if (entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_())) {
            return false;
        }
        return this.hasLineOfSight((Entity)entity);
    }

    public boolean hasLineOfSight(Entity pEntity) {
        Vec3 vec31;
        if (pEntity.f_19853_ != this.f_19853_) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        return this.f_19853_.m_45547_(new ClipContext(vec3, vec31 = new Vec3(pEntity.m_20185_(), pEntity.m_20188_(), pEntity.m_20189_()), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }
}

