/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.barrier;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.unique.AntiSkill;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierEntity;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierPart;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.skill.ResistanceSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class RangedBarrierEntity
extends BarrierEntity {
    public RangedBarrierEntity(Level level, LivingEntity entity) {
        this((EntityType<? extends RangedBarrierEntity>)((EntityType)TensuraEntityTypes.BARRIER.get()), level);
        this.m_5602_((Entity)entity);
    }

    public RangedBarrierEntity(EntityType<? extends RangedBarrierEntity> entityType, Level level) {
        super(entityType, level);
    }

    private float getPhysicalResistances(DamageSource source) {
        Entity entity = this.m_37282_();
        if (!(entity instanceof LivingEntity)) {
            return 1.0f;
        }
        LivingEntity owner = (LivingEntity)entity;
        if (!DamageSourceHelper.isPhysicalAttack(source)) {
            return 1.0f;
        }
        if (SkillUtils.isSkillToggled((Entity)owner, (ManasSkill)ResistanceSkills.PHYSICAL_ATTACK_NULLIFICATION.get())) {
            return SkillUtils.reducingResistances(owner) ? 0.5f : 0.0f;
        }
        if (SkillUtils.isSkillToggled((Entity)owner, (ManasSkill)ResistanceSkills.PHYSICAL_ATTACK_RESISTANCE.get())) {
            return SkillUtils.reducingResistances(owner) ? 1.0f : 0.5f;
        }
        return 1.0f;
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.f_19853_.m_5776_() && !this.m_213877_()) {
            LivingEntity attacker;
            Entity entity = pSource.m_7640_();
            pAmount = entity instanceof LivingEntity && RangedBarrierEntity.shouldInstaBreak(attacker = (LivingEntity)entity, this.m_37282_()) ? this.getHealth() : (pAmount *= this.getPhysicalResistances(pSource));
            this.setHealth(this.getHealth() - pAmount);
            this.m_5834_();
            this.m_146852_(GameEvent.f_223706_, pSource.m_7639_());
            if (this.getHealth() <= 0.0f) {
                this.m_146870_();
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144242_, this.m_5720_(), 2.0f, 1.0f);
            } else {
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12346_, this.m_5720_(), 2.0f, 1.0f);
            }
        }
        return true;
    }

    public static boolean shouldInstaBreak(LivingEntity attacker, @Nullable Entity target) {
        if (((AntiSkill)((Object)UniqueSkills.ANTI_SKILL.get())).isInSlot(attacker) || SkillUtils.isSkillToggled((Entity)attacker, (ManasSkill)UniqueSkills.ANTI_SKILL.get())) {
            return true;
        }
        if (SkillUtils.isSkillToggled((Entity)attacker, (ManasSkill)UniqueSkills.COOK.get())) {
            return true;
        }
        if (attacker.m_21205_().getEnchantmentLevel((Enchantment)TensuraEnchantments.BARRIER_PIERCING.get()) > 0) {
            return true;
        }
        if (attacker.m_21205_().getEnchantmentLevel((Enchantment)TensuraEnchantments.MAGIC_INTERFERENCE.get()) > 0 && target instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)target;
            return SkillHelper.getMP(entity, false) < SkillHelper.getMP(attacker, false) * 1.5;
        }
        return false;
    }

    protected void m_5834_() {
        this.f_19864_ = true;
        for (BarrierPart part : this.parts) {
            part.addServerParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123790_, 0.5);
            part.addServerParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123790_, 0.5);
            part.addServerParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123790_, 0.5);
        }
    }
}

