/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.beam;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.world.TensuraGameRules;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeamProjectile
extends TensuraProjectile {
    private static final EntityDataAccessor<Boolean> FOLLOW_OWNER = SynchedEntityData.m_135353_(BeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> YAW = SynchedEntityData.m_135353_(BeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> PITCH = SynchedEntityData.m_135353_(BeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> RANGE = SynchedEntityData.m_135353_(BeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<BlockPos> TARGET_POS = SynchedEntityData.m_135353_(BeamProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;
    public double prevCollidePosX;
    public double prevCollidePosY;
    public double prevCollidePosZ;
    public float renderYaw;
    public float renderPitch;
    @Nullable
    public Direction side = null;
    public float prevYaw;
    public float prevPitch;
    public final Map<Color, Float> beamColorAndSize = Maps.newHashMap();

    protected BeamProjectile(EntityType<? extends BeamProjectile> pType, Level pLevel) {
        super(pType, pLevel);
        this.f_19811_ = true;
        this.m_20242_(true);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FOLLOW_OWNER, (Object)false);
        this.f_19804_.m_135372_(YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RANGE, (Object)Float.valueOf(30.0f));
        this.f_19804_.m_135372_(TARGET_POS, (Object)BlockPos.f_121853_);
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        this.setFollowingOwner(compound.m_128471_("FollowOwner"));
        this.setRange(compound.m_128457_("Range"));
        this.setYaw(compound.m_128457_("Yaw"));
        this.setPitch(compound.m_128457_("Pitch"));
        this.setTargetPos(compound.m_128459_("TargetX"), compound.m_128459_("TargetY"), compound.m_128459_("TargetZ"));
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        compound.m_128379_("FollowOwner", this.isFollowingOwner());
        compound.m_128350_("Range", this.getRange());
        compound.m_128350_("Yaw", this.getYaw());
        compound.m_128350_("Pitch", this.getPitch());
        compound.m_128347_("TargetX", (double)this.getTargetPos().m_123341_());
        compound.m_128347_("TargetY", (double)this.getTargetPos().m_123342_());
        compound.m_128347_("TargetZ", (double)this.getTargetPos().m_123343_());
    }

    public boolean isFollowingOwner() {
        return (Boolean)this.f_19804_.m_135370_(FOLLOW_OWNER);
    }

    public void setFollowingOwner(boolean follow) {
        this.f_19804_.m_135381_(FOLLOW_OWNER, (Object)follow);
    }

    public float getYaw() {
        return ((Float)this.f_19804_.m_135370_(YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(yaw));
    }

    public float getPitch() {
        return ((Float)this.f_19804_.m_135370_(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(pitch));
    }

    protected float getRange() {
        return ((Float)this.f_19804_.m_135370_(RANGE)).floatValue();
    }

    public void setRange(float range) {
        this.f_19804_.m_135381_(RANGE, (Object)Float.valueOf(range));
    }

    protected BlockPos getTargetPos() {
        return (BlockPos)this.f_19804_.m_135370_(TARGET_POS);
    }

    public void setTargetPos(double x, double y, double z) {
        this.f_19804_.m_135381_(TARGET_POS, (Object)new BlockPos(x, y, z));
    }

    public boolean m_6783_(double distance) {
        return distance < 1024.0;
    }

    @Override
    public boolean shouldDiscardInLava() {
        return false;
    }

    @Override
    public boolean shouldDiscardInWater() {
        return false;
    }

    public void onAddedToWorld() {
        this.updateAngle();
        super.onAddedToWorld();
        this.setEndPos();
        this.updateCollisionPos(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), new Vec3(this.endPosX, this.endPosY, this.endPosZ));
    }

    @Override
    protected boolean shouldRemove() {
        ++this.age;
        int duration = this.getLife() - this.age;
        if (duration < 20) {
            this.setFollowingOwner(false);
            this.setVisualSize(this.getVisualSize() - this.getSize() / 20.0f);
        }
        return duration <= 0;
    }

    @Override
    public void tickHandler() {
        Entity entity;
        this.prevCollidePosX = this.collidePosX;
        this.prevCollidePosY = this.collidePosY;
        this.prevCollidePosZ = this.collidePosZ;
        this.prevYaw = this.renderYaw;
        this.prevPitch = this.renderPitch;
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.updateAngle();
        this.setEndPos();
        if (this.isFollowingOwner() && (this.m_37282_() == null || !this.m_37282_().m_6084_())) {
            this.m_146870_();
        }
        if (!((entity = this.m_37282_()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        List<Entity> entities = this.updateCollisionPos(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), new Vec3(this.endPosX, this.endPosY, this.endPosZ));
        for (Entity entity2 : entities) {
            if (entity2 == this || entity2 == owner || owner.m_7307_(entity2) || TensuraGameRules.isLabyrinthPvpOff(this.f_19853_, entity2, (Entity)owner)) continue;
            if (this.f_19797_ % 5 == 0) {
                this.explosion(entity2.m_20185_(), entity2.m_20186_() + (double)(entity2.m_20206_() / 2.0f), entity2.m_20189_());
            }
            this.hitEntity(entity2);
        }
        this.handleBlockInteraction();
    }

    protected void handleBlockInteraction() {
        if (!this.f_19853_.f_46443_) {
            boolean shouldExplode = false;
            double radius = this.getSize() * 2.0f;
            AABB bounds = new AABB(this.collidePosX - radius, this.collidePosY - radius, this.collidePosZ - radius, this.collidePosX + radius, this.collidePosY + radius, this.collidePosZ + radius);
            double centerX = bounds.m_82399_().f_82479_;
            double centerY = bounds.m_82399_().f_82480_;
            double centerZ = bounds.m_82399_().f_82481_;
            int x = (int)bounds.f_82288_;
            while ((double)x <= bounds.f_82291_) {
                int y = (int)bounds.f_82289_;
                while ((double)y <= bounds.f_82292_) {
                    int z = (int)bounds.f_82290_;
                    while ((double)z <= bounds.f_82293_) {
                        BlockPos pos = new BlockPos(x, y, z);
                        double distance = Math.sqrt(Math.pow((double)x - centerX, 2.0) + Math.pow((double)y - centerY, 2.0) + Math.pow((double)z - centerZ, 2.0));
                        if (!(distance > radius)) {
                            if (this.shouldGrief()) {
                                this.interactBlocks(pos);
                            }
                            if (!this.f_19853_.m_8055_(pos).m_60795_() && !this.f_19853_.m_6425_(pos).m_76170_()) {
                                shouldExplode = true;
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            boolean bl = shouldExplode = shouldExplode && !TensuraGameRules.isLabyrinthPvpOff(this.f_19853_);
            if (this.f_19797_ % 3 == 0 && shouldExplode) {
                this.explosion(this.collidePosX, this.collidePosY, this.collidePosZ);
            }
        }
    }

    protected void interactBlocks(BlockPos pos) {
        BlockState state = this.f_19853_.m_8055_(pos);
        if (!state.m_60767_().m_76336_()) {
            return;
        }
        if (state.m_60767_().equals(Material.f_76309_)) {
            return;
        }
        if (this.f_19853_.m_6425_(pos).m_76170_()) {
            return;
        }
        SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre(this.m_37282_(), this.getSkill(), pos);
        if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
            return;
        }
        this.f_19853_.m_46961_(pos, false);
        MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post(this.m_37282_(), this.getSkill(), pos));
    }

    protected void placeFires(BlockPos pos) {
        if (this.f_19796_.m_188503_(3) == 0 && this.f_19853_.m_8055_(pos).m_60795_() && this.f_19853_.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)this.f_19853_, pos.m_7495_())) {
            this.f_19853_.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)pos));
        }
    }

    private void setEndPos() {
        if (this.f_19853_.f_46443_) {
            this.endPosX = this.m_20185_() + (double)this.getRange() * Math.cos(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosZ = this.m_20189_() + (double)this.getRange() * Math.sin(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosY = this.m_20186_() + (double)this.getRange() * Math.sin(this.renderPitch);
        } else {
            this.endPosX = this.m_20185_() + (double)this.getRange() * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosZ = this.m_20189_() + (double)this.getRange() * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosY = this.m_20186_() + (double)this.getRange() * Math.sin(this.getPitch());
        }
    }

    public List<Entity> updateCollisionPos(Vec3 from, Vec3 to) {
        if (!(this.m_37282_() instanceof LivingEntity)) {
            return List.of();
        }
        BlockHitResult result = this.f_19853_.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (!this.piercingBlock() && result.m_6662_() != HitResult.Type.MISS) {
            Vec3 pos = result.m_82450_();
            this.collidePosX = pos.f_82479_;
            this.collidePosY = pos.f_82480_;
            this.collidePosZ = pos.f_82481_;
            this.side = result.m_82434_();
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.side = null;
        }
        ArrayList<Entity> entities = new ArrayList<Entity>();
        AABB bounds = new AABB(Math.min(this.m_20185_(), this.collidePosX), Math.min(this.m_20186_(), this.collidePosY), Math.min(this.m_20189_(), this.collidePosZ), Math.max(this.m_20185_(), this.collidePosX), Math.max(this.m_20186_(), this.collidePosY), Math.max(this.m_20189_(), this.collidePosZ)).m_82400_((double)this.getSize());
        List list = this.f_19853_.m_45976_(LivingEntity.class, bounds);
        for (Entity entity : list) {
            float pad = entity.m_6143_() + 0.5f;
            AABB padded = entity.m_20191_().m_82377_((double)pad, (double)pad, (double)pad);
            Optional hit = padded.m_82371_(from, to);
            if (padded.m_82390_(from)) {
                entities.add(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            entities.add(entity);
        }
        return entities;
    }

    private void updateAngle() {
        Entity Target2;
        if (!this.getTargetPos().equals((Object)BlockPos.f_121853_)) {
            BlockPos Target2 = this.getTargetPos();
            double d0 = (double)Target2.m_123341_() - this.m_20185_();
            double d1 = (double)Target2.m_123342_() - this.m_20186_();
            double d2 = (double)Target2.m_123343_() - this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            float yRot = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
            float xRot = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))));
            this.renderYaw = (float)(((double)yRot + 90.0) * Math.PI / 180.0);
            this.renderPitch = (float)((double)(-xRot) * Math.PI / 180.0);
            this.setYaw((float)((double)(yRot + 90.0f) * Math.PI / 180.0));
            this.setPitch((float)((double)(-xRot) * Math.PI / 180.0));
        } else if (this.isFollowingOwner() && (Target2 = this.m_37282_()) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)Target2;
            this.renderYaw = (float)(((double)owner.m_146908_() + 90.0) * Math.PI / 180.0);
            this.renderPitch = (float)((double)(-owner.m_146909_()) * Math.PI / 180.0);
            this.setYaw((float)((double)(owner.m_146908_() + 90.0f) * Math.PI / 180.0));
            this.setPitch((float)((double)(-owner.m_146909_()) * Math.PI / 180.0));
            Vec3 vec3 = new Vec3(owner.m_20185_(), owner.m_20186_() + (double)(owner.m_20206_() * 3.0f / 4.0f) - (double)(this.m_20206_() / 2.0f), owner.m_20189_()).m_82549_(owner.m_20252_(1.0f).m_82541_().m_82490_(0.5));
            this.m_6034_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        }
    }

    public void startParticles(Vec3 start) {
    }

    public void rayParticles(Vec3 pos, int i) {
    }

    @Override
    public void hitParticles(double x, double y, double z) {
    }

    @Override
    public void flyingParticles() {
    }

    public static void spawnLastingBeam(EntityType<? extends BeamProjectile> entityType, float damage, float size, LivingEntity owner, @Nullable ManasSkillInstance instance, double cost, double increaseCost, int heldTicks) {
        BeamProjectile.spawnLastingBeam(entityType, damage, size, 21, 30.0f, 0.0f, owner.m_146892_(), owner, instance, cost, increaseCost, heldTicks);
    }

    public static void spawnLastingBeam(EntityType<? extends BeamProjectile> entityType, float damage, float size, int life, float range, float explosionRange, Vec3 pos, LivingEntity owner, @Nullable ManasSkillInstance instance, double cost, double increaseCost, int heldTicks) {
        if (instance == null) {
            return;
        }
        CompoundTag tag = instance.getOrCreateTag();
        Level level = owner.m_9236_();
        if (tag.m_128451_("BeamID") == 0 && !SkillHelper.outOfMagicule(owner, cost)) {
            BeamProjectile beam = (BeamProjectile)entityType.m_20615_(level);
            if (beam == null) {
                return;
            }
            beam.m_5602_((Entity)owner);
            beam.setFollowingOwner(true);
            beam.setLife(life);
            beam.setDamage(damage);
            beam.setExplosionRadius(explosionRange);
            beam.setSize(size);
            beam.setRange(range);
            beam.m_146884_(pos);
            beam.setSkill(instance);
            beam.setMpCost(cost);
            owner.m_9236_().m_7967_((Entity)beam);
            owner.m_21011_(InteractionHand.MAIN_HAND, true);
            tag.m_128405_("BeamID", beam.m_19879_());
        } else {
            BeamProjectile beam;
            Entity entity = owner.m_9236_().m_6815_(tag.m_128451_("BeamID"));
            if (!(entity instanceof BeamProjectile) || !(beam = (BeamProjectile)entity).isFollowingOwner()) {
                tag.m_128405_("BeamID", 0);
            } else if (heldTicks % 20 != 0 || !SkillHelper.outOfMagicule(owner, increaseCost)) {
                beam.age = 0;
            }
        }
        instance.markDirty();
    }
}

