/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.beam;

import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.beam.BeamProjectile;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BloodRayProjectile
extends BeamProjectile {
    public BloodRayProjectile(EntityType<? extends BloodRayProjectile> entityType, Level level) {
        super((EntityType<? extends BeamProjectile>)entityType, level);
        this.beamColorAndSize.put(new Color(255, 0, 0, 255), Float.valueOf(0.2f));
        this.beamColorAndSize.put(new Color(255, 122, 122, 100), Float.valueOf(0.4f));
    }

    public BloodRayProjectile(Level levelIn, LivingEntity shooter) {
        this((EntityType<? extends BloodRayProjectile>)((EntityType)TensuraEntityTypes.BLOOD_RAY.get()), levelIn);
        this.m_5602_((Entity)shooter);
    }

    @Override
    protected void dealDamage(Entity target) {
        if (this.damage <= 0.0f || target instanceof ItemEntity) {
            return;
        }
        DamageSource damagesource = DamageSource.f_19319_;
        if (this.m_37282_() != null) {
            damagesource = DamageSourceHelper.addSkillAndCost(TensuraDamageSources.bloodRay(this.m_37282_()), this.getMpCost(), this.getSkill());
        }
        target.m_6469_(damagesource, this.getDamage());
    }

    @Override
    protected void handleBlockInteraction() {
        if (!this.f_19853_.f_46443_) {
            boolean shouldExplode = false;
            double radius = this.getSize() * 6.0f;
            AABB bounds = new AABB(this.collidePosX - radius, this.collidePosY - radius, this.collidePosZ - radius, this.collidePosX + radius, this.collidePosY + radius, this.collidePosZ + radius);
            double centerX = bounds.m_82399_().f_82479_;
            double centerY = bounds.m_82399_().f_82480_;
            double centerZ = bounds.m_82399_().f_82481_;
            int x = (int)bounds.f_82288_;
            while ((double)x <= bounds.f_82291_) {
                int y = (int)bounds.f_82289_;
                while ((double)y <= bounds.f_82292_) {
                    int z = (int)bounds.f_82290_;
                    while ((double)z <= bounds.f_82293_) {
                        BlockPos pos = new BlockPos(x, y, z);
                        double distance = Math.sqrt(Math.pow((double)x - centerX, 2.0) + Math.pow((double)y - centerY, 2.0) + Math.pow((double)z - centerZ, 2.0));
                        if (!(distance > radius)) {
                            if (this.shouldGrief()) {
                                this.interactBlocks(pos);
                            }
                            if (!this.f_19853_.m_8055_(pos).m_60795_() && !this.f_19853_.m_6425_(pos).m_76170_()) {
                                shouldExplode = true;
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            if (this.f_19797_ % 3 == 0 && shouldExplode) {
                this.explosion(this.collidePosX, this.collidePosY, this.collidePosZ);
            }
        }
    }

    @Override
    protected void interactBlocks(BlockPos pos) {
        BlockState state = this.f_19853_.m_8055_(pos);
        if (state.m_204336_(TensuraTags.Blocks.SKILL_BREAK_EASY) || state.m_60767_().m_76336_() && !this.f_19853_.m_6425_(pos).m_76170_()) {
            SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre(this.m_37282_(), this.getSkill(), pos);
            if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                return;
            }
            this.f_19853_.m_46961_(pos, false);
            MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post(this.m_37282_(), this.getSkill(), pos));
        }
    }

    @Override
    public void startParticles(Vec3 start) {
        if (this.f_19797_ % 3 != 0) {
            return;
        }
        TensuraParticleHelper.addParticlesAroundPos(this.m_9236_().f_46441_, this.f_19853_, start, (ParticleOptions)DustParticleOptions.f_123656_, this.getSize(), 2);
    }

    @Override
    public void hitParticles(double x, double y, double z) {
        if (this.f_19797_ % 3 != 0) {
            return;
        }
        Vec3 end = new Vec3(x, y, z);
        TensuraParticleHelper.addParticlesAroundPos(this.m_9236_().f_46441_, this.f_19853_, end, (ParticleOptions)DustParticleOptions.f_123656_, this.getSize(), 3);
    }

    @Override
    public void rayParticles(Vec3 pos, int i) {
        if (this.f_19797_ % this.f_19796_.m_216339_(15, 20) != 0) {
            return;
        }
        TensuraParticleHelper.addParticlesAroundPos(this.f_19796_, this.f_19853_, pos, (ParticleOptions)DustParticleOptions.f_123656_, this.getVisualSize() / 2.0f, 1);
    }
}

