/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.beam;

import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.beam.BeamProjectile;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.awt.Color;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SpatialRayProjectile
extends BeamProjectile {
    public SpatialRayProjectile(EntityType<? extends SpatialRayProjectile> entityType, Level level) {
        super((EntityType<? extends BeamProjectile>)entityType, level);
        this.beamColorAndSize.put(new Color(211, 0, 255, 255), Float.valueOf(0.15f));
        this.beamColorAndSize.put(new Color(91, 32, 105, 150), Float.valueOf(0.3f));
        this.beamColorAndSize.put(new Color(202, 136, 209, 30), Float.valueOf(0.5f));
    }

    public SpatialRayProjectile(Level levelIn, LivingEntity shooter) {
        this((EntityType<? extends SpatialRayProjectile>)((EntityType)TensuraEntityTypes.SPATIAL_RAY.get()), levelIn);
        this.m_5602_((Entity)shooter);
    }

    @Override
    public boolean piercingBlock() {
        return true;
    }

    @Override
    protected void dealDamage(Entity target) {
        if (this.damage <= 0.0f || target instanceof ItemEntity) {
            return;
        }
        DamageSource damagesource = TensuraDamageSources.indirectElementalAttack("tensura.space_attack", (Entity)this, this.m_37282_(), this.getMpCost(), this.getSkill(), this.isSpiritAttack());
        if (this.m_37282_() != null) {
            damagesource = DamageSourceHelper.addSkillAndCost(TensuraDamageSources.dimensionRay(this.m_37282_()), this.getMpCost(), this.getSkill());
        }
        target.m_6469_(damagesource, this.getDamage());
    }

    @Override
    public void startParticles(Vec3 start) {
        if (this.f_19797_ % 3 != 0) {
            return;
        }
        TensuraParticleHelper.addParticlesAroundPos(this.m_9236_().f_46441_, this.f_19853_, start, (ParticleOptions)ParticleTypes.f_123789_, this.getSize(), 3);
    }

    @Override
    public void hitParticles(double x, double y, double z) {
        if (this.f_19797_ % 3 != 0) {
            return;
        }
        Vec3 end = new Vec3(x, y, z);
        TensuraParticleHelper.addParticlesAroundPos(this.m_9236_().f_46441_, this.f_19853_, end, (ParticleOptions)ParticleTypes.f_123789_, this.getSize(), 3);
    }

    @Override
    public void rayParticles(Vec3 pos, int i) {
        if (this.f_19797_ % this.f_19796_.m_216339_(10, 16) != 0) {
            return;
        }
        TensuraParticleHelper.addParticlesAroundPos(this.f_19796_, this.f_19853_, pos, (ParticleOptions)ParticleTypes.f_123789_, this.getVisualSize() / 2.0f, 1);
    }
}

