/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.breath;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.breath.BreathPart;
import com.github.manasmods.tensura.entity.magic.breath.PredatorMistProjectile;
import com.github.manasmods.tensura.event.SkillPlunderEvent;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class GluttonyMistProjectile
extends PredatorMistProjectile {
    public GluttonyMistProjectile(EntityType<? extends GluttonyMistProjectile> entityType, Level level) {
        super((EntityType<? extends PredatorMistProjectile>)entityType, level);
        this.m_20242_(true);
    }

    public GluttonyMistProjectile(Level level, LivingEntity entity) {
        this((EntityType<? extends GluttonyMistProjectile>)((EntityType)TensuraEntityTypes.GLUTTONY_MIST.get()), level);
        this.m_5602_((Entity)entity);
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        LivingEntity owner;
        if (this.f_19853_.m_5776_()) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        if (this.isConsumeProjectile() && entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            this.devourProjectile(projectile);
            return;
        }
        if (!entity.m_6084_()) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (target instanceof Player) {
            Player player = (Player)target;
            if (player.m_150110_().f_35934_) {
                return;
            }
        }
        DamageSource damageSource = TensuraDamageSources.DEVOURED;
        Entity entity2 = this.m_37282_();
        if (entity2 instanceof LivingEntity) {
            owner = (LivingEntity)entity2;
            damageSource = TensuraDamageSources.devour((Entity)owner);
        }
        if (!entity.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost(damageSource, this.getMpCost(), this.getSkill()), 50.0f)) {
            return;
        }
        entity2 = this.m_37282_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        owner = (LivingEntity)entity2;
        if (!target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
            SkillHelper.drainMP(target, owner, 1000.0, false);
        }
        if (target.m_6084_()) {
            if ((double)target.m_217043_().m_188501_() < 0.3) {
                this.devourRandomSkill(target, owner);
            }
            SkillHelper.checkThenAddEffectSource(target, (Entity)owner, (MobEffect)TensuraMobEffects.CORROSION.get(), 100, 1, false, false, true, true);
        } else {
            this.devourAllSkills(target, owner);
            this.devourEP(target, owner, 0.8f);
            if (owner instanceof Player) {
                Player player = (Player)owner;
                List list = owner.f_19853_.m_45976_(ItemEntity.class, AABB.m_165882_((Vec3)target.m_20182_(), (double)2.0, (double)2.0, (double)2.0));
                for (ItemEntity item : list) {
                    if (this.addItemToSpatialStorage(player, item.m_32055_())) {
                        item.m_146870_();
                        continue;
                    }
                    if (player.m_36356_(item.m_32055_())) {
                        item.m_146870_();
                        continue;
                    }
                    item.m_20219_(owner.m_20182_());
                }
            }
        }
    }

    @Override
    protected void devourRandomSkill(LivingEntity target, LivingEntity owner) {
        if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
            return;
        }
        ArrayList<ManasSkillInstance> collection = new ArrayList<ManasSkillInstance>(SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills().stream().filter(this::canDevour).toList());
        for (int i = 0; i <= 2; ++i) {
            if (collection.isEmpty()) {
                return;
            }
            ManasSkillInstance instance = (ManasSkillInstance)collection.get(target.m_217043_().m_188503_(collection.size()));
            SkillPlunderEvent event = new SkillPlunderEvent((Entity)target, (Entity)owner, false, instance.getSkill());
            if (MinecraftForge.EVENT_BUS.post((Event)event)) continue;
            if (SkillUtils.learnSkill(owner, event.getSkill(), this.getSkill().getRemoveTime())) {
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{event.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
                }
                owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            collection.remove(instance);
        }
    }

    @Override
    public void spawnParticle() {
        for (BreathPart part : this.parts) {
            TensuraParticleHelper.addParticlesAroundSelf((Entity)part, (ParticleOptions)ParticleTypes.f_123765_, 0.7);
            if (!this.f_19796_.m_188499_()) continue;
            TensuraParticleHelper.addParticlesAroundSelf((Entity)part, (ParticleOptions)new DustParticleOptions(new Vector3f(Vec3.m_82501_((int)12659166)), 1.0f), 0.7);
        }
    }
}

