/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.breath;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.tensura.ability.ISpatialStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.Skill;
import com.github.manasmods.tensura.ability.skill.extra.MolecularManipulationSkill;
import com.github.manasmods.tensura.ability.skill.unique.DegenerateSkill;
import com.github.manasmods.tensura.ability.skill.unique.StarvedSkill;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.entity.magic.breath.BreathEntity;
import com.github.manasmods.tensura.entity.magic.breath.BreathPart;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.event.SkillPlunderEvent;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class PredatorMistProjectile
extends BreathEntity {
    private boolean consumeProjectile;
    private int blockMode;

    public PredatorMistProjectile(EntityType<? extends PredatorMistProjectile> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
    }

    public PredatorMistProjectile(Level level, LivingEntity entity) {
        this((EntityType<? extends PredatorMistProjectile>)((EntityType)TensuraEntityTypes.PREDATOR_MIST.get()), level);
        this.m_5602_((Entity)entity);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            this.consumeBlocks();
        }
    }

    @Override
    protected boolean canCollide(Entity entity) {
        LivingEntity living;
        if (this.isConsumeProjectile()) {
            return super.canCollide(entity);
        }
        return entity instanceof LivingEntity && super.canCollide((Entity)(living = (LivingEntity)entity));
    }

    protected boolean canDevour(ManasSkillInstance instance) {
        if (instance.isTemporarySkill() || instance.getMastery() < 0) {
            return false;
        }
        if (instance.getSkill() == this.getSkill().getSkill()) {
            return false;
        }
        if (instance.getSkill() instanceof StarvedSkill) {
            return true;
        }
        if (instance.getSkill() instanceof DegenerateSkill && this.m_9236_().m_46469_().m_46207_(TensuraGameRules.RIMURU_MODE)) {
            return true;
        }
        ManasSkill manasSkill = instance.getSkill();
        if (!(manasSkill instanceof Skill)) {
            return false;
        }
        Skill devouredSkill = (Skill)manasSkill;
        return devouredSkill.getType().equals((Object)Skill.SkillType.INTRINSIC) || devouredSkill.getType().equals((Object)Skill.SkillType.COMMON) || devouredSkill.getType().equals((Object)Skill.SkillType.EXTRA) || devouredSkill.getType().equals((Object)Skill.SkillType.RESISTANCE);
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        LivingEntity owner;
        if (this.f_19853_.m_5776_()) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        if (this.isConsumeProjectile() && entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            this.devourProjectile(projectile);
            return;
        }
        if (!entity.m_6084_()) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (target instanceof Player) {
            Player player = (Player)target;
            if (player.m_150110_().f_35934_) {
                return;
            }
        }
        DamageSource damageSource = TensuraDamageSources.DEVOURED;
        Entity entity2 = this.m_37282_();
        if (entity2 instanceof LivingEntity) {
            owner = (LivingEntity)entity2;
            damageSource = TensuraDamageSources.devour((Entity)owner);
        }
        if (!entity.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost(damageSource, this.getMpCost(), this.getSkill()), 10.0f)) {
            return;
        }
        entity2 = this.m_37282_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        owner = (LivingEntity)entity2;
        if (!target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
            SkillHelper.drainMP(target, owner, 100.0, false);
        }
        if (target.m_6084_()) {
            if ((double)target.m_217043_().m_188501_() < 0.1) {
                this.devourRandomSkill(target, owner);
            }
        } else {
            this.devourAllSkills(target, owner);
            this.devourEP(target, owner, 0.5f);
            if (owner instanceof Player) {
                Player player = (Player)owner;
                List list = owner.f_19853_.m_45976_(ItemEntity.class, AABB.m_165882_((Vec3)target.m_20182_(), (double)2.0, (double)2.0, (double)2.0));
                for (ItemEntity item : list) {
                    if (this.addItemToSpatialStorage(player, item.m_32055_())) {
                        item.m_146870_();
                        continue;
                    }
                    if (player.m_36356_(item.m_32055_())) {
                        item.m_146870_();
                        continue;
                    }
                    item.m_20219_(owner.m_20182_());
                }
            }
        }
    }

    protected void devourProjectile(Projectile projectile) {
        projectile.m_146870_();
        Entity entity = this.m_37282_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        if (projectile.m_6095_() == TensuraEntityTypes.TEMPEST_SCALE.get() && owner instanceof Player) {
            Player player = (Player)owner;
            scale = ((Item)TensuraMobDropItems.CHARYBDIS_SCALE.get()).m_7968_();
            if (!this.addItemToSpatialStorage(player, scale) && !player.m_36356_(scale)) {
                SkillHelper.dropItem((Entity)player, player.m_217043_(), scale, 20, 1.0f);
            }
        } else if (projectile instanceof AbstractArrow) {
            Player player;
            AbstractArrow arrow = (AbstractArrow)projectile;
            if (arrow.f_36705_ == AbstractArrow.Pickup.ALLOWED && owner instanceof Player && !this.addItemToSpatialStorage(player = (Player)owner, scale = arrow.m_7941_()) && !player.m_36356_(scale)) {
                SkillHelper.dropItem((Entity)player, player.m_217043_(), scale, 20, 1.0f);
            }
        }
        if (!(projectile instanceof TensuraProjectile)) {
            return;
        }
        TensuraProjectile tensuraProjectile = (TensuraProjectile)projectile;
        ManasSkillInstance skill = tensuraProjectile.getSkill();
        if (skill == null || !this.canDevour(skill)) {
            return;
        }
        SkillPlunderEvent event = new SkillPlunderEvent(projectile.m_37282_(), (Entity)owner, false, skill.getSkill());
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        if (SkillUtils.learnSkill(owner, event.getSkill(), this.getSkill().getRemoveTime())) {
            if (owner instanceof Player) {
                Player player = (Player)owner;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{event.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
            owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    protected void devourRandomSkill(LivingEntity target, LivingEntity owner) {
        if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
            return;
        }
        List<ManasSkillInstance> collection = SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills().stream().filter(this::canDevour).toList();
        if (collection.isEmpty()) {
            return;
        }
        ManasSkillInstance instance = collection.get(target.m_217043_().m_188503_(collection.size()));
        SkillPlunderEvent event = new SkillPlunderEvent((Entity)target, (Entity)owner, false, instance.getSkill());
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        if (SkillUtils.learnSkill(owner, event.getSkill(), this.getSkill().getRemoveTime())) {
            if (owner instanceof Player) {
                Player player = (Player)owner;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{event.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
            owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    protected void devourAllSkills(LivingEntity target, LivingEntity owner) {
        if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_SKILL_PLUNDER)) {
            return;
        }
        List<ManasSkillInstance> targetSkills = SkillAPI.getSkillsFrom((Entity)target).getLearnedSkills().stream().filter(this::canDevour).toList();
        for (ManasSkillInstance targetInstance : targetSkills) {
            SkillPlunderEvent event;
            if (targetInstance.isTemporarySkill() || targetInstance.getMastery() < 0 || MinecraftForge.EVENT_BUS.post((Event)(event = new SkillPlunderEvent((Entity)target, (Entity)owner, false, targetInstance.getSkill()))) || !SkillUtils.learnSkill(owner, event.getSkill(), this.getSkill().getRemoveTime())) continue;
            if (owner instanceof Player) {
                Player player = (Player)owner;
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire", (Object[])new Object[]{event.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), false);
            }
            owner.m_9236_().m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    protected void devourEP(LivingEntity target, LivingEntity owner, float amountToMax) {
        if (target.m_6095_().m_204039_(TensuraTags.EntityTypes.NO_EP_PLUNDER)) {
            return;
        }
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)owner);
        Optional predator = storage.getSkill(this.skill.getSkill());
        if (predator.isEmpty()) {
            return;
        }
        ManasSkillInstance instance = (ManasSkillInstance)predator.get();
        if (instance.isTemporarySkill()) {
            return;
        }
        CompoundTag tag = instance.getOrCreateTag();
        if (tag.m_128441_("predationList")) {
            predationList = (CompoundTag)tag.m_128423_("predationList");
            if (predationList == null) {
                return;
            }
            String targetID = EntityType.m_20613_((EntityType)target.m_6095_()).toString();
            if (predationList.m_128441_(targetID)) {
                return;
            }
            predationList.m_128379_(targetID, true);
            instance.markDirty();
        } else {
            predationList = new CompoundTag();
            predationList.m_128379_(EntityType.m_20613_((EntityType)target.m_6095_()).toString(), true);
            tag.m_128365_("predationList", (Tag)predationList);
            instance.markDirty();
        }
        storage.syncChanges();
        double EP = Math.min(SkillUtils.getEPGain(target, owner), (Double)TensuraConfig.INSTANCE.skillsConfig.maximumEPSteal.get() / (double)amountToMax);
        if (target instanceof Player) {
            Player playerTarget = (Player)target;
            if (TensuraGameRules.canEpSteal(target.m_9236_())) {
                int minEP = TensuraGameRules.getMinEp(target.m_9236_());
                if (minEP > 0) {
                    EP -= (double)minEP;
                }
                if (EP <= 0.0) {
                    return;
                }
                SkillHelper.gainMaxMP(owner, EP * (double)amountToMax);
                TensuraEPCapability.setSkippingEPDrop(target, true);
                this.saveMagiculeIntoStorage(owner, EP * (double)(1.0f - amountToMax));
                double finalEP = EP;
                TensuraPlayerCapability.getFrom(playerTarget).ifPresent(cap -> {
                    cap.setBaseMagicule(cap.getBaseMagicule() - finalEP / 2.0, (LivingEntity)playerTarget);
                    cap.setBaseAura(cap.getBaseAura() - finalEP / 2.0, (LivingEntity)playerTarget);
                });
                TensuraPlayerCapability.sync(playerTarget);
            }
        } else {
            SkillHelper.gainMaxMP(owner, EP * (double)amountToMax);
            this.saveMagiculeIntoStorage(owner, EP * (double)(1.0f - amountToMax));
            SkillHelper.reduceEP(target, owner, 1.0, true, true);
            TensuraEPCapability.setSkippingEPDrop(target, true);
        }
    }

    protected void saveMagiculeIntoStorage(LivingEntity owner, double amount) {
        ManasSkillInstance instance = this.getSkillInstance(owner);
        if (instance == null) {
            return;
        }
        CompoundTag tag = instance.getOrCreateTag();
        tag.m_128347_("MpStomach", tag.m_128459_("MpStomach") + amount);
        instance.markDirty();
    }

    @Nullable
    protected ManasSkillInstance getSkillInstance(LivingEntity owner) {
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)owner);
        Optional optional = storage.getSkill(this.skill.getSkill());
        return optional.orElse(null);
    }

    protected boolean addItemToSpatialStorage(Player player, ItemStack stack) {
        ManasSkillInstance instance = this.getSkillInstance((LivingEntity)player);
        if (instance == null) {
            return false;
        }
        ManasSkill manasSkill = instance.getSkill();
        if (!(manasSkill instanceof ISpatialStorage)) {
            return false;
        }
        ISpatialStorage spatialStorage = (ISpatialStorage)manasSkill;
        return spatialStorage.addItemToSpatialStorage(instance, (LivingEntity)player, stack);
    }

    protected void consumeBlocks() {
        if (!TensuraGameRules.canSkillGrief(this.m_9236_())) {
            return;
        }
        Entity entity = this.m_37282_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int blockMode = this.getBlockMode();
        if (blockMode == 1) {
            return;
        }
        float range = 0.34906584f;
        for (int i = 0; i < 5; ++i) {
            Vec3 lookAngle = this.m_37282_().m_20154_().m_82541_().m_82496_(this.m_9236_().f_46441_.m_188501_() * range * 2.0f - range).m_82524_(this.m_9236_().f_46441_.m_188501_() * range * 2.0f - range).m_82535_(this.m_9236_().f_46441_.m_188501_() * range * 2.0f - range);
            if (blockMode == 2 || blockMode == 4) {
                this.breakBlocks(player, lookAngle);
            }
            if (blockMode != 3 && blockMode != 4) continue;
            this.consumeFluid(player, lookAngle);
        }
    }

    protected void breakBlocks(Player player, Vec3 lookAngle) {
        BlockHitResult result = this.m_9236_().m_45547_(new ClipContext(player.m_146892_(), player.m_146892_().m_82549_(lookAngle.m_82490_((double)this.getLength())), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos pos = result.m_82425_();
            BlockState state = this.f_19853_.m_8055_(pos);
            if (state.m_204336_(TensuraTags.Blocks.SKILL_UNOBTAINABLE)) {
                return;
            }
            if (state.m_60734_().m_155943_() <= -1.0f) {
                return;
            }
            SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre(this.m_37282_(), this.getSkill(), pos);
            if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                return;
            }
            state.m_60734_().m_5707_(this.f_19853_, pos, state, player);
            if (MolecularManipulationSkill.isMultiBlock(state)) {
                this.f_19853_.m_46953_(pos, true, (Entity)player);
            } else {
                ShulkerBoxBlockEntity shulker;
                BlockEntity blockentity = this.f_19853_.m_7702_(pos);
                if (blockentity instanceof BeehiveBlockEntity) {
                    BeehiveBlockEntity beehiveblockentity = (BeehiveBlockEntity)blockentity;
                    beehiveblockentity.m_58748_(player, state, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                }
                if (!(blockentity instanceof ShulkerBoxBlockEntity) || (shulker = (ShulkerBoxBlockEntity)blockentity).m_7983_()) {
                    ItemStack stack = new ItemStack((ItemLike)state.m_60734_());
                    if (!this.addItemToSpatialStorage(player, stack) && !player.m_36356_(stack)) {
                        player.m_36176_(stack, false);
                    }
                    this.f_19853_.m_46953_(pos, false, (Entity)player);
                } else {
                    this.f_19853_.m_46953_(pos, !player.m_7500_(), (Entity)player);
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post(this.m_37282_(), this.getSkill(), pos));
            List list = player.f_19853_.m_45976_(ItemEntity.class, AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)pos), (double)2.0, (double)2.0, (double)2.0));
            for (ItemEntity item : list) {
                if (this.addItemToSpatialStorage(player, item.m_32055_())) {
                    item.m_146870_();
                    continue;
                }
                if (player.m_36356_(item.m_32055_())) {
                    item.m_146870_();
                    continue;
                }
                item.m_20219_(player.m_20182_());
            }
        }
    }

    protected void consumeFluid(Player player, Vec3 lookAngle) {
        BlockPos pos;
        BlockState state;
        ClipContext context = new ClipContext(player.m_146892_(), player.m_146892_().m_82549_(lookAngle.m_82490_((double)this.getLength())), ClipContext.Block.OUTLINE, ClipContext.Fluid.ANY, (Entity)this);
        BlockHitResult result = this.m_9236_().m_45547_(context);
        if (result.m_6662_() == HitResult.Type.BLOCK && !(state = this.f_19853_.m_8055_(pos = result.m_82425_())).m_60819_().m_76178_()) {
            SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre(this.m_37282_(), this.getSkill(), pos);
            if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                return;
            }
            if (state.m_60819_().m_76170_()) {
                TensuraSkillCapability.getFrom(player).ifPresent(cap -> {
                    if (state.m_60819_().m_205070_(FluidTags.f_13131_)) {
                        cap.setWaterPoint(cap.getWaterPoint() + 1.0);
                        TensuraSkillCapability.sync(player);
                    } else if (state.m_60819_().m_205070_(FluidTags.f_13132_)) {
                        cap.setLavaPoint(cap.getLavaPoint() + 1.0);
                        TensuraSkillCapability.sync(player);
                    }
                });
            }
            if (state.m_60713_(Blocks.f_49990_) || state.m_60713_(Blocks.f_49991_)) {
                this.f_19853_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            } else if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                this.f_19853_.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 11);
            }
            MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post(this.m_37282_(), this.getSkill(), pos));
        }
    }

    @Override
    public void spawnParticle() {
        for (BreathPart part : this.parts) {
            TensuraParticleHelper.addParticlesAroundSelf((Entity)part, (ParticleOptions)ParticleTypes.f_123765_, 0.7);
        }
    }

    public boolean isConsumeProjectile() {
        return this.consumeProjectile;
    }

    public void setConsumeProjectile(boolean consumeProjectile) {
        this.consumeProjectile = consumeProjectile;
    }

    public int getBlockMode() {
        return this.blockMode;
    }

    public void setBlockMode(int blockMode) {
        this.blockMode = blockMode;
    }
}

